/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.parser;

import org.jconfig.Configuration;
import org.jconfig.DefaultCategory;
import org.jconfig.ExtensibleConfiguration;
import org.jconfig.parser.AbstractConfigParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CDataConfigParser
extends AbstractConfigParser {
    public Configuration parse(Document doc, String configName) {
        ExtensibleConfiguration configuration = new ExtensibleConfiguration(configName);
        this.getVariables(doc, configuration);
        this.getIncludeProperties(doc, configuration);
        this.getBaseConfigName(doc, configuration);
        NodeList nl = doc.getElementsByTagName("category");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            NamedNodeMap curAtt = n.getAttributes();
            Node curNode = curAtt.getNamedItem("name");
            String currentCategory = curNode.getNodeValue();
            DefaultCategory ec = new DefaultCategory(currentCategory);
            configuration.setCategory(ec);
            curNode = curAtt.getNamedItem("extends");
            if (curNode != null) {
                ec.setExtendsCategory(curNode.getNodeValue());
            }
            for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || child.getFirstChild() == null) continue;
                String name = child.getNodeName();
                String value = child.getFirstChild().getNodeValue();
                if (name == null || value == null) continue;
                configuration.setProperty(name, value, currentCategory);
            }
        }
        return configuration;
    }
}

