/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.parser;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.jconfig.Configuration;
import org.jconfig.VariableManager;
import org.jconfig.error.ErrorReporter;
import org.jconfig.parser.ConfigurationParser;
import org.jconfig.utils.ExtensionGraph;
import org.jconfig.utils.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractConfigParser
implements ConfigurationParser {
    private static ExtensionGraph eg = new ExtensionGraph();

    protected void getVariables(Document doc, Configuration config) {
        NodeList nl = doc.getElementsByTagName("variables");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!child.getNodeName().equals("variable")) continue;
                NamedNodeMap myAtt = child.getAttributes();
                Node myNode = myAtt.getNamedItem("name");
                String name = myNode.getNodeValue();
                myNode = myAtt.getNamedItem("value");
                String value = myNode.getNodeValue();
                if (name == null || value == null) continue;
                config.setVariable(name, value);
            }
        }
    }

    protected void getBaseConfigName(Document doc, Configuration config) {
        Element nl = doc.getDocumentElement();
        NamedNodeMap myAtt = nl.getAttributes();
        Node myNode = myAtt.getNamedItem("extends");
        if (myNode != null) {
            String name = myNode.getNodeValue();
            eg.addExtension(config.getConfigName(), name);
            if (!eg.checkDependencies(config.getConfigName())) {
                config.setBaseConfiguration(name);
            } else {
                ErrorReporter.getErrorHandler().reportError("The base configuration is invalid since there will be a circular dependency. Found dependency:" + config.getConfigName() + "/" + name);
            }
        }
    }

    protected void getIncludeProperties(Document doc, Configuration config) {
        NodeList nl = doc.getElementsByTagName("include");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            NamedNodeMap myAtt = n.getAttributes();
            Node myNode = myAtt.getNamedItem("properties");
            if (myNode == null) continue;
            this.loadProperties(myNode.getNodeValue(), config.getConfigName());
            config.addInclude(1, myNode.getNodeValue());
        }
    }

    private void loadProperties(String propName, String configName) {
        try {
            InputStream inputStream = null;
            ResourceLocator locator = new ResourceLocator(propName);
            inputStream = locator.getInputStream();
            if (inputStream == null) {
                ErrorReporter.getErrorHandler().reportError("Cannot find the properties file");
            } else {
                VariableManager varman = VariableManager.getInstance();
                Properties myProperties = new Properties();
                myProperties.load(inputStream);
                Enumeration<?> propertyNames = myProperties.propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String name = (String)propertyNames.nextElement();
                    String value = myProperties.getProperty(name);
                    varman.addIncludedVariable(name, value, configName);
                }
            }
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError("The file cannot be loaded", e);
        }
    }

    public abstract Configuration parse(Document var1, String var2);
}

