/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.jmx;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.jmx.ConfigurationDynamicMBean;
import org.jconfig.jmx.DynamicConfigurationMBean;

public class DynamicConfiguration
implements DynamicConfigurationMBean,
MBeanRegistration {
    private MBeanServer mBeanServer;
    private String name;
    private ObjectName objectName;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        Configuration config = ConfigurationManager.getConfiguration(name);
        this.loadConfiguration(name);
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean booleanParam) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.mBeanServer = mBeanServer;
        this.objectName = objectName;
        return objectName;
    }

    public ObjectName loadConfiguration(String name) {
        System.out.println("loadConfiguration called:" + name);
        return this.registerConfigurationMBean(name);
    }

    ObjectName registerConfigurationMBean(String name) {
        ObjectName configurationObjectName = null;
        try {
            configurationObjectName = new ObjectName(this.objectName.getDomain(), "configuration", name);
            ConfigurationDynamicMBean configurationMBean = new ConfigurationDynamicMBean(configurationObjectName, name);
            this.mBeanServer.registerMBean(configurationMBean, configurationObjectName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.objectName;
    }
}

