/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.jmx;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.jmx.AbstractDynamicMBean;
import org.jconfig.jmx.CategoryDynamicMBean;

public class ConfigurationDynamicMBean
extends AbstractDynamicMBean {
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[3];
    private ArrayList alBasicAttributes = new ArrayList();
    private ArrayList alMbeanAttributes = new ArrayList();
    private String dClassName = this.getClass().getName();
    private String dDescription = "This MBean acts as a management facade for a org.jconfig.Configuration instance.";
    private ObjectName objectName;
    private String configurationName;

    public ConfigurationDynamicMBean(ObjectName objectName, String configurationName) {
        this.configurationName = configurationName;
        this.objectName = objectName;
        this.buildDynamicMBeanInfo();
    }

    private void buildDynamicMBeanInfo() {
        Constructor<?>[] constructors = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("ConfigurationDynamicMBean(): Constructs a ConfigurationDynamicMBean instance", constructors[0]);
        this.alBasicAttributes.add(new MBeanAttributeInfo("name", "java.lang.String", "The name of this Configuration.", true, false, false));
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        MBeanParameterInfo[] params2 = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", "The name")};
        this.dOperations[0] = new MBeanOperationInfo("reloadConfiguration", "reloadConfiguration(): reloads configuration", params, "void", 1);
        this.dOperations[1] = new MBeanOperationInfo("saveConfiguration", "saveConfiguration(): saves configuration", params, "void", 1);
        this.dOperations[2] = new MBeanOperationInfo("addCategory", "addCategory(String name): create new category", params2, "void", 1);
    }

    public MBeanInfo getMBeanInfo() {
        System.out.println("getMBeanInfo called.");
        MBeanAttributeInfo[] attribs = new MBeanAttributeInfo[this.alBasicAttributes.size() + this.alMbeanAttributes.size()];
        ArrayList al = new ArrayList();
        al.addAll(this.alBasicAttributes);
        al.addAll(this.alMbeanAttributes);
        al.toArray(attribs);
        al = null;
        MBeanInfo mb = new MBeanInfo(this.dClassName, this.dDescription, attribs, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
        System.out.println("getMBeanInfo exit.");
        return mb;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName.equals("reloadConfiguration")) {
            this.reloadConfiguration();
        } else if (operationName.equals("saveConfiguration")) {
            this.saveConfiguration();
        } else {
            throw new ReflectionException(new NoSuchMethodException(operationName), "Cannot find the operation " + operationName + " in " + this.dClassName);
        }
        return null;
    }

    public void addCategory(String name) throws MBeanException {
    }

    public void reloadConfiguration() throws MBeanException {
        System.out.println("reloadConfiguration called");
        try {
            this.categoryMBeanDeregistration();
            ConfigurationManager.getInstance().reload(this.configurationName);
            this.categoryMBeanRegistration();
        }
        catch (ConfigurationManagerException cme) {
            throw new MBeanException(cme);
        }
    }

    public void saveConfiguration() throws MBeanException {
        System.out.println("saveConfiguration called");
        try {
            ConfigurationManager.getInstance().save(this.configurationName);
        }
        catch (ConfigurationManagerException cme) {
            throw new MBeanException(cme);
        }
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        if (attributeName.equals("name")) {
            return this.configurationName;
        }
        if (attributeName.startsWith("category=")) {
            Hashtable<String, String> keys = new Hashtable<String, String>();
            keys.put("configuration", this.configurationName);
            keys.put("category", attributeName.substring(attributeName.indexOf("=") + 1));
            try {
                return new ObjectName(this.objectName.getDomain(), keys);
            }
            catch (Exception e) {
                System.out.println("Could not create ObjectName " + this.objectName.getDomain() + ":" + keys);
            }
        }
        throw new AttributeNotFoundException("Cannot find " + attributeName + " attribute in " + this.dClassName);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
    }

    void categoryMBeanRegistration() {
        Configuration configuration = ConfigurationManager.getConfiguration(this.configurationName);
        String[] categoryNames = configuration.getCategoryNames();
        for (int i = 0; i < categoryNames.length; ++i) {
            this.registerCategoryMBean(categoryNames[i]);
        }
    }

    void registerCategoryMBean(String categoryName) {
        System.out.println("Adding CategoryMBean for category named " + categoryName);
        ObjectName categoryObjectName = null;
        try {
            Hashtable<String, String> keys = new Hashtable<String, String>();
            keys.put("configuration", this.configurationName);
            keys.put("category", categoryName);
            categoryObjectName = new ObjectName(this.objectName.getDomain(), keys);
            CategoryDynamicMBean categoryMBean = new CategoryDynamicMBean(categoryObjectName, this.configurationName, categoryName);
            this.server.registerMBean(categoryMBean, categoryObjectName);
            this.alMbeanAttributes.add(new MBeanAttributeInfo("category=" + categoryName, "javax.management.ObjectName", "The " + categoryName + " category.", true, true, false));
        }
        catch (Exception e) {
            System.out.println("Could not add CategoryMBean for [" + categoryName + "]." + e);
        }
    }

    public void postRegister(Boolean registrationDone) {
        System.out.println("postRegister called");
        this.categoryMBeanRegistration();
    }

    void categoryMBeanDeregistration() {
        Configuration configuration = ConfigurationManager.getConfiguration(this.configurationName);
        String[] categoryNames = configuration.getCategoryNames();
        for (int i = 0; i < categoryNames.length; ++i) {
            this.unregisterCategoryMBean(categoryNames[i]);
        }
        this.alMbeanAttributes.clear();
    }

    void unregisterCategoryMBean(String categoryName) {
        System.out.println("Removing CategoryMBean for category named " + categoryName);
        ObjectName categoryObjectName = null;
        try {
            Hashtable<String, String> keys = new Hashtable<String, String>();
            keys.put("configuration", this.configurationName);
            keys.put("category", categoryName);
            categoryObjectName = new ObjectName(this.objectName.getDomain(), keys);
            this.server.unregisterMBean(categoryObjectName);
        }
        catch (Exception e) {
            System.out.println("Could not add CategoryMBean for [" + categoryName + "]." + e);
        }
    }
}

