/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.jmx;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.jconfig.Category;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.jmx.AbstractDynamicMBean;

public class CategoryDynamicMBean
extends AbstractDynamicMBean {
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private ArrayList alAttributes = new ArrayList();
    private String dClassName = this.getClass().getName();
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[0];
    private String dDescription = "This MBean acts as a management facade for categories.";
    private ObjectName objectName;
    private String configurationName;
    private String categoryName;

    public CategoryDynamicMBean(ObjectName objectName, String configurationName, String categoryName) {
        this.configurationName = configurationName;
        this.categoryName = categoryName;
        this.objectName = objectName;
        this.buildDynamicMBeanInfo();
    }

    private void buildDynamicMBeanInfo() {
        Constructor<?>[] constructors = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("CategoryDynamicMBean(): Constructs a CategoryDynamicMBean instance", constructors[0]);
        this.alAttributes.add(new MBeanAttributeInfo("name", "java.lang.String", "The name of this Category.", true, false, false));
        Configuration configuration = ConfigurationManager.getConfiguration(this.configurationName);
        Category category = configuration.getCategory(this.categoryName);
        Properties properties = category.getProperties();
        Enumeration<Object> propertiesEnum = properties.keys();
        while (propertiesEnum.hasMoreElements()) {
            String propertyName = (String)propertiesEnum.nextElement();
            this.alAttributes.add(new MBeanAttributeInfo(propertyName, "java.lang.String", "The name of this Property.", true, true, false));
        }
    }

    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] attribs = new MBeanAttributeInfo[this.alAttributes.size()];
        this.alAttributes.toArray(attribs);
        MBeanInfo mb = new MBeanInfo(this.dClassName, this.dDescription, attribs, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
        return mb;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        String value = null;
        if (attributeName.equals("name")) {
            value = this.categoryName;
        } else {
            Configuration configuration = ConfigurationManager.getConfiguration(this.configurationName);
            Category category = configuration.getCategory(this.categoryName);
            if (category.getProperty(attributeName) != null) {
                value = category.getProperty(attributeName);
            }
        }
        return value;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String attributeName = attribute.getName();
        Object value = attribute.getValue();
        if (attributeName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
        Configuration configuration = ConfigurationManager.getConfiguration(this.configurationName);
        Category category = configuration.getCategory(this.categoryName);
        category.setProperty(attributeName, (String)value);
    }

    public void postRegister(Boolean registrationDone) {
    }
}

