/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.error.ErrorReporter;
import org.jconfig.handler.BaseXMLHandler;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.parser.ConfigurationParser;
import org.jconfig.parser.ConfigurationParserFactory;
import org.jconfig.utils.ConfigErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLFileHandler
extends BaseXMLHandler
implements ConfigurationHandler {
    private boolean validate = false;
    private File file;

    public XMLFileHandler() {
    }

    public XMLFileHandler(String filename) {
        this.file = new File(filename);
        this.addFileListener(this);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setValidation(boolean validate) {
        this.validate = validate;
    }

    public synchronized Configuration load(String configurationName) throws ConfigurationManagerException {
        ConfigurationParser parser = ConfigurationParserFactory.getParser(configurationName);
        return this.load(this.file, configurationName, parser);
    }

    public Configuration load(String configurationName, ConfigurationParser parser) throws ConfigurationManagerException {
        return this.load(this.file, configurationName, parser);
    }

    public synchronized Configuration load(File file, String configurationName) throws ConfigurationManagerException {
        ConfigurationParser parser = ConfigurationParserFactory.getParser(configurationName);
        return this.load(file, configurationName, parser);
    }

    public synchronized Configuration load(File file, String configName, ConfigurationParser parser) throws ConfigurationManagerException {
        if (file == null) {
            ErrorReporter.getErrorHandler().reportError("The file is NULL");
            throw new ConfigurationManagerException("The file is NULL");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(this.validate);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            ErrorReporter.getErrorHandler().reportError("The parser cannot create a new document builder", pce);
            throw new ConfigurationManagerException("The parser cannot create a new document builder: " + pce.getMessage());
        }
        if (this.validate) {
            try {
                OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
                db.setErrorHandler(new ConfigErrorHandler(new PrintWriter((Writer)errorWriter, true)));
            }
            catch (Exception e) {
                ErrorReporter.getErrorHandler().reportError("The parser cannot set up the error handler");
                throw new ConfigurationManagerException("The parser cannot set up the error handler");
            }
        }
        Document doc = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            InputSource ins = new InputSource(fis);
            BufferedInputStream buffy = new BufferedInputStream(fis);
            ins = new InputSource(buffy);
            doc = db.parse(file);
        }
        catch (SAXException se) {
            ErrorReporter.getErrorHandler().reportError("The parser cannot parse the file", se);
            throw new ConfigurationManagerException("The parser cannot parse the file: " + se.getMessage());
        }
        catch (IOException ioe) {
            ErrorReporter.getErrorHandler().reportError("The parser cannot parse the file", ioe);
            throw new ConfigurationManagerException("The parser cannot open the file: " + ioe.getMessage());
        }
        Configuration config = parser.parse(doc, configName);
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                if (str.indexOf("encoding") <= -1) continue;
                config.setEncoding(this.getEncodingType(str));
            }
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        config.resetCreated();
        return config;
    }

    public void store(Configuration configuration) throws ConfigurationManagerException {
        this.store(this.file, configuration);
    }

    public File getFile() {
        return this.file;
    }
}

