/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.URLFileWatcher;
import org.jconfig.error.ErrorReporter;
import org.jconfig.event.FileListener;
import org.jconfig.event.FileListenerEvent;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.parser.ConfigurationParser;
import org.jconfig.parser.ConfigurationParserFactory;
import org.jconfig.utils.ConfigErrorHandler;
import org.jconfig.utils.ConfigurationUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class URLHandler
implements ConfigurationHandler,
FileListener {
    private boolean validate = false;
    private String url;
    private URLFileWatcher watcher = null;

    public void setURL(String url) {
        this.url = url;
    }

    public void setValidation(boolean validate) {
        this.validate = validate;
    }

    public synchronized Configuration load() throws ConfigurationManagerException {
        Configuration c = this.load(this.url);
        this.addFileListener(this);
        return c;
    }

    public void fileChanged(FileListenerEvent event) {
        try {
            this.load();
        }
        catch (ConfigurationManagerException e) {
            ErrorReporter.getErrorHandler().reportError("Error while reloading", e);
        }
    }

    public synchronized Configuration load(String configName) throws ConfigurationManagerException {
        ConfigurationParser parser = ConfigurationParserFactory.getParser(configName);
        return this.load(this.getURL(), configName, parser);
    }

    public synchronized Configuration load(String configName, ConfigurationParser parser) throws ConfigurationManagerException {
        return this.load(this.getURL(), configName, parser);
    }

    protected Configuration load(String theURL, String configName) throws ConfigurationManagerException {
        ConfigurationParser parser = ConfigurationParserFactory.getParser(configName);
        return this.load(this.getURL(), configName, parser);
    }

    protected Configuration load(String theURL, String configName, ConfigurationParser parser) throws ConfigurationManagerException {
        URL jcfURL = null;
        InputStream is = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream jcf = cl.getResourceAsStream("jconfig.properties");
            if (jcf != null) {
                Properties jcfProperties = new Properties();
                jcfProperties.load(jcf);
                Properties prop = System.getProperties();
                if (jcfProperties.getProperty("http.proxyHost") != null) {
                    prop.put("http.proxyHost", jcfProperties.getProperty("http.proxyHost"));
                }
                if (jcfProperties.getProperty("http.proxyPort") != null) {
                    prop.put("http.proxyPort", jcfProperties.getProperty("http.proxyPort"));
                }
            }
            jcfURL = new URL(theURL);
            URLConnection con = jcfURL.openConnection();
            is = con.getInputStream();
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError("Problem with URL handling/connection/validating", e);
            throw new ConfigurationManagerException("Problem with URL handling/connection/validating: " + e.getMessage());
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(this.validate);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            ErrorReporter.getErrorHandler().reportError("The parser cannot create a new document builder", pce);
            throw new ConfigurationManagerException("The parser cannot create a new document builder: " + pce.getMessage());
        }
        if (this.validate) {
            try {
                OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
                db.setErrorHandler(new ConfigErrorHandler(new PrintWriter((Writer)errorWriter, true)));
            }
            catch (Exception e) {
                ErrorReporter.getErrorHandler().reportError("The parser cannot set up the error handler", e);
                throw new ConfigurationManagerException("The parser cannot set up the error handler");
            }
        }
        Document doc = null;
        try {
            doc = db.parse(is);
        }
        catch (SAXException se) {
            ErrorReporter.getErrorHandler().reportError("The parser cannot parse the XML", se);
            throw new ConfigurationManagerException("The parser cannot parse the XML: " + se.getMessage());
        }
        catch (IOException ioe) {
            ErrorReporter.getErrorHandler().reportError("The parser cannot open the file", ioe);
            throw new ConfigurationManagerException("The parser cannot open the file: " + ioe.getMessage());
        }
        Configuration config = parser.parse(doc, configName);
        config.resetCreated();
        return config;
    }

    public void store(Configuration configuration) throws ConfigurationManagerException {
    }

    public void addFileListener(FileListener fileListener) {
        try {
            String val = ConfigurationUtils.getConfigProperty("jconfig.filewatcher", "true");
            if (val.equalsIgnoreCase("true")) {
                this.watcher = new URLFileWatcher(this.getURL());
                this.watcher.addFileListener(fileListener);
                this.watcher.start();
            }
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError("Problem while setting up the watcher", e);
        }
    }

    public String getURL() {
        return this.url;
    }
}

