/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.DefaultConfiguration;
import org.jconfig.error.ErrorReporter;
import org.jconfig.handler.AbstractHandler;
import org.jconfig.parser.ConfigurationParser;
import org.jconfig.utils.ResourceLocator;

public class PropertiesFileHandler
extends AbstractHandler {
    private File file;

    public PropertiesFileHandler() {
    }

    public PropertiesFileHandler(String filename) {
        this(new File(filename));
    }

    public PropertiesFileHandler(File file) {
        this.file = file;
        this.addFileListener(this);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public synchronized Configuration load(String configName) throws ConfigurationManagerException {
        return this.loadPropertiesFile(this.file, configName);
    }

    private Configuration loadPropertiesFile(File file, String configName) throws ConfigurationManagerException {
        DefaultConfiguration config = new DefaultConfiguration(configName);
        if (file == null) {
            ErrorReporter.getErrorHandler().reportError("The file is NULL");
            throw new ConfigurationManagerException("The file is NULL");
        }
        try {
            InputStream inputStream = null;
            if (file.exists()) {
                inputStream = new FileInputStream(file);
            } else {
                ResourceLocator locator = new ResourceLocator(file.getName());
                inputStream = locator.getInputStream();
            }
            if (inputStream == null) {
                ErrorReporter.getErrorHandler().reportError("Cannot find the properties file");
                throw new ConfigurationManagerException("Cannot find the properties file");
            }
            Properties myProperties = new Properties();
            myProperties.load(inputStream);
            Enumeration<?> propertyNames = myProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                String value = myProperties.getProperty(name);
                config.setProperty(name, value);
            }
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError("The file cannot be loaded", e);
            throw new ConfigurationManagerException("The file cannot be loaded:" + e.getMessage());
        }
        config.resetCreated();
        return config;
    }

    public void store(Configuration configuration) throws ConfigurationManagerException {
        String[] categories = configuration.getCategoryNames();
        try {
            FileWriter fw = new FileWriter(this.file);
            fw.write("#\n");
            fw.write("# automatically generated properties file\n");
            fw.write("#\n");
            for (int i = 0; i < categories.length; ++i) {
                fw.write("#\n");
                fw.write("# category: " + categories[i] + "\n");
                fw.write("#\n");
                String[] propNames = configuration.getPropertyNames(categories[i]);
                for (int j = 0; j < propNames.length; ++j) {
                    fw.write(categories[i] + "." + propNames[j] + "=" + configuration.getProperty(propNames[j], "", categories[i]) + "\n");
                }
            }
            fw.close();
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError("The file cannot be saved", e);
            throw new ConfigurationManagerException("The file cannot be saved");
        }
    }

    public File getFile() {
        return this.file;
    }

    public Configuration load(String configurationName, ConfigurationParser parser) throws ConfigurationManagerException {
        throw new ConfigurationManagerException("Using a specific parser with this handler is not supported");
    }
}

