/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.DefaultConfiguration;
import org.jconfig.error.ErrorReporter;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.parser.ConfigurationParser;

public class LDAPHandler
implements ConfigurationHandler {
    private String baseDN;

    public Configuration load(String configurationName) throws ConfigurationManagerException {
        InitialDirContext ctx = this.getContext();
        if (ctx == null) {
            throw new ConfigurationManagerException("There is no connection to the LDAP server");
        }
        DefaultConfiguration config = new DefaultConfiguration(null);
        this.getCategories(ctx, config);
        this.getAllProperties(ctx, config);
        return config;
    }

    private void getCategories(InitialDirContext ctx, Configuration config) {
        try {
            SearchControls sctrl = new SearchControls();
            String filter = "(&(objectclass=organizationalUnit)(ou=*))";
            NamingEnumeration<SearchResult> enm = ctx.search(this.baseDN, filter, sctrl);
            while (enm.hasMore()) {
                SearchResult sr = enm.next();
                config.setCategory(sr.getName());
            }
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError(e.getLocalizedMessage(), e);
        }
    }

    private void getAllProperties(InitialDirContext ctx, Configuration config) {
    }

    public void store() throws ConfigurationManagerException {
        throw new RuntimeException("not yet implemented");
    }

    private InitialDirContext getContext() {
        Properties props = new Properties();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("ldap.properties");
            if (is == null) {
                return null;
            }
            props.load(is);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", props.getProperty("Context", ""));
            env.put("java.naming.provider.url", props.getProperty("Host", ""));
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", props.getProperty("RootDN", ""));
            env.put("java.naming.security.credentials", props.getProperty("Password", ""));
            this.baseDN = props.getProperty("BaseDN", "");
            return new InitialDirContext(env);
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError(e.getLocalizedMessage(), e);
            return null;
        }
    }

    public void store(Configuration configuration) throws ConfigurationManagerException {
        throw new RuntimeException("not yet implemented");
    }

    public Configuration load(String configurationName, ConfigurationParser parser) throws ConfigurationManagerException {
        throw new ConfigurationManagerException("Using a specific parser with this handler is not supported");
    }
}

