/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jconfig.Category;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.DefaultConfiguration;
import org.jconfig.error.ErrorReporter;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.parser.ConfigurationParser;
import org.jconfig.utils.ResourceLocator;

public class JDBCHandler
implements ConfigurationHandler {
    private String driver;
    private String jdbcurl;
    private String user;
    private String pwd;
    private Connection con;

    public Configuration load(String configurationName) throws ConfigurationManagerException {
        if (configurationName == null) {
            ErrorReporter.getErrorHandler().reportError("Configuration name cannot be <null>");
            throw new ConfigurationManagerException("Configuration name cannot be <null>");
        }
        if (configurationName.length() == 0) {
            ErrorReporter.getErrorHandler().reportError("Configuration name not valid. Empty String not allowed");
            throw new ConfigurationManagerException("Configuration name not valid. Empty String not allowed");
        }
        this.setupJDBC();
        return this.loadConfiguration(configurationName);
    }

    private void setupJDBC() throws ConfigurationManagerException {
        this.loadJDBCProperties();
        this.loadJDBCDriver();
        this.con = this.JDBCLogin();
    }

    private Configuration loadConfiguration(String configurationName) throws ConfigurationManagerException {
        DefaultConfiguration config = new DefaultConfiguration(configurationName);
        try {
            PreparedStatement pstmt = this.con.prepareStatement("SELECT OID FROM T_CONFIGURATION WHERE NAME = ?");
            pstmt.setString(1, configurationName);
            ResultSet result = pstmt.executeQuery();
            while (result.next()) {
                long oid = result.getLong("OID");
                this.loadCategories(config, oid);
                this.loadVariables(config, oid);
            }
            result.close();
            pstmt.close();
            this.con.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem retrieving Configuration from database", e);
            throw new ConfigurationManagerException("Problem retrieving Configuration from database. " + e.getMessage());
        }
        return config;
    }

    private void loadCategories(Configuration config, long oid) throws ConfigurationManagerException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement("SELECT OID, NAME FROM T_CATEGORY WHERE CONFIGURATION_OID = ?");
            pstmt.setLong(1, oid);
            ResultSet result = pstmt.executeQuery();
            while (result.next()) {
                long catoid = result.getLong("OID");
                String categoryName = result.getString("NAME");
                Category cat = config.getCategory(categoryName);
                this.loadProperties(cat, catoid);
            }
            result.close();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem retrieving categories", e);
            throw new ConfigurationManagerException("Problem retrieving categories. " + e.getMessage());
        }
    }

    private Hashtable readOldCategories(long oid) throws ConfigurationManagerException {
        Hashtable<Long, String> oldCategories = new Hashtable<Long, String>();
        try {
            PreparedStatement pstmt = this.con.prepareStatement("SELECT OID, NAME FROM T_CATEGORY WHERE CONFIGURATION_OID = ?");
            pstmt.setLong(1, oid);
            ResultSet result = pstmt.executeQuery();
            while (result.next()) {
                Long catoid = new Long(result.getLong("OID"));
                String categoryName = result.getString("NAME");
                oldCategories.put(catoid, categoryName);
            }
            result.close();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem retrieving categories", e);
            throw new ConfigurationManagerException("Problem retrieving categories. " + e.getMessage());
        }
        return oldCategories;
    }

    private void loadVariables(Configuration config, long oid) throws ConfigurationManagerException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement("SELECT OID, NAME, VALUE FROM T_VARIABLE WHERE CONFIGURATION_OID = ?");
            pstmt.setLong(1, oid);
            ResultSet result = pstmt.executeQuery();
            while (result.next()) {
                long catoid = result.getLong("OID");
                String variableName = result.getString("NAME");
                String variableValue = result.getString("VALUE");
                config.setVariable(variableName, variableValue);
            }
            result.close();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem retrieving variables", e);
            throw new ConfigurationManagerException("Problem retrieving variables. " + e.getMessage());
        }
    }

    private Hashtable readOldVariables(long oid) throws ConfigurationManagerException {
        Hashtable<Long, String> oldVariables = new Hashtable<Long, String>();
        try {
            PreparedStatement pstmt = this.con.prepareStatement("SELECT OID, NAME, VALUE FROM T_VARIABLE WHERE CONFIGURATION_OID = ?");
            pstmt.setLong(1, oid);
            ResultSet result = pstmt.executeQuery();
            while (result.next()) {
                long catoid = result.getLong("OID");
                String variableName = result.getString("NAME");
                oldVariables.put(new Long(catoid), variableName);
            }
            result.close();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem retrieving old variables", e);
            throw new ConfigurationManagerException("Problem retrieving old variables. " + e.getMessage());
        }
        return oldVariables;
    }

    private Hashtable readOldProperties(long catoid) throws ConfigurationManagerException {
        Hashtable<Long, String> oldProperties = new Hashtable<Long, String>();
        try {
            PreparedStatement pstmt = this.con.prepareStatement("SELECT OID, NAME, VALUE FROM T_PROPERTY WHERE CATEGORY_OID = ? ");
            pstmt.setLong(1, catoid);
            ResultSet result = pstmt.executeQuery();
            while (result.next()) {
                long propoid = result.getLong("OID");
                String propertyName = result.getString("NAME");
                oldProperties.put(new Long(propoid), propertyName);
            }
            result.close();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem retrieving properties", e);
            throw new ConfigurationManagerException("Problem retrieving properties from database. " + e.getMessage());
        }
        return oldProperties;
    }

    private void loadProperties(Category cat, long catoid) throws ConfigurationManagerException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement("SELECT OID, NAME, VALUE FROM T_PROPERTY WHERE CATEGORY_OID = ? ");
            pstmt.setLong(1, catoid);
            ResultSet result = pstmt.executeQuery();
            while (result.next()) {
                long propoid = result.getLong("OID");
                String propertyName = result.getString("NAME");
                String propertyValue = result.getString("VALUE");
                cat.setProperty(propertyName, propertyValue);
            }
            result.close();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem retrieving properties", e);
            throw new ConfigurationManagerException("Problem retrieving properties from database. " + e.getMessage());
        }
    }

    private void loadJDBCDriver() throws ConfigurationManagerException {
        if (this.driver == null) {
            throw new ConfigurationManagerException("JDBC Driver name is <null>. Check jconfig.properties for org.jconfig.jdbcdriver.");
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            ErrorReporter.getErrorHandler().reportError("JDBC Driver " + e.getMessage() + " was not found.");
            throw new ConfigurationManagerException("JDBC Driver " + e.getMessage() + " was not found.");
        }
    }

    private void loadJDBCProperties() throws ConfigurationManagerException {
        try {
            ResourceLocator locator = new ResourceLocator("jconfig.properties");
            InputStream is = locator.getInputStream();
            if (is == null) {
                ErrorReporter.getErrorHandler().reportError("Problem locating jconfig.properties.");
                throw new ConfigurationManagerException("Problem locating jconfig.properties.");
            }
            Properties jcfProperties = new Properties();
            jcfProperties.load(is);
            this.driver = jcfProperties.getProperty("org.jconfig.jdbc.driver");
            this.jdbcurl = jcfProperties.getProperty("org.jconfig.jdbc.url");
            this.user = jcfProperties.getProperty("org.jconfig.jdbc.user");
            this.pwd = jcfProperties.getProperty("org.jconfig.jdbc.pwd");
        }
        catch (IOException e) {
            ErrorReporter.getErrorHandler().reportError("Problem locating jconfig.properties.", e);
            throw new ConfigurationManagerException("Problem locating jconfig.properties. " + e.getMessage());
        }
    }

    protected Connection JDBCLogin() throws ConfigurationManagerException {
        if (this.jdbcurl == null) {
            ErrorReporter.getErrorHandler().reportError("JDBC URL is <null>. Check jconfig.properties for org.jconfig.jdbc.url.");
            throw new ConfigurationManagerException("JDBC URL is <null>. Check jconfig.properties for org.jconfig.jdbc.url.");
        }
        if (this.user == null) {
            ErrorReporter.getErrorHandler().reportError("JDBC USER is <null>. Check jconfig.properties for org.jconfig.jdbc.user.");
            throw new ConfigurationManagerException("JDBC USER is <null>. Check jconfig.properties for org.jconfig.jdbc.user.");
        }
        if (this.pwd == null) {
            ErrorReporter.getErrorHandler().reportError("JDBC PASSWORD is <null>. Check jconfig.properties for org.jconfig.jdbc.pwd");
            throw new ConfigurationManagerException("JDBC PASSWORD is <null>. Check jconfig.properties for org.jconfig.jdbc.pwd.");
        }
        try {
            return DriverManager.getConnection(this.jdbcurl, this.user, this.pwd);
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem getting JDBC Connection", e);
            throw new ConfigurationManagerException("Problem getting JDBC Connection: " + e.getMessage());
        }
    }

    public void store(Configuration configuration) throws ConfigurationManagerException {
        this.setupJDBC();
        long confoid = this.storeConfiguration(configuration.getConfigName());
        Hashtable oldCategories = this.readOldCategories(confoid);
        String[] categoryNameArray = configuration.getCategoryNames();
        for (int i = 0; i < categoryNameArray.length; ++i) {
            String categoryName = categoryNameArray[i];
            long catid = this.storeCategory(confoid, categoryName);
            oldCategories.remove(new Long(catid));
            this.storeProperties(catid, configuration.getCategory(categoryName));
        }
        Enumeration enumCat = oldCategories.keys();
        while (enumCat.hasMoreElements()) {
            Long catid = (Long)enumCat.nextElement();
            this.deleteCategory(catid, oldCategories.get(catid).toString());
        }
        String[] variableNameArray = this.getStringArray(configuration.getVariables());
        Hashtable oldVariables = this.readOldVariables(confoid);
        for (int i = 0; i < variableNameArray.length; ++i) {
            String variableName = variableNameArray[i];
            long varoid = this.storeVariable(confoid, variableName, configuration.getVariable(variableName));
            oldVariables.remove(new Long(varoid));
        }
        Enumeration enumVar = oldVariables.keys();
        while (enumVar.hasMoreElements()) {
            Long varoid = (Long)enumVar.nextElement();
            this.deleteVariable(varoid, oldVariables.get(varoid).toString());
        }
        this.closeConnection();
    }

    private void closeConnection() throws ConfigurationManagerException {
        try {
            this.con.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem closing database connection.", e);
            throw new ConfigurationManagerException("Problem closing database connection. " + e.getMessage());
        }
    }

    private void storeProperties(long catid, Category category) throws ConfigurationManagerException {
        Enumeration<Object> enm = category.getProperties().keys();
        Hashtable oldProperties = this.readOldProperties(catid);
        while (enm.hasMoreElements()) {
            String propertyName = (String)enm.nextElement();
            long propoid = this.storeProperty(catid, propertyName, category.getProperty(propertyName));
            oldProperties.remove(new Long(propoid));
        }
        Enumeration enumeration = oldProperties.keys();
        while (enumeration.hasMoreElements()) {
            Long propoid = (Long)enumeration.nextElement();
            this.deleteProperty(propoid, oldProperties.get(propoid).toString());
        }
    }

    private long storeProperty(long catoid, String propertyName, String propertyValue) throws ConfigurationManagerException {
        long propoid = Long.MIN_VALUE;
        try {
            PreparedStatement pstmt = this.con.prepareStatement("SELECT OID FROM T_PROPERTY WHERE CATEGORY_OID = ? AND NAME= ?");
            pstmt.setLong(1, catoid);
            pstmt.setString(2, propertyName);
            ResultSet result = pstmt.executeQuery();
            while (result.next()) {
                propoid = result.getLong("OID");
                this.updateProperty(propoid, propertyValue);
            }
            result.close();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem storing configuration in database.", e);
            throw new ConfigurationManagerException("Problem storing configuration in database. " + e.getMessage());
        }
        if (propoid == Long.MIN_VALUE) {
            this.createNewProperty(catoid, propertyName, propertyValue);
            return this.storeProperty(catoid, propertyName, propertyValue);
        }
        return propoid;
    }

    private void updateProperty(long propoid, String propertyValue) throws ConfigurationManagerException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement("UPDATE T_PROPERTY SET VALUE=? WHERE OID=?");
            pstmt.setString(1, propertyValue);
            pstmt.setLong(2, propoid);
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError(propertyValue + " variable value could not be stored.", e);
            throw new ConfigurationManagerException(propertyValue + " variable value could not be stored." + e.getMessage());
        }
    }

    private void createNewProperty(long catoid, String propertyName, String propertyValue) throws ConfigurationManagerException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement("INSERT INTO T_PROPERTY (NAME, VALUE, CATEGORY_OID) VALUES (?, ?, ?)");
            pstmt.setString(1, propertyName);
            pstmt.setString(2, propertyValue);
            pstmt.setLong(3, catoid);
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError(propertyValue + " property value could not be stored.", e);
            throw new ConfigurationManagerException(propertyName + " property could not be stored." + e.getMessage());
        }
    }

    private long storeVariable(long confoid, String variableName, String variableValue) throws ConfigurationManagerException {
        long varoid = Long.MIN_VALUE;
        try {
            PreparedStatement pstmt = this.con.prepareStatement("SELECT OID FROM T_VARIABLE WHERE CONFIGURATION_OID = ? AND NAME= ?");
            pstmt.setLong(1, confoid);
            pstmt.setString(2, variableName);
            ResultSet result = pstmt.executeQuery();
            while (result.next()) {
                varoid = result.getLong("OID");
                this.updateVariable(varoid, variableValue);
            }
            result.close();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError(variableName + " variable value could not be stored.", e);
            throw new ConfigurationManagerException("Problem sotring variable in database. " + e.getMessage());
        }
        if (varoid == Long.MIN_VALUE) {
            this.createNewVariable(confoid, variableName, variableValue);
            return this.storeVariable(confoid, variableName, variableValue);
        }
        return varoid;
    }

    private void updateVariable(long varoid, String variableValue) throws ConfigurationManagerException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement("UPDATE T_VARIABLE SET VALUE=? WHERE OID=?");
            pstmt.setString(1, variableValue);
            pstmt.setLong(2, varoid);
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError(variableValue + " variable value could not be stored.", e);
            throw new ConfigurationManagerException(variableValue + " variable value could not be stored." + e.getMessage());
        }
    }

    private void createNewVariable(long confoid, String variableName, String variableValue) throws ConfigurationManagerException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement("INSERT INTO T_VARIABLE (NAME, VALUE, CONFIGURATION_OID) VALUES (?, ?, ?)");
            pstmt.setString(1, variableName);
            pstmt.setString(2, variableValue);
            pstmt.setLong(3, confoid);
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError(variableValue + " variable value could not be stored.", e);
            throw new ConfigurationManagerException(variableName + " variable could not be stored." + e.getMessage());
        }
    }

    private long storeCategory(long confoid, String categoryName) throws ConfigurationManagerException {
        long catoid = Long.MIN_VALUE;
        try {
            PreparedStatement pstmt = this.con.prepareStatement("SELECT OID FROM T_CATEGORY WHERE CONFIGURATION_OID = ? AND NAME = ?");
            pstmt.setLong(1, confoid);
            pstmt.setString(2, categoryName);
            ResultSet result = pstmt.executeQuery();
            while (result.next()) {
                catoid = result.getLong("OID");
            }
            result.close();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem storing category " + categoryName + ". ", e);
            throw new ConfigurationManagerException("Problem storing category " + categoryName + ". " + e.getMessage());
        }
        if (catoid == Long.MIN_VALUE) {
            this.createNewCategory(confoid, categoryName);
            return this.storeCategory(confoid, categoryName);
        }
        return catoid;
    }

    private void deleteCategory(long confoid, String categoryName) throws ConfigurationManagerException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement("DELETE FROM T_CATEGORY WHERE CONFIGURATION_OID = ? AND NAME = ?");
            pstmt.setLong(1, confoid);
            pstmt.setString(2, categoryName);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem deleting category " + categoryName + ". ", e);
            throw new ConfigurationManagerException("Problem deleting category " + categoryName + ". " + e.getMessage());
        }
    }

    private void deleteProperty(long propoid, String propertyName) throws ConfigurationManagerException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement("DELETE FROM T_PROPERTY WHERE OID = ? AND NAME = ?");
            pstmt.setLong(1, propoid);
            pstmt.setString(2, propertyName);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem deleting property " + propertyName + ". ", e);
            throw new ConfigurationManagerException("Problem deleting property " + propertyName + ". " + e.getMessage());
        }
    }

    private void deleteVariable(long varoid, String variableName) throws ConfigurationManagerException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement("DELETE FROM T_VARIABLE WHERE OID = ? ");
            pstmt.setLong(1, varoid);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem deleting variable " + variableName + ". ", e);
            throw new ConfigurationManagerException("Problem deleting variable " + variableName + ". " + e.getMessage());
        }
    }

    private void createNewCategory(long confoid, String categoryName) throws ConfigurationManagerException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement("INSERT INTO T_CATEGORY (NAME, CONFIGURATION_OID) VALUES (?, ?)");
            pstmt.setString(1, categoryName);
            pstmt.setLong(2, confoid);
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem storing category " + categoryName + ". ", e);
            throw new ConfigurationManagerException(categoryName + " category could not be stored." + e.getMessage());
        }
    }

    private long storeConfiguration(String configurationName) throws ConfigurationManagerException {
        long oid = Long.MIN_VALUE;
        try {
            PreparedStatement pstmt = this.con.prepareStatement("SELECT OID FROM T_CONFIGURATION WHERE NAME = ?");
            pstmt.setString(1, configurationName);
            ResultSet result = pstmt.executeQuery();
            while (result.next()) {
                oid = result.getLong("OID");
            }
            result.close();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem storing configuration in database.", e);
            throw new ConfigurationManagerException("Problem storing configuration in database. " + e.getMessage());
        }
        if (oid == Long.MIN_VALUE) {
            this.createNewConfiguration(configurationName);
            return this.storeConfiguration(configurationName);
        }
        return oid;
    }

    private void createNewConfiguration(String configurationName) throws ConfigurationManagerException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement("INSERT INTO T_CONFIGURATION (NAME) VALUES (?)");
            pstmt.setString(1, configurationName);
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            ErrorReporter.getErrorHandler().reportError("Problem storing configuration in database.", e);
            throw new ConfigurationManagerException(configurationName + " configuration could not be stored." + e.getMessage());
        }
    }

    private String[] getStringArray(Map categories) {
        Set allCategories = categories.keySet();
        return allCategories.toArray(new String[0]);
    }

    public Configuration load(String configurationName, ConfigurationParser parser) throws ConfigurationManagerException {
        throw new ConfigurationManagerException("Using a specific parser with this handler is not supported");
    }
}

