/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class VariableManager {
    private static VariableManager vm = null;
    private HashMap varMapping;
    private Properties envVariables;
    private HashMap includedProperties;
    private HashMap inheritance = new HashMap();

    private VariableManager() {
        this.varMapping = new HashMap();
        this.includedProperties = new HashMap();
    }

    public static VariableManager getInstance() {
        if (vm == null) {
            vm = new VariableManager();
        }
        return vm;
    }

    public HashMap getVariables(String configName) {
        Vector includes;
        HashMap vars = (HashMap)this.varMapping.get(configName);
        if (vars == null) {
            vars = new HashMap();
        }
        if ((includes = (Vector)this.includedProperties.get(configName)) != null) {
            for (int i = 0; i < includes.size(); ++i) {
                String name = (String)includes.get(i);
                if (!vars.containsKey(name)) continue;
                vars.remove(name);
            }
        }
        return vars;
    }

    public String getVariable(String configName, String name) {
        HashMap vars = (HashMap)this.varMapping.get(configName);
        if (vars != null && vars.containsKey(name)) {
            return (String)vars.get(name);
        }
        if (this.inheritance.containsKey(configName)) {
            String base = (String)this.inheritance.get(configName);
            return this.getVariable(base, name);
        }
        return null;
    }

    public void setInheritance(String configName, String baseConfig) {
        if (!this.inheritance.containsKey(configName) && baseConfig != null) {
            this.inheritance.put(configName, baseConfig);
        }
    }

    public void addVariable(String varName, String varValue, String configName) {
        HashMap<String, String> vars = (HashMap<String, String>)this.varMapping.get(configName);
        if (vars == null) {
            vars = new HashMap<String, String>();
        }
        vars.put(varName, varValue);
        this.varMapping.put(configName, vars);
    }

    public void removeVariable(String varName, String configName) {
        HashMap vars = (HashMap)this.varMapping.get(configName);
        if (vars != null) {
            vars.remove(varName);
            this.varMapping.put(configName, vars);
        }
    }

    public void addIncludedVariable(String varName, String varValue, String configName) {
        this.addVariable(varName, varValue, configName);
        Vector<String> includes = (Vector<String>)this.includedProperties.get(configName);
        if (includes == null) {
            includes = new Vector<String>();
        }
        includes.add(varName);
        this.includedProperties.put(configName, includes);
    }

    public String replaceVariables(String text, String configName) {
        Map vars = (Map)this.varMapping.get(configName);
        if (vars != null && vars.size() > 0) {
            text = this.replaceVar(text, vars, configName);
        }
        text = this.replaceEnvVar(text);
        return this.replaceSystemVar(text);
    }

    private String replaceVar(String text, Map vars, String configName) {
        int endPosition;
        if (text == null) {
            return text;
        }
        int startPosition = text.indexOf("${");
        if (startPosition == -1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        int textLength = text.length();
        int lastIndex = 0;
        while (startPosition > -1 && startPosition + 2 < textLength && (endPosition = text.indexOf("}", startPosition + 2)) != -1) {
            buffer.append(text.substring(lastIndex, startPosition));
            String currentKey = text.substring(startPosition + 2, endPosition);
            String value = this.getVariable(configName, currentKey);
            if (value != null) {
                value = this.replaceVar(value, vars, configName);
                buffer.append(value);
                lastIndex = endPosition + 1;
            } else {
                buffer.append(text.charAt(startPosition));
                buffer.append(text.charAt(startPosition + 1));
                lastIndex = startPosition + 2;
            }
            startPosition = text.indexOf("${", lastIndex);
        }
        buffer.append(text.substring(lastIndex, textLength));
        return buffer.toString();
    }

    protected String replaceEnvVar(String text) {
        if (text != null) {
            if (this.envVariables == null && text.indexOf("${env:") != -1) {
                this.envVariables = this.getEnvVars();
            }
            int idx = text.indexOf("${env:");
            while (idx != -1) {
                String firstPart = text.substring(0, idx);
                String tmp = text.substring(idx + 6);
                String envVar = tmp.substring(0, tmp.indexOf("}"));
                String secondPart = text.substring(idx + envVar.length() + 7);
                String value = this.envVariables.getProperty(envVar);
                if (value == null) {
                    value = "${env:" + envVar + "}";
                }
                text = firstPart + value + secondPart;
                idx = text.indexOf("${env:", idx + 1);
            }
        }
        return text;
    }

    protected String replaceSystemVar(String text) {
        if (text != null) {
            int idx = text.indexOf("${system:");
            while (idx != -1) {
                String firstPart = text.substring(0, idx);
                String tmp = text.substring(idx + 9);
                String sysVar = tmp.substring(0, tmp.indexOf("}"));
                String secondPart = text.substring(idx + sysVar.length() + 10);
                String value = System.getProperty(sysVar);
                if (value == null) {
                    value = "${system:" + sysVar + "}";
                }
                text = firstPart + value + secondPart;
                idx = text.indexOf("${system:", idx + 1);
            }
        }
        return text;
    }

    private Properties getEnvVars() {
        Process p = null;
        Properties envVars = new Properties();
        BufferedReader br = null;
        try {
            String line;
            Runtime r = Runtime.getRuntime();
            String OS = System.getProperty("os.name").toLowerCase();
            p = OS.indexOf("windows 9") > -1 ? r.exec("command.com /c set") : (OS.indexOf("nt") > -1 || OS.indexOf("windows 2000") > -1 || OS.indexOf("windows xp") > -1 ? r.exec("cmd.exe /c set") : r.exec("env"));
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                int idx = line.indexOf(61);
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                envVars.setProperty(key, value);
            }
            br.close();
        }
        catch (Exception e) {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        return envVars;
    }
}

