/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.jconfig.Category;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.DefaultConfiguration;
import org.jconfig.NestedCategory;
import org.jconfig.VariableManager;
import org.jconfig.event.ConfigurationChangedEventImpl;

public class NestedConfiguration
extends DefaultConfiguration
implements Serializable,
Configuration {
    private static final VariableManager vm = VariableManager.getInstance();
    private EventListenerList configurationListenerList = new EventListenerList();

    public NestedConfiguration(String configName) {
        super(configName);
    }

    public String[] getCategoryNames() {
        Set allCategories = this.categories.keySet();
        Vector<String> all = new Vector<String>();
        Iterator it = allCategories.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            this.addCategoryName(all, name);
        }
        if (this.baseConfigName != null) {
            Configuration cfg = ConfigurationManager.getConfiguration(this.baseConfigName);
            String[] parentCategories = cfg.getCategoryNames();
            for (int i = 0; i < parentCategories.length; ++i) {
                if (all.indexOf(parentCategories[i]) != -1) continue;
                all.add(parentCategories[i]);
            }
        }
        return all.toArray(new String[0]);
    }

    private void addCategoryName(Vector all, String name) {
        all.add(name);
        NestedCategory myCat = (NestedCategory)this.getCategory(name);
        Collection children = myCat.getChildCategories();
        if (children.size() > 0) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                NestedCategory nc = (NestedCategory)it.next();
                String cp = name + "/" + nc.getCategoryName();
                this.addCategoryName(all, cp);
            }
        }
    }

    protected String[] getCategoryNames(boolean includeParent) {
        Set allCategories = this.categories.keySet();
        Vector all = new Vector(allCategories);
        if (this.baseConfigName != null && includeParent) {
            Configuration cfg = ConfigurationManager.getConfiguration(this.baseConfigName);
            String[] parentCategories = cfg.getCategoryNames();
            for (int i = 0; i < parentCategories.length; ++i) {
                if (all.indexOf(parentCategories[i]) != -1) continue;
                all.add(parentCategories[i]);
            }
        }
        return all.toArray(new String[0]);
    }

    public void setCategory(String name, boolean main) {
        if (name != null) {
            if (main) {
                this.mainCategory = name;
            }
            if (!this.categories.containsKey(name)) {
                NestedCategory category = new NestedCategory(name);
                category.setConfigurationName(this.configName);
                category.addCategoryListener(new DefaultConfiguration.MyCategoryListener());
                this.categories.put(name, category);
                this.markDirty();
                category.fireCategoryChangedEvent(new ConfigurationChangedEventImpl(4, category, null, null, null));
            }
        }
    }

    public void setCategory(Category category) {
        category.setConfigurationName(this.configName);
        category.addCategoryListener(new DefaultConfiguration.MyCategoryListener());
        this.categories.put(category.getCategoryName(), category);
        this.markDirty();
        category.fireCategoryChangedEvent(new ConfigurationChangedEventImpl(4, category, null, null, null));
    }

    public String getProperty(String key, String defaultValue, String categoryName) {
        boolean isMainCat = false;
        if (key == null) {
            return defaultValue;
        }
        if (categoryName == null) {
            isMainCat = true;
            categoryName = this.mainCategory;
        } else if (categoryName.indexOf("/") == -1 && !this.categories.containsKey(categoryName)) {
            isMainCat = true;
            categoryName = this.mainCategory;
        }
        String tmp = null;
        Category category = this.getCategory(categoryName);
        if (category != null) {
            if (category.getCategoryName().equals(this.mainCategory)) {
                isMainCat = true;
            }
            tmp = category.getProperty(key);
        }
        if (tmp == null && !isMainCat) {
            category = this.getCategory(this.mainCategory);
            tmp = category.getProperty(key);
        }
        if (tmp == null) {
            if (this.baseConfigName != null) {
                Configuration cfg = ConfigurationManager.getConfiguration(this.baseConfigName);
                tmp = cfg.getProperty(key, defaultValue, categoryName);
            } else {
                tmp = defaultValue;
            }
        }
        return tmp;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String[] cats = this.getCategoryNames();
        for (int i = 0; i < cats.length; ++i) {
            buffer.append("Category=");
            buffer.append(cats[i]);
            String[] propNames = this.getPropertyNames(cats[i]);
            if (propNames == null) continue;
            buffer.append("\n");
            for (int j = 0; j < propNames.length; ++j) {
                buffer.append("  ");
                buffer.append(propNames[j]);
                buffer.append("=");
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public String getXMLAsString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\"");
        if (this.getEncoding() != null) {
            buffer.append(" encoding=\"" + this.getEncoding() + "\"");
        }
        buffer.append(" ?>\n");
        buffer.append("<properties");
        if (this.baseConfigName != null) {
            buffer.append(" extends=\"");
            buffer.append(this.baseConfigName);
            buffer.append("\"");
        }
        buffer.append(">\n");
        this.addIncludeBlock(buffer);
        this.addVariableBlock(buffer);
        String[] cats = this.getCategoryNames(false);
        for (int i = 0; i < cats.length; ++i) {
            NestedCategory nc = (NestedCategory)this.getCategory(cats[i]);
            this.generateCategoryString(buffer, nc, nc.getCategoryName(), 0);
        }
        buffer.append("</properties>\n");
        return buffer.toString();
    }

    private void generateCategoryString(StringBuffer buffer, NestedCategory category, String categoryPath, int indent) {
        indent += 2;
        for (int i = 0; i < indent; ++i) {
            buffer.append(" ");
        }
        buffer.append("<category name=\"");
        buffer.append(this.escapeForXML(category.getCategoryName()));
        buffer.append("\">\n");
        SortedMap sm = this.getSortedProperties(categoryPath, false);
        if (sm != null) {
            Iterator nit = sm.keySet().iterator();
            while (nit.hasNext()) {
                String name = (String)nit.next();
                String value = (String)sm.get(name);
                for (int i = 0; i < indent + 2; ++i) {
                    buffer.append(" ");
                }
                buffer.append("<");
                buffer.append(this.escapeForXML(name));
                buffer.append(">");
                buffer.append(this.escapeForXML(value));
                buffer.append("</");
                buffer.append(this.escapeForXML(name));
                buffer.append(">\n");
            }
            Collection children = category.getChildCategories();
            if (children.size() > 0) {
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    NestedCategory nc = (NestedCategory)it.next();
                    String cp = categoryPath + "/" + nc.getCategoryName();
                    this.generateCategoryString(buffer, nc, cp, indent);
                }
            }
            for (int i = 0; i < indent; ++i) {
                buffer.append(" ");
            }
            buffer.append("</category>\n");
            indent -= 2;
        }
    }

    public Category getCategory(String name) {
        return this.getCategory(name, true);
    }

    private Category getCategory(String name, boolean create) {
        if (name == null) {
            name = this.mainCategory;
        }
        NestedCategory category = null;
        if (name.indexOf("/") != -1) {
            boolean first = true;
            StringTokenizer sto = new StringTokenizer(name, "/");
            while (sto.hasMoreElements()) {
                String current = (String)sto.nextElement();
                if (first) {
                    category = (NestedCategory)this.categories.get(current);
                    first = false;
                    continue;
                }
                if (category == null) continue;
                category = category.getCategory(current);
            }
        } else {
            category = (NestedCategory)this.categories.get(name);
            if (category == null && create) {
                category = new NestedCategory(name);
                this.categories.put(name, category);
            }
        }
        if (category == null && create) {
            category = this.createCategory(name);
        }
        return category;
    }

    private NestedCategory createCategory(String name) {
        StringTokenizer sto = new StringTokenizer(name, "/");
        Object dir = null;
        boolean first = true;
        NestedCategory category = null;
        NestedCategory parent = null;
        while (sto.hasMoreElements()) {
            String current = (String)sto.nextElement();
            if (first) {
                category = (NestedCategory)this.categories.get(current);
                if (category == null) {
                    this.setCategory(current);
                    category = (NestedCategory)this.categories.get(current);
                }
                parent = category;
                first = false;
                continue;
            }
            if (category != null && (category = category.getCategory(current)) == null) {
                NestedCategory newCategory = new NestedCategory(current);
                parent.addCategory(newCategory);
                category = newCategory;
            }
            parent = category;
        }
        return category;
    }

    public boolean containsCategory(String categoryName) {
        Category cat = this.getCategory(categoryName, false);
        return cat != null;
    }
}

