/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig;

import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedMap;
import org.jconfig.Category;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.DefaultConfiguration;

public class ExtensibleConfiguration
extends DefaultConfiguration
implements Serializable {
    public ExtensibleConfiguration(String configName) {
        super(configName);
    }

    public String getProperty(String key, String defaultValue, String categoryName) {
        if (key == null) {
            return defaultValue;
        }
        Category category = this.getCategory(categoryName);
        String tmp = category.getProperty(key);
        if (tmp == null && category.getExtendsCategory() != null) {
            return this.getProperty(key, defaultValue, category.getExtendsCategory());
        }
        if (tmp == null) {
            if (this.baseConfigName != null) {
                Configuration cfg = ConfigurationManager.getConfiguration(this.baseConfigName);
                tmp = cfg.getProperty(key, defaultValue, categoryName);
            } else {
                tmp = defaultValue;
            }
        }
        return tmp;
    }

    public String getXMLAsString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\"");
        if (this.getEncoding() != null) {
            buffer.append(" encoding=\"" + this.getEncoding() + "\"");
        }
        buffer.append(" ?>\n");
        buffer.append("<properties");
        if (this.baseConfigName != null) {
            buffer.append(" extends=\"");
            buffer.append(this.baseConfigName);
            buffer.append("\"");
        }
        buffer.append(">\n");
        this.addIncludeBlock(buffer);
        this.addVariableBlock(buffer);
        String[] cats = this.getCategoryNames(false);
        for (int i = 0; i < cats.length; ++i) {
            Category ec = this.getCategory(cats[i]);
            buffer.append("  <category name=\"");
            buffer.append(this.escapeForXML(ec.getCategoryName()));
            buffer.append("\"");
            if (ec.getExtendsCategory() != null) {
                buffer.append(" extends=\"");
                buffer.append(this.escapeForXML(ec.getExtendsCategory()));
                buffer.append("\"");
            }
            buffer.append(">\n");
            SortedMap sm = this.getSortedProperties(ec.getCategoryName(), false);
            if (sm == null) continue;
            Iterator nit = sm.keySet().iterator();
            while (nit.hasNext()) {
                String name = (String)nit.next();
                String value = (String)sm.get(name);
                buffer.append("    <");
                buffer.append(this.escapeForXML(name));
                buffer.append(">");
                buffer.append(this.escapeForXML(value));
                buffer.append("</");
                buffer.append(this.escapeForXML(name));
                buffer.append(">\n");
            }
            buffer.append("  </category>\n");
        }
        buffer.append("</properties>\n");
        return buffer.toString();
    }
}

