          Program ArbitrarySidedPolyAfineTextureMap;

          Uses Mode13h,Sprites,Crt;

          Const MaxPolys=5;
                MaxTextures=2;
                MaxVerts=4;

          Type ArbtrPoly3d=Record
                                 NSides:Byte;
                                 Verts:Array[1..MaxVerts] Of Record
                                                                   X,Y,Z:Real;
                                                                   U,V:Integer;
                                                             End;
                                 Xc,Yc,Zc:Real;
                                 Xn,Yn,Zn:Real;
                                 Texture:Byte;
                           End;

          Type ArbtrPoly2d=Record
                                 NSides:Byte;
                                 Verts:Array[1..MaxVerts] Of Record
                                                                   X,Y:Integer;
                                                                   U,V:Integer;
                                                             End;
                                 Texture:Byte;
                           End;

          Type Solid3d=Record
                             NumPolys:Word;
                             Polys:Array[1..MaxPolys] Of Word;
                             Xc,Yc,Zc:Real;
                       End;

          Var Polygons:Array[1..MaxPolys] Of ArbtrPoly3d;
              Textures:Array[1..MaxTextures] Of Pointer;
              Pyramid:Solid3d;
              RotCentX,RotCentY,RotCentZ:Real;
              A,Dir:Integer;
              ViewVector:Record
                               Vx,Vy,Vz:Real;
                         End;
              Pal:RGBList;
              Poly:Array[0..199] Of Record
                                          MinX,MaxX:Integer;
                                          U1,V1:Integer;
                                          U2,V2:Integer;
                                    End;

          Procedure Gen3dVert(N1,N2:Word;X,Y,Z:Real;
                              U,V:Integer);
          Begin
               Polygons[N1].Verts[N2].X:=X;
               Polygons[N1].Verts[N2].Y:=Y;
               Polygons[N1].Verts[N2].Z:=Z;
               Polygons[N1].Verts[N2].U:=U;
               Polygons[N1].Verts[N2].V:=V;
          End;

          Procedure Gen3dPoly(N1,N2,T:Word);
          Var X1,X2,X3:Real;
              Y1,Y2,Y3:Real;
              Z1,Z2,Z3:Real;
              Module:Real;
          Begin
               { Set the number of sides }
               Polygons[N1].NSides:=N2;
               { Find the center of the poly }
               Polygons[N1].Xc:=0;
               Polygons[N1].Yc:=0;
               Polygons[N1].Zc:=0;
               For A:=1 To N2 Do
               Begin
                    Polygons[N1].Xc:=Polygons[N1].Xc+Polygons[N1].Verts[A].X;
                    Polygons[N1].Yc:=Polygons[N1].Yc+Polygons[N1].Verts[A].Y;
                    Polygons[N1].Zc:=Polygons[N1].Zc+Polygons[N1].Verts[A].Z;
               End;
               Polygons[N1].Xc:=Polygons[N1].Xc/N2;
               Polygons[N1].Yc:=Polygons[N1].Yc/N2;
               Polygons[N1].Zc:=Polygons[N1].Zc/N2;
               { Calc the normals }
               X1:=Polygons[N1].Verts[1].X;
               X2:=Polygons[N1].Verts[2].X;
               X3:=Polygons[N1].Verts[3].X;
               Y1:=Polygons[N1].Verts[1].Y;
               Y2:=Polygons[N1].Verts[2].Y;
               Y3:=Polygons[N1].Verts[3].Y;
               Z1:=Polygons[N1].Verts[1].Z;
               Z2:=Polygons[N1].Verts[2].Z;
               Z3:=Polygons[N1].Verts[3].Z;
               Polygons[N1].Xn:=(Z2-Z1)*(Y3-Y1)-(Y2-Y1)*(Z3-Z1);
               Polygons[N1].Yn:=(Z2-Z1)*(X3-X1)-(X2-X1)*(Z3-Z1);
               Polygons[N1].Zn:=(Y2-Y1)*(X3-X1)-(X2-X1)*(Y3-Y1);
               { Normalize the normals }
               Module:=Sqrt(Sqr(Polygons[N1].Xn)+Sqr(Polygons[N1].Yn)+
                            Sqr(Polygons[N1].Zn));
               Polygons[N1].Xn:=Polygons[N1].Xn/Module;
               Polygons[N1].Yn:=-Polygons[N1].Yn/Module;
               Polygons[N1].Zn:=Polygons[N1].Zn/Module;
               Polygons[N1].Texture:=T;
          End;

          Procedure InitTextures;
          Var F:File;
          Begin
               Assign(F,'Arbtr.Tex'); Reset(F,1);
               LoadImage(F,Textures[1]);
               LoadImage(F,Textures[2]);
               Close(F);
          End;

          Procedure TranslatePoly(Var P:ArbtrPoly3d;Xt,Yt,Zt:Real);
          { This translates a polygon }
          Begin
               For A:=1 To P.NSides Do
               Begin
                    P.Verts[A].X:=P.Verts[A].X+Xt;
                    P.Verts[A].Y:=P.Verts[A].Y+Yt;
                    P.Verts[A].Z:=P.Verts[A].Z+Zt;
               End;
               P.Xc:=P.Xc+Xt; P.Yc:=P.Yc+Yt; P.Zc:=P.Zc+Zt;
          End;

          Procedure TranslateSolid(Var S:Solid3d;Xt,Yt,Zt:Real);
          { This translates the solid }
          Var A:Byte;
          Begin
               For A:=1 To S.NumPolys Do
                 TranslatePoly(Polygons[S.Polys[A]],Xt,Yt,Zt);
               S.Xc:=S.Xc+Xt; S.Yc:=S.Yc+Yt; S.Zc:=S.Zc+Zt;
          End;

          Procedure Rotate3dPoly(Var P:ArbtrPoly3d;XAng,YAng,ZAng:Integer);
          { This rotates around a certain point, specified by the variables
            RotCentX, RotCentY and RotCentZ. We also rotate the center of
            the polygons, that change in order to the rotation point,
            and the normal of the polygon. }
          Var Angle:Integer;
              Temp:Real;
          Begin
               { Transform negative angles into positive ones }
               If XAng<0 Then XAng:=XAng+360;
               If YAng<0 Then YAng:=YAng+360;
               If ZAng<0 Then ZAng:=ZAng+360;
               { Make the coordinates of the points relative to the center }
               TranslatePoly(P,-RotCentX,-RotCentY,-RotCentZ);
               For A:=1 To P.NSides Do
               Begin
                 { Rotate all points of poly around Z axis }
                 Angle:=ZAng;
                 Temp:=P.Verts[A].X;
                 P.Verts[A].X:=Temp*Cosines^[Angle]-P.Verts[A].Y*Sines^[Angle];
                 P.Verts[A].Y:=P.Verts[A].Y*Cosines^[Angle]+Temp*Sines^[Angle];
                 { Rotate all points of poly around X axis }
                 Angle:=XAng;
                 Temp:=P.Verts[A].Z;
                 P.Verts[A].Z:=Temp*Cosines^[Angle]-P.Verts[A].Y*Sines^[Angle];
                 P.Verts[A].Y:=P.Verts[A].Y*Cosines^[Angle]+Temp*Sines^[Angle];
                 { Rotate all points of poly around Y axis }
                 Angle:=YAng;
                 Temp:=P.Verts[A].X;
                 P.Verts[A].X:=Temp*Cosines^[Angle]-P.Verts[A].Z*Sines^[Angle];
                 P.Verts[A].Z:=P.Verts[A].Z*Cosines^[Angle]+Temp*Sines^[Angle];
               End;
               { Rotate normal and center of poly around Z axis}
               Angle:=ZAng;
               Temp:=P.Xc;
               P.Xc:=Temp*Cosines^[Angle]-P.Yc*Sines^[Angle];
               P.Yc:=P.Yc*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.Xn;
               P.Xn:=Temp*Cosines^[Angle]-P.Yn*Sines^[Angle];
               P.Yn:=P.Yn*Cosines^[Angle]+Temp*Sines^[Angle];
               { Rotate normal and center of poly around X axis}
               Angle:=XAng;
               Temp:=P.Zc;
               P.Zc:=Temp*Cosines^[Angle]-P.Yc*Sines^[Angle];
               P.Yc:=P.Yc*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.Zn;
               P.Zn:=Temp*Cosines^[Angle]-P.Yn*Sines^[Angle];
               P.Yn:=P.Yn*Cosines^[Angle]+Temp*Sines^[Angle];
               { Rotate normal and center of poly around Y axis}
               Angle:=YAng;
               Temp:=P.Xc;
               P.Xc:=Temp*Cosines^[Angle]-P.Zc*Sines^[Angle];
               P.Zc:=P.Zc*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.Xn;
               P.Xn:=Temp*Cosines^[Angle]-P.Zn*Sines^[Angle];
               P.Zn:=P.Zn*Cosines^[Angle]+Temp*Sines^[Angle];
               { Transform the coordinates again }
               TranslatePoly(P,RotCentX,RotCentY,RotCentZ);
          End;

          Procedure InitPyramid;
          Var A:Byte;
              Average:Real;
          Begin
               { Define the polygons that will be part of the solid }
               { ** Base ** }
               Gen3dVert(1,4,-24,12,232,0,0); Gen3dVert(1,3,-24,12,280,45,0);
               Gen3dVert(1,2,24,12,280,45,39); Gen3dVert(1,1,24,12,232,0,39);
               Gen3dPoly(1,4,2);
               { ** Sides ** }
               Gen3dVert(2,1,24,12,232,0,0); Gen3dVert(2,2,0,-12,256,45,39);
               Gen3dVert(2,3,24,12,280,0,39); Gen3dPoly(2,3,2);
               Gen3dVert(3,1,24,12,280,0,23); Gen3dVert(3,2,0,-12,256,24,0);
               Gen3dVert(3,3,-24,12,280,47,23); Gen3dPoly(3,3,1);
               Gen3dVert(4,1,-24,12,280,45,0); Gen3dVert(4,2,0,-12,256,45,39);
               Gen3dVert(4,3,-24,12,232,0,39); Gen3dPoly(4,3,2);
               Gen3dVert(5,1,-24,12,232,0,23); Gen3dVert(5,2,0,-12,256,24,0);
               Gen3dVert(5,3,24,12,232,47,23); Gen3dPoly(5,3,1);
               { Define the pyramid solid }
               Pyramid.NumPolys:=5;
               For A:=1 To 5 Do Pyramid.Polys[A]:=A;
               { Calc the center point }
               Average:=0;
               For A:=1 To 5 Do Average:=Average+Polygons[A].Xc;
               Pyramid.Xc:=Average/5;
               Average:=0;
               For A:=1 To 5 Do Average:=Average+Polygons[A].Yc;
               Pyramid.Yc:=Average/5;
               Average:=0;
               For A:=1 To 5 Do Average:=Average+Polygons[A].Zc;
               Pyramid.Zc:=Average/5;
          End;

          Procedure Conv3d(X,Y,Z:Real;Var Xt,Yt:Integer);
          Begin
               Xt:=160+Trunc((X*256/Z));
               Yt:=100+Trunc((Y*256/Z));
          End;

          Procedure TMap(P:ArbtrPoly3d;Where:Word);
          Var MnY,MxY:Integer;
              A,B:Integer;
              Segm,Offs:Word;
              XSize,YSize,Height:Integer;
              C:Byte;
              DeltaX:Integer;
              U,V:Integer;
              Temp:Word;
              TextIncX,TextIncY:Integer;
              P2:ArbtrPoly2d;

              Tx,Ty:Integer;
              Txx,tyy:Integer;


              Procedure Side(X1,Y1,X2,Y2,Us,Vs,Ue,Ve:Integer);
              { This routine updates the Poly variable, based on the side it
                is. The sides are numbered clockwise. Side 1 is the topmost
                (when the poly has suffered no rotation }
              Var Temp:Integer;
                  X,XInc:Integer;
                  A:Integer;
              Begin
                   { Set the start and end coordinates of the texture map }
                   If Y1=Y2 Then Exit;
                   Height:=Y2-Y1;
                   TextIncX:=Round(((Ue-Us)/Height)*128);
                   TextIncY:=Round(((Ve-Vs)/Height)*128);
                   If Y2<Y1 Then
                   Begin
                        { Calc the slope. The Shl 7 is used to implement a rough
                          sort of 9.7 fixed point math }
                        XInc:=((X2-X1) Shl 7) Div Height;
                        { Initial position in fixed point }
                        X:=X2 Shl 7;
                        U:=Ue Shl 7;
                        V:=Ve Shl 7;
                        For A:=Y2 To Y1 Do
                        Begin
                             { Calc the minimum and maximum X coordinates in
                               this scanline }
                             If (X Shr 7<Poly[A].MinX) Then
                             Begin
                                  Poly[A].MinX:=X Shr 7;
                                  Poly[A].U1:=U Shr 7;
                                  Poly[A].V1:=V Shr 7;
                             End;
                             If (X Shr 7>Poly[A].MaxX) Then
                             Begin
                                  Poly[A].MaxX:=X Shr 7;
                                  Poly[A].U2:=U Shr 7;
                                  Poly[A].V2:=V Shr 7;
                             End;
                             X:=X+XInc;
                             U:=U+TextIncX;
                             V:=V+TextIncY;
                        End;
                   End
                   Else
                   Begin
                        { Calc the slope. The Shl 7 is used to implement a rough
                          sort of 9.7 fixed point math }
                        XInc:=((X2-X1) Shl 7) Div Height;
                        { Initial position in fixed point }
                        X:=X1 Shl 7;
                        U:=Us Shl 7;
                        V:=Vs Shl 7;
                        For A:=Y1 To Y2 Do
                        Begin
                             { Calc the minimum and maximum X coordinates in
                               this scanline }
                             If (X Shr 7<Poly[A].MinX) Then
                             Begin
                                  Poly[A].MinX:=X Shr 7;
                                  Poly[A].U1:=U Shr 7;
                                  Poly[A].V1:=V Shr 7;
                             End;
                             If (X Shr 7>Poly[A].MaxX) Then
                             Begin
                                  Poly[A].MaxX:=X Shr 7;
                                  Poly[A].U2:=U Shr 7;
                                  Poly[A].V2:=V Shr 7;
                             End;
                             X:=X+XInc;
                             U:=U+TextIncX;
                             V:=V+TextIncY;
                        End;
                   End;
              End;

          Begin
               For A:=0 To 199 Do
               Begin
                    Poly[A].MinX:=MaxInt;
                    Poly[A].MaxX:=-MaxInt;
                    Poly[A].U1:=0; Poly[A].V1:=0; Poly[A].U2:=0; Poly[A].V2:=0;
               End;
               { Set the texture }
               Segm:=Seg(Textures[P.Texture]^);
               Offs:=Ofs(Textures[P.Texture]^);
               Move(Mem[Segm:Offs],XSize,2);
               Move(Mem[Segm:Offs+2],YSize,2);
               Inc(Offs,4);
               { Convert the 3d poly to a 2d one }
               P2.NSides:=P.NSides;
               P2.Texture:=P.Texture;
               For A:=1 To P.NSides Do
               Begin
                    Conv3d(P.Verts[A].X,P.Verts[A].Y,P.Verts[A].Z,
                           P2.Verts[A].X,P2.Verts[A].Y);
                    P2.Verts[A].U:=P.Verts[A].U;
                    P2.Verts[A].V:=P.Verts[A].V;
               End;
               { Set the maximmum and minimum Y coordinate }
               MnY:=P2.Verts[1].Y;
               MxY:=P2.Verts[1].Y;
               For A:=1 To P2.NSides Do
               Begin
                    If P2.Verts[A].Y>MxY Then MxY:=P2.Verts[A].Y;
                    If P2.Verts[A].Y<MnY Then MnY:=P2.Verts[A].Y;
               End;
               If MnY<0 Then MnY:=0;
               If MxY>199 Then MxY:=199;
               { Calc the sides }
               For B:=1 To P2.NSides-1 Do
                 Side(P2.Verts[B].X,P2.Verts[B].Y,
                      P2.Verts[B+1].X,P2.Verts[B+1].Y,
                      P2.Verts[B].U,P2.Verts[B].V,
                      P2.Verts[B+1].U,P.Verts[B+1].V);
               Side(P2.Verts[B+1].X,P2.Verts[B+1].Y,
                    P2.Verts[1].X,P2.Verts[1].Y,
                    P2.Verts[B+1].U,P2.Verts[B+1].V,
                    P2.Verts[1].U,P2.Verts[1].V);
               { Draw the poly }
               For A:=MnY to MxY Do
               Begin
                    DeltaX:=Poly[A].MaxX-Poly[A].MinX;
                    If DeltaX<>0 Then
                    Begin
                         TextIncX:=((Poly[A].U2-Poly[A].U1) Shl 7) Div DeltaX;
                         TextIncY:=((Poly[A].V2-Poly[A].V1) Shl 7) Div DeltaX;
                         U:=Poly[A].U1 Shl 7;
                         V:=Poly[A].V1 Shl 7;
                         For B:=Poly[A].MinX To Poly[A].MaxX Do
                         Begin
                              { Get the textel }
                              Temp:=((V Shr 7)*XSize)+(U Shr 7);
                              C:=Mem[Segm:Offs+Temp];
                              PutPixel(B,A,C,Where);
                              U:=U+TextIncX;
                              V:=V+TextIncY;
                         End;
                    End;
               End;
          End;

          Procedure Draw3dPoly(P:ArbtrPoly3d;Where:Word);
          Var Tx1,Tx2,Tx3,Tx4,
              Ty1,Ty2,Ty3,Ty4:Integer;
              Module,Temp:Real;
              CosAngle:Real;
              C:Byte;
          Begin
               { Find out the view vector between the camera and the poly.
                 There is no need to normalize the vector, because we are
                 interested in the sign and not in the value of the dot
                 product... The view vector is equal to coordinates of the
                 poly, because the camera is in the origin }
               Module:=Sqrt(Sqr(P.Xc)+Sqr(P.Yc)+Sqr(P.Zc));
               ViewVector.Vx:=P.Xc/Module;
               ViewVector.Vy:=P.Yc/Module;
               ViewVector.Vz:=P.Zc/Module;
               { Find out the dot product, and store it in the Temp
                 variable }
               Temp:=(ViewVector.Vx*P.Xn)+(ViewVector.Vy*P.Yn)+
                     (ViewVector.Vz*P.Zn);
               { Draw if the dot product between the normal of the polygon
                 and the view vector is negative, i.e. it is visible }
               If (Temp>=0) Then Exit Else TMap(P,Where);
          End;

          Procedure DrawSolid(S:Solid3d;Where:Word);
          Var A:Word;
          Begin
               For A:=1 To S.NumPolys Do
                 Draw3dPoly(Polygons[S.Polys[A]],Where);
          End;

          Procedure RotateSolid(S:Solid3d;XAng,YAng,ZAng:Integer);
          Var A:Word;
          Begin
               RotCentX:=S.Xc;
               RotCentY:=S.Yc;
               RotCentZ:=S.Zc;
               For A:=1 To S.NumPolys Do
                 Rotate3dPoly(Polygons[S.Polys[A]],XAng,YAng,ZAng);
          End;

          Begin
               LoadPal('Cube.Pal',Pal);
               InitGraph;
               InitVirt;
               InitTables;
               SetPalette(Pal);
               Cls(0,VGA);
               InitPyramid;
               InitTextures;
               Dir:=10;
               RotateSolid(Pyramid,90,0,0);
               Repeat
                     Cls(0,Vp[1]);
                     { Draw the pyramid }
                     DrawSolid(Pyramid,Vp[1]);
                     TranslateSolid(Pyramid,0,0,Dir);
                     If (Pyramid.Zc>750) Or (Pyramid.Zc<150) Then Dir:=-Dir;
                     WaitVbl;
                     CopyPage(Vp[1],VGA);
                     RotateSolid(Pyramid,3,Dir,4);
                     Delay(10);
               Until Keypressed;
               ClearTables;
               CloseVirt;
               CloseGraph;
          End.
