          Program AfineTextureMapCubeWithLambertLighting;

          Uses Mode13h,Sprites,Crt;

          Const MaxPolys=6;
                MaxTextures=5;

          Type Poly3d=Record
                            X1,Y1,Z1,
                            X2,Y2,Z2,
                            X3,Y3,Z3,
                            X4,Y4,Z4,
                            Xc,Yc,Zc:Real;
                            Xn,Yn,Zn:Real;
                            Texture:Byte;
                       End;

          Type Solid3d=Record
                             NumPolys:Word;
                             Polys:Array[1..MaxPolys] Of Word;
                             Xc,Yc,Zc:Real;
                       End;

          Type ShadeMap=Array[0..255] Of Byte;

          Var Polygons:Array[1..MaxPolys] Of Poly3d;
              Textures:Array[1..MaxTextures] Of Pointer;
              Cube:Solid3d;
              RotCentX,RotCentY,RotCentZ:Real;
              A,Rot:Integer;
              ViewVector:Record
                               Vx,Vy,Vz:Real;
                         End;
              Pal:RGBList;
              Poly:Array[0..199] Of Record
                                          MinX,MaxX:Integer;
                                          U1,V1:Integer;
                                          U2,V2:Integer;
                                    End;
              Shades:Array[0..15] Of ShadeMap;
              Light:Record
                          X,Y,Z:Real;
                    End;
              Temp,TempInc:Real;
              T:Integer;

          Procedure Gen3dPoly(N:Word;
                              X1,Y1,Z1,X2,Y2,Z2,
                              X3,Y3,Z3,X4,Y4,Z4:Real;
                              T:Byte);
          Var Module:Real;
          Begin
               Polygons[N].X1:=X1; Polygons[N].Y1:=Y1; Polygons[N].Z1:=Z1;
               Polygons[N].X2:=X2; Polygons[N].Y2:=Y2; Polygons[N].Z2:=Z2;
               Polygons[N].X3:=X3; Polygons[N].Y3:=Y3; Polygons[N].Z3:=Z3;
               Polygons[N].X4:=X4; Polygons[N].Y4:=Y4; Polygons[N].Z4:=Z4;
               Polygons[N].Xc:=(X1+X2+X3+X4)/4;
               Polygons[N].Yc:=(Y1+Y2+Y3+Y4)/4;
               Polygons[N].Zc:=(Z1+Z2+Z3+Z4)/4;
               { Calc the normals }
               Polygons[N].Xn:=(Z2-Z1)*(Y3-Y1)-(Y2-Y1)*(Z3-Z1);
               Polygons[N].Yn:=(Z2-Z1)*(X3-X1)-(X2-X1)*(Z3-Z1);
               Polygons[N].Zn:=(Y2-Y1)*(X3-X1)-(X2-X1)*(Y3-Y1);
               { Normalize the normals }
               Module:=Sqrt(Sqr(Polygons[N].Xn)+Sqr(Polygons[N].Yn)+
                            Sqr(Polygons[N].Zn));
               Polygons[N].Xn:=Polygons[N].Xn/Module;
               Polygons[N].Yn:=Polygons[N].Yn/Module;
               Polygons[N].Zn:=Polygons[N].Zn/Module;
               Polygons[N].Texture:=T;
          End;

          Procedure InitTextures;
          Var F:File;
          Begin
               Assign(F,'Cube.Tex'); Reset(F,1);
               LoadImage(F,Textures[1]);
               LoadImage(F,Textures[2]);
               LoadImage(F,Textures[3]);
               LoadImage(F,Textures[4]);
               LoadImage(F,Textures[5]);
               FlipHoriz(Textures[5]);
          End;

          Procedure TranslatePoly(Var P:Poly3d;Xt,Yt,Zt:Real);
          { This translates a polygon }
          Begin
               P.X1:=P.X1+Xt; P.Y1:=P.Y1+Yt; P.Z1:=P.Z1+Zt;
               P.X2:=P.X2+Xt; P.Y2:=P.Y2+Yt; P.Z2:=P.Z2+Zt;
               P.X3:=P.X3+Xt; P.Y3:=P.Y3+Yt; P.Z3:=P.Z3+Zt;
               P.X4:=P.X4+Xt; P.Y4:=P.Y4+Yt; P.Z4:=P.Z4+Zt;
               P.Xc:=P.Xc+Xt; P.Yc:=P.Yc+Yt; P.Zc:=P.Zc+Zt;
          End;

          Procedure TranslateSolid(Var S:Solid3d;Xt,Yt,Zt:Real);
          { This translates the solid }
          Var A:Byte;
          Begin
               For A:=1 To S.NumPolys Do
                 TranslatePoly(Polygons[S.Polys[A]],Xt,Yt,Zt);
               S.Xc:=S.Xc+Xt; S.Yc:=S.Yc+Yt; S.Zc:=S.Zc+Zt;
          End;

          Procedure Rotate3dPoly(Var P:Poly3d;XAng,YAng,ZAng:Integer);
          { This rotates around a certain point, specified by the variables
            RotCentX, RotCentY and RotCentZ. We also rotate the center of
            the polygons, that change in order to the rotation point,
            and the normal of the polygon. }
          Var Angle:Integer;
              Temp:Real;
          Begin
               { Transform negative angles into positive ones }
               If XAng<0 Then XAng:=XAng+360;
               If YAng<0 Then YAng:=YAng+360;
               If ZAng<0 Then ZAng:=ZAng+360;
               { Make the coordinates of the points relative to the center }
               TranslatePoly(P,-RotCentX,-RotCentY,-RotCentZ);
               { Rotate all points of poly around Z axis }
               Angle:=ZAng;
               Temp:=P.X1;
               P.X1:=Temp*Cosines^[Angle]-P.Y1*Sines^[Angle];
               P.Y1:=P.Y1*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.X2;
               P.X2:=Temp*Cosines^[Angle]-P.Y2*Sines^[Angle];
               P.Y2:=P.Y2*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.X3;
               P.X3:=Temp*Cosines^[Angle]-P.Y3*Sines^[Angle];
               P.Y3:=P.Y3*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.X4;
               P.X4:=Temp*Cosines^[Angle]-P.Y4*Sines^[Angle];
               P.Y4:=P.Y4*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.Xc;
               P.Xc:=Temp*Cosines^[Angle]-P.Yc*Sines^[Angle];
               P.Yc:=P.Yc*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.Xn;
               P.Xn:=Temp*Cosines^[Angle]-P.Yn*Sines^[Angle];
               P.Yn:=P.Yn*Cosines^[Angle]+Temp*Sines^[Angle];
               { Rotate all points of poly around X axis }
               Angle:=XAng;
               Temp:=P.Z1;
               P.Z1:=Temp*Cosines^[Angle]-P.Y1*Sines^[Angle];
               P.Y1:=P.Y1*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.Z2;
               P.Z2:=Temp*Cosines^[Angle]-P.Y2*Sines^[Angle];
               P.Y2:=P.Y2*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.Z3;
               P.Z3:=Temp*Cosines^[Angle]-P.Y3*Sines^[Angle];
               P.Y3:=P.Y3*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.Z4;
               P.Z4:=Temp*Cosines^[Angle]-P.Y4*Sines^[Angle];
               P.Y4:=P.Y4*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.Zc;
               P.Zc:=Temp*Cosines^[Angle]-P.Yc*Sines^[Angle];
               P.Yc:=P.Yc*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.Zn;
               P.Zn:=Temp*Cosines^[Angle]-P.Yn*Sines^[Angle];
               P.Yn:=P.Yn*Cosines^[Angle]+Temp*Sines^[Angle];
               { Rotate all points of poly around Y axis }
               Angle:=YAng;
               Temp:=P.X1;
               P.X1:=Temp*Cosines^[Angle]-P.Z1*Sines^[Angle];
               P.Z1:=P.Z1*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.X2;
               P.X2:=Temp*Cosines^[Angle]-P.Z2*Sines^[Angle];
               P.Z2:=P.Z2*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.X3;
               P.X3:=Temp*Cosines^[Angle]-P.Z3*Sines^[Angle];
               P.Z3:=P.Z3*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.X4;
               P.X4:=Temp*Cosines^[Angle]-P.Z4*Sines^[Angle];
               P.Z4:=P.Z4*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.Xc;
               P.Xc:=Temp*Cosines^[Angle]-P.Zc*Sines^[Angle];
               P.Zc:=P.Zc*Cosines^[Angle]+Temp*Sines^[Angle];
               Temp:=P.Xn;
               P.Xn:=Temp*Cosines^[Angle]-P.Zn*Sines^[Angle];
               P.Zn:=P.Zn*Cosines^[Angle]+Temp*Sines^[Angle];
               { Transform the coordinates again }
               TranslatePoly(P,RotCentX,RotCentY,RotCentZ);
          End;

          Procedure InitCube;
          Var A:Byte;
              Average:Real;
          Begin
               { Define the polygons that will be part of the solid }
               Gen3dPoly(1,-30,-30,226,30,-30,226,30,30,226,-30,30,226,1);
               Gen3dPoly(2,30,-30,226,30,-30,286,30,30,286,30,30,226,2);
               Gen3dPoly(3,30,-30,286,-30,-30,286,-30,30,286,30,30,286,3);
               Gen3dPoly(4,-30,-30,286,-30,-30,226,-30,30,226,-30,30,286,4);
               Gen3dPoly(5,-30,-30,286,-30,-30,226,30,-30,226,30,-30,286,5);
               Gen3dPoly(6,-30,30,286,30,30,286,30,30,226,-30,30,226,5);
               { Define the cube solid }
               Cube.NumPolys:=6;
               For A:=1 To 6 Do Cube.Polys[A]:=A;
               { Calc the center point }
               Average:=0;
               For A:=1 To 6 Do Average:=Average+Polygons[A].Xc;
               Cube.Xc:=Average/6;
               Average:=0;
               For A:=1 To 6 Do Average:=Average+Polygons[A].Yc;
               Cube.Yc:=Average/6;
               Average:=0;
               For A:=1 To 6 Do Average:=Average+Polygons[A].Zc;
               Cube.Zc:=Average/6;
          End;

          Procedure Conv3d(X,Y,Z:Real;Var Xt,Yt:Integer);
          Begin
               Xt:=160+Trunc((X*256/Z));
               Yt:=100+Trunc((Y*256/Z));
          End;

          Procedure TMapTint(X1,Y1,X2,Y2,X3,Y3,X4,Y4:Integer;
                   Texture:Pointer;Where:Word;Tint:ShadeMap);
          Var MnY,MxY:Integer;
              A,B:Integer;
              Segm,Offs:Word;
              XSize,YSize,Height:Integer;
              C:Byte;
              DeltaX:Integer;
              U,V:Integer;
              TextIncX,TextIncY:Integer;
              Temp:Word;

              Procedure Side(X1,Y1,X2,Y2:Integer;Side:Byte);
              { This routine updates the Poly variable, based on the side it
                is. The sides are numbered clockwise. Side 1 is the topmost
                (when the poly has suffered no rotation }
              Var Temp:Integer;
                  X,XInc:Integer;
                  A:Integer;
                  Us,Vs:Integer; { The start coordinates in the texture }
                  Ue,Ve:Integer; { The end coordinates in the texture }
              Begin
                   { Set the start and end coordinates of the texture map }
                   If Y1=Y2 Then Exit;
                   Height:=Y2-Y1;
                   If Side=1 Then
                   Begin
                        Us:=0; Vs:=0; Ue:=XSize; Ve:=0;
                        TextIncX:=(XSize Shl 7) Div Height;
                        TextIncY:=0;
                   End
                   Else
                   If Side=2 Then
                   Begin
                        Us:=XSize; Vs:=0; Ue:=XSize; Ve:=YSize;
                        TextIncX:=0;
                        TextIncY:=(YSize Shl 7) Div Height;
                   End
                   Else
                   If Side=3 Then
                   Begin
                        Us:=XSize; Vs:=YSize; Ue:=0; Ve:=YSize;
                        TextIncX:=(-XSize Shl 7) Div Height;
                        TextIncY:=0;
                   End
                   Else
                   If Side=4 Then
                   Begin
                        Us:=0; Vs:=YSize; Ue:=0; Ve:=0;
                        TextIncX:=0;
                        TextIncY:=(-YSize Shl 7) Div Height;
                   End;
                   If Y2<Y1 Then
                   Begin
                        { Calc the slope. The Shl 7 is used to implement a rough
                          sort of 9.7 fixed point math }
                        XInc:=((X2-X1) Shl 7) Div Height;
                        { Initial position in fixed point }
                        X:=X2 Shl 7;
                        U:=Ue Shl 7;
                        V:=Ve Shl 7;
                        For A:=Y2 To Y1 Do
                        Begin
                             { Calc the minimum and maximum X coordinates in
                               this scanline }
                             If (X Shr 7<Poly[A].MinX) Then
                             Begin
                                  Poly[A].MinX:=X Shr 7;
                                  Poly[A].U1:=U Shr 7;
                                  Poly[A].V1:=V Shr 7;
                             End;
                             If (X Shr 7>Poly[A].MaxX) Then
                             Begin
                                  Poly[A].MaxX:=X Shr 7;
                                  Poly[A].U2:=U Shr 7;
                                  Poly[A].V2:=V Shr 7;
                             End;
                             X:=X+XInc;
                             U:=U+TextIncX;
                             V:=V+TextIncY;
                        End;
                   End
                   Else
                   Begin
                        { Calc the slope. The Shl 7 is used to implement a rough
                          sort of 9.7 fixed point math }
                        XInc:=((X2-X1) Shl 7) Div Height;
                        { Initial position in fixed point }
                        X:=X1 Shl 7;
                        U:=Us Shl 7;
                        V:=Vs Shl 7;
                        For A:=Y1 To Y2 Do
                        Begin
                             { Calc the minimum and maximum X coordinates in
                               this scanline }
                             If (X Shr 7<Poly[A].MinX) Then
                             Begin
                                  Poly[A].MinX:=X Shr 7;
                                  Poly[A].U1:=U Shr 7;
                                  Poly[A].V1:=V Shr 7;
                             End;
                             If (X Shr 7>Poly[A].MaxX) Then
                             Begin
                                  Poly[A].MaxX:=X Shr 7;
                                  Poly[A].U2:=U Shr 7;
                                  Poly[A].V2:=V Shr 7;
                             End;
                             X:=X+XInc;
                             U:=U+TextIncX;
                             V:=V+TextIncY;
                        End;
                   End;
              End;

          Begin
               For A:=0 To 199 Do
               Begin
                    Poly[A].MinX:=MaxInt;
                    Poly[A].MaxX:=-MaxInt;
                    Poly[A].U1:=0; Poly[A].V1:=0; Poly[A].U2:=0; Poly[A].V2:=0;
               End;
               { Set the texture }
               Segm:=Seg(Texture^);
               Offs:=Ofs(Texture^);
               Move(Mem[Segm:Offs],XSize,2);
               Move(Mem[Segm:Offs+2],YSize,2);
               Inc(Offs,4);
               { Set the maximmum and minimum Y coordinate }
               MnY:=Y1;
               MxY:=Y1;
               If MnY>Y2 Then MnY:=Y2;
               If MnY>Y3 Then MnY:=Y3;
               If MnY>Y4 Then MnY:=Y4;
               If MxY<Y2 Then MxY:=Y2;
               If MxY<Y3 Then MxY:=Y3;
               If MxY<Y4 Then MxY:=Y4;
               If MnY<0 Then MnY:=0;
               If MxY>199 Then MxY:=199;
               { Calc the sides }
               Side(X1,Y1,X2,Y2,1);
               Side(X2,Y2,X3,Y3,2);
               Side(X3,Y3,X4,Y4,3);
               Side(X4,Y4,X1,Y1,4);
               { Draw the poly }
               For A:=MnY to MxY Do
               Begin
                    DeltaX:=Poly[A].MaxX-Poly[A].MinX;
                    If DeltaX<>0 Then
                    Begin
                         TextIncX:=((Poly[A].U2-Poly[A].U1) Shl 7) Div DeltaX;
                         TextIncY:=((Poly[A].V2-Poly[A].V1) Shl 7) Div DeltaX;
                         U:=Poly[A].U1 Shl 7;
                         V:=Poly[A].V1 Shl 7;
                         For B:=Poly[A].MinX To Poly[A].MaxX Do
                         Begin
                              { Get the textel }
                              Temp:=((V Shr 7)*XSize)+(U Shr 7);
                              C:=Mem[Segm:Offs+Temp];
                              PutPixel(B,A,Tint[C],Where);
                              U:=U+TextIncX;
                              V:=V+TextIncY;
                         End;
                    End;
               End;
          End;

          Procedure Draw3dPoly(P:Poly3d;Where:Word);
          Var Tx1,Tx2,Tx3,Tx4,
              Ty1,Ty2,Ty3,Ty4:Integer;
              Module,Temp:Real;
              CosAngle:Real;
              C:Byte;
          Begin
               { Find out the view vector between the camera and the poly.
                 There is no need to normalize the vector, because we are
                 interested in the sign and not in the value of the dot
                 product... The view vector is equal to coordinates of the
                 poly, because the camera is in the origin }
               ViewVector.Vx:=P.Xc;
               ViewVector.Vy:=P.Yc;
               ViewVector.Vz:=P.Zc;
               { Find out the dot product, and store it in the Temp
                 variable }
               Temp:=(ViewVector.Vx*P.Xn)+(ViewVector.Vy*P.Yn)+
                     (ViewVector.Vz*P.Zn);
               { Draw if the dot product between the normal of the polygon
                 and the view vector is negative, i.e. it is visible }
               If (Temp>=0) Then Exit;
               Conv3d(P.X1,P.Y1,P.Z1,Tx1,Ty1);
               Conv3d(P.X2,P.Y2,P.Z2,Tx2,Ty2);
               Conv3d(P.X3,P.Y3,P.Z3,Tx3,Ty3);
               Conv3d(P.X4,P.Y4,P.Z4,Tx4,Ty4);
               { Find out the angle between the normal of the poly and the
                 light vector to find out the lighting of the poly }
               CosAngle:=(Light.X*P.Xn)+(Light.Y*P.Yn)+(Light.Z*P.Zn);
               If CosAngle>0 Then C:=0
                             Else C:=-Trunc(CosAngle*15);
               TMapTint(Tx1,Ty1,Tx2,Ty2,Tx3,Ty3,Tx4,Ty4,
                        Textures[P.Texture],Where,Shades[C]);
          End;

          Procedure DrawSolid(S:Solid3d;Where:Word);
          Var A:Word;
          Begin
               For A:=1 To S.NumPolys Do
                 Draw3dPoly(Polygons[S.Polys[A]],Where);
          End;

          Procedure RotateSolid(S:Solid3d;XAng,YAng,ZAng:Integer);
          Var A:Word;
          Begin
               RotCentX:=S.Xc;
               RotCentY:=S.Yc;
               RotCentZ:=S.Zc;
               For A:=1 To S.NumPolys Do
                 Rotate3dPoly(Polygons[S.Polys[A]],XAng,YAng,ZAng);
          End;

          Procedure GenTint(Pal:RgbList;Var Map:ShadeMap;R,G,B:Byte);
          Var FactR,FactG,FactB:Real;
              RealR,RealG,RealB:Byte;
              A,C:Byte;
              MinC:Byte;
              MinD,Dist:Real;
          Begin
               { Determine the real factors }
               FactR:=R/100;
               FactG:=G/100;
               FactB:=B/100;
               { Determine the map }
               For A:=0 To 255 Do
               Begin
                    { Find the real colour }
                    RealR:=Round(Pal[A].R*FactR); If RealR>63 Then RealR:=63;
                    RealG:=Round(Pal[A].G*FactG); If RealG>63 Then RealG:=63;
                    RealB:=Round(Pal[A].B*FactB); If RealB>63 Then RealB:=63;
                    { Find now the most approximate colour in the palette }
                    MinC:=0; MinD:=MaxInt;
                    For C:=0 To 255 Do
                    Begin
                         { Find distance of colour C to the real colour }
                         Dist:=Sqrt(Sqr(RealR-Pal[C].R)+
                                    Sqr(RealG-Pal[C].G)+
                                    Sqr(RealB-Pal[C].B));
                         { If the distance is the smallest so far... }
                         If Dist<MinD Then
                         Begin
                              { ...then this is the colour we're after so far }
                              MinD:=Dist;
                              MinC:=C;
                         End;
                    End;
                    { Add the colour to the shademap }
                    Map[A]:=MinC;
               End;
          End;

          Begin
               LoadPal('Cube.Pal',Pal);
               Temp:=10; TempInc:=90/15;
               For A:=0 To 15 Do
               Begin
                    T:=Round(Temp);
                    WriteLn('Generating shademap ',A,' (',T,'%)...');
                    GenTint(Pal,Shades[A],T,T,T);
                    Temp:=Temp+TempInc;
               End;
               InitGraph;
               InitVirt;
               InitTables;
               SetPalette(Pal);
               Cls(0,VGA);
               InitCube;
               InitTextures;
               Light.Y:=0;
               Repeat
                     Cls(0,Vp[1]);
                     { Rotate Light }
                     Light.X:=-Cosines^[Rot];
                     Light.Z:=-Sines^[Rot];
                     PutPixel(30,170,17,Vp[1]);
                     PutPixel(30+Round(-Light.X*20),170+Round(Light.Z*20),
                              16,Vp[1]);
                     Inc(Rot,5); If Rot>360 Then Rot:=0;
                     { Draw the cube }
                     DrawSolid(Cube,Vp[1]);
                     WaitVbl;
                     CopyPage(Vp[1],VGA);
                     RotateSolid(Cube,5,4,3);
                     Delay(10);
               Until Keypressed;
               ClearTables;
               CloseGraph;
          End.
