Program TestShadeMap;

Uses Crt,Mode13h;

Type ShadeMap=Array[0..255] Of Byte;

Var Shade:ShadeMap;
    Pal:RGBList;
    A,B:Byte;

Procedure GenTint(Pal:RgbList;Var Map:ShadeMap;R,G,B:Byte);
Var FactR,FactG,FactB:Real;
    RealR,RealG,RealB:Byte;
    A,C:Byte;
    MinC:Byte;
    MinD,Dist:Real;
Begin
     { Determine the real factors }
     FactR:=R/100;
     FactG:=G/100;
     FactB:=B/100;
     { Determine the map }
     For A:=0 To 255 Do
     Begin
          { Find the real colour }
          RealR:=Round(Pal[A].R*FactR); If RealR>63 Then RealR:=63;
          RealG:=Round(Pal[A].G*FactG); If RealG>63 Then RealG:=63;
          RealB:=Round(Pal[A].B*FactB); If RealB>63 Then RealB:=63;
          { Find now the most approximate colour in the palette }
          MinC:=0; MinD:=MaxInt;
          For C:=0 To 255 Do
          Begin
               { Find distance of colour C to the real colour }
               Dist:=Sqrt(Sqr(RealR-Pal[C].R)+
                          Sqr(RealG-Pal[C].G)+
                          Sqr(RealB-Pal[C].B));
               { If the distance is the smallest so far... }
               If Dist<MinD Then
               Begin
                    { ...then this is the colour we're after so far }
                    MinD:=Dist;
                    MinC:=C;
               End;
          End;
          { Add the colour to the shademap }
          Map[A]:=MinC;
     End;
End;

Begin
     InitGraph;
     LoadPal('Cube.Pal',Pal);
     SetPalette(Pal);
     { Generate a 25% shade }
     GenTint(Pal,Shade,25,25,25);
     For A:=0 To 15 Do
       For B:=0 To 15 Do
         FilledBox(A*8,B*8,A*8+7,B*8+7,A*16+B,VGA);
     ReadKey;
     For A:=0 To 15 Do
       For B:=0 To 15 Do
         FilledBox(A*8,B*8,A*8+7,B*8+7,Shade[A*16+B],VGA);
     ReadKey;
     CloseGraph;
End.