
   (*                                                                  *)
   (*                 Sound Blaster parrot Demo Program                *)
   (*                                                                  *)
   (*    Programmed by Viriato (l41324@alfa.ist.utl.pt) in 1996 for    *)
   (*                                                                  *)
   (*                  Spellcaster's The Mag issue 12                  *)
   (*                                                                  *)
   (*                                                                  *)
   (* Beside the parrot, this program has a textmode scope. It shows   *)
   (* also how to do some calculations to get some interesting values  *)
   (* about the sound.                                                 *)
   (*                                                                  *)


Program Parrot;

Uses Crt,Dos,Sbdsu;

Const Buffersize=8000;
      TimerInternalFreq=1193180;

Var OldInt8Handler:Pointer;  { To keep address of old BIOS int 8 handler }

    BIOSClock:Longint Absolute $40:$6C;    { The BIOS clock }
    iBIOSClockCounter,         { Initial value for BIOSClockCounter }
    BIOSClockCounter:Word;     { When it reaches 0, BIOS clock is incremented }

    Frequency:Word;            { Sampling frequency }

    Buffer:Array[1..Buffersize] Of Byte;  { To keep the sampled sound }
    Sam_Num:Word;            { Index for buffer }
    Sample:Byte;             { Current sample being treated by int 8, }
                             { the sample being recorded or played.   }
    Playing:Boolean;         { Mode of int 8 operation: Playback orRecord }


Procedure TimerHandler;Interrupt;
Begin
     { If playing, play a sample until we have played the entire buffer}
     { Else, take a sample, until we have filled the entire buffer.    }
     If Playing Then
     Begin
          DSPWrite($10);               { Send Direct DAC command }
          DSPWrite(Buffer[Sam_Num]);   { Send sample to be played }
     End
     Else    { If it's not playing, it's recording }
     Begin
          DSPWrite($20);               { Send Direct ADC command }
          Buffer[Sam_Num]:=DSPRead;    { Read (take) a sample }
     End;

     Sample:=Buffer[Sam_Num];     { May be useful for main program }
     { 'Go to' next sample }
     Inc(Sam_Num);
     { If the end of the buffer is reached, swap the 'mode' and }
     { reset sam_num.                                           }
     If Sam_Num>Buffersize Then
     Begin
          Playing:=Not Playing;
          Sam_Num:=1
     End;

     { If it is the time, update the BIOS clock }
     Dec(BIOSClockCounter);
     If BIOSClockCounter=0 Then
     Begin
          BIOSClockCounter:=iBIOSClockCounter;
          Inc(BIOSClock)   { Update the BIOS clock }
     End;

     { Warn the Master PIC about the ending interrupt }
     Port[$20]:=$20
End;

Procedure SetTimerFreq(Freq:Word);
{ Reprograms the timer to tick at freq Hz }
Begin
     If Freq<=18 Then Freq:=0 { 0 means'the lowest possible'(~18.2)}
     Else Freq:=(TimerInternalFreq+Freq Div 2) Div Freq;
     Port[$43]:=$34;
     Port[$40]:=Lo(Freq);
     Port[$40]:=Hi(Freq)
End;

Procedure Cursor(Stat:Boolean);Assembler;
{ Turns the textmode cursor ON/OFF }
Asm
   mov ah,1
   mov bh,0
   mov cx,772
   cmp stat,True
   je @int
   mov cx,2000h
   @int:
        int 10h
End;

Procedure Ini;
Var Aux:Word;
Begin
     { Test for an SB presence }
     If Not SBPresent Then
     Begin
          Writeln('Ok... where did you hide the sound card?');
          Halt(0);
     End;

     { VERY IMPORTANT: turn speaker ON }
     SetSpeakerStatus(True);

     { Read command line parameters: frequency. If there are none, or   }
     { the parameter is illegal, then a default frequency of 10KHz will }
     { be used.                                                         }
     If (Paramcount<>0) Then
     Begin
          Val(ParamStr(1),Frequency,Aux);
          If (Aux<>0) Or (Frequency<18) Or (Frequency>14000) Then
            Frequency:=10000
     End
     Else Frequency:=10000;

     ClrScr;
     TextMode(CO80+Font8x8);
     Cursor(False);       { Hide the cursor }
     Writeln('Parrot - Demo program for The Mag'#10#13'By Viriato,1996');
     GotoXY(1,4);
     Writeln('Frequency: ',Frequency,' Hz');
     GotoXY(3,11);
     Write('');
     GotoXY(5+20, 11);
     Write('');

     { Calculate iBIOSClockCounter }
     iBIOSClockCounter:=(Frequency+18 Div 2) Div 18;
     BIOSClockCounter:=iBIOSClockCounter;

     Playing:=False;  { First we have to record something... }
     Sam_Num:=1;

     { Keep old handler and install the new one }
     GetIntVec(8,OldInt8Handler);
     SetIntVec(8,Addr(TimerHandler));
     { Reprogram the timer to the new frequency and it's already sampling}
     SetTimerFreq(Frequency)
End;

Procedure Fini;
Begin
     SetSpeakerStatus(False);    { Turn speaker off }
     { Set old handler and reprogram timer to normal frequency }
     SetTimerFreq(18);
     SetIntVec(8,OldInt8Handler);

     Cursor(True);        { Show the cursor }
     ClrScr;
     TextMode(CO80);
     WriteLn('Parrot, by Viriato to The Mag, 1996');
     WriteLn;
     WriteLn('If you are curious, or want to know where in the hell');
     WriteLn('is Portugal, write me... l41324@alfa.ist.utl.pt');
     WriteLn;
     WriteLn('See you in some future mag, maybe...')
End;

Procedure DoIt;
Const Bar:Array[False..True] Of String[20]=
          ('', '');
      MaxSamples=80;       { Max number of samples for scope }
Var Which:Boolean;
    X_Cord,Y_Cord,Aux:Integer;
    Y_Array:Array[1..MaxSamples] Of Byte;
Begin
     FillChar(Y_Array,SizeOf(Y_Array),127);

     Repeat
           If KeyPressed Then
                Case UpCase(ReadKey) Of
                     #0 : ReadKey; { (It was a 2 code key) }
                    #27 : break;   { break make execution leave the repeat}
                End;

           GotoXY(5,8);
           If Playing Then Write('Playing  ')
           Else Write('Recording ');

           { Put a buffer status bar on the screen }
           Which:=Playing;    { Playing can be changed at any moment }
           Bar[Which][0]:=
             Chr((LongInt(Sam_Num)*20+Buffersize Div 2) Div Buffersize);
           GotoXY(5,11);
           Write(Bar[Which]);
           GotoXY(5+23,11);
           Write((LongInt(Sam_Num)*100+Buffersize Div 2) Div Buffersize:3,'%');
           { Put some more info }
           GotoXY(5,13);
           Write('Time: ',Sam_Num/Frequency:4:2,' s ');

           { Put a TM scope (as you can see, a scope is something really }
           { easy to do...)                                              }
           For X_Cord:=1 To MaxSamples Do
           Begin
                Y_Cord:=44-Sample Div 8;
                { Erase old 'pixel' }
                GotoXY(X_Cord,Y_Array[X_Cord]);
                Write(' ');
                { Put new 'pixel' and store it in y_array }
                GotoXY(X_Cord,Y_Cord);
                Write('');
                Y_Array[X_Cord]:=Y_Cord
           End;
     Until False;
End;

Begin
     Ini;    { Initialization: install int 8 handler and reprogram timer }
     DoIt;   { Wait for a key... }
     Fini    { Reinstall old handler, unreprogram timer, say bye bye }
End.



















