Program Chain4BigPcx;

Uses Crt;

Const Size:Byte=80;
      VGA=$A000;
      XScreenSize=640;
      YScreenSize=400;

Type RgbItem=Record
                   R,G,B:Byte;
             End;
     RgbList=Array[0..255] of RgbItem;

Var A:Integer;
    PCXPal:RgbList;

Procedure InitChain4; Assembler;
Asm
   Mov Ax,0013h
   Int 10h

   Mov Dx,03c4h
   Mov Al,4
   Out Dx,Al
   Inc Dx
   In Al,Dx
   And Al,11110111b
   Or Al,00000100b
   Out Dx,Al

   Mov Dx,3ceh
   Mov Al,5
   Out Dx,Al
   Inc Dx
   In Al,Dx
   And Al,Not 10h
   Out Dx,Al

   Dec Dx
   Mov Al,6
   Out Dx,Al
   Inc Dx
   In Al,Dx
   And Al,Not 02h
   Out Dx,Al

   Mov Dx,3d4h
   Mov Al,14h
   Out Dx,Al
   Inc Dx
   In Al,Dx
   And Al,Not 40h
   Out Dx,Al

   Dec Dx
   Mov Al,17h
   Out Dx,Al
   Inc Dx
   In Al,Dx
   Or Al,40h
   Out Dx,Al

   Mov Dx,3d4h
   Mov Al,13h
   Out Dx,Al
   Inc Dx
   Mov Al,[Size]
   Out Dx,Al
End;

Procedure CloseChain4; Assembler;
Asm
   mov ax,03h
   int 10h
End;

Procedure SetColor(Col,R,G,B:Byte); Assembler;
Asm
   Mov Dx,3c8h
   Mov Al,[Col]
   Out Dx,Al
   Inc Dx
   Mov Al,[R]
   Out Dx,Al
   Mov Al,[G]
   Out Dx,Al
   Mov Al,[B]
   Out Dx,Al
End;

Procedure SetPalette(Var Palette:RgbList);Assembler;
Label L1,L2;
Asm
   Mov Dx,3dah
   L1:
      In Al,Dx
      And Al,08h
      Jnz L1
   L2:
      In Al,Dx
      And Al,08h
      Jz l2
   Push  ds
   Lds Si,Palette
   Mov Dx,3c8h
   Mov Al,0
   Out Dx,Al
   Inc dx
   Mov Cx,768
   Rep OutsB
   Pop Ds
End;

Procedure WaitVbl; Assembler;
Label L1,L2;
Asm
   Mov Dx,3dah
   L1:
      In Al,Dx
      And Al,08h
      Jnz L1
   L2:
      In Al,Dx
      And Al,08h
      Jz L2
End;

Procedure PutPixel(X,Y:Integer; Color:Byte);
Var Pos:Word;
    BitMask:Byte;
Begin
     Pos:=Y*(Size Shl 1)+(X Div 4);
     BitMask:=1 Shl (X Mod 4);
     PortW[$3c4]:=(BitMask Shl 8)+2;
     Mem[$A000:Pos]:=Color;
End;

Procedure LoadChain4Pcx(FileName:String);
Var Fil:File;
    Dx,Dy:Word;
    J,M:Byte;
    Ph:Word;
    Buff:Array[0..127] of byte;
Begin
     Assign(Fil,Filename);
     Reset(Fil,1);
     Blockread(Fil,Buff,128);
     Dy:=0;
     Repeat
           Dx:=0;
           Repeat
                 BlockRead(Fil,J,1);
                 If J>192 Then
                 Begin
                      BlockRead(Fil,M,1);
                      Dec(J,192);
                      For Ph:=1 To J Do
                      Begin
                           PutPixel(Dx,Dy,M);
                           Inc(Dx);
                      End;
                 End
                 Else
                 Begin
                      PutPixel(Dx,Dy,J);
                      Inc(Dx);
                 End;
           Until Dx>=XScreenSize;
           Inc(Dy);
     Until Dy=YScreenSize;
     BlockRead(Fil,M,1);
     If M=12 Then
     Begin
          BlockRead(Fil,PCXPal,768);
          For M:=0 To 255 Do
          Begin
               PCXPal[M].R:=PCXPal[M].R Div 4;
               PCXPal[M].G:=PCXPal[M].G Div 4;
               PCXPal[M].B:=PCXPal[M].B Div 4;
          End;
     End;
     Close(Fil);
End;

Procedure ChangeViewPort(X,Y:Word);
Var A:Word;
Begin
     A:=Y*(Size Shl 1)+X;
     PortW[$3d4]:=(Hi(A) Shl 8)+$C;
     PortW[$3d4]:=(Lo(A) Shl 8)+$D;
End;

Begin
     InitChain4;
     LoadChain4Pcx('Pic.Pcx');
     SetPalette(PCXPal);
     Repeat
           For A:=0 To 200 Do
           Begin
                WaitVbl;
                ChangeViewPort(0,A);
           End;
           For A:=0 To 80 Do
           Begin
                WaitVbl;
                ChangeViewPort(A,200);
           End;
           For A:=200 DownTo 0 Do
           Begin
                WaitVbl;
                ChangeViewPort(80,A);
           End;
           For A:=80 DownTo 0 Do
           Begin
                WaitVbl;
                ChangeViewPort(A,0);
           End;
     Until KeyPressed;
     CloseChain4;
End.