Program Chain4Plasma;

Uses Crt;

Const Size=80;
      TableElements=256;
      VGA=$A000;

Type Table=Array[0..TableElements-1] Of Integer;
     PTable=^Table;

Var Virt:Pointer;
    Sines,Cosines:PTable;
    A,B:Integer;
    C:Char;

Procedure InitChain4; Assembler;
Asm
   Mov Ax,0013h
   Int 10h

   Mov Dx,03c4h
   Mov Al,4
   Out Dx,Al
   Inc Dx
   In Al,Dx
   And Al,11110111b
   Or Al,00000100b
   Out Dx,Al

   Mov Dx,3ceh
   Mov Al,5
   Out Dx,Al
   Inc Dx
   In Al,Dx
   And Al,Not 10h
   Out Dx,Al

   Dec Dx
   Mov Al,6
   Out Dx,Al
   Inc Dx
   In Al,Dx
   And Al,Not 02h
   Out Dx,Al

   Mov Dx,3d4h
   Mov Al,14h
   Out Dx,Al
   Inc Dx
   In Al,Dx
   And Al,Not 40h
   Out Dx,Al

   Dec Dx
   Mov Al,17h
   Out Dx,Al
   Inc Dx
   In Al,Dx
   Or Al,40h
   Out Dx,Al

   Mov Dx,3d4h
   Mov Al,13h
   Out Dx,Al
   Inc Dx
   Mov Al,40
   Out Dx,Al
End;

Procedure CloseChain4; Assembler;
Asm
   mov ah,0
   mov al,03h
   int 10h
End;

Procedure MakeVirt;
{ Create a 80x55 virtual screen }
Begin
     GetMem(Virt,4400);
End;

Procedure CloseVirt;
Begin
     FreeMem(Virt,4400);
End;

Procedure MakeLookUpTable;
Var A:Word;
    B:Real;
    Increment:Real;
Begin
     Getmem(Sines,Sizeof(Sines^));
     Getmem(Cosines,Sizeof(Cosines^));
     B:=0;
     Increment:=2*PI/TableElements;
     For A:=0 To TableElements-1 Do
     Begin
          Sines^[A]:=Round(16*Sin(B));
          Cosines^[A]:=Round(16*Cos(B));
          B:=B+Increment;
     End;
End;

Procedure ClearLookUpTable;
Begin
     Freemem(Sines,Sizeof(Sines^));
     Freemem(Cosines,Sizeof(Cosines^));
End;

Procedure SetColor(Col,R,G,B:Byte); Assembler;
Asm
   Mov Dx,3c8h
   Mov Al,[Col]
   Out Dx,Al
   Inc Dx
   Mov Al,[R]
   Out Dx,Al
   Mov Al,[G]
   Out Dx,Al
   Mov Al,[B]
   Out Dx,Al
End;

Procedure SetColors;
Begin
     For A:=0 To 7 Do SetColor(A,0,A*8,A*8);
     For A:=0 To 7 Do SetColor(A+8,0,63,63-(A*8));
     For A:=0 To 7 Do SetColor(A+16,A*8,63,0);
     For A:=0 To 7 Do SetColor(A+24,63,63-(A*8),0);
     SetColor(32,64,0,0);
End;

Procedure DoPlasma;
Var X,Y:Word;
    C:Byte;
    S,O:Word;
Begin
     S:=Seg(Virt^);
     O:=Ofs(Virt^);
     For X:=0 To 79 Do
       For Y:=0 To 54 Do
       Begin
            C:=(Sines^[Byte((X+A)*2)]+CoSines^[Byte(Y+B*2)]+
                Sines^[Byte(Y*3+A)]+Cosines^[Byte(X+B)]+64) Div 4;
            Mem[S:(O+Y*80+X)]:=C;
       End;
End;

Procedure CopyVirt;
{ This copies the virtual screen to the physical screen }
Var X,Y:Integer;
    S,O:Word;
Begin
     PortW[$3c4]:=(15 shl 8)+2;
     Y:=0;
     S:=Seg(Virt^); O:=Ofs(Virt^);
     Repeat
           For X:=0 To 79 Do
           Begin
                Mem[VGA:(Y*Size+X)]:=Mem[S:(O+(Y Div 4)*80+X)];
           End;
           Inc(Y);
     Until Y=204;
End;

Procedure WaitVbl; Assembler;
Label L1,L2;
Asm
   Mov Dx,3dah
   L1:
      In Al,Dx
      And Al,08h
      Jnz L1
   L2:
      In Al,Dx
      And Al,08h
      Jz L2
End;

Begin
     InitChain4;
     MakeVirt;
     MakeLookUpTable;
     SetColors;
     A:=0; B:=0;
     Repeat
           DoPlasma;
           WaitVbl;
           CopyVirt;
           Inc(A,2); Inc(B,3);
           Delay(20);
     Until KeyPressed;
     ClearLookUpTable;
     CloseVirt;
     CloseChain4;
End.