Unit Sprites;

{ Version 1.1 }

Interface

Type Sprite=Record
                  Img:Pointer;
                  Back:Pointer;
                  X,Y:Integer;
            End;

Var MinX,MaxX:Integer;
    MinY,MaxY:Integer;

Procedure GetImage(x1,y1,x2,y2:Word;Var Img:Pointer;Where:Word);
Procedure KillImage(Var Img:Pointer);
Procedure PutImage(X,Y:Word;Var Img:Pointer;Where:Word);
Procedure PutImage_C(X,Y:Integer;Var Img:Pointer;Where:Word);
Procedure PutImage_T(X,Y:Word;Var Img:Pointer;Where:Word);
Procedure PutImage_CT(X,Y:Integer;Var Img:Pointer;Where:Word);
Procedure SaveImage(Var F:File;Img:Pointer);
Procedure LoadImage(Var F:File;Var Img:Pointer);
Procedure FlipHoriz(Var Img:Pointer);
Procedure FlipVert(Var Img:Pointer);
Procedure PutRotatedImage(X,Y,Angle:Word;Var Img:Pointer;Where:Word);
Procedure Scale(Image:Pointer;DeltaX,DeltaY:Word;Var Target:Pointer);

Implementation

Uses Mode13h;

Procedure GetImage(x1,y1,x2,y2:Word;Var Img:Pointer;Where:Word);
Var Dx,Dy:Word;
    A,B:Word;
    Segm,Offs:Word;
Begin
     Dx:=Abs(x2-x1)+1;
     Dy:=Abs(y2-y1)+1;
     GetMem(Img,Dx*Dy+4);
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Dx,Mem[Segm:Offs],2);
     Move(Dy,Mem[Segm:Offs+2],2);
     Offs:=Offs+4;
     For A:=y1 to y2 Do
     For B:=x1 to x2 Do
     Begin
          Mem[Segm:Offs]:=GetPixel(B,A,Where);
          Inc(Offs);
     End;
End;

Procedure KillImage(Var Img:Pointer);
Var Dx,Dy:Word;
    Segm,Offs:Word;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     FreeMem(Img,Dx*Dy+4);
End;

Procedure PutImage(X,Y:Word;Var Img:Pointer;Where:Word);
Var Dx,Dy:Word;
    A,B:Word;
    Segm,Offs:Word;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     Offs:=Offs+4;
     For A:=Y To Y+Dy-1 Do
     Begin
          Move(Mem[Segm:Offs],Mem[Where:A*320+X],Dx);
          Offs:=Offs+Dx;
     End;
End;

Procedure PutImage_C(X,Y:Integer;Var Img:Pointer;Where:Word);
Var Dx,Dy:Word;
    A,B:Word;
    Segm,Offs:Word;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     Offs:=Offs+4;
     A:=Y;
     While (A<=Y+DY-1) And (A<MaxY) Do
     Begin
          B:=X;
          While (B<=X+DX-1) And (B<MaxX) Do
          Begin
               If (X>=MinX) And (Y>=MinY) Then
                 PutPixel(B,A,Mem[Segm:Offs],Where);
               Inc(Offs);
               Inc(B);
          End;
          Inc(A);
     End;
End;

Procedure PutImage_T(X,Y:Word;Var Img:Pointer;Where:Word);
Var Dx,Dy:Word;
    A,B:Word;
    Segm,Offs:Word;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     Offs:=Offs+4;
     For A:=Y To Y+Dy-1 Do
     Begin
          For B:=X To X+Dx-1 Do
          Begin
               If Mem[Segm:Offs]<>0 Then PutPixel(B,A,Mem[Segm:Offs],Where);
               Inc(Offs);
          End;
     End;
End;

Procedure PutImage_CT(X,Y:Integer;Var Img:Pointer;Where:Word);
Var Dx,Dy:Word;
    A,B:Word;
    Segm,Offs:Word;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     Offs:=Offs+4;
     A:=Y;
     While (A<=Y+DY-1) And (A<MaxY) Do
     Begin
          B:=X;
          While (B<=X+DX-1) And (B<MaxX) Do
          Begin
               If (X>=MinX) And (Y>=MinY) And (Mem[Segm:Offs]<>0) Then
                 PutPixel(B,A,Mem[Segm:Offs],Where);
               Inc(Offs);
               Inc(B);
          End;
          Inc(A);
     End;
End;

Procedure SaveImage(Var F:File;Img:Pointer);
Var Dx,Dy:Word;
    Segm,Offs:Word;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     BlockWrite(F,Img^,Dx*Dy+4);
End;

Procedure LoadImage(Var F:File;Var Img:Pointer);
Var Dx,Dy:Word;
    Segm,Offs:Word;
Begin
     BlockRead(F,Dx,2);
     BlockRead(F,Dy,2);
     GetMem(Img,Dx*Dy+4);
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Dx,Mem[Segm:Offs],2);
     Move(Dy,Mem[Segm:Offs+2],2);
     Offs:=Offs+4;
     BlockRead(F,Mem[Segm:Offs],Dx*Dy);
End;

Procedure FlipHoriz(Var Img:Pointer);
Var Dx,Dy:Word;
    S1,O1:Word;
    S2,O2:Word;
    Tmp:Pointer;
    A,B:Word;
Begin
     { Get X and Y sizes }
     S1:=Seg(Img^);
     O1:=Ofs(Img^);
     Move(Mem[S1:O1],Dx,2);
     Move(Mem[S1:O1+2],Dy,2);
     { Create temporary sprite }
     GetMem(Tmp,Dx*Dy+4);
     S2:=Seg(Tmp^);
     O2:=Ofs(Tmp^);
     { Put the size of the sprite in the temporary sprite }
     Move(Mem[S1:O1],Mem[S2:O2],4);
     { Move the columns }
     For A:=0 To Dx-1 Do
       For B:=0 To Dy-1 Do
         Move(Mem[S1:O1+(B*Dx+A+4)],
              Mem[S2:O2+(B*Dx+(Dx-A-1)+4)],1);
     { Kill old image }
     KillImage(Img);
     { Copy new image to old one }
     Img:=Tmp;
End;

Procedure FlipVert(Var Img:Pointer);
Var Dx,Dy:Word;
    S1,O1:Word;
    S2,O2:Word;
    Tmp:Pointer;
    A:Word;
Begin
     { Get X and Y sizes }
     S1:=Seg(Img^);
     O1:=Ofs(Img^);
     Move(Mem[S1:O1],Dx,2);
     Move(Mem[S1:O1+2],Dy,2);
     { Create temporary sprite }
     GetMem(Tmp,Dx*Dy+4);
     S2:=Seg(Tmp^);
     O2:=Ofs(Tmp^);
     { Put the size of the sprite in the temporary sprite }
     Move(Mem[S1:O1],Mem[S2:O2],4);
     { Move the lines }
     For A:=0 To Dy-1 Do
       Move(Mem[S1:O1+(A*Dx+4)],
            Mem[S2:O2+((Dy-1-A)*Dx+4)],Dx);
     { Kill old image }
     KillImage(Img);
     { Copy new image to old one }
     Img:=Tmp;
End;

Procedure PutRotatedImage(X,Y,Angle:Word;Var Img:Pointer;Where:Word);
Var Dx,Dy:Word;
    A,B:Word;
    Segm,Offs:Word;
    Xp,Yp:Integer;
    Xr,Yr:Integer;
    Xc,Yc:Integer;
    Color:Byte;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     Offs:=Offs+4;
     Xc:=X+(Dx Div 2);
     Yc:=Y+(Dy Div 2);
     For A:=1 To Dy Do
       For B:=1 To Dx Do
       Begin
            { Calculate relative coordinates }
            Xp:=(X+B)-Xc;
            Yp:=(Y+A)-Yc;
            { Calculate rotated coordinates }
            Xr:=Trunc(Xp*Cosines^[Angle]-Yp*Sines^[Angle]);
            Yr:=Trunc(Yp*Cosines^[Angle]+Xp*Sines^[Angle]);
            { Add the value of the center }
            Xr:=Xr+Xc;
            Yr:=Yr+Yc;
            { Put the pixel }
            Color:=Mem[Segm:Offs];
            PutPixel(Xr,Yr,Color,Where);
            Inc(Offs);
       End;
End;

Procedure Scale(Image:Pointer;DeltaX,DeltaY:Word;Var Target:Pointer);
Var Segm1,Segm2,Offs1,Offs2:Word;
    XSize,YSize:Word;
    IndexX,IndexY,XRatio,YRatio:Real;
    Dx,Dy:Word;
    C:Byte;
Begin
     Segm1:=Seg(Image^);
     Offs1:=Ofs(Image^);
     Move(Mem[Segm1:Offs1],Xsize,2);
     Move(Mem[Segm1:Offs1+2],Ysize,2);
     GetMem(Target,DeltaX*DeltaY+4);
     Segm2:=Seg(Target^);
     Offs2:=Ofs(Target^);
     Move(DeltaX,Mem[Segm2:Offs2],2);
     Move(DeltaY,Mem[Segm2:Offs2+2],2);
     Offs2:=Offs2+4;
     XRatio:=XSize/DeltaX;
     YRatio:=YSize/DeltaY;
     IndexX:=0;
     IndexY:=0;
     For Dy:=1 To DeltaY Do
     Begin
          For Dx:=1 To DeltaX Do
          Begin
               Offs1:=Trunc(IndexY)*XSize+Trunc(IndexX)+4;
               C:=Mem[Segm1:Offs1];
               Mem[Segm2:Offs2]:=C;
               Inc(Offs2);
               IndexX:=IndexX+XRatio;
          End;
          IndexX:=0;
          IndexY:=IndexY+YRatio;
     End;
End;

Begin
     MinX:=0;
     MaxX:=319;
     MinY:=0;
     MaxY:=199;
End.
