               Program VectorBalls;

               Uses Mode13h,Crt;

               Type BallSprite=Array[1..8,1..8] Of Byte;

               Const Balls=43;
                     { Base object }
                     Ball:BallSprite=
                     ((0,0,2,2,2,1,0,0),(0,2,3,3,3,2,1,0),(2,3,4,3,3,2,1,1),
                      (2,3,3,3,2,2,1,1),(2,2,3,3,2,1,1,1),(1,2,2,2,1,1,1,1),
                      (0,1,1,1,1,1,1,0),(0,0,1,1,1,1,0,0));

               Type Ball3d=Record
                                 Color:Byte;
                                 X,Y,Z:Real;
                           End;

               Var S:Array[1..Balls] of Ball3d;
                   A:Integer;
                   C:Char;

               Procedure InitColors;
               { Sets the colors }
               Begin
                    SetColor(0,0,0,0);
                    { Blues }
                    SetColor(1,0,0,30);
                    SetColor(2,0,0,50);
                    SetColor(3,0,20,63);
                    SetColor(4,0,40,63);
                    { Yellows }
                    SetColor(5,63,25,0);
                    SetColor(6,63,50,0);
                    SetColor(7,63,63,0);
                    SetColor(8,63,63,63);
                    { Greens }
                    SetColor(9,0,20,0);
                    SetColor(10,0,40,0);
                    SetColor(11,0,50,0);
                    SetColor(12,0,63,0);
                    { Browns }
                    SetColor(13,63,20,0);
                    SetColor(14,63,30,0);
                    SetColor(15,63,40,0);
                    SetColor(16,63,50,0);
               End;

               Procedure LoadVector(Filename:String);
               { Loads a vector object from disk... The objects may be
                 generated with the VECTGEN.PAS program... }
               Var F:Text;
                   A,N:Byte;
               Begin
                    Assign(F,Filename);
                    Reset(F);
                    ReadLn(F,N);
                    For A:=1 To N Do
                    Begin
                         ReadLn(F,S[A].X);
                         ReadLn(F,S[A].Y);
                         ReadLn(F,S[A].Z);
                         ReadLn(F,S[A].Color);
                    End;
                    Close(F);
               End;

               Procedure DrawSprite(X,Y:Integer;BaseColor:Byte;Where:Word);
               Var A,B:Byte;
               Begin
                    For A:=1 To 8 Do For B:=1 To 8 Do
                      If Ball[A,B]<>0 Then
                        PutPixel(X+A-1,Y+B-1,Ball[A,B]+BaseColor-1,Where);
               End;

               Procedure DrawBall(P:Ball3d;Where:Word);
               Var Xt,Yt:Integer;
               Begin
                    { Convert X,Y,Z to X,Y }
                    Xt:=160+Trunc((P.X*256)/P.Z);
                    If (Xt<0) Or (Xt>319) Then Exit;
                    Yt:=100+Trunc((P.Y*256)/P.Z);
                    If (Yt<0) Or (Yt>199) Then Exit;
                    { Draw the ball }
                    DrawSprite(Xt,Yt,P.Color,Where);
               End;

               Procedure Sort;
               Var Flag:Boolean;
                   I,J:Integer;
                   N:Real;
                   X:Ball3d;

                   Procedure SortSubArray(Left,Right:Byte);
                   Begin
                        { Partition }
                        I:=Left;
                        J:=Right;
                        N:=S[(Left+Right) Div 2].Z;
                        Repeat
                              { Find first number from the left to be < N }
                              While S[I].Z<N Do Inc(I);
                              { Find first number from the right to be > N }
                              While S[J].Z>N Do Dec(J);
                              { Exchange }
                              If I<=J Then
                              Begin
                                   X:=S[J];
                                   S[J]:=S[I];
                                   S[I]:=X;
                                   Inc(I);
                                   Dec(J);
                              End;
                        Until J<I;
                        { Order left and right subarrays }
                        If Left<J Then SortSubArray(Left,J);
                        If I<Right Then SortSubArray(I,Right);
                   End;

               Begin
                    SortSubArray(1,Balls);
               End;

               Procedure DrawBalls(Where:Word);
               Var A:Byte;
               Begin
                    Sort;
                    For A:=Balls DownTo 1 Do DrawBall(S[A],Where);
               End;

               Procedure RotateX(Deg:Integer);
               Var A:Byte;
                   Angle:Real;
                   ZTemp:Real;
                   Si,Co:Real;
               Begin
                    Angle:=0.0175*Deg;
                    Si:=Sin(Angle);
                    Co:=Cos(Angle);
                    For A:=1 To Balls Do
                      With S[A] Do
                      Begin
                           ZTemp:=Z;
                           Z:=ZTemp*Co-Y*Si;
                           Y:=Y*Co+ZTemp*Si;
                      End;
               End;

               Procedure RotateY(Deg:Integer);
               Var A:Byte;
                   Angle:Real;
                   XTemp:Real;
                   Si,Co:Real;
               Begin
                    Angle:=0.0175*Deg;
                    Si:=Sin(Angle);
                    Co:=Cos(Angle);
                    For A:=1 To Balls Do
                      With S[A] Do
                      Begin
                           XTemp:=X;
                           X:=XTemp*Co-Z*Si;
                           Z:=Z*Co+XTemp*Si;
                      End;
               End;

               Procedure RotateZ(Deg:Integer);
               Var A:Byte;
                   Angle:Real;
                   XTemp:Real;
                   Si,Co:Real;
               Begin
                    Angle:=0.0175*Deg;
                    Si:=Sin(Angle);
                    Co:=Cos(Angle);
                    For A:=1 To Balls Do
                      With S[A] Do
                      Begin
                           XTemp:=X;
                           X:=XTemp*Co-Y*Si;
                           Y:=Y*Co+XTemp*Si;
                      End;
               End;

               Procedure Rotate(XRot,YRot,ZRot:Integer);
               Begin
                    RotateX(XRot);
                    RotateY(XRot);
                    RotateZ(XRot);
               End;

               Procedure Move(XOff,YOff,ZOff:Integer);
               Begin
                    For A:=1 To Balls Do
                    Begin
                         S[A].X:=S[A].X+XOff;
                         S[A].Y:=S[A].Y+YOff;
                         S[A].Z:=S[A].Z+ZOff;
                    End;
               End;

               Begin
                    { Setup program }
                    InitGraph;
                    InitVirt;
                    InitColors;
                    LoadVector('Island.Vct');
                    { Move it further away }
                    Move(0,0,256);
                    Cls(0,VGA);
                    Cls(0,VP[1]);
                    { Main cicle }
                    Repeat
                          { Clear virtual screen }
                          Cls(0,VP[1]);
                          Move(0,0,-256);
                          Rotate(5,-10,10);
                          Move(0,0,256);
                          { Draw balls }
                          DrawBalls(VP[1]);
                          { Copy virtual screen to VGA screen }
                          CopyPage(VP[1],VGA);
                    Until Keypressed;
                    { Shutdown }
                    CloseVirt;
                    Closegraph;
               End.