               Program WireFrame;

               Uses Mode13h,Crt;

               Const MaxPoints=30;
                     MaxLines=30;

               Type Point3d=Record
                                  X,Y,Z:Real;
                            End;

                    Object3d=Record
                                   NumberPoints:Byte;
                                   NumberLines:Byte;
                                   Pt:Array[1..MaxPoints] Of Point3d;
                                   Lines:Array[1..MaxLines,1..2] Of Byte;
                             End;

               Var A:Integer;
                   Cube:Object3d;
                   D:Char;

               Procedure Conv3d(X,Y,Z:Real;Var Xt,Yt:Integer);
               Begin
                    Xt:=160+Trunc((X*256)/Z);
                    Yt:=100+Trunc((Y*256)/Z);
               End;

               Procedure Load3d(Filename:String;Var Obj:Object3d);
               Var F:Text;
                   A:Byte;
               Begin
                    Assign(F,Filename);
                    Reset(F);
                    ReadLn(F,Obj.NumberPoints);
                    ReadLn(F,Obj.NumberLines);
                    For A:=1 To Obj.NumberPoints Do
                      ReadLn(F,Obj.Pt[A].X,Obj.Pt[A].Y,Obj.Pt[A].Z);
                    For A:=1 To Obj.NumberLines Do
                      ReadLn(F,Obj.Lines[A,1],Obj.Lines[A,2]);
                    Close(F);
               End;

               Procedure Draw3d(Obj:Object3d;XOff,YOff,ZOff:Integer;
                                Color:Byte;Where:Word);
               Var A:Byte;
                   Pt1,Pt2:Byte;
                   X1,Y1,X2,Y2:Integer;
               Begin
                    For A:=1 To Obj.NumberLines Do
                    Begin
                         Pt1:=Obj.Lines[A,1];
                         Pt2:=Obj.Lines[A,2];
                         Conv3d(Obj.Pt[Pt1].X+XOff,
                                Obj.Pt[Pt1].Y+YOff,
                                Obj.Pt[Pt1].Z+ZOff,
                                X1,Y1);
                         Conv3d(Obj.Pt[Pt2].X+XOff,
                                Obj.Pt[Pt2].Y+YOff,
                                Obj.Pt[Pt2].Z+ZOff,
                                X2,Y2);
                         LineC(X1,Y1,X2,Y2,Color,Where);
                    End;
               End;

               Procedure Translate(Var Obj:Object3d;XOff,YOff,ZOff:Integer);
               Var A:Byte;
               Begin
                    For A:=1 To Obj.NumberPoints Do
                    Begin
                         Obj.Pt[A].X:=Obj.Pt[A].X+XOff;
                         Obj.Pt[A].Y:=Obj.Pt[A].Y+YOff;
                         Obj.Pt[A].Z:=Obj.Pt[A].Z+ZOff;
                    End;
               End;

               Procedure Scale(Var Obj:Object3d;XScl,YScl,ZScl:Real);
               Var A:Byte;
               Begin
                    For A:=1 To Obj.NumberPoints Do
                    Begin
                         Obj.Pt[A].X:=Obj.Pt[A].X*XScl;
                         Obj.Pt[A].Y:=Obj.Pt[A].Y*YScl;
                         Obj.Pt[A].Z:=Obj.Pt[A].Z*ZScl;
                    End;
               End;

               Procedure RotateX(Var Obj:Object3d;Deg:Integer);
               Var A:Byte;
                   Angle:Real;
                   ZTemp:Real;
               Begin
                    Angle:=0.0175*Deg;
                    For A:=1 To Obj.NumberPoints Do
                      With Obj.Pt[A] Do
                      Begin
                           ZTemp:=Z;
                           Z:=ZTemp*Cos(Angle)-Y*Sin(Angle);
                           Y:=Y*Cos(Angle)+ZTemp*Sin(Angle);
                      End;
               End;

               Procedure RotateY(Var Obj:Object3d;Deg:Integer);
               Var A:Byte;
                   Angle:Real;
                   XTemp:Real;
               Begin
                    Angle:=0.0175*Deg;
                    For A:=1 To Obj.NumberPoints Do
                      With Obj.Pt[A] Do
                      Begin
                           XTemp:=X;
                           X:=XTemp*Cos(Angle)-Z*Sin(Angle);
                           Z:=Z*Cos(Angle)+XTemp*Sin(Angle);
                      End;
               End;

               Procedure RotateZ(Var Obj:Object3d;Deg:Integer);
               Var A:Byte;
                   Angle:Real;
                   XTemp:Real;
               Begin
                    Angle:=0.0175*Deg;
                    For A:=1 To Obj.NumberPoints Do
                      With Obj.Pt[A] Do
                      Begin
                           XTemp:=X;
                           X:=XTemp*Cos(Angle)-Y*Sin(Angle);
                           Y:=Y*Cos(Angle)+XTemp*Sin(Angle);
                      End;
               End;

               Begin
                    Initgraph;
                    Load3d('Cube.3d',Cube);
                    SetColor(1,63,63,0);
                    Translate(Cube,-40,-50,200);
                    For A:=1 To 72 Do
                    Begin
                         Translate(Cube,40,50,-200);
                         RotateX(Cube,5);
                         Translate(Cube,-40,-50,200);
                         Draw3d(Cube,0,0,0,1,VGA);
                         Draw3d(Cube,0,0,0,0,VGA);
                    End;
                    For A:=1 To 72 Do
                    Begin
                         Translate(Cube,40,50,-200);
                         RotateY(Cube,5);
                         Translate(Cube,-40,-50,200);
                         Draw3d(Cube,0,0,0,1,VGA);
                         Draw3d(Cube,0,0,0,0,VGA);
                    End;
                    For A:=1 To 72 Do
                    Begin
                         Translate(Cube,40,50,-200);
                         RotateZ(Cube,5);
                         Translate(Cube,-40,-50,200);
                         Draw3d(Cube,0,0,0,1,VGA);
                         Draw3d(Cube,0,0,0,0,VGA);
                    End;
                    Draw3d(Cube,0,0,0,1,VGA);
                    D:=Readkey;
                    Closegraph;
               End.