#Makefile for ZTools 7/2 to make an MPW tool with CodeWarrior 68K compiler and linker
#Don't forget to convert LF->CR in source files

#Modify this line, then use 
#BuildProgram "Mydisk:mydir:mpwcw"

SrcDir   = HDSC 600:ZTools:

MAKEFILE     = {SrcDir}mpwcw.make
MondoBuild = {MAKEFILE}  # Make blank to avoid rebuilds when makefile is modified

Includes     = -i {SrcDir}
Sym68K      = -mbg full -model far -D MAC_MPW
ObjDir68K   = {SrcDir}
ToolDir		 = {SrcDir}
C 			 = MWC68K
Link		 = MWLink68K -d

COptions     = {Includes} {Sym68K} 

#CWPro1.  Note that the ANSI lib is not built by default.  Use Build MSL Library tool to build it.
AnsiLib 	 = "{MW68KLibraries}MSL C.68K MPW(NL_4i_8d).Lib" "{MW68KLibraries}MSL Runtime68K.Lib"
MPWRuntimeLib 	 = "{MW68KLibraries}MSL MPWRuntime.68K.Lib"
MathLib	=	"{MW68KLibraries}MathLib68K (4i_8d).lib"

#CW11
#AnsiLib 	 = "{MW68KLibraries}MSL MPW C.68K.Lib"
# You have to build unix.mac.c.o yourself.  CW 11 MSL left out some definitions. 
#MPWRuntimeLib 	 = "{MW68KLibraries}unix.mac.c.o" "{MW68KLibraries}MSL MPWRuntime.68K.Lib"
#MathLib	=	"{MW68KLibraries}MathLib68K (4i/8d).lib"

#Following definitions are for pre-MSL ANSI libraries.  Use for CW MPW 10 or less
#AnsiLib 	 = "{MW68KLibraries}MPW ANSI (4i/8d) C.68K.Lib"
#MPWRuntimeLib 	 = "{MW68KLibraries}MPWRuntime.68K.Lib"
#MathLib	=	"{MW68KLibraries}MathLib68K (4i/8d).lib"

CheckObjects68K  = 
		"{ObjDir68K}check.c.o"

Pix2gifObjects68K  = 
		"{ObjDir68K}pix2gif.c.o"

InfodumpObjects68K  = 
		"{ObjDir68K}txio.c.o" 
		"{ObjDir68K}infodump.c.o" 
		"{ObjDir68K}showhead.c.o" 
		"{ObjDir68K}showdict.c.o" 
		"{ObjDir68K}showobj.c.o" 
		"{ObjDir68K}getopt.c.o" 
		"{ObjDir68K}showverb.c.o"

TxdObjects68K  = 
		"{ObjDir68K}txio.c.o" 
		"{ObjDir68K}txd.c.o" 
		"{ObjDir68K}getopt.c.o" 
		"{ObjDir68K}showverb.c.o"
		
{SrcDir}mpwcw  {ToolDir}check {ToolDir}infodump {ToolDir}pix2gif {ToolDir}txd 

{ToolDir}check  {MondoBuild} {CheckObjects68K}
	{Link} -o {Targ} -xm mpwtool -model far 
				{CheckObjects68K} 
				{MPWRuntimeLib} 
				{AnsiLib} 
				"{MW68KLibraries}MacOS.lib" 
				{MathLib} 
				"{Libraries}ToolLibs.o"

{ToolDir}pix2gif  {MondoBuild} {Pix2gifObjects68K}
	{Link} -o {Targ} -xm mpwtool -model far 
				{Pix2gifObjects68K} 
				{MPWRuntimeLib} 
				{AnsiLib} 
				"{MW68KLibraries}MacOS.lib" 
				{MathLib} 
				"{Libraries}ToolLibs.o"

{ToolDir}infodump  {MondoBuild} {InfodumpObjects68K}
	{Link} -o {Targ} -xm mpwtool -model far 
				{InfodumpObjects68K} 
				{MPWRuntimeLib} 
				{AnsiLib} 
				"{MW68KLibraries}MacOS.lib" 
				{MathLib} 
				"{Libraries}ToolLibs.o"

{ToolDir}txd  {MondoBuild} {TxdObjects68K}
	{Link} -o {Targ} -xm mpwtool -model far 
				{MPWRuntimeLib} 
				"{MW68KLibraries}MacOS.lib" 
				{TxdObjects68K} 
				{AnsiLib} 
				{MathLib} 
				"{Libraries}ToolLibs.o"

.c.o  .c {MondoBuild}
	{C} {depDir}{Default}{stem}.c -o {Targ} {COptions}

