package zpplet.header;


public class ZHeader5
		extends ZHeader4
	{
	final static int SCREEN_WIDTH_UNITS = 0x22;
	final static int SCREEN_HEIGHT_UNITS = 0x24;
	final static int FONT_WIDTH_UNITS = 0x26;
	final static int FONT_HEIGHT_UNITS = 0x27;
	final static int DEFAULT_BACKGROUND_COLOR = 0x2C;
	final static int DEFAULT_FOREGROUND_COLOR = 0x2D;
	final static int TERMINATORS_BASE = 0x2E;
	final static int ALPHABET_CUSTOM_BASE = 0x34;
	final static int EXTENSION_BASE = 0x36;
	final static int EXTENSION_LEN = 0;
	final static int EXTENSION_MOUSEX = 1;
	final static int EXTENSION_MOUSEY = 2;
	final static int EXTENSION_UNICODEBASE = 3;

	public ZHeader5(byte[] mem)
		{
		super(mem);
		}

	public int getAlphaCustomBase()
		{
		return getWord(ALPHABET_CUSTOM_BASE);
		}

	public void setColorsAvailable(boolean value)
		{
		if (value)
			m[FLAGS1] |= 0x01;
		else
			m[FLAGS1] &= 0xFE;
		}

	public void setGraphicsWanted(boolean value)
		{
		if (value)
			m[FLAGS2 + 1] |= 0x08;
		else
			m[FLAGS2 + 1] &= 0xF7;
		}
	
	public boolean getPicturesWanted()
		{
		return (m[FLAGS2 + 1] & (1 << 3)) != 0;
		}
	
	public void setPicturesAvailable(boolean value)
		{
		if (!value)
			m[FLAGS2 + 1] &= ~(1 << 3);
		}

	public boolean getUndoWanted()
		{
		return (m[FLAGS2 + 1] & 0x10) != 0;
		}

	public void setUndoAvailable(boolean value)
		{
		if (!value)
			m[FLAGS2 + 1] &= 0xEF;
		}

	public boolean getMouseWanted()
		{
		return (m[FLAGS2 + 1] & 0x20) != 0;
		}

	public void setMouseAvailable(boolean value)
		{
		if (!value)
			m[FLAGS2 + 1] &= 0xDF;
		}

	public boolean getColorsWanted()
		{
		return (m[FLAGS2 + 1] & 0x40) != 0;
		}

	public boolean getSoundWanted()
		{
		return (m[FLAGS2 + 1] & 0x80) != 0;
		}

	public void setScreenHeightUnits(int value)
		{
		m[SCREEN_HEIGHT_UNITS] = (byte)(value >> 8);
		m[SCREEN_HEIGHT_UNITS + 1] = (byte)(value & 0xFF);
		}

	public void setScreenWidthUnits(int value)
		{
		m[SCREEN_WIDTH_UNITS] = (byte)(value >> 8);
		m[SCREEN_WIDTH_UNITS + 1] = (byte)(value & 0xFF);
		}

	public void setFontHeightUnits(int value)
		{
		m[FONT_HEIGHT_UNITS] = (byte)value;
		}

	public void setFontWidthUnits(int value)
		{
		m[FONT_WIDTH_UNITS] = (byte)value;
		}

	public int getDefaultBackgroundColor()
		{
		return m[DEFAULT_BACKGROUND_COLOR];
		}

	public void setDefaultBackgroundColor(int value)
		{
		m[DEFAULT_BACKGROUND_COLOR] = (byte)value;
		}

	public int getDefaultForegroundColor()
		{
		return m[DEFAULT_FOREGROUND_COLOR];
		}

	public void setDefaultForegroundColor(int value)
		{
		m[DEFAULT_FOREGROUND_COLOR] = (byte)value;
		}
	
	public int getTerminatorsBase()
		{
		return getWord(TERMINATORS_BASE);
		}
	
	private int getExtension(int n)
		{
		int base = getWord(EXTENSION_BASE); 
		if (base == 0)
			return 0;
		int len = getWord(base + EXTENSION_LEN);
		if (len < n)
			return 0;
		return getWord(base + n * 2);
		}
	
	private void setExtension(int n, int value)
		{
		int base = getWord(EXTENSION_BASE); 
		if (base == 0)
			return;
		int len = getWord(base + EXTENSION_LEN);
		if (len < n)
			return;
		m[base + n * 2] = (byte)((value >> 8) & 0xFF);
		m[base + n * 2 + 1] = (byte)(value & 0xFF);
		}
	
	public int getUnicodeBase() 
		{
		return getExtension(EXTENSION_UNICODEBASE);
		}
	
	public int getMouseClickX()
		{
		return getExtension(EXTENSION_MOUSEX);
		}
	
	public int getMouseClickY()
		{
		return getExtension(EXTENSION_MOUSEY);
		}
	
	public int getFileLength()
		{
		return getWord(FILE_LENGTH) * 4;
		}
	
	public void setMouseClick(int x, int y)
		{
		setExtension(EXTENSION_MOUSEX, x);
		setExtension(EXTENSION_MOUSEY, y);
		}
	}