package zpplet.header;

import zpplet.ZUserConfig;

// TODO: identify and handle peculiar Infocom cases

public class ZHeader
	{
	protected byte m[];

	protected final static int VERSION = 0x00;
	protected final static int FLAGS1 = 0x01;
	protected final static int RELEASE = 0x02;
	protected final static int HIGH_BASE = 0x04;
	protected final static int INITIAL_PC = 0x06;
	protected final static int DICTIONARY = 0x08;
	protected final static int OBJECT_TABLE = 0x0A;
	protected final static int GLOBAL_TABLE = 0x0C;
	protected final static int STATIC_BASE = 0x0E;
	protected final static int FLAGS2 = 0x10;
	protected final static int SERIAL_NUMBER = 0x12;
	protected final static int ABBREV_TABLE = 0x18;
	protected final static int FILE_LENGTH = 0x1A;
	protected final static int FILE_CHECKSUM = 0x1C;
	protected final static int STD_REVISION = 0x32;
	
	public final static int UNKNOWN = 0;
	public final static int BEYOND_ZORK = 1;
	public final static int SHERLOCK = 2;
	public final static int ZORK_ZERO = 3;
	public final static int SHOGUN = 4;
	public final static int ARTHUR = 5;
	public final static int JOURNEY = 6;
	public final static int LURKING_HORROR = 7;

    private static class Record
		{
    	Record(int story, int release, String serial)
		{
    		this.story = story;
    		this.release = release;
    		this.serial = serial;
		}
    	int story;
    	int release;
    	String serial;
        }
	
    private static Record records[] = {
    	new Record(SHERLOCK,  21, "871214"),
    	new Record(SHERLOCK,  26, "880127"),
    	new Record(BEYOND_ZORK,  47, "870915"),
    	new Record(BEYOND_ZORK,  49, "870917"),
    	new Record(BEYOND_ZORK,  51, "870923"),
    	new Record(BEYOND_ZORK,  57, "871221"),
    	new Record(ZORK_ZERO, 296, "881019"),
    	new Record(ZORK_ZERO, 366, "890323"),
    	new Record(ZORK_ZERO, 383, "890602"),
    	new Record(ZORK_ZERO, 393, "890714"),
    	new Record(SHOGUN, 292, "890314"),
    	new Record(SHOGUN, 295, "890321"),
    	new Record(SHOGUN, 311, "890510"),
    	new Record(SHOGUN, 322, "890706"),
    	new Record(ARTHUR,  54, "890606"),
    	new Record(ARTHUR,  63, "890622"),
    	new Record(ARTHUR,  74, "890714"),
    	new Record(JOURNEY,  26, "890316"),
    	new Record(JOURNEY,  30, "890322"),
    	new Record(JOURNEY,  77, "890616"),
    	new Record(JOURNEY,  83, "890706"),
    	new Record(LURKING_HORROR, 203, "870506"),
    	new Record(LURKING_HORROR, 219, "870912"),
    	new Record(LURKING_HORROR, 221, "870918")
        };

    // special case information
    public int story;
    public boolean newlineatstart;
        
	public ZHeader(byte[] m)
		{
		this.m = m;
	    story = UNKNOWN;
		for (int i = 0; i < records.length; i++)
			if (getRelease() == records[i].release)
				{
				String serial = new String(getSerialNumber());
				if (serial.equals(records[i].serial))
					{
					story = records[i].story;
					break;
					}
				}
			
		newlineatstart = (ZUserConfig.interpreter != ZUserConfig.INTERP_MSDOS) || 
			(story != ZHeader.ZORK_ZERO) || (getRelease() != 393);
		}
	
	public boolean wantsMedia()
		{
		return ((m[0x11] & 0x88) != 0) || (story == LURKING_HORROR);
		}
	
	public boolean useAmigaScreenModel() // TODO: apply amiga screen model
		{
		if (ZUserConfig.interpreter == ZUserConfig.INTERP_AMIGA)
			switch (story)
				{
				case ZHeader.BEYOND_ZORK:
				case ZHeader.ZORK_ZERO:
				case ZHeader.SHOGUN:
				case ZHeader.ARTHUR:
				case ZHeader.JOURNEY:
					return true;
				}
		return false;
		}
	
	public int getVersion()
		{
		return m[VERSION] & 0xFF;
		}

	public static int getImageVersion(byte[] m)
		{
		return m[VERSION] & 0xFF;
		}

	public int getHighBase()
		{
		return getWord(HIGH_BASE);
		}

	public int getInitialPC()
		{
		return getWord(INITIAL_PC);
		}

	public int getDictionaryAddr()
		{
		return getWord(DICTIONARY);
		}

	public int getObjectTableAddr()
		{
		return getWord(OBJECT_TABLE);
		}

	public int getGlobalTableAddr()
		{
		return getWord(GLOBAL_TABLE);
		}

	public int getStaticBase()
		{
		return getWord(STATIC_BASE);
		}

	public boolean getTranscripting()
		{
		return ((m[FLAGS2 + 1] & 1) == 1);
		}

	public void setTranscripting(boolean value)
		{
		if (value)
			m[FLAGS2 + 1] |= 1;
		else
			m[FLAGS2 + 1] &= ~1;
		}

	public byte[] getSerialNumber()
		{
		byte[] result = new byte[6];
		System.arraycopy(m, SERIAL_NUMBER, result, 0, 6);
		return result;
		}

	public int getAbbrevTableAddr()
		{
		return getWord(ABBREV_TABLE);
		}

	public void setRevision(int major, int minor)
		{
		m[STD_REVISION] = (byte)major;
		m[STD_REVISION + 1] = (byte)minor;
		}

	public int getRelease()
		{
		return getWord(RELEASE);
		}

	public int getChecksum()
		{
		return getWord(FILE_CHECKSUM);
		}

	public int getFileLength()
		{
		return getWord(FILE_LENGTH) * 2;
		}

	protected int getWord(int addr)
		{
		return ((m[addr] << 8) & 0xFF00) | (m[addr + 1] & 0xFF);
		}

	public void setStatusUnavailable(boolean value)
		{
		if (value)
			m[FLAGS1] |= (1 << 4);
		else
			m[FLAGS1] &= ~(1 << 4);
		}

	public void setSplittingAvailable(boolean value)
		{
		if (value)
			m[FLAGS1] |= (1 << 5);
		else
			m[FLAGS1] &= ~(1 << 5);
		}

	public void setVariableDefault(boolean value)
		{
		if (value)
			m[FLAGS1] |= (1 << 6);
		else
			m[FLAGS1] &= ~(1 << 6);
		}

	public boolean isTimeGame() // as opposed to score game
		{
		return false;
		}
	}
