/*
 * Created on Dec 10, 2004 NOTE: add credits, license, etc.
 * TODO: Make Zpplet work (vs. Zpplication)
 */
package zpplet;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.*;

import zpplet.machine.ZMachine;
import zpplet.system.ZScreen;

/**
 * @author Michael Hainze
 */
public final class Zpplet
		extends JApplet
	{

	private javax.swing.JPanel jContentPane = null;

	private ZScreen zScreen = null;
	private ZMachine zm = null;

	/**
	 * This is the default constructor
	 */
	public Zpplet()
		{
		super();
		init();
		}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	public void init()
		{
		this.setSize(400, 300);
		this.setContentPane(getJContentPane());
		}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane()
		{
		if (jContentPane == null)
			{
			jContentPane = new javax.swing.JPanel();
			jContentPane.setLayout(new java.awt.BorderLayout());
			jContentPane.add(getZScreen(), java.awt.BorderLayout.CENTER);
			}
		return jContentPane;
		}

	/**
	 * This method initializes zScreen
	 * 
	 * @return zpplet.screen.ZScreen
	 */
	private ZScreen getZScreen()
		{
		if (zScreen == null)
			{
			zScreen = new ZScreen();
			}
		return zScreen;
		}

	byte[] getStream(InputStream s)
			throws IOException
		{
		byte[] buffer;
		byte[] oldbuffer;
		int currentbytes = 0;
		int bytesleft;
		int got;
		int buffersize = 2048;

		buffer = new byte[buffersize];
		bytesleft = buffersize;
		got = 0;
		while (got != -1)
			{
			bytesleft -= got;
			currentbytes += got;
			if (bytesleft == 0)
				{
				oldbuffer = buffer;
				buffer = new byte[buffersize + currentbytes];
				System.arraycopy(oldbuffer, 0, buffer, 0, currentbytes);
				oldbuffer = null;
				bytesleft = buffersize;
				}
			got = s.read(buffer, currentbytes, bytesleft);
			}
		if (buffer.length != currentbytes)
			{
			oldbuffer = buffer;
			buffer = new byte[currentbytes];
			System.arraycopy(oldbuffer, 0, buffer, 0, currentbytes);
			}
		return buffer;
		}

	void startz(String codefile)
		{
		URL url;
		InputStream ins;

		byte[] image = null;

		try
			{
			url = new URL(codefile);
			ins = url.openStream();
			image = getStream(ins);
			}
		catch (MalformedURLException e)
			{
			try
				{
				ins = new FileInputStream(codefile);
				image = getStream(ins);
				}
			catch (IOException e2)
				{
				JOptionPane.showMessageDialog(this, "Bad URL or filename", null, JOptionPane.ERROR);
				}
			}
		catch (IOException e)
			{
			JOptionPane.showMessageDialog(this, "I/O Error", null, JOptionPane.ERROR);
			}

		if (image == null) return;

		try
			{
			if (zm != null)
				{
				zm.kill();
				zm.join();
				}
			zm = ZMachine.NewZMachine(image, zScreen);
/*			if (zm.media == null)
				lookForBlorb(codefile);
			setTitle("Zpplet - " + codefile);
			if (smallFontRadioButtonMenuItem.isSelected())
				ZUserConfig.fontsize = 12;
			else if (regularFontRadioButtonMenuItem.isSelected())
				ZUserConfig.fontsize = 16;
			else if (largeFontRadioButtonMenuItem.isSelected())
				ZUserConfig.fontsize = 20;
			else if (xlargeFontRadioButtonMenuItem.isSelected()) ZUserConfig.fontsize = 24;
*/			zm.start();
			}
		catch (Exception e)
			{
			if (e.getMessage() != null)
				{
				e.printStackTrace();
				JOptionPane.showMessageDialog(this, e.getMessage(), null, JOptionPane.ERROR_MESSAGE);
				}
			}
		}


	public void start()
		{
		//if ((zm == null) || !zm.isAlive()) startzm();
		}

	public void destroy()
		{
		if (zm != null) zm.kill();
		zm = null;
		remove(zScreen);
		zScreen = null;
		}
	}