// zeal - A portable Glk-based Z-code interpreter
// Copyright (C) 2000 Jeremy Condit <jcondit@eecs.harvard.edu>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// =======================================================================
//  mac.cc:
//
//  this module contains support for mac-specific glk features.
//  it creates an osdep structure and places it in the global os variable
//  for glk_main to find.
//
//  thanks to andrew plotkin for contributing this code.  (minor tweaks
//  made by jeremy condit.)
// =======================================================================

#include "zeal.h"
#include "osdep.h"

extern "C" {
// include file from the macglk library
#include "macglk_startup.h"
}

extern osdep* os;

// =======================================================================
//  mac
// =======================================================================

class mac : public osdep {
    public:
        mac(int strictz_in, macglk_startup_t *data);
        virtual ~mac();

        virtual unsigned long get_seed();
        virtual strid_t get_story();
        virtual void close_story();
        virtual uint get_strictz();
        virtual bool debug();
        virtual void debug_msg(const char* format, ...);

    private:
        strid_t story_stream;
        uint strictz;
};

// constructor
//
// set up the library to open the appropriate streams.

mac::mac(int strictz_in, macglk_startup_t *data)
  : strictz(strictz_in)
{
    static OSType gamefile_type = 'ZCOD';

    data->app_creator = 'gZl';
    data->startup_model = macglk_model_ChooseOrBuiltIn;
    data->gamefile_types = &gamefile_type;
    data->savefile_type = 'IFZS';
    data->datafile_type = 'ZipD';
    data->num_gamefile_types = 1;
    data->gamefile = &story_stream;
}

// destructor
//
// nothing to do.

mac::~mac()
{
}

// get_seed
//
// seed the random number generator using the current time.

unsigned long
mac::get_seed()
{
    return TickCount();
}

// get_story
//
// get the current story file.

strid_t
mac::get_story()
{
    return story_stream;
}

// close_story
//
// no reason to keep this file open the whole time.  well, actually, in
// MacGlk that may be hairy, since the library could be the one to open it.
// I don't feel like figuring out whether it's safe.

void
mac::close_story()
{
}

// get_strictz
//
// get the strictz setting specified by the user.

uint
mac::get_strictz()
{
    return strictz;
}

// debug
//
// are we sending output to the debug file?

bool
mac::debug()
{
    return false;
}

// debug_msg
//
// send a message to the debug log.

void
mac::debug_msg(const char* format, ...)
{
}

// macglk_startup_code
//
// pass the macglk data struct to the osdep constructor so that its fields
// can be filled out with osdep private data.

Boolean
macglk_startup_code(macglk_startup_t *data)
{
    os = new mac(0, data);
    // no MEMCHECK necessary
    
    return TRUE;
}
