/**
 * Copyright (c) 2008 Matthew E. Kimmel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/* Modified 2008 by William H. Johnson for ZaxMidlet 
 * 
 */

package zmachine;

import java.io.*;

import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

class ZMemory extends Object {
    private ZUserInterface zui;
    byte[] data;
    int dataLength;

    // The initialize routine sets things up and loads a game
    // into memory.  It is passed the ZUserInterface object
    // for this ZMachine and the filename of the story-file.
    void initialize(ZUserInterface ui,String storyFile)
    {
//        File f;
//        FileInputStream fis;
//        DataInputStream dis;
		InputStream fis;
		DataInputStream dis;
		FileConnection fc;

        
        
        zui = ui;

        // Read in the story file
        try {
    	    fc = (FileConnection)Connector.open(storyFile);
            if((!fc.exists()) || (!fc.canRead()) )
                zui.fatal("Storyfile " + storyFile + " not found.");
            dataLength = (int)fc.fileSize();
            //dataLength = (int)fc.length();
            data = new byte[dataLength];
//            fis = new FileInputStream(f);
//            dis = new DataInputStream(fis);
		    dis = fc.openDataInputStream();		
            dis.readFully(data,0,dataLength);
//            fis.close();
			dis.close();
			fc.close();
        
        }
        catch (IOException ioex) {
            zui.fatal("I/O error loading storyfile.");
        }
    }


    // Fetch a byte from the specified address
    int fetchByte(int addr)
    {
 //       System.out.println("Fetch Byte: addr = " + addr);

    	if (addr > (dataLength - 1))
            zui.fatal("Memory fault: address " + addr);
        if (addr < 0) // Kludge, SUSPECT wait - yes, yes, produces a read to addr -1,  Probably a more serious problem
            return 0;
        	//zui.fatal("Memory fault: address " + addr);
        int i = (data[addr] & 0xff);
        return i;
    }

    // Store a byte at the specified address
    void putByte(int addr,int b)
    {
        if (addr > (dataLength - 1))
            zui.fatal("Memory fault: address " + addr);
        data[addr] = (byte)(b & 0xff);
    }

    // Fetch a word from the specified address
    int fetchWord(int addr)
    {
        int i;
        if (addr > (dataLength - 1))
            zui.fatal("Memory fault: address " + addr);
        if (addr < 0) // Kludge, SUSPECT wait - yes, yes, produces a FetchByte to addr -1,  Probably a more serious problem
            return 0;
        i = (((data[addr] << 8) | (data[addr+1] & 0xff)) & 0xffff);
        return i;
    }

    // Store a word at the specified address
    void putWord(int addr,int w)
    {
        if (addr > (dataLength - 1))
            zui.fatal("Memory fault: address " + addr);
        data[addr] = (byte)((w >> 8) & 0xff);
        data[addr+1] = (byte)(w & 0xff);
    }

	// Dump the specified amount of memory, starting at the specified address,
	// to the specified DataOutputStream.
	void dumpMemory(DataOutputStream dos,int addr,int len) throws IOException
	{
		dos.write(data,addr,len);
	}

	// Read in memory stored by dumpMemory.
	void readMemory(DataInputStream dis,int addr,int len) throws IOException
	{
		dis.read(data,addr,len);
	}
}
