/*
 * Decompiled with CFR 0.152.
 */
package terminal;

import terminal.Terminal;

public abstract class VT320 {
    public static final int VK_ENTER = 10;
    public static final int VK_BACK_SPACE = 8;
    public static final int VK_TAB = 9;
    public static final int VK_CANCEL = 3;
    public static final int VK_CLEAR = 12;
    public static final int VK_SHIFT = 16;
    public static final int VK_CONTROL = 17;
    public static final int VK_ALT = 18;
    public static final int VK_PAUSE = 19;
    public static final int VK_CAPS_LOCK = 20;
    public static final int VK_ESCAPE = 27;
    public static final int VK_SPACE = 32;
    public static final int VK_PAGE_UP = 33;
    public static final int VK_PAGE_DOWN = 34;
    public static final int VK_END = 35;
    public static final int VK_HOME = 36;
    public static final int VK_LEFT = 37;
    public static final int VK_UP = 38;
    public static final int VK_RIGHT = 39;
    public static final int VK_DOWN = 40;
    public static final int VK_COMMA = 44;
    public static final int VK_MINUS = 45;
    public static final int VK_PERIOD = 46;
    public static final int VK_SLASH = 47;
    public static final int VK_0 = 48;
    public static final int VK_1 = 49;
    public static final int VK_2 = 50;
    public static final int VK_3 = 51;
    public static final int VK_4 = 52;
    public static final int VK_5 = 53;
    public static final int VK_6 = 54;
    public static final int VK_7 = 55;
    public static final int VK_8 = 56;
    public static final int VK_9 = 57;
    public static final int VK_SEMICOLON = 59;
    public static final int VK_EQUALS = 61;
    public static final int VK_A = 65;
    public static final int VK_B = 66;
    public static final int VK_C = 67;
    public static final int VK_D = 68;
    public static final int VK_E = 69;
    public static final int VK_F = 70;
    public static final int VK_G = 71;
    public static final int VK_H = 72;
    public static final int VK_I = 73;
    public static final int VK_J = 74;
    public static final int VK_K = 75;
    public static final int VK_L = 76;
    public static final int VK_M = 77;
    public static final int VK_N = 78;
    public static final int VK_O = 79;
    public static final int VK_P = 80;
    public static final int VK_Q = 81;
    public static final int VK_R = 82;
    public static final int VK_S = 83;
    public static final int VK_T = 84;
    public static final int VK_U = 85;
    public static final int VK_V = 86;
    public static final int VK_W = 87;
    public static final int VK_X = 88;
    public static final int VK_Y = 89;
    public static final int VK_Z = 90;
    public static final int VK_OPEN_BRACKET = 91;
    public static final int VK_BACK_SLASH = 92;
    public static final int VK_CLOSE_BRACKET = 93;
    public static final int VK_NUMPAD0 = 96;
    public static final int VK_NUMPAD1 = 97;
    public static final int VK_NUMPAD2 = 98;
    public static final int VK_NUMPAD3 = 99;
    public static final int VK_NUMPAD4 = 100;
    public static final int VK_NUMPAD5 = 101;
    public static final int VK_NUMPAD6 = 102;
    public static final int VK_NUMPAD7 = 103;
    public static final int VK_NUMPAD8 = 104;
    public static final int VK_NUMPAD9 = 105;
    public static final int VK_MULTIPLY = 106;
    public static final int VK_ADD = 107;
    public static final int VK_SEPARATER = 108;
    public static final int VK_SEPARATOR = 108;
    public static final int VK_SUBTRACT = 109;
    public static final int VK_DECIMAL = 110;
    public static final int VK_DIVIDE = 111;
    public static final int VK_DELETE = 127;
    public static final int VK_NUM_LOCK = 144;
    public static final int VK_SCROLL_LOCK = 145;
    public static final int VK_F1 = 112;
    public static final int VK_F2 = 113;
    public static final int VK_F3 = 114;
    public static final int VK_F4 = 115;
    public static final int VK_F5 = 116;
    public static final int VK_F6 = 117;
    public static final int VK_F7 = 118;
    public static final int VK_F8 = 119;
    public static final int VK_F9 = 120;
    public static final int VK_F10 = 121;
    public static final int VK_F11 = 122;
    public static final int VK_F12 = 123;
    public static final int VK_INSERT = 155;
    public static final int KEY_CONTROL = 1;
    public static final int KEY_SHIFT = 2;
    public static final int KEY_ALT = 4;
    public static final int KEY_ACTION = 8;
    public int keypressed = 1;
    public int rows_counted = 0;
    private int writeBufferIndex = 0;
    private byte[] writeBuffer = new byte[128];
    public boolean localecho = true;
    private byte[] stringConversionBuffer = new byte[10];
    private String terminalID = "vt320";
    public int R;
    public int C;
    int attributes = 0;
    int Sc;
    int Sr;
    int Sa;
    int Stm;
    int Sbm;
    char Sgr;
    char Sgl;
    char[] Sgx;
    int insertmode = 0;
    int statusmode = 0;
    boolean vt52mode = false;
    boolean keypadmode = false;
    boolean output8bit = false;
    int normalcursor = 0;
    boolean moveoutsidemargins = true;
    boolean wraparound = true;
    boolean sendcrlf = true;
    boolean capslock = false;
    boolean numlock = false;
    int mouserpt = 0;
    byte mousebut = 0;
    boolean useibmcharset = false;
    int lastwaslf = 0;
    boolean usedcharsets = false;
    private static final char ESC = '\u001b';
    private static final char IND = '\u0084';
    private static final char NEL = '\u0085';
    private static final char RI = '\u008d';
    private static final char SS2 = '\u008e';
    private static final char SS3 = '\u008f';
    private static final char DCS = '\u0090';
    private static final char HTS = '\u0088';
    private static final char CSI = '\u009b';
    private static final char OSC = '\u009d';
    private static final int TSTATE_DATA = 0;
    private static final int TSTATE_ESC = 1;
    private static final int TSTATE_CSI = 2;
    private static final int TSTATE_DCS = 3;
    private static final int TSTATE_DCEQ = 4;
    private static final int TSTATE_ESCSQUARE = 5;
    private static final int TSTATE_OSC = 6;
    private static final int TSTATE_SETG0 = 7;
    private static final int TSTATE_SETG1 = 8;
    private static final int TSTATE_SETG2 = 9;
    private static final int TSTATE_SETG3 = 10;
    private static final int TSTATE_CSI_DOLLAR = 11;
    private static final int TSTATE_CSI_EX = 12;
    private static final int TSTATE_ESCSPACE = 13;
    private static final int TSTATE_VT52X = 14;
    private static final int TSTATE_VT52Y = 15;
    private static final int TSTATE_CSI_TICKS = 16;
    char[] gx = new char[]{'B', '0', 'B', 'B'};
    char gl = '\u0000';
    char gr = (char)2;
    int onegl = -1;
    private static final String scoansi_acs = "Tm7k3x4u?kZl@mYjEnB\u2566DqCtAvM\u2550:\u2551N\u2557I\u2554;\u2557H\u255a0a<\u255d";
    private static char[] DECSPECIAL = new char[]{'@', '\u2666', '\u2592', '\u2409', '\u240c', '\u240d', '\u240a', '\u00ba', '\u00b1', '\u2424', '\u240b', '\u2518', '\u2510', '\u250c', '\u2514', '\u253c', '\u2594', '\u2580', '\u2500', '\u25ac', '_', '\u251c', '\u2524', '\u2534', '\u252c', '\u2502', '\u2264', '\u2265', '\u00b6', '\u2260', '\u00a3', '\u00b7'};
    private String[] FunctionKey;
    private String[] Numpad;
    private String[] FunctionKeyShift;
    private String[] FunctionKeyCtrl;
    private String[] FunctionKeyAlt;
    private String[] TabKey;
    private String[] KeyUp;
    private String[] KeyDown;
    private String[] KeyLeft;
    private String[] KeyRight;
    private String PF1;
    private String PF2;
    private String PF3;
    private String PF4;
    private String KPMinus;
    private String KPComma;
    private String KPPeriod;
    private String KPEnter;
    private String Help;
    private String Do;
    private String Find;
    private String Select;
    private String[] Remove;
    private String[] Insert;
    private String[] KeyHome;
    private String[] KeyEnd;
    private String[] PrevScn;
    private String[] NextScn;
    private String[] Escape;
    private String[] BackSpace;
    private String[] NUMDot;
    private String[] NUMPlus;
    private String osc;
    private String dcs;
    private int term_state = 0;
    private boolean vms = false;
    private byte[] Tabs;
    private int[] DCEvars = new int[30];
    private int DCEvar;
    private static final char[] unimap;
    public int height;
    public int width;
    public boolean[] update;
    public char[][] charArray;
    public int[][] charAttributes;
    public int bufSize;
    public int maxBufSize;
    public int screenBase;
    public int windowBase;
    public int scrollMarker;
    private int topMargin;
    private int bottomMargin;
    protected boolean showcursor = true;
    protected int cursorX;
    protected int cursorY;
    public static final boolean SCROLL_UP = false;
    public static final boolean SCROLL_DOWN = true;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int UNDERLINE = 2;
    public static final int INVERT = 4;
    public static final int LOW = 8;
    public static final int COLOR = 4080;
    public static final int COLOR_FG = 240;
    public static final int COLOR_BG = 3840;
    protected Terminal display;

    static {
        char[] cArray = new char[256];
        cArray[1] = '\u0001';
        cArray[2] = 2;
        cArray[3] = 3;
        cArray[4] = 4;
        cArray[5] = 5;
        cArray[6] = 6;
        cArray[7] = 7;
        cArray[8] = 8;
        cArray[9] = 9;
        cArray[10] = 10;
        cArray[11] = 11;
        cArray[12] = 12;
        cArray[13] = 13;
        cArray[14] = 14;
        cArray[15] = 15;
        cArray[16] = 16;
        cArray[17] = 17;
        cArray[18] = 18;
        cArray[19] = 19;
        cArray[20] = 20;
        cArray[21] = 21;
        cArray[22] = 22;
        cArray[23] = 23;
        cArray[24] = 24;
        cArray[25] = 25;
        cArray[26] = 26;
        cArray[27] = 27;
        cArray[28] = 28;
        cArray[29] = 29;
        cArray[30] = 30;
        cArray[31] = 31;
        cArray[32] = 32;
        cArray[33] = 33;
        cArray[34] = 34;
        cArray[35] = 35;
        cArray[36] = 36;
        cArray[37] = 37;
        cArray[38] = 38;
        cArray[39] = 39;
        cArray[40] = 40;
        cArray[41] = 41;
        cArray[42] = 42;
        cArray[43] = 43;
        cArray[44] = 44;
        cArray[45] = 45;
        cArray[46] = 46;
        cArray[47] = 47;
        cArray[48] = 48;
        cArray[49] = 49;
        cArray[50] = 50;
        cArray[51] = 51;
        cArray[52] = 52;
        cArray[53] = 53;
        cArray[54] = 54;
        cArray[55] = 55;
        cArray[56] = 56;
        cArray[57] = 57;
        cArray[58] = 58;
        cArray[59] = 59;
        cArray[60] = 60;
        cArray[61] = 61;
        cArray[62] = 62;
        cArray[63] = 63;
        cArray[64] = 64;
        cArray[65] = 65;
        cArray[66] = 66;
        cArray[67] = 67;
        cArray[68] = 68;
        cArray[69] = 69;
        cArray[70] = 70;
        cArray[71] = 71;
        cArray[72] = 72;
        cArray[73] = 73;
        cArray[74] = 74;
        cArray[75] = 75;
        cArray[76] = 76;
        cArray[77] = 77;
        cArray[78] = 78;
        cArray[79] = 79;
        cArray[80] = 80;
        cArray[81] = 81;
        cArray[82] = 82;
        cArray[83] = 83;
        cArray[84] = 84;
        cArray[85] = 85;
        cArray[86] = 86;
        cArray[87] = 87;
        cArray[88] = 88;
        cArray[89] = 89;
        cArray[90] = 90;
        cArray[91] = 91;
        cArray[92] = 92;
        cArray[93] = 93;
        cArray[94] = 94;
        cArray[95] = 95;
        cArray[96] = 96;
        cArray[97] = 97;
        cArray[98] = 98;
        cArray[99] = 99;
        cArray[100] = 100;
        cArray[101] = 101;
        cArray[102] = 102;
        cArray[103] = 103;
        cArray[104] = 104;
        cArray[105] = 105;
        cArray[106] = 106;
        cArray[107] = 107;
        cArray[108] = 108;
        cArray[109] = 109;
        cArray[110] = 110;
        cArray[111] = 111;
        cArray[112] = 112;
        cArray[113] = 113;
        cArray[114] = 114;
        cArray[115] = 115;
        cArray[116] = 116;
        cArray[117] = 117;
        cArray[118] = 118;
        cArray[119] = 119;
        cArray[120] = 120;
        cArray[121] = 121;
        cArray[122] = 122;
        cArray[123] = 123;
        cArray[124] = 124;
        cArray[125] = 125;
        cArray[126] = 126;
        cArray[127] = 127;
        cArray[128] = 199;
        cArray[129] = 252;
        cArray[130] = 233;
        cArray[131] = 226;
        cArray[132] = 228;
        cArray[133] = 224;
        cArray[134] = 229;
        cArray[135] = 231;
        cArray[136] = 234;
        cArray[137] = 235;
        cArray[138] = 232;
        cArray[139] = 239;
        cArray[140] = 238;
        cArray[141] = 236;
        cArray[142] = 196;
        cArray[143] = 197;
        cArray[144] = 201;
        cArray[145] = 230;
        cArray[146] = 198;
        cArray[147] = 244;
        cArray[148] = 246;
        cArray[149] = 242;
        cArray[150] = 251;
        cArray[151] = 249;
        cArray[152] = 255;
        cArray[153] = 214;
        cArray[154] = 220;
        cArray[155] = 162;
        cArray[156] = 163;
        cArray[157] = 165;
        cArray[158] = 8359;
        cArray[159] = 402;
        cArray[160] = 225;
        cArray[161] = 237;
        cArray[162] = 243;
        cArray[163] = 250;
        cArray[164] = 241;
        cArray[165] = 209;
        cArray[166] = 170;
        cArray[167] = 186;
        cArray[168] = 191;
        cArray[169] = 8976;
        cArray[170] = 172;
        cArray[171] = 189;
        cArray[172] = 188;
        cArray[173] = 161;
        cArray[174] = 171;
        cArray[175] = 187;
        cArray[176] = 9617;
        cArray[177] = 9618;
        cArray[178] = 9619;
        cArray[179] = 9474;
        cArray[180] = 9508;
        cArray[181] = 9569;
        cArray[182] = 9570;
        cArray[183] = 9558;
        cArray[184] = 9557;
        cArray[185] = 9571;
        cArray[186] = 9553;
        cArray[187] = 9559;
        cArray[188] = 9565;
        cArray[189] = 9564;
        cArray[190] = 9563;
        cArray[191] = 9488;
        cArray[192] = 9492;
        cArray[193] = 9524;
        cArray[194] = 9516;
        cArray[195] = 9500;
        cArray[196] = 9472;
        cArray[197] = 9532;
        cArray[198] = 9566;
        cArray[199] = 9567;
        cArray[200] = 9562;
        cArray[201] = 9556;
        cArray[202] = 9577;
        cArray[203] = 9574;
        cArray[204] = 9568;
        cArray[205] = 9552;
        cArray[206] = 9580;
        cArray[207] = 9575;
        cArray[208] = 9576;
        cArray[209] = 9572;
        cArray[210] = 9573;
        cArray[211] = 9561;
        cArray[212] = 9560;
        cArray[213] = 9554;
        cArray[214] = 9555;
        cArray[215] = 9579;
        cArray[216] = 9578;
        cArray[217] = 9496;
        cArray[218] = 9484;
        cArray[219] = 9608;
        cArray[220] = 9604;
        cArray[221] = 9612;
        cArray[222] = 9616;
        cArray[223] = 9600;
        cArray[224] = 945;
        cArray[225] = 223;
        cArray[226] = 915;
        cArray[227] = 960;
        cArray[228] = 931;
        cArray[229] = 963;
        cArray[230] = 181;
        cArray[231] = 964;
        cArray[232] = 934;
        cArray[233] = 920;
        cArray[234] = 937;
        cArray[235] = 948;
        cArray[236] = 8734;
        cArray[237] = 966;
        cArray[238] = 949;
        cArray[239] = 8745;
        cArray[240] = 8801;
        cArray[241] = 177;
        cArray[242] = 8805;
        cArray[243] = 8804;
        cArray[244] = 8992;
        cArray[245] = 8993;
        cArray[246] = 247;
        cArray[247] = 8776;
        cArray[248] = 176;
        cArray[249] = 8729;
        cArray[250] = 183;
        cArray[251] = 8730;
        cArray[252] = 8319;
        cArray[253] = 178;
        cArray[254] = 9632;
        cArray[255] = 160;
        unimap = cArray;
    }

    public VT320(int width, int height) {
        this.setScreenSize(width, height);
        this.setVMS(false);
        this.setIBMCharset(false);
        this.setBufferSize(height);
        int nw = width;
        if (nw < 132) {
            nw = 132;
        }
        this.Tabs = new byte[nw];
        int i = 0;
        while (i < nw) {
            this.Tabs[i] = 1;
            i += 8;
        }
        this.PF1 = "\u001bOP";
        this.PF2 = "\u001bOQ";
        this.PF3 = "\u001bOR";
        this.PF4 = "\u001bOS";
        this.Remove = new String[4];
        this.Insert = new String[4];
        this.KeyHome = new String[4];
        this.KeyEnd = new String[4];
        this.NextScn = new String[4];
        this.PrevScn = new String[4];
        this.Escape = new String[4];
        this.BackSpace = new String[4];
        this.TabKey = new String[4];
        this.Remove[3] = "\u001b[3~";
        this.Remove[2] = "\u001b[3~";
        this.Remove[1] = "\u001b[3~";
        this.Remove[0] = "\u001b[3~";
        this.Insert[3] = "\u001b[2~";
        this.Insert[2] = "\u001b[2~";
        this.Insert[1] = "\u001b[2~";
        this.Insert[0] = "\u001b[2~";
        this.KeyHome[3] = "\u001b[H";
        this.KeyHome[2] = "\u001b[H";
        this.KeyHome[1] = "\u001b[H";
        this.KeyHome[0] = "\u001b[H";
        this.KeyEnd[3] = "\u001b[F";
        this.KeyEnd[2] = "\u001b[F";
        this.KeyEnd[1] = "\u001b[F";
        this.KeyEnd[0] = "\u001b[F";
        this.PrevScn[3] = "\u001b[5~";
        this.PrevScn[2] = "\u001b[5~";
        this.PrevScn[1] = "\u001b[5~";
        this.PrevScn[0] = "\u001b[5~";
        this.NextScn[3] = "\u001b[6~";
        this.NextScn[2] = "\u001b[6~";
        this.NextScn[1] = "\u001b[6~";
        this.NextScn[0] = "\u001b[6~";
        this.Escape[3] = "\u001b";
        this.Escape[2] = "\u001b";
        this.Escape[1] = "\u001b";
        this.Escape[0] = "\u001b";
        if (this.vms) {
            this.BackSpace[1] = "\n";
            this.BackSpace[2] = "\u0018";
            this.BackSpace[3] = "\u007f";
            this.BackSpace[0] = "\u007f";
        } else {
            this.BackSpace[3] = "\b";
            this.BackSpace[2] = "\b";
            this.BackSpace[1] = "\b";
            this.BackSpace[0] = "\b";
        }
        this.FunctionKey = new String[21];
        this.FunctionKey[0] = "";
        this.FunctionKey[1] = this.PF1;
        this.FunctionKey[2] = this.PF2;
        this.FunctionKey[3] = this.PF3;
        this.FunctionKey[4] = this.PF4;
        this.FunctionKey[5] = "\u001b[15~";
        this.FunctionKey[6] = "\u001b[17~";
        this.FunctionKey[7] = "\u001b[18~";
        this.FunctionKey[8] = "\u001b[19~";
        this.FunctionKey[9] = "\u001b[20~";
        this.FunctionKey[10] = "\u001b[21~";
        this.FunctionKey[11] = "\u001b[23~";
        this.FunctionKey[12] = "\u001b[24~";
        this.FunctionKey[13] = "\u001b[25~";
        this.FunctionKey[14] = "\u001b[26~";
        this.FunctionKey[15] = this.Help;
        this.FunctionKey[16] = this.Do;
        this.FunctionKey[17] = "\u001b[31~";
        this.FunctionKey[18] = "\u001b[32~";
        this.FunctionKey[19] = "\u001b[33~";
        this.FunctionKey[20] = "\u001b[34~";
        this.Find = "\u001b[1~";
        this.Select = "\u001b[4~";
        this.Help = "\u001b[28~";
        this.Do = "\u001b[29~";
        this.FunctionKeyShift = new String[21];
        this.FunctionKeyAlt = new String[21];
        this.FunctionKeyCtrl = new String[21];
        i = 0;
        while (i < 20) {
            this.FunctionKeyShift[i] = "";
            this.FunctionKeyAlt[i] = "";
            this.FunctionKeyCtrl[i] = "";
            ++i;
        }
        this.FunctionKeyShift[15] = this.Find;
        this.FunctionKeyShift[16] = this.Select;
        this.TabKey[0] = "\t";
        this.TabKey[1] = "\u001bOP\t";
        this.TabKey[3] = "";
        this.TabKey[2] = "";
        this.KeyUp = new String[4];
        this.KeyUp[0] = "\u001b[A";
        this.KeyDown = new String[4];
        this.KeyDown[0] = "\u001b[B";
        this.KeyRight = new String[4];
        this.KeyRight[0] = "\u001b[C";
        this.KeyLeft = new String[4];
        this.KeyLeft[0] = "\u001b[D";
        this.Numpad = new String[10];
        this.Numpad[0] = "\u001bOp";
        this.Numpad[1] = "\u001bOq";
        this.Numpad[2] = "\u001bOr";
        this.Numpad[3] = "\u001bOs";
        this.Numpad[4] = "\u001bOt";
        this.Numpad[5] = "\u001bOu";
        this.Numpad[6] = "\u001bOv";
        this.Numpad[7] = "\u001bOw";
        this.Numpad[8] = "\u001bOx";
        this.Numpad[9] = "\u001bOy";
        this.KPMinus = this.PF4;
        this.KPComma = "\u001bOl";
        this.KPPeriod = "\u001bOn";
        this.KPEnter = "\u001bOM";
        this.NUMPlus = new String[4];
        this.NUMPlus[0] = "+";
        this.NUMDot = new String[4];
        this.NUMDot[0] = ".";
    }

    public VT320() {
        this(80, 24);
    }

    protected void write(byte[] b, int offset, int length) {
    }

    protected void flush() {
    }

    public void beep() {
    }

    public void putString(String s) {
        int len = s.length();
        if (len > 0) {
            this.markLine(this.R, 1);
            int i = 0;
            while (i < len) {
                if (this.rows_counted >= this.height - this.topMargin - 1) {
                    this.rows_counted = 0;
                    this.keypressed = 0;
                    this.putString(0, this.height, "[MORE]", 4);
                    this.setCursorPosition(6, this.height);
                    while (this.keypressed == 0) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.putString(0, this.height, "      ", 0);
                    this.setCursorPosition(0, this.height);
                }
                this.putChar(s.charAt(i), false);
                if (s.charAt(i) == '\n') {
                    this.putChar('\r', false);
                    ++this.rows_counted;
                }
                ++i;
            }
            this.setCursorPosition(this.C, this.R);
            this.redraw();
        }
    }

    public void putStringUpper(String s) {
        int len = s.length();
        if (len > 0) {
            this.markLine(this.R, 1);
            int i = 0;
            while (i < len) {
                this.putChar(s.charAt(i), false);
                if (s.charAt(i) == '\n') {
                    this.putChar('\r', false);
                }
                ++i;
            }
            this.setCursorPosition(this.C, this.R);
            this.redraw();
        }
    }

    protected void sendTelnetCommand(byte cmd) {
    }

    public void setLocalEcho(boolean echo) {
        this.localecho = echo;
    }

    public void setVMS(boolean vms) {
        this.vms = vms;
    }

    public void setIBMCharset(boolean ibm) {
        this.useibmcharset = ibm;
    }

    public void setTerminalID(String terminalID) {
        this.terminalID = terminalID;
    }

    public String getTerminalID() {
        return this.terminalID;
    }

    private boolean write(String s, boolean doecho) {
        if (doecho) {
            this.putStringUpper(s);
        }
        return true;
    }

    private boolean write(String s) {
        return this.write(s, this.localecho);
    }

    /*
     * Unable to fully structure code
     */
    static String unEscape(String tmp) {
        idx = 0;
        oldidx = 0;
        cmd = "";
        if (true) ** GOTO lbl43
        do {
            cmd = String.valueOf(cmd) + tmp.substring(oldidx, idx - 1);
            if (idx == tmp.length()) {
                return cmd;
            }
            switch (tmp.charAt(idx)) {
                case 'b': {
                    cmd = String.valueOf(cmd) + "\b";
                    break;
                }
                case 'e': {
                    cmd = String.valueOf(cmd) + "\u001b";
                    break;
                }
                case 'n': {
                    cmd = String.valueOf(cmd) + "\n";
                    break;
                }
                case 'r': {
                    cmd = String.valueOf(cmd) + "\r";
                    break;
                }
                case 't': {
                    cmd = String.valueOf(cmd) + "\t";
                    break;
                }
                case 'v': {
                    cmd = String.valueOf(cmd) + "\u000b";
                    break;
                }
                case 'a': {
                    cmd = String.valueOf(cmd) + "\u0012";
                    break;
                }
                default: {
                    if (tmp.charAt(idx) >= '0' && tmp.charAt(idx) <= '9') {
                        i = idx;
                        while (i < tmp.length()) {
                            if (tmp.charAt(i) < '0' || tmp.charAt(i) > '9') break;
                            ++i;
                        }
                        cmd = String.valueOf(cmd) + (char)Integer.parseInt(tmp.substring(idx, i));
                        idx = i - 1;
                        break;
                    }
                    cmd = String.valueOf(cmd) + tmp.substring(idx++, idx);
                }
            }
            oldidx = ++idx;
lbl43:
            // 2 sources

            idx = tmp.indexOf(92, oldidx);
        } while (idx >= 0 && ++idx <= tmp.length());
        if (oldidx <= tmp.length()) {
            cmd = String.valueOf(cmd) + tmp.substring(oldidx);
        }
        return cmd;
    }

    private boolean writeSpecial(String s) {
        if (s == null) {
            return true;
        }
        if (s.length() >= 3 && s.charAt(0) == '\u001b' && s.charAt(1) == 'O') {
            if (this.vt52mode) {
                s = s.charAt(2) >= 'P' && s.charAt(2) <= 'S' ? "\u001b" + s.substring(2) : "\u001b?" + s.substring(2);
            } else if (this.output8bit) {
                s = "\u008f" + s.substring(2);
            }
        }
        if (s.length() >= 3 && s.charAt(0) == '\u001b' && s.charAt(1) == '[' && this.output8bit) {
            s = "\u009b" + s.substring(2);
        }
        return this.write(s, false);
    }

    public void keyPressed(int keyCode, int modifiers) {
        boolean control = (modifiers & 1) != 0;
        boolean shift = (modifiers & 2) != 0;
        boolean alt = (modifiers & 4) != 0;
        int xind = 0;
        String[] fmap = this.FunctionKey;
        if (shift) {
            fmap = this.FunctionKeyShift;
            xind = 1;
        }
        if (control) {
            fmap = this.FunctionKeyCtrl;
            xind = 2;
        }
        if (alt) {
            fmap = this.FunctionKeyAlt;
            xind = 3;
        }
        if (shift) {
            xind = 1;
        }
        if (control) {
            xind = 2;
        }
        if (alt) {
            xind = 3;
        }
        if (keyCode >= 112 && keyCode <= 123) {
            this.writeSpecial(fmap[keyCode - 112 + 1]);
        } else {
            switch (keyCode) {
                case 19: {
                    if (!shift && !control) break;
                    this.sendTelnetCommand((byte)-13);
                    break;
                }
                case 38: {
                    this.writeSpecial(this.KeyUp[xind]);
                    break;
                }
                case 40: {
                    this.writeSpecial(this.KeyDown[xind]);
                    break;
                }
                case 37: {
                    this.writeSpecial(this.KeyLeft[xind]);
                    break;
                }
                case 39: {
                    this.writeSpecial(this.KeyRight[xind]);
                    break;
                }
                case 34: {
                    this.writeSpecial(this.NextScn[xind]);
                    break;
                }
                case 33: {
                    this.writeSpecial(this.PrevScn[xind]);
                    break;
                }
                case 155: {
                    this.writeSpecial(this.Insert[xind]);
                    break;
                }
                case 127: {
                    this.writeSpecial(this.Remove[xind]);
                    break;
                }
                case 8: {
                    this.writeSpecial(this.BackSpace[xind]);
                    if (!this.localecho) break;
                    if (this.BackSpace[xind] == "\b") {
                        this.putString("\b \b");
                        break;
                    }
                    this.putString(this.BackSpace[xind]);
                    break;
                }
                case 36: {
                    this.writeSpecial(this.KeyHome[xind]);
                    break;
                }
                case 35: {
                    this.writeSpecial(this.KeyEnd[xind]);
                    break;
                }
                case 144: {
                    if (this.vms && control) {
                        this.writeSpecial(this.PF1);
                    }
                    if (control) break;
                    this.numlock = !this.numlock;
                    break;
                }
                case 20: {
                    this.capslock = !this.capslock;
                    break;
                }
            }
        }
        this.flush();
    }

    public void stringTyped(String str) {
        int i = 0;
        while (i < str.length()) {
            this._keyTyped(0, str.charAt(i), 0);
            ++i;
        }
        this.flush();
    }

    public void keyTyped(int keyCode, char keyChar, int modifiers) {
        this._keyTyped(keyCode, keyChar, modifiers);
        this.flush();
    }

    private void _keyTyped(int keyCode, char keyChar, int modifiers) {
        boolean alt;
        boolean control = (modifiers & 1) != 0;
        boolean shift = (modifiers & 2) != 0;
        boolean bl = alt = (modifiers & 4) != 0;
        if (keyChar == '\t') {
            if (shift) {
                this.write(this.TabKey[1], false);
            } else if (control) {
                this.write(this.TabKey[2], false);
            } else if (alt) {
                this.write(this.TabKey[3], false);
            } else {
                this.write(this.TabKey[0], false);
            }
            return;
        }
        if (alt) {
            this.write("" + (char)(keyChar | 0x80));
            return;
        }
        if (!(keyCode != 10 && keyChar != '\n' || control)) {
            this.write("\r", false);
            if (this.localecho) {
                this.putStringUpper("\r\n");
            }
            return;
        }
        if ((!this.vms && keyChar == '2' || keyChar == ' ') && control) {
            this.write("\u0000");
        }
        if (this.vms) {
            if (keyChar == '\u007f' && !control) {
                if (shift) {
                    this.writeSpecial(this.Insert[0]);
                } else {
                    this.writeSpecial(this.Remove[0]);
                }
                return;
            }
            if (control) {
                switch (keyChar) {
                    case '0': {
                        this.writeSpecial(this.Numpad[0]);
                        return;
                    }
                    case '1': {
                        this.writeSpecial(this.Numpad[1]);
                        return;
                    }
                    case '2': {
                        this.writeSpecial(this.Numpad[2]);
                        return;
                    }
                    case '3': {
                        this.writeSpecial(this.Numpad[3]);
                        return;
                    }
                    case '4': {
                        this.writeSpecial(this.Numpad[4]);
                        return;
                    }
                    case '5': {
                        this.writeSpecial(this.Numpad[5]);
                        return;
                    }
                    case '6': {
                        this.writeSpecial(this.Numpad[6]);
                        return;
                    }
                    case '7': {
                        this.writeSpecial(this.Numpad[7]);
                        return;
                    }
                    case '8': {
                        this.writeSpecial(this.Numpad[8]);
                        return;
                    }
                    case '9': {
                        this.writeSpecial(this.Numpad[9]);
                        return;
                    }
                    case '.': {
                        this.writeSpecial(this.KPPeriod);
                        return;
                    }
                    case '\u001f': 
                    case '-': {
                        this.writeSpecial(this.KPMinus);
                        return;
                    }
                    case '+': {
                        this.writeSpecial(this.KPComma);
                        return;
                    }
                    case '\n': {
                        this.writeSpecial(this.KPEnter);
                        return;
                    }
                    case '/': {
                        this.writeSpecial(this.PF2);
                        return;
                    }
                    case '*': {
                        this.writeSpecial(this.PF3);
                        return;
                    }
                }
            }
        }
        int xind = 0;
        if (shift) {
            xind = 1;
        }
        if (control) {
            xind = 2;
        }
        if (alt) {
            xind = 3;
        }
        if (shift) {
            xind = 1;
        }
        if (control) {
            xind = 2;
        }
        if (alt) {
            xind = 3;
        }
        if (keyCode == 27) {
            this.writeSpecial(this.Escape[xind]);
            return;
        }
        if ((modifiers & 8) != 0) {
            switch (keyCode) {
                case 96: {
                    this.writeSpecial(this.Numpad[0]);
                    return;
                }
                case 97: {
                    this.writeSpecial(this.Numpad[1]);
                    return;
                }
                case 98: {
                    this.writeSpecial(this.Numpad[2]);
                    return;
                }
                case 99: {
                    this.writeSpecial(this.Numpad[3]);
                    return;
                }
                case 100: {
                    this.writeSpecial(this.Numpad[4]);
                    return;
                }
                case 101: {
                    this.writeSpecial(this.Numpad[5]);
                    return;
                }
                case 102: {
                    this.writeSpecial(this.Numpad[6]);
                    return;
                }
                case 103: {
                    this.writeSpecial(this.Numpad[7]);
                    return;
                }
                case 104: {
                    this.writeSpecial(this.Numpad[8]);
                    return;
                }
                case 105: {
                    this.writeSpecial(this.Numpad[9]);
                    return;
                }
                case 110: {
                    this.writeSpecial(this.NUMDot[xind]);
                    return;
                }
                case 107: {
                    this.writeSpecial(this.NUMPlus[xind]);
                    return;
                }
            }
        }
        if (keyChar != '\b' && keyChar != '\u007f' && keyChar != '\r' && keyChar != '\n') {
            if (control) {
                if (keyChar >= 'a' && keyChar <= 'z') {
                    keyChar = (char)(keyChar - 97 + 65);
                }
                if (keyChar >= 'A' && keyChar <= 'Z') {
                    keyChar = (char)(keyChar - 65 + 1);
                    this.write("" + keyChar);
                } else {
                    switch (keyChar) {
                        case '@': {
                            keyChar = '\u0000';
                            break;
                        }
                        case '[': {
                            keyChar = (char)27;
                            break;
                        }
                        case '\\': {
                            keyChar = (char)28;
                            break;
                        }
                        case ']': {
                            keyChar = (char)29;
                            break;
                        }
                        case '^': {
                            keyChar = (char)30;
                            break;
                        }
                        case '_': {
                            keyChar = (char)31;
                        }
                    }
                    this.write("" + keyChar);
                }
            } else if (shift) {
                if (keyChar >= 'a' && keyChar <= 'z') {
                    keyChar = (char)(keyChar - 97 + 65);
                }
                this.write("" + keyChar);
            } else {
                this.write("" + keyChar);
            }
            return;
        }
    }

    public char map_cp850_unicode(char x) {
        if (x >= '\u0100') {
            return x;
        }
        return unimap[x];
    }

    private void _SetCursor(int row, int col) {
        int maxr = this.height;
        int tm = this.getTopMargin();
        this.R = row < 0 ? 0 : row;
        int n = this.C = col < 0 ? 0 : col;
        if (!this.moveoutsidemargins) {
            this.R += tm;
            maxr = this.getBottomMargin();
        }
        if (this.R > maxr) {
            this.R = maxr;
        }
    }

    private void putChar(char c, boolean doshowcursor) {
        int rows = this.height;
        int columns = this.width;
        int tm = this.getTopMargin();
        int bm = this.getBottomMargin();
        boolean mapped = false;
        this.markLine(this.R, 1);
        block0 : switch (this.term_state) {
            case 0: {
                if (!this.useibmcharset) {
                    boolean doneflag = true;
                    switch (c) {
                        case '\u008d': {
                            if (this.R > tm) {
                                --this.R;
                                break;
                            }
                            this.insertLine(this.R, 1, true);
                            break;
                        }
                        case '\u0084': {
                            if (this.R == bm || this.R == rows - 1) {
                                this.insertLine(this.R, 1, false);
                                break;
                            }
                            ++this.R;
                            break;
                        }
                        case '\u0085': {
                            if (this.R == bm || this.R == rows - 1) {
                                this.insertLine(this.R, 1, false);
                            } else {
                                ++this.R;
                            }
                            this.C = 0;
                            break;
                        }
                        case '\u0088': {
                            this.Tabs[this.C] = 1;
                            break;
                        }
                        default: {
                            doneflag = false;
                        }
                    }
                    if (doneflag) break;
                }
                switch (c) {
                    case '\u008f': {
                        this.onegl = 3;
                        break;
                    }
                    case '\u008e': {
                        this.onegl = 2;
                        break;
                    }
                    case '\u009b': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.DCEvars[1] = 0;
                        this.DCEvars[2] = 0;
                        this.DCEvars[3] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case '\u001b': {
                        this.term_state = 1;
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\f': {
                        this.deleteArea(0, 0, columns, rows, this.attributes);
                        this.R = 0;
                        this.C = 0;
                        break;
                    }
                    case '\b': {
                        --this.C;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\t': {
                        do {
                            ++this.C;
                        } while (this.C < columns && this.Tabs[this.C] == 0);
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\r': {
                        this.C = 0;
                        break;
                    }
                    case '\n': {
                        if (!this.vms) {
                            if (this.lastwaslf != 0 && this.lastwaslf != c) break block0;
                            this.lastwaslf = c;
                        }
                        if (this.R == bm || this.R >= rows - 1) {
                            this.insertLine(this.R, 1, false);
                            break;
                        }
                        ++this.R;
                        break;
                    }
                    case '\u0007': {
                        this.beep();
                        break;
                    }
                    case '\u000e': {
                        this.gl = '\u0001';
                        this.usedcharsets = true;
                        break;
                    }
                    case '\u000f': {
                        this.gl = '\u0000';
                        this.usedcharsets = true;
                        break;
                    }
                    default: {
                        int thisgl = this.gl;
                        if (this.onegl >= 0) {
                            thisgl = this.onegl;
                            this.onegl = -1;
                        }
                        this.lastwaslf = 0;
                        if (c < ' ' && c != '\u0000' && c == '\u0000') break block0;
                        if (this.C >= columns) {
                            if (this.wraparound) {
                                ++this.rows_counted;
                                if (this.R < rows - 1) {
                                    ++this.R;
                                } else {
                                    this.insertLine(this.R, 1, false);
                                }
                                this.C = 0;
                            } else {
                                this.C = columns - 1;
                            }
                        }
                        if (this.usedcharsets) {
                            if (c >= ' ' && c <= '\u007f') {
                                switch (this.gx[thisgl]) {
                                    case '0': {
                                        if (this.terminalID.equals("scoansi") || this.terminalID.equals("ansi")) {
                                            int i = 0;
                                            while (i < scoansi_acs.length()) {
                                                if (c == scoansi_acs.charAt(i)) {
                                                    c = scoansi_acs.charAt(i + 1);
                                                    break;
                                                }
                                                i += 2;
                                            }
                                        }
                                        if (c < '_' || c > '~') break;
                                        c = DECSPECIAL[(short)c - 95];
                                        mapped = true;
                                        break;
                                    }
                                    case '<': {
                                        c = (char)(c & 0x7F | 0x80);
                                        mapped = true;
                                        break;
                                    }
                                    case 'A': 
                                    case 'B': {
                                        mapped = true;
                                        break;
                                    }
                                }
                            }
                            if (!mapped && c >= '\u0080' && c <= '\u00ff') {
                                switch (this.gx[this.gr]) {
                                    case '0': {
                                        if (c < '\u00df' || c > '\u00fe') break;
                                        c = DECSPECIAL[c - 223];
                                        mapped = true;
                                        break;
                                    }
                                    case '<': 
                                    case 'A': 
                                    case 'B': {
                                        mapped = true;
                                        break;
                                    }
                                }
                            }
                        }
                        if (!mapped && this.useibmcharset) {
                            c = this.map_cp850_unicode(c);
                        }
                        if (this.insertmode == 1) {
                            this.insertChar(this.C, this.R, c, this.attributes);
                        } else {
                            this.putChar(this.C, this.R, c, this.attributes);
                        }
                        ++this.C;
                        break;
                    }
                }
                break;
            }
            default: {
                this.term_state = 0;
            }
        }
        if (this.C > columns) {
            this.C = columns;
        }
        if (this.R > rows) {
            this.R = rows;
        }
        if (this.C < 0) {
            this.C = 0;
        }
        if (this.R < 0) {
            this.R = 0;
        }
        if (doshowcursor) {
            this.setCursorPosition(this.C, this.R);
        }
        this.markLine(this.R, 1);
    }

    public void reset() {
        this.gx[0] = 66;
        this.gx[1] = 48;
        this.gx[2] = 66;
        this.gx[3] = 66;
        this.gl = '\u0000';
        this.gr = '\u0001';
        int nw = this.width;
        if (nw < 132) {
            nw = 132;
        }
        this.Tabs = new byte[nw];
        int i = 0;
        while (i < nw) {
            this.Tabs[i] = 1;
            i += 8;
        }
        this.term_state = 0;
    }

    public void putChar(int c, int l, char ch) {
        this.putChar(c, l, ch, 0);
    }

    public void putChar(int c, int l, char ch, int attributes) {
        c = this.checkBounds(c, 0, this.width - 1);
        l = this.checkBounds(l, 0, this.height - 1);
        this.charArray[this.screenBase + l][c] = ch;
        this.charAttributes[this.screenBase + l][c] = attributes;
        this.markLine(l, 1);
    }

    public char getChar(int c, int l) {
        c = this.checkBounds(c, 0, this.width - 1);
        l = this.checkBounds(l, 0, this.height - 1);
        return this.charArray[this.screenBase + l][c];
    }

    public int getAttributes(int c, int l) {
        c = this.checkBounds(c, 0, this.width - 1);
        l = this.checkBounds(l, 0, this.height - 1);
        return this.charAttributes[this.screenBase + l][c];
    }

    public void insertChar(int c, int l, char ch, int attributes) {
        c = this.checkBounds(c, 0, this.width - 1);
        l = this.checkBounds(l, 0, this.height - 1);
        System.arraycopy(this.charArray[this.screenBase + l], c, this.charArray[this.screenBase + l], c + 1, this.width - c - 1);
        System.arraycopy(this.charAttributes[this.screenBase + l], c, this.charAttributes[this.screenBase + l], c + 1, this.width - c - 1);
        this.putChar(c, l, ch, attributes);
    }

    public void deleteChar(int c, int l) {
        c = this.checkBounds(c, 0, this.width - 1);
        l = this.checkBounds(l, 0, this.height - 1);
        if (c < this.width - 1) {
            System.arraycopy(this.charArray[this.screenBase + l], c + 1, this.charArray[this.screenBase + l], c, this.width - c - 1);
            System.arraycopy(this.charAttributes[this.screenBase + l], c + 1, this.charAttributes[this.screenBase + l], c, this.width - c - 1);
        }
        this.putChar(this.width - 1, l, '\u0000');
    }

    public void putString(int c, int l, String s) {
        this.putString(c, l, s, 0);
    }

    public void putString(int c, int l, String s, int attributes) {
        int i = 0;
        while (i < s.length() && c + i < this.width) {
            this.putChar(c + i, l, s.charAt(i), attributes);
            ++i;
        }
    }

    public void insertLine(int l) {
        this.insertLine(l, 1, false);
    }

    public void insertLine(int l, int n) {
        this.insertLine(l, n, false);
    }

    public void insertLine(int l, boolean scrollDown) {
        this.insertLine(l, 1, scrollDown);
    }

    public void insertLine(int l, int n, boolean scrollDown) {
        int bottom;
        int top;
        l = this.checkBounds(l, 0, this.height - 1);
        char[][] cbuf = null;
        int[][] abuf = null;
        int offset = 0;
        int oldBase = this.screenBase;
        if (l > this.bottomMargin) {
            return;
        }
        int n2 = l < this.topMargin ? 0 : (l > this.bottomMargin ? (this.bottomMargin + 1 < this.height ? this.bottomMargin + 1 : this.height - 1) : (top = this.topMargin));
        int n3 = l > this.bottomMargin ? this.height - 1 : (l < this.topMargin ? (this.topMargin > 0 ? this.topMargin - 1 : 0) : (bottom = this.bottomMargin));
        if (scrollDown) {
            if (n > bottom - top) {
                n = bottom - top;
            }
            cbuf = new char[bottom - l - (n - 1)][this.width];
            abuf = new int[bottom - l - (n - 1)][this.width];
            System.arraycopy(this.charArray, oldBase + l, cbuf, 0, bottom - l - (n - 1));
            System.arraycopy(this.charAttributes, oldBase + l, abuf, 0, bottom - l - (n - 1));
            System.arraycopy(cbuf, 0, this.charArray, oldBase + l + n, bottom - l - (n - 1));
            System.arraycopy(abuf, 0, this.charAttributes, oldBase + l + n, bottom - l - (n - 1));
            cbuf = this.charArray;
            abuf = this.charAttributes;
        } else {
            try {
                if (n > bottom - top + 1) {
                    n = bottom - top + 1;
                }
                if (this.bufSize < this.maxBufSize) {
                    if (this.bufSize + n > this.maxBufSize) {
                        offset = n - (this.maxBufSize - this.bufSize);
                        this.scrollMarker += offset;
                        this.bufSize = this.maxBufSize;
                        this.windowBase = this.screenBase = this.maxBufSize - this.height - 1;
                    } else {
                        this.scrollMarker += n;
                        this.screenBase += n;
                        this.windowBase += n;
                        this.bufSize += n;
                    }
                    cbuf = new char[this.bufSize][this.width];
                    abuf = new int[this.bufSize][this.width];
                } else {
                    offset = n;
                    cbuf = this.charArray;
                    abuf = this.charAttributes;
                }
                if (oldBase > 0) {
                    System.arraycopy(this.charArray, offset, cbuf, 0, oldBase - offset);
                    System.arraycopy(this.charAttributes, offset, abuf, 0, oldBase - offset);
                }
                if (top > 0) {
                    System.arraycopy(this.charArray, oldBase, cbuf, this.screenBase, top);
                    System.arraycopy(this.charAttributes, oldBase, abuf, this.screenBase, top);
                }
                if (oldBase > 0) {
                    System.arraycopy(this.charArray, oldBase + top, cbuf, oldBase - offset, n);
                    System.arraycopy(this.charAttributes, oldBase + top, abuf, oldBase - offset, n);
                }
                int i = 0;
                while (i < l - top - (n - 1)) {
                    cbuf[this.screenBase + top + i] = this.charArray[oldBase + top + n + i];
                    abuf[this.screenBase + top + i] = this.charAttributes[oldBase + top + n + i];
                    ++i;
                }
                if (l < this.height - 1) {
                    System.arraycopy(this.charArray, oldBase + l + 1, cbuf, this.screenBase + l + 1, this.height - 1 - l);
                    System.arraycopy(this.charAttributes, oldBase + l + 1, abuf, this.screenBase + l + 1, this.height - 1 - l);
                }
            }
            catch (ArrayIndexOutOfBoundsException i) {
                // empty catch block
            }
        }
        this.scrollMarker -= n;
        int i = 0;
        while (i < n) {
            cbuf[this.screenBase + l + (scrollDown ? i : -i)] = new char[this.width];
            abuf[this.screenBase + l + (scrollDown ? i : -i)] = new int[this.width];
            ++i;
        }
        this.charArray = cbuf;
        this.charAttributes = abuf;
        if (scrollDown) {
            this.markLine(l, bottom - l + 1);
        } else {
            this.markLine(top, l - top + 1);
        }
    }

    public void deleteLine(int l) {
        int bottom = (l = this.checkBounds(l, 0, this.height - 1)) > this.bottomMargin ? this.height - 1 : (l < this.topMargin ? this.topMargin : this.bottomMargin + 1);
        System.arraycopy(this.charArray, this.screenBase + l + 1, this.charArray, this.screenBase + l, bottom - l - 1);
        System.arraycopy(this.charAttributes, this.screenBase + l + 1, this.charAttributes, this.screenBase + l, bottom - l - 1);
        this.charArray[this.screenBase + bottom - 1] = new char[this.width];
        this.charAttributes[this.screenBase + bottom - 1] = new int[this.width];
        this.markLine(l, bottom - l);
    }

    public void deleteArea(int c, int l, int w, int h, int curAttr) {
        c = this.checkBounds(c, 0, this.width - 1);
        l = this.checkBounds(l, 0, this.height - 1);
        char[] cbuf = new char[w];
        int[] abuf = new int[w];
        int i = 0;
        while (i < w) {
            abuf[i] = curAttr;
            ++i;
        }
        i = 0;
        while (i < h && l + i < this.height) {
            System.arraycopy(cbuf, 0, this.charArray[this.screenBase + l + i], c, w);
            System.arraycopy(abuf, 0, this.charAttributes[this.screenBase + l + i], c, w);
            ++i;
        }
        this.markLine(l, h);
    }

    public void deleteArea(int c, int l, int w, int h) {
        c = this.checkBounds(c, 0, this.width - 1);
        l = this.checkBounds(l, 0, this.height - 1);
        char[] cbuf = new char[w];
        int[] abuf = new int[w];
        int i = 0;
        while (i < h && l + i < this.height) {
            System.arraycopy(cbuf, 0, this.charArray[this.screenBase + l + i], c, w);
            System.arraycopy(abuf, 0, this.charAttributes[this.screenBase + l + i], c, w);
            ++i;
        }
        this.markLine(l, h);
    }

    public void showCursor(boolean doshow) {
        if (doshow != this.showcursor) {
            this.markLine(this.cursorY, 1);
        }
        this.showcursor = doshow;
    }

    public void setCursorPosition(int c, int l) {
        this.cursorX = this.checkBounds(c, 0, this.width - 1);
        this.cursorY = this.checkBounds(l, 0, this.height - 1);
        this.markLine(this.cursorY, 1);
        this.R = l;
        this.C = c;
    }

    public int getCursorColumn() {
        return this.cursorX;
    }

    public int getCursorRow() {
        return this.cursorY;
    }

    public void setWindowBase(int line) {
        if (line > this.screenBase) {
            line = this.screenBase;
        } else if (line < 0) {
            line = 0;
        }
        this.windowBase = line;
        this.update[0] = true;
        this.redraw();
    }

    public int getWindowBase() {
        return this.windowBase;
    }

    public void setTopMargin(int l) {
        if (l > this.bottomMargin) {
            this.topMargin = this.bottomMargin;
            this.bottomMargin = l;
        } else {
            this.topMargin = l;
        }
        if (this.topMargin < 0) {
            this.topMargin = 0;
        }
        if (this.bottomMargin > this.height - 1) {
            this.bottomMargin = this.height - 1;
        }
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setBottomMargin(int l) {
        if (l < this.topMargin) {
            this.bottomMargin = this.topMargin;
            this.topMargin = l;
        } else {
            this.bottomMargin = l;
        }
        if (this.topMargin < 0) {
            this.topMargin = 0;
        }
        if (this.bottomMargin > this.height - 1) {
            this.bottomMargin = this.height - 1;
        }
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBufferSize(int amount) {
        if (amount < this.height) {
            amount = this.height;
        }
        if (amount < this.maxBufSize) {
            int copyCount;
            char[][] cbuf = new char[amount][this.width];
            int[][] abuf = new int[amount][this.width];
            int copyStart = this.bufSize - amount < 0 ? 0 : this.bufSize - amount;
            int n = copyCount = this.bufSize - amount < 0 ? this.bufSize : amount;
            if (this.charArray != null) {
                System.arraycopy(this.charArray, copyStart, cbuf, 0, copyCount);
            }
            if (this.charAttributes != null) {
                System.arraycopy(this.charAttributes, copyStart, abuf, 0, copyCount);
            }
            this.charArray = cbuf;
            this.charAttributes = abuf;
            this.bufSize = copyCount;
            this.windowBase = this.screenBase = this.bufSize - this.height;
        }
        this.maxBufSize = amount;
        this.update[0] = true;
        this.redraw();
    }

    public int getBufferSize() {
        return this.bufSize;
    }

    public int getMaxBufferSize() {
        return this.maxBufSize;
    }

    public void setScreenSize(int w, int h) {
        int bsize = this.bufSize;
        if (w < 1 || h < 1) {
            return;
        }
        if (h > this.maxBufSize) {
            this.maxBufSize = h;
        }
        if (h > this.bufSize) {
            this.bufSize = h;
            this.screenBase = 0;
            this.windowBase = 0;
        }
        if (this.windowBase + h >= this.bufSize) {
            this.windowBase = this.bufSize - h;
        }
        if (this.screenBase + h >= this.bufSize) {
            this.screenBase = this.bufSize - h;
        }
        char[][] cbuf = new char[this.bufSize][w];
        int[][] abuf = new int[this.bufSize][w];
        if (this.charArray != null && this.charAttributes != null) {
            int i = 0;
            while (i < bsize && i < this.bufSize) {
                System.arraycopy(this.charArray[i], 0, cbuf[i], 0, w < this.width ? w : this.width);
                System.arraycopy(this.charAttributes[i], 0, abuf[i], 0, w < this.width ? w : this.width);
                ++i;
            }
        }
        this.charArray = cbuf;
        this.charAttributes = abuf;
        this.width = w;
        this.height = h;
        this.topMargin = 0;
        this.bottomMargin = h - 1;
        this.update = new boolean[h + 1];
        this.update[0] = true;
    }

    public void markLine(int l, int n) {
        l = this.checkBounds(l, 0, this.height - 1);
        int i = 0;
        while (i < n && l + i < this.height) {
            this.update[l + i + 1] = true;
            ++i;
        }
    }

    private int checkBounds(int value, int lower, int upper) {
        if (value < lower) {
            return lower;
        }
        if (value > upper) {
            return upper;
        }
        return value;
    }

    public void setAttributes(int new_attributes) {
        this.attributes = new_attributes;
    }

    public void setDisplay(Terminal display) {
        this.display = display;
    }

    protected void redraw() {
        if (this.display != null) {
            this.display.redraw();
        }
    }
}

