/*
**  This file is part of Zterp, and is
**  Copyright 1992, 1993 Charles Hannum
*/

#pragma pack(1)

typedef struct zheader {
  zbyte _zil_version;
  zbyte flags1;
  zword release;
  zword _save_length;
  zword _initial_pc;
  zword _vocabulary_offset;
  zword _object_offset;
  zword _variable_offset;
  zword save_length;
  zword flags2;
  zbyte serial_number[6];
  zword _shortcut_offset;
  zword _game_length;
  zword _game_checksum;
  zbyte _zip_version,
	_zip_subversion;
  zbyte _screen_height,
	_screen_width,
	_screen_left,
	_screen_right,
	_screen_top,
	_screen_bottom;
  zbyte _font_height,
	_font_width;
  zword reserved1[3];
  zword _keymap_offset;
  zword reserved2[2];
  zword _alphabet_offset;
  zword reserved3[5];
} zheader;

#pragma pack(4)

#define zil_version (header->_zil_version)
#define save_length (get_word (&header->_save_length))
#define initial_pc (get_word (&header->_initial_pc))
#define game_length (ZADDR (get_word (&header->_game_length)))
#define game_checksum (get_word (&header->_game_checksum))
#define vocabulary_offset (get_word (&header->_vocabulary_offset))
#define object_offset (get_word (&header->_object_offset))
#define variable_offset (get_word (&header->_variable_offset))
#define shortcut_offset (get_word (&header->_shortcut_offset))
#define keymap_offset (get_word (&header->_keymap_offset))
#define alphabet_offset (get_word (&header->_alphabet_offset))
#define zip_version (header->_zip_version)
#define zip_subversion (header->_zip_subversion)
#define screen_height (header->_screen_height)
#define screen_width (header->_screen_width)
#define screen_left (header->_screen_left)
#define screen_right (header->_screen_right)
#define screen_top (header->_screen_top)
#define screen_bottom (header->_screen_bottom)
#define font_height (header->_font_height)
#define font_width (header->_font_width)

#define keymap (near_address (keymap_offset))
