/*
**  This file is part of Zterp, and is
**  Copyright 1992, 1993 Charles Hannum
*/

#include <sys/types.h>
#include "main.h"
#include "variable.h"
#include "jump.h"

void
fetch_word_from_array (a, b)
  uword a, b;
{
  zpointer p = near_address (a + (b << 1));
  store_variable_push (get_word (p));
}

void
fetch_byte_from_array (a, b)
  uword a, b;
{
  zpointer p = near_address (a + b);
  store_variable_push (get_byte (p));
}

void
store_word_in_array (a, b, c)
  uword a, b, c;
{
  zpointer p = near_address (a + (b << 1));
  set_word (p, c);
}

void
store_byte_in_array (a, b, c)
  uword a, b, c;
{
  zpointer p = near_address (a + b);
  set_byte (p, c);
}

void
find_in_array (args, argp)
  int args;
  uword *argp;
{
  uword x = argp[0],
	b = argp[1],
	c = argp[2],
	d = (args > 3) ? argp[3] : 0x82;
  if (d & 0x80)
  {
    d &= 0x7f;
    while (c--)
      if (get_word (near_address (b)) == x)
      {
        store_variable_push (b);
        return_or_jump (1);
        return;
      }
      else
        b += d;
  }
  else
  {
    d &= 0x7f;
    while (c--)
      if (get_byte (near_address (b)) == x)
      {
        store_variable_push (b);
        return_or_jump (1);
        return;
      }
      else
        b += d;
  }
  store_variable_push (0);
  return_or_jump (0);
}

void
copy_array (a, b, n)
  uword a, b;
  sword n;
{
  if (n && a != b)
    if (!b)
    {
      zpointer p = near_address (a);
      while (n--)
      {
        set_byte (p, 0);
        p += 1;
      }
    }
    else
    {
      zpointer s = near_address (a),
	       d = near_address (b);
      if (n < 0)
	while (n++)
	{
	  set_byte (d, get_byte (s));
	  d += 1, s += 1;
	}
      else
      {
	d += n, s += n;
	while (n--)
	{
	  d -= 1, s -= 1;
	  set_byte (d, get_byte (s));
	}
      }
    }
}
