/* Texas instruments calculators terminal interface for pinfocom *
 * by Nils Gesbert, January 2003 */


#include <kbd.h>
#include <graph.h>
#include <compat.h>
#include <string.h>
#include <system.h>
#include "infocom.h"

#define OCTETS_PAR_LIGNE 30 /* nb. d'octets ds une ligne de pixels */
#define HAUTEUR_STATUT 7 /* en pixels : petite police + 1 pix. noir au-dessus et en-dessous */
#define hauteur_ligne (fonte_courante == F_4x6 ? 6 : 8)
#define hauteur_trou ((LCD_HEIGHT - HAUTEUR_STATUT) % hauteur_ligne)
#define position_y (LCD_HEIGHT - HAUTEUR_STATUT - hauteur_trou - hauteur_ligne)
#define largeur_ecran LCD_WIDTH
#define largeur_espace (fonte_courante == F_4x6 ? 2 : 6)
#define nb_lignes_max \
((LCD_HEIGHT - HAUTEUR_STATUT) / hauteur_ligne - nb_lignes_a_garder)
#define nb_lignes_a_garder CONTEXT

static int fonte_courante;
static int ligne_courante;
static int position_x;

inline void scr_setup (){
  FontSetSys (F_4x6);
  fonte_courante = F_4x6;
  ligne_courante = 1 - nb_lignes_a_garder; /* Pas besoin d'historique au dbut... */
  position_x = -1;
  return;
}

void va_a_la_ligne() {
  /* Faut-il changer de police ? */
  int decalage = 0;
  int fonte = F2_IS_SET (B_FIXED_FONT) ? F_6x8 : F_4x6;
  if (fonte != fonte_courante) {
    decalage = hauteur_trou;
    FontSetSys (fonte);
    fonte_courante = fonte;
    decalage -= hauteur_trou;
  }
  if (ligne_courante++ >= nb_lignes_max) {
    int lc;
    /* crire "..." en bas de l'cran */
    ((byte*)LCD_MEM)[OCTETS_PAR_LIGNE * (LCD_HEIGHT - HAUTEUR_STATUT - 2)] = 42;
    switch (ngetchx()) {
      case KEY_ESC : lc = -32768; break; /* Ne plus s'arrter */
      case KEY_DOWN : lc = 32767; break; /* scroller seulement une ligne */
      case ' ' : lc = 1 - nb_lignes_a_garder; break; /* un cran entier */
      default : lc = 1;
    }
    ligne_courante = lc;
  }
  /* scrolling d'une ligne vers le haut */
  memmove (LCD_MEM, LCD_MEM + (hauteur_ligne - decalage) * OCTETS_PAR_LIGNE,
	   OCTETS_PAR_LIGNE * position_y);
  memset (LCD_MEM + OCTETS_PAR_LIGNE * position_y, 0,
	  (hauteur_ligne + hauteur_trou) * OCTETS_PAR_LIGNE);
  position_x = -1; /* Les caractres ont une approche  gauche de 1 pixel */
}

static void ecrit_texte (const char *ptr) {
  char mot[30];
  int k = 0;
  do {
    mot[k++] = *ptr;
    if (*ptr == ' ' || *ptr == '\0' || k == 29) {
      int longueur;
      mot[k] = '\0';
      longueur = DrawStrWidth (mot, fonte_courante);
      if (position_x + longueur > largeur_ecran + (*ptr == ' ' ? largeur_espace : 0))
	va_a_la_ligne(); /* on vire les espaces en fin de ligne */
      k = 0;
      DrawStr (position_x, position_y, mot, A_NORMAL);
      position_x += longueur;
    }
  } while (*ptr++);
}

void scr_putline (const char *texte) {
  ecrit_texte (texte);
  va_a_la_ligne();
}

static void rafraichit_statut () {
#ifdef USE_TI89 /* crire hors de l'cran pour rafrachir aprs ne marche que sur la TI 89 */
  memcpy (LCD_MEM + (LCD_HEIGHT - 7) * OCTETS_PAR_LIGNE,
	  LCD_MEM + LCD_HEIGHT * OCTETS_PAR_LIGNE,
	  7 * OCTETS_PAR_LIGNE);
#endif
}

void scr_putscore() {
#ifdef USE_TI89
#define position LCD_HEIGHT /* crire la barre de statut hors de l'cran,
			       ainsi on peut en rafrachir l'affichage en la recopiant */ 
#else
#define position LCD_HEIGHT - 7 /* Pas possible si y a pas le rab de mm. vido */
#endif
  int fonte = FontSetSys (F_4x6);
  memset (LCD_MEM + position * OCTETS_PAR_LIGNE, 0xFF, 7 * OCTETS_PAR_LIGNE);

  DrawStr (0, position + 1, ti_location, A_REVERSE);
  DrawStr (LCD_WIDTH - DrawStrWidth (ti_status, F_4x6),
	   position + 1, ti_status, A_REVERSE);
  FontSetSys (fonte);
  rafraichit_statut();
#undef position
}

inline void scr_putsound (int number,
		   int action,
		   int volume,
		   int argc) {
  scr_putline ("[son]");
}

int scr_getline (const char *prompt, int maxlen, char *buffer) {
  unsigned short key, i = 0;
  void *kbq = kbd_queue();
  scr_putscore();
  ecrit_texte (prompt);
  buffer[0] = 0;
  do {
    DrawStr (position_x, position_y, buffer, A_REPLACE);
    DrawStr (position_x + DrawStrWidth (buffer, fonte_courante),
	     position_y, "_   ", A_REPLACE);
    OSTimerRestart (APD_TIMER);
    while (OSdequeue (&key, kbq)) {
      idle();
      if (OSTimerExpired (APD_TIMER)) {key = KEY_DIAMOND + KEY_ON; break;}
      rafraichit_statut();
    }
    key &= 0xF7FF; /* Pour la rptition */

    if (key & KEY_DIAMOND) switch (key - KEY_DIAMOND) {
      case KEY_ON : off();
#ifdef ALPHALOCK
	{unsigned char c; alphaLockOn (&c);} /* off enlve le alpha-lock */
#endif
	break;
      case KEY_STO /* P */: F2_CHANGEB (B_FIXED_FONT); break; /* change de police */
      case KEY_MODE : F1_CHANGEB (B_TANDY); break; /* change le Mystrieux Bit Tandy */
      case KEY_ESC : quit(); return i;
      default : key -= KEY_DIAMOND; /* redonne le code SANS alpha -> pratique pour taper , ou .*/
    }
    if (key >= ' ' && key <= '~' && i < maxlen - 1) buffer[i++] = key;
    else if (key == KEY_BACKSPACE && i) i--;
    else if (key == KEY_CLEAR) i = 0; /* moche mais peut-tre pratique quand mme ? */
    else if (key == KEY_ESC && gflags.game_state == LOAD_GAME)
      return -1; /* Pour annuler... */
    buffer[i] = 0;
  } while (key != KEY_ENTER);
  ligne_courante = 0;
  va_a_la_ligne();
  return i;
}

inline void scr_window (int size) {}
inline void scr_set_win (int win) {}
inline void scr_shutdown(){}
