/*
 * main.c
 *
 * Z-code interpreter main routine
 *
 * This is an interpreter for Infocom V1 to V5 games. It also supports
 * the recently defined V7 and V8 games. Please report bugs to
 *
 *    jokisch@ls7.informatik.uni-dortmund.de
 *
 */

#include "frotz.h"

#define DEFAULT_ATTRIBUTE_TESTING 0
#define DEFAULT_ATTRIBUTE_ASSIGNMENT 0
#define DEFAULT_CONTEXT_LINES 0
#define DEFAULT_OBJECT_LOCATING	0
#define DEFAULT_OBJECT_MOVEMENT 0
#define DEFAULT_RIGHT_MARGIN 0
#define DEFAULT_TANDY_BIT 0
#define DEFAULT_UNDO_SLOTS 10

/* Story file header data */

zbyte h_version = 0;
zbyte h_config = 0;
zword h_release = 0;
zword h_start_pc = 0;
zword h_dictionary = 0;
zword h_objects = 0;
zword h_globals = 0;
zword h_dynamic_size = 0;
zword h_flags = 0;
zbyte h_serial[6] = { 0, 0, 0, 0, 0, 0 };
zword h_abbreviations = 0;
zword h_file_size = 0;
zword h_checksum = 0;
zbyte h_interpreter_number = 0;
zbyte h_interpreter_version = 0;
zbyte h_screen_rows = 0;
zbyte h_screen_cols = 0;
zword h_screen_width;
zword h_screen_height;
zbyte h_font_width;
zbyte h_font_height;
zword h_alphabet = 0;
zword h_functions_offset = 0;
zword h_strings_offset = 0;
zbyte h_default_background = 0;
zbyte h_default_foreground = 0;
zword h_terminating_keys = 0;
zword h_mouse_table = 0;

/* Story file name and size */

char *story_name;
long story_size;

/* Z-code version specific data */

int story_shift = 0;
int property_mask = 0;

/* Stack data */

zword stack[STACK_SIZE];
zword *sp = &stack[STACK_SIZE];
zword *fp = &stack[STACK_SIZE];

/* Mouse data */

int mouse_x = 0;
int mouse_y = 0;

/* Workarounds for specific problems */

int beyond_zork_flag = 0;
int newline_flag = 0;
int input_flag = 0;

/* IO stream data */

int outputting = 1;
int redirecting = 0;
int scripting = 0;
int recording = 0;
int message = 0;
int replaying = 0;

/* Current window and scrolling data */

int cwin = 0;

int upper_size = 0;
int line_count = 0;

/* User options */

int option_attribute_testing = DEFAULT_ATTRIBUTE_TESTING;
int option_attribute_assignment = DEFAULT_ATTRIBUTE_ASSIGNMENT;
int option_context_lines = DEFAULT_CONTEXT_LINES;
int option_object_locating = DEFAULT_OBJECT_LOCATING;
int option_object_movement = DEFAULT_OBJECT_MOVEMENT;
int option_right_margin = DEFAULT_RIGHT_MARGIN;
int option_tandy_bit = DEFAULT_TANDY_BIT;
int option_undo_slots = DEFAULT_UNDO_SLOTS;

/*
 * main
 *
 * Prepare and run the game.
 *
 */

int main (int argc, char *argv[])
{

    os_process_arguments (argc, argv);

    init_memory ();

    os_init_screen ();

    z_restart ();

    interpret ();

    reset_memory ();

    os_reset_screen ();

    return (0);

}/* main */
