/*
 * hotkey.c
 *
 * Hot key routines
 *
 */

#include <stdlib.h>
#include "frotz.h"

/*
 * hot_key_playback
 *
 */

void hot_key_playback (void)
{

    display_string ("Hot key -- playback on.");
    display_new_line ();
    z_input_stream (1);

}/* hot_key_playback */

/*
 * hot_key_recording
 *
 */

void hot_key_recording (void)
{

    if (replaying) {
	display_string ("Hot key -- playback off.");
	display_new_line ();
	z_input_stream (0);
    } else if (recording) {
	display_string ("Hot key -- recording off.");
	display_new_line ();
	z_output_stream (-4, 0);
    } else {
	display_string ("Hot key -- recording on.");
	display_new_line ();
	z_output_stream (4, 0);
    }

}/* hot_key_recording */

/*
 * hot_key_seed
 *
 */

void hot_key_seed (void)
{
    char number[6];
    int terminator;

    display_string ("Hot key -- random number seed.");
    display_new_line ();
    display_string ("Enter seed value (or return to randomize): ");

    /* Read new seed value */

    number[0] = 0;

    do {
	terminator = os_read (5, number, 0);
    } while (terminator != 13);

    display_new_line ();

    /* Set new seed value */

    random_number (-atoi (number));

}/* hot_key_seed */

/*
 * hot_key_undo
 *
 */

void hot_key_undo (int *success)
{

    display_string ("Hot key -- undo one turn.");
    display_new_line ();

    *success = restore_undo (1);

    if (*success != 2) {
	display_string ("No more undo information available.");
	display_new_line ();
	return;
    }

    if (h_version >= V5)
	store (2);

}/* hot_key_undo */
