/*
 * frotz.h
 *
 * Global declarations and definitions
 *
 */

typedef unsigned char zbyte;  /* unsigned 1 byte quantity */
typedef unsigned short zword; /* unsigned 2 byte quantity */

/* Story file header format */

#define H_VERSION 0
#define H_CONFIG 1
#define H_RELEASE 2
#define H_RESIDENT_SIZE 4
#define H_START_PC 6
#define H_DICTIONARY 8
#define H_OBJECTS 10
#define H_GLOBALS 12
#define H_DYNAMIC_SIZE 14
#define H_FLAGS 16
#define H_SERIAL 18
#define H_ABBREVIATIONS 24
#define H_FILE_SIZE 26
#define H_CHECKSUM 28
#define H_INTERPRETER_NUMBER 30
#define H_INTERPRETER_VERSION 31
#define H_SCREEN_ROWS 32
#define H_SCREEN_COLS 33
#define H_SCREEN_WIDTH 34
#define H_SCREEN_HEIGHT 36
#define H_FONT_WIDTH 38
#define H_FONT_HEIGHT 39
#define H_FUNCTIONS_OFFSET 40
#define H_STRINGS_OFFSET 42
#define H_DEFAULT_BACKGROUND 44
#define H_DEFAULT_FOREGROUND 45
#define H_TERMINATING_KEYS 46
#define H_LINE_WIDTH 48
#define H_SPECIFICATION_HIGH 50
#define H_SPECIFICATION_LOW 51
#define H_ALPHABET 52
#define H_MOUSE_TABLE 54
#define H_USER_NAME 56

/* Various Z-machine constants */

#define V1 1
#define V2 2
#define V3 3
#define V4 4
#define V5 5
#define V6 6
#define V7 7
#define V8 8

#define CONFIG_BYTE_SWAPPED 0x01 /* Game data is byte swapped          - V3  */
#define CONFIG_COLOUR       0x01 /* Interpr supports colour            - V5+ */
#define CONFIG_TIME         0x02 /* Status line displays time          - V3  */
#define CONFIG_BOLDFACE     0x04 /* Interpr supports boldface style    - V4+ */
#define CONFIG_TANDY        0x08 /* Tandy licensed game                - V3  */
#define CONFIG_EMPHASIS     0x08 /* Interpr supports text emphasis     - V4+ */
#define CONFIG_NOSTATUSLINE 0x10 /* Interpr can't support status lines - V3  */
#define CONFIG_FIXED        0x10 /* Interpr supports fixed width style - V4+ */
#define CONFIG_SPLITSCREEN  0x20 /* Interpr supports split screen mode - V3  */
#define CONFIG_SOUND        0x20 /* Interpr supports sound effects (?) - V6  */
#define CONFIG_PROPORTIONAL 0x40 /* Interpr uses proportional font     - V3  */
#define CONFIG_TIMEDINPUT   0x80 /* Interpr supports timed input       - V4+ */

#define SCRIPTING_FLAG	    0x01 /* Outputting to transscript file     - V1+ */
#define FIXED_FONT_FLAG     0x02 /* Use fixed width font               - V3+ */
#define REFRESH_FLAG 	    0x04 /* Refresh the screen                 - V6  */
#define GRAPHICS_FLAG	    0x08 /* Game wants to use pictures         - V5+ */
#define OLD_SOUND_FLAG	    0x10 /* Game wants to use sound effects    - V3  */
#define UNDO_FLAG	    0x10 /* Game wants to use UNDO feature     - V5+ */
#define MOUSE_FLAG	    0x20 /* Game wants to use a mouse          - V5+ */
#define COLOUR_FLAG	    0x40 /* Game wants to use colours          - V5+ */
#define SOUND_FLAG	    0x80 /* Game wants to use sound effects    - V5+ */

#define INTERP_DEC_20 1
#define INTERP_APPLE_IIE 2
#define INTERP_MACINTOSH 3
#define INTERP_AMIGA 4
#define INTERP_ATARI_ST 5
#define INTERP_MSDOS 6
#define INTERP_CBM_128 7
#define INTERP_CBM_64 8
#define INTERP_APPLE_IIC 9
#define INTERP_APPLE_IIGS 10
#define INTERP_TANDY 11

#define DEFAULT_COLOUR 1
#define BLACK_COLOUR 2
#define RED_COLOUR 3
#define GREEN_COLOUR 4
#define YELLOW_COLOUR 5
#define BLUE_COLOUR 6
#define MAGENTA_COLOUR 7
#define CYAN_COLOUR 8
#define WHITE_COLOUR 9

#define LOWER_WINDOW 0
#define UPPER_WINDOW 1

#define ROMAN_STYLE 0
#define REVERSE_STYLE 1
#define BOLDFACE_STYLE 2
#define EMPHASIS_STYLE 4
#define FIXED_WIDTH_STYLE 8

#define TEXT_FONT 1
#define PICTURE_FONT 2
#define GRAPHICS_FONT 3
#define FIXED_WIDTH_FONT 4

/* Other constants */

#define CODE_ROMAN_STYLE 1
#define CODE_REVERSE_STYLE 2
#define CODE_BOLDFACE_STYLE 3
#define CODE_EMPHASIS_STYLE 4
#define CODE_FIXED_WIDTH_STYLE 5
#define CODE_TEXT_FONT 14
#define CODE_PICTURE_FONT 15
#define CODE_GRAPHICS_FONT 16
#define CODE_FIXED_WIDTH_FONT 17

#define STACK_SIZE 1024

#define FILE_RESTORE 0
#define FILE_SAVE 1
#define FILE_SCRIPT 2
#define FILE_RECORD 3
#define FILE_PLAYBACK 4
#define FILE_LOAD_AUX 5
#define FILE_SAVE_AUX 6

#define MAX_FILE_NAME 30

#define DEFAULT_SAVE_NAME "story.sav"
#define DEFAULT_SCRIPT_NAME "story.scr"
#define DEFAULT_COMMAND_NAME "story.rec"
#define DEFAULT_AUXILARY_NAME "story.aux"

#define HOT_KEY_MIN 1000

#define HOT_KEY_RECORDING 1000
#define HOT_KEY_PLAYBACK 1001
#define HOT_KEY_SEED 1002
#define HOT_KEY_UNDO 1003

#define HOT_KEY_MAX 1003

/* Data access macros */

#define lo_word(v)  ((unsigned int *)&v)[0]
#define hi_word(v)  ((unsigned int *)&v)[1]

#define lo(v)   ((unsigned char *)&v)[0]
#define hi(v)   ((unsigned char *)&v)[1]

extern zbyte *pcp;
extern zbyte *zmp;

#define LOW_BYTE(addr,v)	v = zmp[addr];
#define CODE_BYTE(v)		v = *(pcp++);
#define SET_BYTE(addr,v)	zmp[addr] = v;

#define LOW_WORD(addr,v) \
    asm {\
	les bx,dword ptr zmp;\
	add bx,addr;\
	mov ax,word ptr es:[bx];\
	xchg al,ah;\
	mov v,ax;\
    }

#define CODE_WORD(v) \
    asm {\
	les bx,dword ptr pcp;\
	mov ax,word ptr es:[bx];\
	xchg al,ah;\
	mov v,ax;\
	add word ptr pcp,2;\
    }

#define HIGH_WORD(addr,v) \
    asm {\
	mov bx,word ptr zmp;\
	add bx,word ptr addr;\
	mov al,bh;\
	mov bh,0;\
	mov ah,0;\
	adc ah,byte ptr addr+2;\
	mov cl,4;\
	shl ax,cl;\
	add ax,word ptr zmp+2;\
	mov es,ax;\
	mov ax,word ptr es:[bx];\
	xchg al,ah;\
	mov v,ax;\
    }

#define SET_WORD(addr,v) \
    asm {\
	les bx,dword ptr zmp;\
	add bx,addr;\
	mov ax,v;\
	xchg al,ah;\
	mov word ptr es:[bx],ax;\
    }

#define GET_PC(v) \
    asm {\
	mov bx,word ptr pcp+2;\
	sub bx,word ptr zmp+2;\
	mov al,bh;\
	mov cl,4;\
	shl bx,cl;\
	shr al,cl;\
	add bx,word ptr pcp;\
	adc al,0;\
	sub bx,word ptr zmp;\
	sbb al,0;\
	mov ah,0;\
	mov word ptr v,bx;\
	mov word ptr v+2,ax;\
    }

#define SET_PC(v) \
    asm {\
	mov bx,word ptr zmp;\
	add bx,word ptr v;\
	mov al,bh;\
	mov bh,0;\
	mov ah,0;\
	adc ah,byte ptr v+2;\
	mov cl,4;\
	shl ax,cl;\
	add ax,word ptr zmp+2;\
	mov word ptr pcp,bx;\
	mov word ptr pcp+2,ax;\
    }

/* Story file header data */

extern zbyte h_version;
extern zbyte h_config;
extern zword h_release;
extern zword h_start_pc;
extern zword h_dictionary;
extern zword h_objects;
extern zword h_globals;
extern zword h_dynamic_size;
extern zword h_flags;
extern zbyte h_serial[];
extern zword h_abbreviations;
extern zword h_file_size;
extern zword h_checksum;
extern zbyte h_interpreter_number;
extern zbyte h_interpreter_version;
extern zbyte h_screen_rows;
extern zbyte h_screen_cols;
extern zword h_screen_width;
extern zword h_screen_height;
extern zbyte h_font_width;
extern zbyte h_font_height;
extern zword h_alphabet;
extern zword h_functions_offset;
extern zword h_strings_offset;
extern zbyte h_default_background;
extern zbyte h_default_foreground;
extern zword h_terminating_keys;
extern zword h_mouse_table;

/* Various data */

extern char *story_name;
extern long story_size;

extern int story_shift;
extern int property_mask;

extern zword stack[STACK_SIZE];
extern zword *sp;
extern zword *fp;

extern int mouse_x;
extern int mouse_y;

extern int beyond_zork_flag;
extern int newline_flag;
extern int input_flag;

extern int cwin;

extern int outputting;
extern int redirecting;
extern int scripting;
extern int recording;
extern int message;
extern int replaying;

extern int upper_size;
extern int line_count;

extern int option_attribute_testing;
extern int option_attribute_assignment;
extern int option_context_lines;
extern int option_object_locating;
extern int option_object_movement;
extern int option_right_margin;
extern int option_tandy_bit;
extern int option_undo_slots;

/* Z-code instructions */

void z_add (zword, zword);
void z_and (zword, zword);
void z_arith_shift (zword, zword);
void z_buffer_mode (zword);
void z_call (int, zword *, int);
void z_catch (void);
void z_check_arg_count (zword);
void z_clear_attr (zword, zword);
void z_copy_table (zword, zword, zword);
void z_dec (zword);
void z_dec_chk (zword, zword);
void z_div (zword, zword);
void z_encode_text (zword, zword, zword, zword);
void z_erase_line (zword);
void z_erase_window (zword);
void z_get_child (zword);
void z_get_cursor (zword);
void z_get_next_prop (zword, zword);
void z_get_parent (zword);
void z_get_prop (zword, zword);
void z_get_prop_addr (zword, zword);
void z_get_prop_len (zword);
void z_get_sibling (zword);
void z_inc (zword);
void z_inc_chk (zword, zword);
void z_input_stream (zword);
void z_insert_obj (zword, zword);
void z_je (int, zword *);
void z_jg (zword, zword);
void z_jin (zword, zword);
void z_jl (zword, zword);
void z_jump (zword);
void z_jz (zword);
void z_load (zword);
void z_loadb (zword, zword);
void z_loadw (zword, zword);
void z_log_shift (zword, zword);
void z_mod (zword, zword);
void z_mul (zword, zword);
void z_new_line (void);
void z_not (zword);
void z_or (zword, zword);
void z_output_stream (zword, zword);
void z_pop (void);
void z_print (void);
void z_print_addr (zword);
void z_print_char (zword);
void z_print_num (zword);
void z_print_obj (zword);
void z_print_paddr (zword);
void z_print_ret (void);
void z_print_table (int, zword *);
void z_pull (zword);
void z_push (zword);
void z_put_prop (zword, zword, zword);
void z_random (zword);
void z_read (int, zword *);
void z_read_char (int, zword *);
void z_remove_obj (zword);
void z_restart (void);
void z_restore (int, zword *);
void z_restore_undo (void);
void z_ret (zword);
void z_save (int, zword *);
void z_save_undo (void);
void z_scan_table (int, zword *);
void z_set_attr (zword, zword);
void z_set_font (zword);
void z_set_colour (zword, zword);
void z_set_cursor (zword, zword);
void z_set_window (zword);
void z_set_text_style (zword);
void z_show_status (void);
void z_sound_effect (int, zword *);
void z_split_window (zword);
void z_store (zword, zword);
void z_storeb (zword, zword, zword);
void z_storew (zword, zword, zword);
void z_sub (zword, zword);
void z_test (zword, zword);
void z_test_attr (zword, zword);
void z_throw (zword, zword);
void z_tokenise (int, zword *);
void z_verify (void);

/* Various global routines */

void flush_buffer (void);
void init_memory (void);
void reset_memory (void);
int restore_undo (int);
int save_undo (void);
void hot_key_playback (void);
void hot_key_recording (void);
void hot_key_seed (void);
void hot_key_undo (int *);
int is_terminator (int);
int random_number (int);
void end_of_sound (void);
zword object_name (int);
void branch (int);
void store (zword);
void interpret (void);
int call_interrupt (zword);
void display_new_line (void);
void display_string (const char *);
void memory_char (int);
int playback_key (void);
int playback_line (int, char *);
void record_key (int);
void record_line (const char *, int);
void script_backup (int);
void script_char (int);
void script_string (const char *);

/* Interface functions */

void os_beep (int);
void os_display_char (int);
void os_erase_area (int, int, int, int);
void os_fatal (const char *);
void os_finish_with_sample (void);
int os_font_available (int);
void os_get_cursor (int *, int *);
int os_get_file_name (char *, char *, int);
void os_init_screen (void);
void os_message_start (void);
void os_message_end (void);
void os_more_prompt (void);
void os_prepare_sample (int);
void os_process_arguments (int, char *[]);
int os_read (int, char *, int);
int os_read_char (int);
void os_reset_screen (void);
void os_scroll_area (int, int, int, int);
void os_set_colour (int, int);
void os_set_cursor (int, int);
void os_set_font (int);
void os_set_text_style (int);
void os_start_sample (int, int, int);
void os_stop_sample (void);
int os_text_length (const char *);
void os_wait_sample (void);
