/* iface.c - HelioFrotz Startup Dialog IFace Handler
 *
 * This file is part of HelioFrotz.
 *
 * HelioFrotz is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * HelioFrotz is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <system.h>
#include "frotz.h"
#include "heliofro.h"
#include "res\resource.h"
#include "..\stdlib\my_stdio.h"
#include "..\stdlib\fnt.h"

static char savename[64];
static int savesmall;
static int savego = 0;

extern char *how2play;
extern char *heliohelp;

extern int textFont;
extern int fixedFont;

char textName[64];
char fixedName[64];

int wantfixed;
char *fonttitle = NULL;

void ReadPrefs()
{
  FILE *fp;
  
  textFont  = smallFont;
  fixedFont = smallFixedFont;
  textName[0] = 0;
  fixedName[0] = 0;
  fp = fopen("HelioFrotzPrefs15", "rb");
  if (fp) {
    fread(&textFont, 1, sizeof(int), fp);
    fread(textName, 1, 64, fp);
    fread(&fixedFont, 1, sizeof(int), fp);
    fread(fixedName, 1, 64, fp);
    fclose(fp);
  }
}

void WritePrefs()
{
  FILE *fp;
  filetype("HelioFrotz Preferences");
  fp = fopen("HelioFrotzPrefs15", "wb");
  if (fp) {
    fwrite(&textFont, 1, sizeof(int), fp);
    fwrite(textName, 1, 64, fp);
    fwrite(&fixedFont, 1, sizeof(int), fp);
    fwrite(fixedName, 1, 64, fp);
    fclose(fp);
  }
}

void LoadFonts()
{
  if (textFont==userFont0)
    FntInstallFontNum(textName, 0);
  if (fixedFont==userFont1)
    FntInstallFontNum(fixedName, 1);
}

static int doneiface;
int DoIface(char *fname)
{
  EvtType event;

  doneiface=0;
  strcpy(savename, "");
  savesmall = 0;
  savego = 0;
  ReadPrefs();
  FormPopupForm(FORM_IFACE);
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
    if (event.eventType==EVT_APP_STOP) break;
  } while(!doneiface);
  FormDeleteForm(FORM_IFACE);
  strcpy(fname, savename);
  FntClearScreen();
  WritePrefs();
  LoadFonts();
  return savego;
}


BOOLEAN FormIfaceHandleEvent(EvtType* Event)
{
  SHORT item;
  BYTE *ptr;
	
  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    FormDrawForm(Event->eventID);
    ListDeleteAllItems(LIST_MAIN);
    ListAllDBs("Frotz", LIST_MAIN);
    ListSetSelectedItem(LIST_MAIN, NO_SELECTION);
    ListDrawList(LIST_MAIN);
    break;

  case EVT_MENU_SELECT_ITEM:
    if (Event->para1==MENU_ABOUT) FormPopupForm(FORM_ABOUT);
    else if (Event->para1==MENU_HOW2PLAY || Event->para1==MENU_HELIOHELP) {
      int x;
      if (Event->para1==MENU_HOW2PLAY) x=DoHelp("How To Play Interactive Fiction", how2play);
      else x=DoHelp("HelioFrotz Port Help", heliohelp);
      if (x==EVT_APP_STOP) {
	savego = 0;
	doneiface = 1;
      }
    }
    break;

  case EVT_LIST_SELECT:
    ListSetSelectedItem(Event->eventID, Event->para1);
    ListSetHighlightedItem(Event->eventID, Event->para1);
    ListDrawList(Event->eventID);
    return TRUE;
		
  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      ListGetTotalItems(LIST_MAIN, &item);
      if (item==0) break;
      ListGetSelectedItem(LIST_MAIN, &item);
      if (item == NO_SELECTION) return TRUE;
      ListGetListItem(LIST_MAIN, item, (BYTE **)&ptr);
      strcpy(savename, ptr);
      savego = 1;
      doneiface = 1;
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      doneiface = 1;
      savego = 0;
      break;
    default:
      return FALSE;
    }
    break;
		
  case EVT_CONTROL_SELECT:
    switch (Event->eventID) {
    case FIXED_BUTTON:
      strcpy(savename, ptr);
      fonttitle = "Please Select A Fixed-Width Font";
      wantfixed = 1;
      FormPopupForm(FORM_FONT);
      return TRUE;
    case TEXT_BUTTON:
      strcpy(savename, ptr);
      fonttitle = "Please Select A Proportional Font";
      wantfixed = 0;
      FormPopupForm(FORM_FONT);
      return TRUE;
    }
    ListGetTotalItems(LIST_MAIN, &item);
    if (item==0) break;
    ListGetSelectedItem(LIST_MAIN, &item);
    if (item == NO_SELECTION) return TRUE;
    ListGetListItem(LIST_MAIN, item, (BYTE **)&ptr);
    switch (Event->eventID) {
    case OPEN_BUTTON:
      strcpy(savename, ptr);
      savego = 1;
      doneiface = 1;
      break;
    }
    break;
		
  default:
    return FALSE;
  }
  return TRUE;
}


BOOLEAN FormAboutHandleEvent(EvtType* Event)
{
  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    FormSaveBehindBits(Event->eventID);
    FormDrawForm(Event->eventID);
    break;

  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormRestoreBitBehind(FORM_ABOUT);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_ABOUT, 0, 0, NULL);
      FormPopupForm(FORM_IFACE);
      break;
    default:
      return FALSE;
    }
    break;
	
  default:
    return FALSE;
  }
  return TRUE;
}




void ChangeToFont(char *str)
{
  char buff[100];

  if (strcmp(str, "Small Fixed Font")==0) {
    if (wantfixed) fixedFont = smallFixedFont;
    else textFont = smallFixedFont;
    EvtAppendEvt(EVT_FORM_CLOSE, FORM_FONT, 0, 0, NULL);
  } else if (strcmp(str, "Standard Fixed Font")==0) {
    if (wantfixed) fixedFont = stdFixedFont;
    else textFont = stdFixedFont;
    EvtAppendEvt(EVT_FORM_CLOSE, FORM_FONT, 0, 0, NULL);
  } else if (strcmp(str, "Small Proportional Font")==0) {
    if (wantfixed) fixedFont = smallFont;
    else textFont = smallFont;
    EvtAppendEvt(EVT_FORM_CLOSE, FORM_FONT, 0, 0, NULL);
  } else if (strcmp(str, "Standard Proportional Font")==0) {
    if (wantfixed) fixedFont = stdFont;
    else textFont = stdFont;
    EvtAppendEvt(EVT_FORM_CLOSE, FORM_FONT, 0, 0, NULL);
  } else {
    FntInstallFontNum(str, wantfixed?1:0);
    if (FntIsFixedWidth(wantfixed?userFont1:userFont0) || !wantfixed) {
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_FONT, 0, 0, NULL);
    } else {
      sprintf(buff, "'%s' Var-Width, Continue?", str);
      if (!DoYesNo(buff, -1)) {
	FormPopupForm(FORM_FONT);
	return;
      }
    }
    if (wantfixed) {
      fixedFont = userFont1;
      strcpy(fixedName, str);
    } else {
      textFont = userFont0;
      strcpy(textName, str);
    }
  }
  FntBeep();
  FormPopupForm(FORM_IFACE);
}


BOOLEAN FormFontHandleEvent(EvtType* Event)
{
  SHORT item;
  BYTE *ptr;
	
  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    StringSetText(STRING_FONT, fonttitle);
    FormDrawForm(Event->eventID);
    ListDeleteAllItems(LIST_FONT);
    ListAllDBs("FontPDB", LIST_FONT);
    ListInsertItem(LIST_FONT, 0, "Small Fixed Font");
    ListInsertItem(LIST_FONT, 1, "Standard Fixed Font");
    if (!wantfixed) {
      ListInsertItem(LIST_FONT, 2, "Small Proportional Font");
      ListInsertItem(LIST_FONT, 3, "Standard Proportional Font");
    }
    ListSetSelectedItem(LIST_FONT, NO_SELECTION);
    ListDrawList(LIST_FONT);
    break;

  case EVT_LIST_SELECT:
    ListSetSelectedItem(Event->eventID, Event->para1);
    ListSetHighlightedItem(Event->eventID, Event->para1);
    ListDrawList(Event->eventID);
    return TRUE;
		
  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      ListGetTotalItems(LIST_FONT, &item);
      if (item==0) break;
      ListGetSelectedItem(LIST_FONT, &item);
      if (item == NO_SELECTION) return TRUE;
      ListGetListItem(LIST_FONT, item, (BYTE **)&ptr);
      ChangeToFont(ptr);
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormPopupForm(FORM_IFACE);
      break;
    default:
      return FALSE;
    }
    break;
		
  case EVT_CONTROL_SELECT:
    ListGetTotalItems(LIST_FONT, &item);
    if (item==0) break;
    ListGetSelectedItem(LIST_FONT, &item);
    if (item == NO_SELECTION) return TRUE;
    ListGetListItem(LIST_FONT, item, (BYTE **)&ptr);
    switch (Event->eventID) {
    case OPEN_FONT:
      ChangeToFont(ptr);
      break;
    case DELETE_FONT:
      if (DoYesNo("Really Delete Font?",-1)) {
	if (unlink(ptr)) FntBeep();
      }
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_FONT, 0, 0, NULL);
      FormPopupForm(FORM_FONT);
      break;
    }
    break;
		
  default:
    return FALSE;
  }
  return TRUE;
}
