/* helptext.c - HelioFrotz Help Messages
 *
 * This file is part of HelioFrotz.
 *
 * HelioFrotz is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * HelioFrotz is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

char *how2play=""
"HOW_TO_PLAY (from the Frotz distribution)\r\r"
"The adventure games known as \"Infocom text adventures\", \"Infocom games\", or \"Z-code games\" are in the \"Z-code\" format (a machine-independent abstract machine code), which was designed by Infocom and used for all their adventure games from \"Zork I\" to \"Shogun\" (the \"Z\" in \"Z-code\" stands for \"Zork).  Infocom created six versions of this virtual machine.  Their most popular versions were \"Standard\" (version 3) and \"Advanced\"(version 5).\r\r"
"Some time after Infocom's heyday of the 1980s ended, the Z-machine was reverse-engineered and a new language called \"Inform\" was created to allow people to once again write programs for the Z-machine.\r\r"
"The Z-code games written nowadays were written using this Inform language.  These games are usually in the form of single files.  The extensions .z3 and .z5 mean that a file is a \"Z-code\" game in version 3 or version 5.  These files are not compressed, but are ordinary binary files and should be downloaded in 'binary' mode.\r\r"
"The canonical repository of freeware games which can be played on Frotz is at the Interactive Fiction Archive at\r"
"http://www.ifarchive.org.\r\r"
"(The following is borrowed from the first few pages of the manual to Lost Treasures of Infocom I)\r"
"\r"
"======================================\r"
"Communicating with Interactive Fiction\r"
"======================================\r"
"\r"
"With Interactive Fiction, you type your commands in plain English each time you see the prompt which looks like this:\r"
"\r"
">  \r"
"\r"
"Most of the sentences that the stories understand are imperative sentences.  See the examples below.\r"
"\r"
"When you have finished typing your input, press the ENTER (or RETURN) key. The story will then respond, telling you whether your request is possible at this point in the story, and what happened as a result.\r"
"\r"
"The story recognizes your words by their first six letters, and all subsequent letters are ignored.  Therefore, CANDLE, CANDLEs, and CANDLEstick would all be treated as the same word.  Most stories don't care about capitalization, so you can just type in all-lowercase if you like.\r"
"\r"
"To move around, just type the direction you want to go.  Directions can be abbreviated:  NORTH to N, SOUTH to S, EAST to E, WEST to W, NORTHEAST to NE, NORTHWEST to NW, SOUTHEAST to SE, SOUTHWEST to SW, UP to U, and DOWN to D.  IN and OUT will also work in certain places.\r"
"\r"
"There are many differnet kinds of sentences used in Interactive Fiction.  Here are some examples:\r"
"\r"
"> WALK TO THE NORTH\r"
"> WEST\r"
"> NE\r"
"> DOWN\r"
"> TAKE THE BIRDCAGE\r"
"> READ ABOUT DIMWIT FLATHEAD\r"
"> LOOK UP MEGABOZ IN THE ENCYCLOPEDIA\r"
"> LIE DOWN IN THE PINK SOFA\r"
"> EXAMINE THE SHINY COIN\r"
"> PUT THE RUSTY KEY IN THE CARDBOARD BOX\r"
"> SHOW MY BOW TIE TO THE BOUNCER\r"
"> HIT THE CRAWLING CRAB WITH THE GIANT NUTCRACKER\r"
"> ASK THE COWARDLY KIND ABOUT THE CROWN JEWELS\r"
"\r"
"You can use multiple objects with certain verbs if you separate them by the word \"AND\" or by a comma.  Here are some examples:\r"
"\r"
"> TAKE THE BOOX AND THE FROG\r"
"> DROP THE JAR OF PEANUT BUTTER, THE SPOON, AND THE LEMMING FOOD\r"
"> PUT THE EGG AND THE PENCIL IN THE CABINET\r"
"\r"
"You can include several inputs on one line if you separate them by the word \"THEN\" or by a period.  Each input will be handled in order, as though you had typed them individually at seperate prompts.  For example, you could type all of the following at once, before pressing the ENTER (or RETURN) key:\r"
"\r"
"> TURN ON THE LIGHT. TAKE THE BOOK THEN READ ABOUT THE JESTER IN THE BOOK\r"
"\r"
"If the story doesn't understand one of the sentences on your input line, or if an unusual event occurs, it will ignore the rest of your input line.\r"
"\r"
"The words \"IT\" and \"ALL\" can be very useful.  For example:\r"
"\r"
"> EXAMINE THE APPLE.  TAKE IT.  EAT IT\r"
"> CLOSE THE HEAVY METAL DOOR.  LOCK IT\r"
"> PICK UP THE GREEN BOOT.  SMELL IT.  PUT IT ON.\r"
"> TAKE ALL\r"
"> TAKE ALL THE TOOLS\r"
"> DROP ALL THE TOOLS EXCEPT THE WRENCH AND MINIATURE HAMMER\r"
"> TAKE ALL FROM THE CARTON\r"
"> GIVE ALL BUT THE RUBY SLIPPERS TO THE WICKED WITCH\r"
"\r"
"The word \"ALL\" refers to every visible object except those inside something else.  If there were an apple on the ground and an orange inside a cabinet, \"TAKE ALL\" would take the apple but not the orange.\r"
"\r"
"There are three kinds of questions you can ask:  \"WHERE IS (something)\", \"WHAT IS (something)\", and \"WHO IS (someone)\".  For example:\r"
"\r"
"> WHO IS LORD DIMWIT?\r"
"> WHAT IS A GRUE?\r"
"> WHERE IS EVERYBODY?\r"
"\r"
"When you meet intelligent creatures, you can talk to them by typing their name, then a comma, then whatever you want to say to them.  Here are some examples:\r"
"\r"
"> JESTER, HELLO\r"
"> GUSTAR WOOMAX, TELL ME ABOUT THE COCONUT\r"
"> UNCLE OTTO, GIVE ME YOUR WALLET\r"
"> HORSE, WHERE IS YOUR SADDLE?\r"
"> BOY, RUN HOME THEN CALL THE POLICE\r"
"> MIGHTY WIZARD, TAKE THIS POISONED APPLE.  EAT IT\r"
"\r"
"Notice that in the last two examples, you are giving the characters more than one command on the same input line.  Keep in mind, however, that many creatures don't care for idle chatter; your actions will speak louder than your words.  \r"
"\r"
"==============\r"
"Basic Commands\r"
"==============\r"
"\r"
"BRIEF - This command causes Frotz to fully describe a location only the first time you enter it.  On subsequent visits, only the name of the location and any objects present will be described.  Most adventures will begin in \"BRIEF\" mode and remain in \"BRIEF\" mode unless you use the \"VERBOSE\" or \"SUPERBRIEF\" commands.\r"
"\r"
"DIAGNOSE - This will give you a report of your physical condition.  Most, but not all games support this command.\r"
"\r"
"INVENTORY - This will give you a list of what you are carrying and wearing.  Usually you can abbreviate \"INVENTORY\" to \"I\".\r"
"\r"
"LOOK - This will give you a full description of your location.  You can abbreviate \"LOOK\" to 'L'.\r"
"\r"
"QUIT - This lets you stop Frotz gracefully.  If you want to save your position before quitting, you must use the \"SAVE\" command.\r"
"\r"
"RESTORE - This restores a previously saved position.\r"
"\r"
"RESTART - This stops the store and restarts it from the beginning.\r"
"\r"
"SAVE - This saves a \"snapshot\" of your current position.  You can return to a saved position in the future by using the \"RESTORE\" command.\r"
"\r"
"SCRIPT - This command tells Frotz to make a transcript of the story and save it to a file.  Transcripts can be used to aid your memory, prepare maps, prepare walkthroughs, make something to brag about, and so on.\r"
"\r"
"SCORE - This command will show your current score and often a ranking based on that score.\r"
"\r"
"SUPERBRIEF - This one causes Frotz to display only the name of a place you enter, even if you've never been there before.  In this mode, not even objects present are described.  Of course, you can get a full description of your location and the object present by typing \"LOOK\".  In \"SUPERBRIEF\" mode, the blank line between turns is eliminated.  This mode is meant for players who are already familiar with the geography.\r"
"\r"
"TIME - This gives your the current time in the story.  Some games don't have a concept of time and therefore don't have this command.\r"
"\r"
"UNSCRIPT - Stops Frotz from making a transcript.\r"
"\r"
"VERBOSE - This causes the game to give a complete description of each location and the objects in it every time you enter a location, even if you've been there before.\r"
"\r"
"VERSION - Shows you the release number and serial number of the story file.\r"
"\r"
"WAIT - Causes time in the story to pass.  Since nothing happens until you type a sentence and press RETURN, you could leave your machine, take a nap, then return to the story to find that nothing has changed.  So, to make time pass in the story, you type \"WAIT\".  For example, if you meet a wizard, you might \"WAIT\" to see if he will say anything.  If you're aboard a flying carpet, you might \"WAIT\" to see where it goes.  There are few exceptions, most notable Infocom's \"Border Zone\", in which the game is played in real-time (take too long deciding what to do and Bad Things happen).  This command can often be abbreviated to \"Z\".\r"
;

char *heliohelp=""
"HelioFrotz is a port of the Frotz interpreter to the Helio.\r\r"
"The Startup Screen:\r"
"When you start up HelioFrotz, the screen will list all Frotz files available. Just click on one and hit \"Play\" to start the game.  See the section below called \"Making ZHDBs\" for information about transferring Z-Code files from your PC to Helio.\r"
"\r"
"You can also modify the fonts used to display text inside HelioFrotz.  Use the \"Set Fixed\" button to select the font that will be used to display characters in a fixed-width font (such as the status bar or ASCII maps).  Use the \"Set Text\" button to choose a font for the normal, in-game text.  Font settings are saved between runs of HelioFrotz.  See the section called \"Making PalmPDB files\" below for information about loading Palm(tm) font files onto your Helio.\r"
"\r\r"
"In-Game Operations:\r"
"There are many ways of \"typing\" in HelioFrotz:\r"
"* Write in the Jot area\r"
"* Hit the keyboard button and screen-type\r"
"* Click on a word on-screen to \"type\" it automatically\r"
"* Use the compass on the lower right-hand corner for cardinal directions\r"
"* Use the history down-arrow on the lower right-hand corner to re-type one of your last five commands\r"
"* Use the Menu button and select from the popup list\r"
"* In a ***MORE*** screen, a tap anywhere on-screen will continue\r"
"\r"
"Shutdown Operations:\r"
"* If your Helio is shut off in the middle of a game, it will autosave a file called \"power.sav\".  Just restart the game file, then enter RESTORE, select \"power.sav\" and you should be back where you left off.\r"
"\r"
"Viewing Saved Transcripts:\r"
"Please download and install TEXTVIEW from\r"
"http://www.ziplabel.com/helio\r"
"\r\r"
"Making ZHDB Files:\r"
"* Get many free ZCODE games at:\r"
"http://www.ifarchive.org/indexes/if-archiveXgamesXzcode.html\r"
". Run MakeZHDB to convert the inform.dat file into Helio format\r"
"ex: makezhdb zork1.dat \"Zork I\" \"Frotz\" zork1.hdb\r"
"* It is important to keep the 3rd option given to makehdb as \"Frotz\".  That's how these files are detected by HelioFrotz.\r"
". Copy the resulting HDB file to your hotsync upload dir:\r"
"C:\\Program Files\\VTech\\Helio Desktop 2.0\\1\\Acc\r"
". Hotsync, and the files will be installed\r"
"\r\r"
"Making PalmPDB Font Files:\r"
". Download any Palm PDB formatted font (only 1 font per PDB is allowed)\r"
". Run MAKEZHDB with filetype as FontPDB\r"
"ex: makezhdb HKFONT.PDB \"HK Font 40x26\" \"FontPDB\" hkfont.hdb\r"
". Copy the resulting HDB file to your hotsync upload dir:\r"
"C:\\Program Files\\VTech\\Helio Desktop 2.0\\1\\Acc\r"
". Hotsync the resulting HDB file and you're set!\r"
"* Check out\r"
"http://www.rainerzenz.de/palm/alphafonts.html\r"
"for some good, free Palm fonts to try.  And get the font HKFONT from\r"
"http://www.rainerzenz.de/palm/alphafontothers.html\r"
"to play the Z-CODE abusers in 40x25 glory!\r"
"\r\r"
"Good luck, enjoy HelioFrotz!\r\r"
"Earle F. Philhower, III\r"
"earle@ziplabel.com\r"
;
