/* help.c - HelioFrotz Help Dialog
 *
 * This file is part of HelioFrotz.
 *
 * HelioFrotz is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * HelioFrotz is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <system.h>
#include <string.h>
#include "res/resource.h"
#include "frotz.h"
#include "heliofro.h"
#include "../stdlib/fnt.h"

static char *helptitle;
static char *helptext;

int DoHelp(char *title, char *text)
{
  EvtType event;

  helptitle = title;
  helptext = text;
  FormPopupForm(FORM_HELP);
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
    if (event.eventType==EVT_APP_STOP) break;
  } while (event.eventType!=EVT_FORM_CLOSE);
  if (event.eventType!=EVT_APP_STOP) FormPopupForm(FORM_IFACE);
  return event.eventType;
}


BOOLEAN FormHelpHandleEvent(EvtType *event)
{
  WORD wLineNum;
  WORD wValue;
  WORD wMaxValue;
  WORD wMinValue;
  WORD wPageSize;
  WORD wTotalNumOfLine;

  switch (event->eventType){
  case EVT_FORM_OPEN:
    if (helptitle) FormSetDialogTitle(FORM_HELP, helptitle);
    ScrollbarInitScrollbar(SCROLLBAR_HELP);
    FieldInitField(FIELD_HELP);
    if (helptext) FieldSetText(FIELD_HELP, helptext);
    FieldSetTopLineNum(FIELD_HELP, 0);
    FieldGetTotalNumOfLines(FIELD_HELP, &wLineNum);
    ScrollbarSetScrollbar(SCROLLBAR_HELP, 0, max(wLineNum - 13,13), 0, 13, wLineNum);
    ScrollbarSetScrollbarDrawPagesize(SCROLLBAR_HELP, 13);
    FormDrawForm(FORM_HELP);
    break;

  case EVT_MENU_SELECT_ITEM:
    if (event->para1==0) FieldCopy(FIELD_HELP);
    break;

  case EVT_CONTROL_SELECT:	
    if (event->eventID == BUTTON_HELP) {	
      FormRestoreBitBehind(FORM_HELP);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_HELP, 0, 0, NULL);
      return TRUE;
    }
    break;

  case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_OK:
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormRestoreBitBehind(FORM_HELP);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_HELP, 0, 0, NULL);
      break;
    }
    break;

  case EVT_SCROLLBAR_REPEAT:
  case EVT_SCROLLBAR_SELECT:
    ScrollbarGetScrollbar(SCROLLBAR_HELP, &wValue, &wMaxValue, &wMinValue,
    			  &wPageSize, &wTotalNumOfLine);
    ScrollbarSetScrollbar(SCROLLBAR_HELP, event->para2, wMaxValue, wMinValue,
    			  wPageSize, wTotalNumOfLine);
    ScrollbarDrawScrollbar(SCROLLBAR_HELP);
    
    FieldSetTopLineNum(FIELD_HELP, wValue);
    FieldDrawField(FIELD_HELP);
    break;
			
  default:
    return FALSE;
  }
  return TRUE;
}
