/* compass.c - HelioFrotz Compass Dialog
 *
 * This file is part of HelioFrotz.
 *
 * HelioFrotz is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * HelioFrotz is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <system.h>
#include <string.h>
#include "res/resource.h"
#include "frotz.h"
#include "heliofro.h"
#include "../stdlib/fnt.h"

static char *strsave;


int DoCompass(char *buff)
{
  EvtType event;

  strsave = buff;
  FormPopupForm(FORM_COMPASS);
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
    if (event.eventType==EVT_APP_STOP)  {PowerOff();break;}
  } while (event.eventType!=EVT_FORM_CLOSE);
  if (event.eventType!=EVT_APP_STOP) FormPopupForm(FORM_MAIN);
  return event.eventType;
}

BOOLEAN FormCompassHandleEvent(EvtType* Event)
{
  char *inject;

  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    FormSaveBehindBits(FORM_COMPASS);
    FormDrawForm(FORM_COMPASS);
    break;

  case EVT_CONTROL_SELECT:
    switch (Event->eventID) {
    case 11: inject=NULL; break; // Cancel
    case 12: inject = "Northwest|"; break;
    case 13: inject = "North|"; break;
    case 14: inject = "Northeast|"; break;
    case 15: inject = "West|"; break;
    case 16: inject = "Enter "; break;
    case 17: inject = "East|"; break;
    case 18: inject = "Southwest|"; break;
    case 19: inject = "South|"; break;
    case 20: inject = "Southeast|"; break;
    case 21: inject = "Up|"; break;
    case 22: inject = "Down|"; break;
    default: inject = NULL; break;
    }
    if (inject) {
      if (strsave[strlen(strsave)-1]!=' ' && strlen(strsave)>0) strcat(strsave," ");
      strcat(strsave, inject);
      FntBeep();
    }
    FormRestoreBitBehind(FORM_COMPASS);
    EvtAppendEvt(EVT_FORM_CLOSE, FORM_COMPASS, 0, 0, NULL);
    break;

  default:
    return FALSE;
  }
  return FALSE;
}
