/*
	Frostz.cpp : Defines the entry point for the application.
	Copyright (C) 2005 Fabio Concas

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file COPYING.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/


#include "StdAfx.h"

#include "Frostz.h"

extern "C" {
	#include "Frotz/Frotz.h"
}



static SHACTIVATEINFO s_sai;
static short oldOrientation;
static unsigned long oldDisplayOrientation;



FrostzApp Application;



// Blind users don't need gfx, nor a status line.
extern "C" {
	char cBlindMode = 0;
}



//****************************************************************************
//		About
//	Dialog Box event handling procedure
//****************************************************************************
LRESULT CALLBACK DlgAbout (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	HWND hFrame = GetDlgItem (hDlg, IDC_GAMEICON);
	HWND hIntFrame = GetDlgItem (hDlg, IDC_INTERPBMP);
	HDC hdc;
	PAINTSTRUCT ps;
	SHINITDLGINFO shidi;
	unsigned short wStoryName[64];
	unsigned short wGameInfo[1024];
	unsigned short wInterpName[256];
	static int BmpId = IDB_FROSTZ;
	static int IntBmpId = IDB_IBM_PC;

	switch (message)
	{	
		case WM_DESTROY:
			Application.GoFullScreen ();
			break;

		case WM_INITDIALOG:
			shidi.dwMask = SHIDIM_FLAGS;
			shidi.dwFlags = SHIDIF_SIZEDLGFULLSCREEN;
			shidi.hDlg = hDlg;
			SHInitDialog (&shidi);

			// Write something on the static text dlg items
			if (!Application.isZmachineRunning)
			{
				wsprintf (wGameInfo, L"No story loaded.");
				BmpId = IDB_FROSTZ;

				wsprintf (wInterpName, L"\0");
				IntBmpId = 0;
				ShowWindow (hIntFrame, SW_HIDE);
			}
			else
			{
				unsigned short wSerial[16];
				memset (wSerial, 0, sizeof (unsigned short) * 16);
				mbstowcs (wSerial, (const char*)h_serial, 16);

				GetWindowText (Application.GetMainWnd (), wStoryName, 64);
				wsprintf (wGameInfo, L"\"%s\"\nRelease: %d\nSerial: %s\nZ-Code V%d (Std %d.%d)",
					wStoryName, h_release, wSerial, h_version, h_standard_high, h_standard_low);
				// Choose the right image for the story
				if (!wcsncmp (wStoryName, L"Advent", 6)) // Colossal Cave Adventure
					BmpId = IDB_ADVENT;
				else if (!wcsncmp (wStoryName, L"A mind", 6)) // A Mind Forever Voyaging
					BmpId = IDB_AMFV;
				else if (!wcsncmp (wStoryName, L"Arthur", 6)) // Arthur - Quest for Excalibur
					BmpId = IDB_ARTHUR;
				else if (!wcsncmp (wStoryName, L"Ballyh", 6)) // Ballyhoo
					BmpId = IDB_BALLY;
				else if (!wcsncmp (wStoryName, L"Beyond", 6)) // Beyond Zork
					BmpId = IDB_BZORK;
				else if (!wcsncmp (wStoryName, L"Border", 6)) // Border Zone
					BmpId = IDB_BORDERZ;
				else if (!wcsncmp (wStoryName, L"Bureau", 6)) // Bureaucracy
					BmpId = IDB_BUREAU;
				else if (!wcsncmp (wStoryName, L"Cutthr", 6)) // Cuttrhoats
					BmpId = IDB_CUTTHROA;
				else if (!wcsncmp (wStoryName, L"Deadli", 6)) // Deadline
					BmpId = IDB_DEAD;
				else if (!wcsncmp (wStoryName, L"Enchan", 6)) // Enchanter
					BmpId = IDB_ENCHANT;
				else if (!wcsncmp (wStoryName, L"HitchH", 6)) // HitchHiker's Guide to the Galaxy
					BmpId = IDB_HITCH;
				else if (!wcsncmp (wStoryName, L"Hollyw", 6)) // Hollywood Hijinks
					BmpId = IDB_HOLLY;
				else if (!wcsncmp (wStoryName, L"Infide", 6)) // Infidel
					BmpId = IDB_INFIDEL;
				else if (!wcsncmp (wStoryName, L"Journe", 6)) // Journey
					BmpId = IDB_JOURNEY;
				else if (!wcsncmp (wStoryName, L"Leathe", 6)) // Leather Goddesses Of Phobos
					BmpId = IDB_LEATHER;
				else if (!wcsncmp (wStoryName, L"Lurkin", 6)) // Lurking Horror
					BmpId = IDB_LURKING;
				else if (!wcsncmp (wStoryName, L"Mini-Z", 6)) // Mini-Zork I
					BmpId = IDB_ZORK1;
				else if (!wcsncmp (wStoryName, L"Moonmi", 6)) // Moonmist
					BmpId = IDB_MOON;
				else if (!wcsncmp (wStoryName, L"Nord a", 6)) // Nord and Bert
					BmpId = IDB_NORDANDB;
				else if (!wcsncmp (wStoryName, L"Planetf", 7)) // Planetfall
					BmpId = IDB_PLANETF;
				else if (!wcsncmp (wStoryName, L"Plunde", 6)) // Plundered Hearts
					BmpId = IDB_PLUNDER;
				else if (!wcsncmp (wStoryName, L"Seasta", 6)) // Seastalker
					BmpId = IDB_SEASTALK;
				else if (!wcsncmp (wStoryName, L"Sherlo", 6)) // Sherlock - Riddle of the Crown Jewels
					BmpId = IDB_SHERLOCK;
				else if (!wcsncmp (wStoryName, L"Shogun", 6)) // Shogun
					BmpId = IDB_SHOGUN;
				else if (!wcsncmp (wStoryName, L"Sorcer", 6)) // Sorcerer
					BmpId = IDB_SORCERER;
				else if (!wcsncmp (wStoryName, L"Spellb", 6)) // Spellbreaker
					BmpId = IDB_SPELLBR;
				else if (!wcsncmp (wStoryName, L"Starcr", 6)) // Starcross
					BmpId = IDB_STARCR;
				else if (!wcsncmp (wStoryName, L"Statio", 6)) // Stationfall
					BmpId = IDB_STATIONF;
				else if (!wcsncmp (wStoryName, L"Suspec", 6)) // Suspect
					BmpId = IDB_SUSPECT;
				else if (!wcsncmp (wStoryName, L"Suspen", 6)) // Suspended
					BmpId = IDB_SUSPEND;
				else if (!wcsncmp (wStoryName, L"Trinit", 6)) // Trinity
					BmpId = IDB_TRINITY;
				else if (!wcsncmp (wStoryName, L"Wishbr", 6)) // Wishbringer
					BmpId = IDB_WISHBRING;
				else if (!wcsncmp (wStoryName, L"Witnes", 6)) // Witness
					BmpId = IDB_WITNESS;
				else if (!wcsncmp (wStoryName, L"Zork III", 8)) // Zork III - Dungeon Master
					BmpId = IDB_ZORK3;
				else if (!wcsncmp (wStoryName, L"Zork II", 7)) // Zork II - Wizard of Frobozz
					BmpId = IDB_ZORK2;
				else if (!wcsncmp (wStoryName, L"Zork I", 6)) // Zork I - Great Underground Empire
					BmpId = IDB_ZORK1;
				else if (!wcsncmp (wStoryName, L"Zork -", 6)) // Zork - Undiscovered Underground
					BmpId = IDB_ZORKUU;
				else if (!wcsncmp (wStoryName, L"Zork Z", 6)) // Zork Zero - Revenge of Megaboz
					BmpId = IDB_ZORK0;
				else
					BmpId = IDB_FROSTZ;

				//*** Now interpreter info and picture ***
				ShowWindow (hIntFrame, SW_SHOW);
				if (Application.InterpreterNumber == INTERP_DEC_20)
				{
					wcscpy (wInterpName, L"DECSystem 20 Interpreter");
					IntBmpId = IDB_DECSYSTEM_20;
				}
				else if (Application.InterpreterNumber == INTERP_APPLE_IIE)
				{
					wcscpy (wInterpName, L"Apple //e Interpreter");
					IntBmpId = IDB_APPLE_IIE;
				}
				else if (Application.InterpreterNumber == INTERP_MACINTOSH)
				{
					wcscpy (wInterpName, L"Macintosh Interpreter");
					IntBmpId = IDB_MACINTOSH;
				}
				else if (Application.InterpreterNumber == INTERP_AMIGA)
				{
					wcscpy (wInterpName, L"Commodore Amiga Interpreter");
					IntBmpId = IDB_AMIGA;
				}
				else if (Application.InterpreterNumber == INTERP_ATARI_ST)
				{
					wcscpy (wInterpName, L"Atari ST Interpreter");
					IntBmpId = IDB_ATARI_ST;
				}
				else if (Application.InterpreterNumber == INTERP_MSDOS)
				{
					wcscpy (wInterpName, L"IBM PC MS/DOS Interpreter");
					IntBmpId = IDB_IBM_PC;
				}
				else if (Application.InterpreterNumber == INTERP_CBM_128)
				{
					wcscpy (wInterpName, L"Commodore 128 Interpreter");
					IntBmpId = IDB_CBM_128;
				}
				else if (Application.InterpreterNumber == INTERP_CBM_64)
				{
					wcscpy (wInterpName, L"Commodore 64 Interpreter");
					IntBmpId = IDB_CBM_64;
				}
				else if (Application.InterpreterNumber == INTERP_APPLE_IIC)
				{
					wcscpy (wInterpName, L"Apple //c Interpreter");
					IntBmpId = IDB_APPLE_IIC;
				}
				else if (Application.InterpreterNumber == INTERP_APPLE_IIGS)
				{
					wcscpy (wInterpName, L"Apple //gs Interpreter");
					IntBmpId = IDB_APPLE_IIGS;
				}
				else if (Application.InterpreterNumber == INTERP_TANDY)
				{
					wcscpy (wInterpName, L"Tandy Color Interpreter");
					IntBmpId = IDB_TANDY_COLOR;
				}
				else
				{
					wcscpy (wInterpName, L"Unknown Interpreter");
					IntBmpId = 0;
					ShowWindow (hIntFrame, SW_HIDE);
				}

			}

			SetDlgItemText (hDlg, IDC_GAMEINFO, wGameInfo);
			SetDlgItemText (hDlg, IDC_TXT_INTERP, wInterpName);
			return TRUE;

		case WM_PAINT:
			{
				hdc = BeginPaint (hFrame, &ps);

				// Change bitmap icon if a story is loaded
				HBITMAP hBMP = LoadBitmap(Application.GetAppInstance (),
					MAKEINTRESOURCE(BmpId));

				HDC hdcMem = CreateCompatibleDC (NULL);
				HBITMAP hOldBmp = (HBITMAP)SelectObject (hdcMem, hBMP);

				BitBlt (hdc, 0, 0, 32, 32, hdcMem, 0, 0, SRCCOPY);

				SelectObject (hdcMem, hOldBmp);
				DeleteObject (hBMP);
				DeleteDC (hdcMem);

				EndPaint (hFrame, &ps);
			}
				//*** Paint another bitmap for the interpreter
			if (IntBmpId)
			{
				hdc = BeginPaint (hIntFrame, &ps);

				HBITMAP hBMP = LoadBitmap (Application.GetAppInstance (),
					MAKEINTRESOURCE (IntBmpId));
				HDC hdcMem = CreateCompatibleDC (NULL);
				HBITMAP hOldBmp = (HBITMAP)SelectObject (hdcMem, hBMP);

				BitBlt (hdc, 0, 0, 48, 48, hdcMem, 0, 0, SRCCOPY);
				SelectObject (hdcMem, hOldBmp);
				DeleteObject (hBMP);
				DeleteDC (hdcMem);

				EndPaint (hIntFrame, &ps);
			}
			break;

		case WM_COMMAND:
			if (LOWORD (wParam) == IDOK)
			{
				EndDialog (hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}



//****************************************************************************
//		DlgMacros
//	Dialog Box event handling procedure
//****************************************************************************
LRESULT CALLBACK DlgMacros (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	SHINITDLGINFO shidi;

	switch (message)
	{	
		case WM_DESTROY:
			Application.GoFullScreen ();
			break;

		case WM_INITDIALOG:
			shidi.dwMask = SHIDIM_FLAGS;
			shidi.dwFlags = SHIDIF_SIZEDLGFULLSCREEN;
			shidi.hDlg = hDlg;
			SHInitDialog (&shidi);
			// Add macros to the listbox
			{
				HWND hNameList = GetDlgItem (hDlg, IDC_MACROLIST);
				HWND hActionList = GetDlgItem (hDlg, IDC_ACTIONLIST);
				HWND hNLList = GetDlgItem (hDlg, IDC_NL_LIST);

				for (unsigned int Cnt = 0; Cnt < MAX_MACROS; ++Cnt)
					if (Application.Macros[Cnt].isDefined)
					{
						TCHAR wNLStyle[2];
						switch (Application.Macros[Cnt].nlStyle)
						{
							case 2:
								wcscpy (wNLStyle, L"2");
								break;
							case 1:
								wcscpy (wNLStyle, L"1");
								break;
							case 0:
							default:
								wcscpy (wNLStyle, L"0");
								break;
						}

						SendMessage (hNameList, LB_ADDSTRING, 0,
							(LPARAM)Application.Macros[Cnt].wName);
						SendMessage (hActionList, LB_ADDSTRING, 0,
							(LPARAM)Application.Macros[Cnt].wAction);
						SendMessage (hNLList, LB_ADDSTRING, 0,
							(LPARAM)wNLStyle);
					}
			}
			return TRUE;

		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDC_MACROLIST:		// A macro is selected from the list
					{
						HWND hNameList = GetDlgItem (hDlg, IDC_MACROLIST);
						HWND hActionList = GetDlgItem (hDlg, IDC_ACTIONLIST);
						HWND hNLList = GetDlgItem (hDlg, IDC_NL_LIST);
						HWND hNoNL = GetDlgItem (hDlg, IDC_NL_NONL);
						HWND hImmNL = GetDlgItem (hDlg, IDC_NL_IMMEDIATE);
						HWND hAftNL = GetDlgItem (hDlg, IDC_NL_AFTER);

						// Get currently selected item index
						short CurSel = (short)SendMessage (hNameList, LB_GETCURSEL, 0, 0);
						if (CurSel != LB_ERR)
						{
							unsigned short wBuffer[32];

							SendMessage (hNameList, LB_GETTEXT, (WPARAM)CurSel,
								(LPARAM)wBuffer);
							SetDlgItemText (hDlg, IDC_MACRONAME, wBuffer);

							SendMessage (hActionList, LB_GETTEXT, (WPARAM)CurSel,
								(LPARAM)wBuffer);
							SetDlgItemText (hDlg, IDC_MACROACTION, wBuffer);

							SendMessage (hNLList, LB_GETTEXT, (WPARAM)CurSel,
								(LPARAM)wBuffer);
							switch (wBuffer[0])
							{
								case _T('2'):
									SendMessage (hAftNL, BM_SETCHECK, (WPARAM)BST_CHECKED, 0);
									SendMessage (hImmNL, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
									SendMessage (hNoNL, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
									break;
								case _T('1'):
									SendMessage (hAftNL, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
									SendMessage (hImmNL, BM_SETCHECK, (WPARAM)BST_CHECKED, 0);
									SendMessage (hNoNL, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
									break;
								case _T('0'):
								default:
									SendMessage (hAftNL, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
									SendMessage (hImmNL, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
									SendMessage (hNoNL, BM_SETCHECK, (WPARAM)BST_CHECKED, 0);
									break;
							}
						}
					}
					break;

				case ID_MACRODELETE:
					{
						HWND hNameList = GetDlgItem (hDlg, IDC_MACROLIST);
						HWND hActionList = GetDlgItem (hDlg, IDC_ACTIONLIST);
						HWND hNLList = GetDlgItem (hDlg, IDC_NL_LIST);

						short CurSel = (short)SendMessage (hNameList, LB_GETCURSEL, 0, 0);
						if (CurSel != LB_ERR)
						{
							// Delete currently selected item from all lists
							SendMessage (hNameList, LB_DELETESTRING, CurSel, 0);
							SendMessage (hActionList, LB_DELETESTRING, CurSel, 0);
							SendMessage (hNLList, LB_DELETESTRING, CurSel, 0);
						}
						else
							MessageBeep (MB_ICONSTOP);
					}
					break;

				case ID_MACROADD:
					{
						HWND hNameList = GetDlgItem (hDlg, IDC_MACROLIST);
						HWND hActionList = GetDlgItem (hDlg, IDC_ACTIONLIST);
						HWND hNLList = GetDlgItem (hDlg, IDC_NL_LIST);
						HWND hImmNL = GetDlgItem (hDlg, IDC_NL_IMMEDIATE);
						HWND hAftNL = GetDlgItem (hDlg, IDC_NL_AFTER);

						// Check if there are already MAX_MACROS macros in the list
						if (LB_ERR != SendMessage (hNameList, LB_GETTEXTLEN, MAX_MACROS - 1, 0))
							MessageBeep (MB_ICONSTOP);
						else
						{
							unsigned short wName[32], wAction[32], wNLStyle[2];

							// Check if a name AND an action have been specified
							if (GetDlgItemText (hDlg, IDC_MACRONAME, wName, 32) > 0
								&&
								GetDlgItemText (hDlg, IDC_MACROACTION, wAction, 32) > 0)
							{
								// All ok, add macro to the lists
								SendMessage (hNameList, LB_ADDSTRING, 0, (LPARAM)wName);
								SendMessage (hActionList, LB_ADDSTRING, 0, (LPARAM)wAction);
								// See which radio button is checked
								if (SendMessage (hAftNL, BM_GETCHECK, 0, 0) == BST_CHECKED)
									wcscpy (wNLStyle, L"2");
								else if (SendMessage (hImmNL, BM_GETCHECK, 0, 0) == BST_CHECKED)
									wcscpy (wNLStyle, L"1");
								else
									wcscpy (wNLStyle, L"0");
								SendMessage (hNLList, LB_ADDSTRING, 0, (LPARAM)wNLStyle);
							}
							else
								MessageBeep (MB_ICONSTOP);
						}
					}
					break;

				case ID_CANCEL:
					// Quit without updating macros
					EndDialog (hDlg, LOWORD(wParam));
					return TRUE;

				case IDOK:
					// Update Macros
					{
						HWND hNameList = GetDlgItem (hDlg, IDC_MACROLIST);
						HWND hActionList = GetDlgItem (hDlg, IDC_ACTIONLIST);
						HWND hNLList = GetDlgItem (hDlg, IDC_NL_LIST);
						unsigned short wBuffer[32];
						long Ret;

						if (hNameList && hActionList)
						for (unsigned short Cnt = 0; Cnt < MAX_MACROS; ++Cnt)
						{
							// Get text of next item in the names list
							wBuffer[0] = (unsigned short)0;
							Ret = SendMessage (hNameList, LB_GETTEXT, (WPARAM)Cnt,
								(LPARAM)wBuffer);
							if (Ret == LB_ERR)
							{
								// There's no item with that index, so make this macro undefined
								Application.Macros[Cnt].isDefined = false;
								Application.Macros[Cnt].wName[0] = (unsigned short)0;
								Application.Macros[Cnt].nlStyle = 0;
							}
							else
							{
								// All ok, write macro data
								Application.Macros[Cnt].isDefined = true;
								wcscpy (Application.Macros[Cnt].wName, wBuffer);
								SendMessage (hActionList, LB_GETTEXT, (WPARAM)Cnt,
									(LPARAM)wBuffer);
								wcscpy (Application.Macros[Cnt].wAction, wBuffer);
								SendMessage (hNLList, LB_GETTEXT, (WPARAM)Cnt,
									(LPARAM)wBuffer);
								switch (wBuffer[0])
								{
									case _T('2'):
										Application.Macros[Cnt].nlStyle = 2;
										break;
									case _T('1'):
										Application.Macros[Cnt].nlStyle = 1;
										break;
									case _T('0'):
									default:
										Application.Macros[Cnt].nlStyle = 0;
										break;
								}
							}
						}

						Application.UpdateMacros ();
					}

					EndDialog (hDlg, LOWORD(wParam));
					return TRUE;
			}
			break;
	}
    return FALSE;
}



//****************************************************************************
//		WndProc
//	Event handling procedure
//****************************************************************************
#pragma warning ( disable : 4101 )
LRESULT CALLBACK WndProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;

	switch (message)
	{
		case WM_COMMAND:
		{
			HMENU hMenu;
			DWORD Ret, Val;

			wmId    = LOWORD(wParam);
			wmEvent = HIWORD(wParam);

#define GetOptionsMenu()	hMenu = (HMENU)SendMessage (SHFindMenuBar (hWnd), SHCMBM_GETSUBMENU, (WPARAM)0, (LPARAM)ID_MENU_OPTIONS);
#define GetGameFileMenu()	hMenu = (HMENU)SendMessage (SHFindMenuBar (hWnd), SHCMBM_GETSUBMENU, (WPARAM)0, (LPARAM)ID_GAMEMENU_FILE);

			switch (wmId)
			{
				case ID_MENU_LOADSTORY:
					Application.OnStoryOpen ();
					break;

				case ID_MENU_TIMER125:
					if (Application.UpdateTimerMs != 125)
					{
						Application.UpdateTimerMs = 125;
						GetOptionsMenu();
						CheckMenuItem (hMenu, ID_MENU_TIMER125, MF_BYCOMMAND | MF_CHECKED);
						CheckMenuItem (hMenu, ID_MENU_TIMER250, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_TIMER500, MF_BYCOMMAND | MF_UNCHECKED);
					}
					break;

				case ID_MENU_TIMER250:
					if (Application.UpdateTimerMs != FROSTZ_UPDATE_MS)
					{
						Application.UpdateTimerMs = FROSTZ_UPDATE_MS;
						GetOptionsMenu();
						CheckMenuItem (hMenu, ID_MENU_TIMER125, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_TIMER250, MF_BYCOMMAND | MF_CHECKED);
						CheckMenuItem (hMenu, ID_MENU_TIMER500, MF_BYCOMMAND | MF_UNCHECKED);
					}
					break;

				case ID_MENU_TIMER500:
					if (Application.UpdateTimerMs != 500)
					{
						Application.UpdateTimerMs = 500;
						GetOptionsMenu();
						CheckMenuItem (hMenu, ID_MENU_TIMER125, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_TIMER250, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_TIMER500, MF_BYCOMMAND | MF_CHECKED);
					}
					break;

				case BASE_MRU_ID:
				case BASE_MRU_ID + 1:
				case BASE_MRU_ID + 2:
				case BASE_MRU_ID + 3:
					Application.OnLoadRecent (wmId - BASE_MRU_ID);
					break;

				case ID_MENU_CLRMRU:
					Application.ClearMRUList ();
					break;

				case ID_MENU_EXIT:
				case ID_GAMEMENU_QUITAPP:
					if (Application.isZmachineRunning)
						os_reset_screen ();
					SendMessage (hWnd, WM_DESTROY, 0, 0);
					break;

				case ID_IGNORERTERRORS:
					Application.ignore_errors = (Application.ignore_errors != 0)?
						0 : 1;
					Val = (Application.ignore_errors != 0)? MF_CHECKED : MF_UNCHECKED;
					GetOptionsMenu();
					Ret = CheckMenuItem (hMenu, ID_IGNORERTERRORS, MF_BYCOMMAND | Val);
					break;


				case ID_MENU_EXPAND:
					Application.expand_abbreviations = (Application.expand_abbreviations != 0)?
						0 : 1;
					Val = (Application.expand_abbreviations != 0)? MF_CHECKED : MF_UNCHECKED;
					GetOptionsMenu();
					Ret = CheckMenuItem (hMenu, ID_MENU_EXPAND, MF_BYCOMMAND | Val);
					break;

				case ID_MENU_TANDY:
					Application.TandyBit = !Application.TandyBit;
					Val = Application.TandyBit? MF_CHECKED : MF_UNCHECKED;
					GetOptionsMenu();
					Ret = CheckMenuItem (hMenu, ID_MENU_TANDY, MF_BYCOMMAND | Val);
					break;

				case ID_MENU_TEXTSTYLES:
					Application.UseStyles = !Application.UseStyles;
					Val = Application.UseStyles? MF_CHECKED : MF_UNCHECKED;
					GetOptionsMenu();
					Ret = CheckMenuItem (hMenu, ID_MENU_TEXTSTYLES, MF_BYCOMMAND | Val);
					break;

				case ID_MENU_INT_DEC20:
					Application.InterpreterNumber = INTERP_DEC_20;
					Application.UpdateMenuItems ();
					break;

				case ID_MENU_INT_APPLE2E:
					Application.InterpreterNumber = INTERP_APPLE_IIE;
					Application.UpdateMenuItems ();
					break;

				case ID_MENU_INT_MAC:
					Application.InterpreterNumber = INTERP_MACINTOSH;
					Application.UpdateMenuItems ();
					break;

				case ID_MENU_INT_AMIGA:
					Application.InterpreterNumber = INTERP_AMIGA;
					Application.UpdateMenuItems ();
					break;

				case ID_MENU_INT_ATARIST:
					Application.InterpreterNumber = INTERP_ATARI_ST;
					Application.UpdateMenuItems ();
					break;

				case ID_MENU_INT_MSDOS:
					Application.InterpreterNumber = INTERP_MSDOS;
					Application.UpdateMenuItems ();
					break;

				case ID_MENU_INT_C128:
					Application.InterpreterNumber = INTERP_CBM_128;
					Application.UpdateMenuItems ();
					break;

				case ID_MENU_INT_C64:
					Application.InterpreterNumber = INTERP_CBM_64;
					Application.UpdateMenuItems ();
					break;

				case ID_MENU_INT_APPLE2C:
					Application.InterpreterNumber = INTERP_APPLE_IIC;
					Application.UpdateMenuItems ();
					/*if (Application.UseColours)
					{
						MessageBox (hWnd, L"This interpreter should be used without colors.\nThe option will be automaticcaly switched off.",
							L"Frostz", MB_ICONEXCLAMATION);
						GetOptionsMenu();
						CheckMenuItem (hMenu, ID_MENU_USECOLORS, MF_BYCOMMAND | MF_UNCHECKED);
						Application.UseColours = false;
						Application.GoFullScreen ();
						return TRUE;
					}*/
					break;

				case ID_MENU_INT_APPLE2GS:
					Application.InterpreterNumber = INTERP_APPLE_IIGS;
					Application.UpdateMenuItems ();
					/*
					if (Application.UseColours)
					{
						MessageBox (hWnd, L"This interpreter should be used without colors.\nThe option will be automaticcaly switched off.",
							L"Frostz", MB_ICONEXCLAMATION);
						GetOptionsMenu();
						CheckMenuItem (hMenu, ID_MENU_USECOLORS, MF_BYCOMMAND | MF_UNCHECKED);
						Application.UseColours = false;
						Application.GoFullScreen ();
						return TRUE;
					}
					*/
					break;

				case ID_MENU_INT_TANDY:
					Application.InterpreterNumber = INTERP_TANDY;
					Application.UpdateMenuItems ();
					if (!Application.TandyBit)
						if (MessageBox (Application.hWnd, L"Do you want to set the Tandy Bit?",
							L"Frostz", MB_YESNO) == IDYES)
						{
							GetOptionsMenu();
							CheckMenuItem (hMenu, ID_MENU_TANDY, MF_BYCOMMAND | MF_CHECKED);
							Application.TandyBit = true;
						}
						Application.GoFullScreen ();
					break;

				case ID_MENU_SIMCBM:
					Application.SimulateCBM = !Application.SimulateCBM;
					Val = Application.SimulateCBM? MF_CHECKED : MF_UNCHECKED;
					GetOptionsMenu();
					Ret = CheckMenuItem (hMenu, ID_MENU_SIMCBM, MF_BYCOMMAND | Val);
					break;

				case ID_MENU_6x10:
					if (Application.FontHeight != 10)
					{
						GetOptionsMenu ();
						Application.FontWidth = 6;
						Application.FontHeight = 10;
						CheckMenuItem (hMenu, ID_MENU_6x10, MF_BYCOMMAND | MF_CHECKED);
						CheckMenuItem (hMenu, ID_MENU_8x12, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_4x11, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_4x8, MF_BYCOMMAND | MF_UNCHECKED);
					}
					break;

				case ID_MENU_8x12:
					if (Application.FontHeight != 12)
					{
						GetOptionsMenu();
						Application.FontWidth = 8;
						Application.FontHeight = 12;
						CheckMenuItem (hMenu, ID_MENU_6x10, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_8x12, MF_BYCOMMAND | MF_CHECKED);
						CheckMenuItem (hMenu, ID_MENU_4x11, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_4x8, MF_BYCOMMAND | MF_UNCHECKED);
					}
					break;

				case ID_MENU_4x11:
					if (Application.FontHeight != 11)
					{
						GetOptionsMenu();
						Application.FontWidth = 4;
						Application.FontHeight = 11;
						CheckMenuItem (hMenu, ID_MENU_6x10, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_8x12, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_4x11, MF_BYCOMMAND | MF_CHECKED);
						CheckMenuItem (hMenu, ID_MENU_4x8, MF_BYCOMMAND | MF_UNCHECKED);
					}
					break;

				case ID_MENU_4x8:
					if (Application.FontHeight != 8)
					{
						GetOptionsMenu();
						Application.FontWidth = 4;
						Application.FontHeight = 8;
						CheckMenuItem (hMenu, ID_MENU_6x10, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_8x12, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_4x11, MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem (hMenu, ID_MENU_4x8, MF_BYCOMMAND | MF_CHECKED);
					}
					break;

				case ID_EMPH_BOLD:
					Application.bUnderline = false;
					GetOptionsMenu();
					CheckMenuItem (hMenu, ID_EMPH_BOLD, MF_BYCOMMAND | MF_CHECKED);
					CheckMenuItem (hMenu, ID_EMPH_UNDERL, MF_BYCOMMAND | MF_UNCHECKED);
					break;

				case ID_EMPH_UNDERL:
					Application.bUnderline = true;
					GetOptionsMenu();
					CheckMenuItem (hMenu, ID_EMPH_BOLD, MF_BYCOMMAND | MF_UNCHECKED);
					CheckMenuItem (hMenu, ID_EMPH_UNDERL, MF_BYCOMMAND | MF_CHECKED);
					break;

				case ID_MENU_USECOLORS:
					Application.UseColours = !Application.UseColours;
					Val = Application.UseColours? MF_CHECKED : MF_UNCHECKED;
					GetOptionsMenu();
					Ret = CheckMenuItem (hMenu, ID_MENU_USECOLORS, MF_BYCOMMAND | Val);
					break;

				case ID_MENU_SOUND:
					Application.UseSounds = !Application.UseSounds;
					Val = Application.UseSounds? MF_CHECKED : MF_UNCHECKED;
					GetOptionsMenu();
					Ret = CheckMenuItem (hMenu, ID_MENU_SOUND, MF_BYCOMMAND | Val);
					break;

				case ID_MENU_BLINDMODE:
					cBlindMode = cBlindMode? 0 : 1;
					Val = cBlindMode? MF_CHECKED : MF_UNCHECKED;
					GetOptionsMenu();
					Ret = CheckMenuItem (hMenu, ID_MENU_BLINDMODE, MF_BYCOMMAND | Val);
					// Show/Hide SIP too
					SipShowIM (cBlindMode? SIPF_OFF : SIPF_ON);
					Application.ClientRect.bottom = cBlindMode? 303 : 215;
					Application.GoFullScreen ();
					break;

				case ID_MENU_ABOUT:
				case ID_GAMEMENU_ABOUT:
					DialogBox (Application.hInstance, MAKEINTRESOURCE (IDD_ABOUT), hWnd, (DLGPROC)DlgAbout);
					break;

				case ID_MENU_TOGGLESIP:
					Application.bShowSip = !Application.bShowSip;
					SipShowIM ((Application.bShowSip && !cBlindMode)? SIPF_ON : SIPF_OFF);
					//MessageBox (GetActiveWindow (), L"Sip toggled", L"DEBUG", MB_ICONINFORMATION);
					Application.ClientRect.bottom =
						(Application.bShowSip && !cBlindMode)? 215 : 303;
					Application.GoFullScreen ();
					break;

				case ID_GAMEMENU_EDITMACROS:
					DialogBox (Application.hInstance, MAKEINTRESOURCE (IDD_MACROS), hWnd, (DLGPROC)DlgMacros);
					break;

				case ID_GAMEMENU_COMPASS:
					Application.ShowCompass = !Application.ShowCompass;
					Val = Application.ShowCompass? MF_CHECKED : MF_UNCHECKED;
					GetGameFileMenu();
					Ret = CheckMenuItem (hMenu, ID_GAMEMENU_COMPASS, MF_BYCOMMAND | Val);
					// Redraw area
					{
						RECT Rect = { 180, 20, 229, 69 };
						InvalidateRect (Application.hWnd, &Rect, true);
					}
					break;

				case ID_GAMEMENU_RESUME:
					if (Application.ExpectingInput)
						Application.StuffKeyboard ("Restore", true, true);
					break;

				case ID_GAMEMENU_SAVE:
					if (Application.ExpectingInput)
						Application.StuffKeyboard ("Save", true, true);
					break;

				case ID_GAMEMENU_RESTART:
					if (Application.ExpectingInput)
						Application.StuffKeyboard ("Restart", true, true);
					break;
					
				case ID_GAMEMENU_QUITSTORY:
					if (Application.ExpectingInput)
						Application.StuffKeyboard ("Quit", true, true);
					break;

				case ID_GAMEMENU_UNDO:
					if (Application.ExpectingInput)
						Application.OnUndo ();
					break;

				case ID_GAMEMENU_LOOK:
					if (Application.ExpectingInput)
					{
						Application.State = STATE_LOOKING;
						Application.StuffKeyboard ("Look ", false, true);
					}
					break;

				case ID_GAMEMENU_LOOKAT:
					if (Application.ExpectingInput)
					{
						Application.State = STATE_LOOKING;
						Application.StuffKeyboard ("Look at ", false, true);
					}
					break;

				case ID_GAMEMENU_LOOKIN:
					if (Application.ExpectingInput)
					{
						Application.State = STATE_LOOKING;
						Application.StuffKeyboard ("Look inside ", false, true);
					}
					break;

				case ID_GAMEMENU_LOOKOUT:
					if (Application.ExpectingInput)
					{
						Application.State = STATE_LOOKING;
						Application.StuffKeyboard ("Look outside ", false, true);
					}
					break;

				case ID_GAMEMENU_LOOKUNDER:
					if (Application.ExpectingInput)
					{
						Application.State = STATE_LOOKING;
						Application.StuffKeyboard ("Look under ", false, true);
					}
					break;

				case ID_GAMEMENU_TAKE:
					if (Application.ExpectingInput)
					{
						Application.State = STATE_TAKING;
						Application.StuffKeyboard ("Take ", false, true);
					}
					break;

				case ID_GAMEMENU_DROP:
					if (Application.ExpectingInput)
					{
						Application.State = STATE_TAKING;
						Application.StuffKeyboard ("Drop ", false, true);
					}
					break;

				case ID_GAMEMENU_INV:
					if (Application.ExpectingInput)
						Application.StuffKeyboard ("Inventory", true, true);
					break;

				case ID_GAMEMENU_GOTO:
					if (Application.ExpectingInput)
					{
						Application.State = STATE_GOING;
						Application.StuffKeyboard ("Go to ", false, true);
					}
					break;

				case ID_GAMEMENU_OPEN:
					if (Application.ExpectingInput)
					{
						Application.State = STATE_OPENING;
						Application.StuffKeyboard ("Open ", false, true);
					}
					break;

				case ID_GAMEMENU_CBMPAL:
					Application.CycleCBMPalette ();
					break;

				default:
					//*** Check for macros ***
					if (Application.ExpectingInput &&
						wmId >= BASE_MACRO_ID && wmId < (int)(BASE_MACRO_ID + MAX_MACROS))
					{
						bool bReturn = false;
						char Str[32];
						if (Application.Macros[wmId - BASE_MACRO_ID].nlStyle == 1)
							bReturn = true; // Macro wants immediate newline
						else if (Application.Macros[wmId - BASE_MACRO_ID].nlStyle == 2)
							Application.State = STATE_MACRONL; // Return after input
						wcstombs (Str, Application.Macros[wmId - BASE_MACRO_ID].wAction, 32);
						Application.StuffKeyboard (Str, bReturn, true);
					}
					//*** *** *** *** *** ***
					else
						return DefWindowProc (hWnd, message, wParam, lParam);
			}
		}	break;

		case WM_TIMER:
			Application.OnTimer ();
			break;

		case WM_PAINT:
			Application.OnPaint ();
			break;

		/*
		case WM_CAPTURECHANGED:
			if ((HWND)lParam == Application.hWnd)
				Application.GoFullScreen ();
			break;
		*/

		case WM_SETFOCUS:
			Application.OnSetFocus ();
			// Hide the taskbar
			//SetForegroundWindow (hWnd);
			//SHFullScreen (hWnd, SHFS_HIDETASKBAR);
			// Show the SIP
			if (Application.bShowSip && !cBlindMode)
				SipShowIM (SIPF_ON);
			break;

		case WM_KILLFOCUS:
			//HideCaret (hWnd);
			//DestroyCaret ();
			// Show the taskbar
			//SHFullScreen ((HWND)wParam, SHFS_SHOWTASKBAR);
			break;

		case WM_CREATE:
            // Initialize the shell activate info structure
            memset (&s_sai, 0, sizeof (s_sai));
            s_sai.cbSize = sizeof (s_sai);
			break;

		case WM_DESTROY:
			Application.OnExit ();
			if (Application.hMenuBar)
				CommandBar_Destroy (Application.hMenuBar);
			PostQuitMessage (0);
			break;

		//case WM_ACTIVATE:
            // Notify shell of our activate message
			//SHHandleWMActivate (hWnd, wParam, lParam, &s_sai, FALSE); just messes all up
     	//	return TRUE;

		case WM_SETTINGCHANGE:
			SHHandleWMSettingChange (hWnd, wParam, lParam, &s_sai);
     		break;

		case WM_CHAR:
			Application.OnChar ((UINT)wParam,
				0, 0); // Unused parameters
			break;

		case WM_LBUTTONDOWN:
			Application.OnLButtonDown (wParam, LOWORD(lParam), HIWORD(lParam));
			break;

		case WM_KEYDOWN:
			Application.OnKeyDown ((UINT)wParam,
				0, 0); // Unused parameters
			break;

		//*** Custom window messages ***
		case WM_UPDATE_MENU:
			Application.OnUpdateMenu ();
			return TRUE;

		case WM_CREATE_CURSOR:
			if (hWnd == Application.hWnd)
				CreateCaret (hWnd, NULL, Application.CharWidth, Application.CharHeight);
			return TRUE;

		case WM_UPDATE_CURSOR:
			Application.OnUpdateCursor ();
			return TRUE;

		case WM_SHOW_CURSOR:
			if (wParam)
				ShowCaret (hWnd);
			else
				HideCaret (hWnd);
			return TRUE;

		case WM_TAKE_FOCUS:
			SetFocus (hWnd);
			return TRUE;

		default:
			return DefWindowProc (hWnd, message, wParam, lParam);
	}

	return 0;
}
#pragma warning ( default : 4101 )




//****************************************************************************
//		GetAppDir
//	Code taken from Mini vMac by Paul Pratt
//****************************************************************************
bool GetAppDir (LPWSTR pathName, HINSTANCE appInstance)
{
	if (GetModuleFileName (appInstance, pathName, 256) == 0)
		return false;

	LPWSTR p0 = pathName;
	LPWSTR p = (LPWSTR)0;
	unsigned short c;

	while ((c = *p0++) != 0)
		if (c == (unsigned short)'\\')
			p = p0;

	if (p == 0)
		return false;

	*p = (unsigned short)0;
	return true;
}



//****************************************************************************
//		WinMain
//	Everything starts here
//****************************************************************************
int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	MSG msg;
	DEVMODE dm;
	// - Experimental -
	unsigned short FontFile[256];

	/*** Register our fonts ***/
	GetAppDir (FontFile, hInstance);
	wcscat (FontFile, L"frostz.ttf");
	if (AddFontResource (FontFile) == 0)
	{
		unsigned short wMsg[32], wTxt[128];
		wsprintf (wMsg, L"Error #%d", GetLastError ());
		wsprintf (wTxt, L"Could not add \"%s\"", FontFile);
		MessageBox (NULL, wTxt, wMsg, MB_ICONSTOP);
	}
	else
		SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
	GetAppDir (FontFile, hInstance);
	wcscat (FontFile, L"bzork.ttf");
	if (AddFontResource (FontFile) == 0)
	{
		unsigned short wMsg[32], wTxt[128];
		wsprintf (wMsg, L"Error #%d", GetLastError ());
		wsprintf (wTxt, L"Could not add \"%s\"", FontFile);
		MessageBox (NULL, wTxt, wMsg, MB_ICONSTOP);
	}
	else
		SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
	GetAppDir (FontFile, hInstance);
	wcscat (FontFile, L"CBM.ttf");
	if (AddFontResource (FontFile) == 0)
	{
		unsigned short wMsg[32], wTxt[128];
		wsprintf (wMsg, L"Error #%d", GetLastError ());
		wsprintf (wTxt, L"Could not add \"%s\"", FontFile);
		MessageBox (NULL, wTxt, wMsg, MB_ICONSTOP);
	}
	else
		SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
	GetAppDir (FontFile, hInstance);
	wcscat (FontFile, L"CBM-BZ.ttf");
	if (AddFontResource (FontFile) == 0)
	{
		unsigned short wMsg[32], wTxt[128];
		wsprintf (wMsg, L"Error #%d", GetLastError ());
		wsprintf (wTxt, L"Could not add \"%s\"", FontFile);
		MessageBox (NULL, wTxt, wMsg, MB_ICONSTOP);
	}
	else
		SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
	/**************************/

	// initialize the DEVMODE structure
	ZeroMemory (&dm, sizeof (dm));
	dm.dmSize = sizeof (dm);

	// Backup old values
	EnumDisplaySettings (NULL, ENUM_CURRENT_SETTINGS, &dm);
	oldOrientation = dm.dmOrientation;
	oldDisplayOrientation = dm.dmDisplayOrientation;

	// Switch to Portrait mode
	dm.dmOrientation = DMORIENT_PORTRAIT;
	dm.dmDisplayOrientation = DMDO_0;
	dm.dmFields = DM_ORIENTATION | DM_DISPLAYORIENTATION;
	if (ChangeDisplaySettingsEx (NULL, &dm, NULL, 0, 0) != DISP_CHANGE_SUCCESSFUL)
		MessageBox (NULL, L"Could not change display orientation!", L"Frostz", MB_ICONEXCLAMATION);

	if (!Application.Initialize (hInstance, nCmdShow))
		return 0;

	SipShowIM (cBlindMode? SIPF_OFF : SIPF_ON);
	Application.ClientRect.bottom = cBlindMode? 303 : 215;

	DialogBox (hInstance, MAKEINTRESOURCE (IDD_ABOUT), Application.GetMainWnd (),
		(DLGPROC)DlgAbout);

	Application.SetBgImage (IDB_FROSTZBG);

	Application.GoFullScreen ();

	// Main message loop:
	while (GetMessage (&msg, NULL, 0, 0)) 
	{
		TranslateMessage (&msg);
		DispatchMessage (&msg);
	}

	/* - Experimental - */
	/*** Un-register our fonts ***/
	GetAppDir (FontFile, hInstance);
	wcscat (FontFile, L"frostz.ttf");
	RemoveFontResource (FontFile);
	SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
	GetAppDir (FontFile, hInstance);
	wcscat (FontFile, L"bzork.ttf");
	RemoveFontResource (FontFile);
	SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
	GetAppDir (FontFile, hInstance);
	wcscat (FontFile, L"CBM.ttf");
	RemoveFontResource (FontFile);
	SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
	GetAppDir (FontFile, hInstance);
	wcscat (FontFile, L"CBM-BZ.ttf");
	RemoveFontResource (FontFile);
	SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
	/*****************************/

	// Switch back to previous orientation mode
	dm.dmOrientation = oldOrientation;
	dm.dmDisplayOrientation = oldDisplayOrientation;
	dm.dmFields = DM_ORIENTATION | DM_DISPLAYORIENTATION;
	if (ChangeDisplaySettingsEx (NULL, &dm, NULL, 0, 0) != DISP_CHANGE_SUCCESSFUL)
		MessageBox (NULL, L"Could not change display orientation!", L"Frostz", MB_ICONEXCLAMATION);

	return msg.wParam;
}
