/* infocom.c
 *
 *  foblub -- a Z-machine for TI calculators
 *  based on pinfocom by InfoTaskForce and Paul Smith
 *  Ported and extended by Nils Gesbert, 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#define NO_SIGNALS

#include "infocom.h"
#include <args.h>
#include <graph.h>

/* Qques pointeurs qu'il faudra freer */
typedef struct
{
    word    page;
    byte    next;
    byte    prev;
} pg_table_t;
extern pg_table_t *pg_table;
extern print_buf_t text, room;

#ifdef DEBUG
Bool tracing = FALSE;
#endif

/* gflags_t    gflags; */
word        pc_page;
char        *ti_location;
char        *ti_status;
byte        *strt_vocab_table;
byte        *end_of_sentence;
print_buf_t *pbf_p;
word        *stack_base;
LCD_BUFFER  *sauvegarde_ecran;
word        *stack_var_ptr; /* a c'est le  frame pointer  */
byte        *prog_block_ptr;

#ifdef REGISTRES
register byte *base_ptr asm ("a3");
register long pc_offset asm ("d7");
register word *stack asm ("a4");
#else
byte *base_ptr;
long pc_offset;
word *stack;
#endif

enum stories {
  AMFV,
  TRINITY,
  BUREAUCRACY,
  AUTRE
} story;

char nom_jeu[8] = JEU_PAR_DEFAUT;
/* Parat que c'est mal d'utiliser des variables globales, surtout pas initialises.
   eh ben on n'est pas sorti de l'auberge hein... */
/* J'en transforme certaines en macros, cf. infocom.h */

char ws_table[] = { ' ','\t','\r','.',',','?','\0','\0' };

char table[] =
{
    'a','b','c','d','e','f','g','h','i','j','k','l','m',
    'n','o','p','q','r','s','t','u','v','w','x','y','z',
    'A','B','C','D','E','F','G','H','I','J','K','L','M',
    'N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
    ' ',' ','0','1','2','3','4','5','6','7','8','9','.',
    ',','!','?','_','#','\'','"','/','\\','-',':','(',')',
    '\0','\0'
};

#include "titi.c"
#include "support.c"
#include "file.c"
#include "funcs.c"
#include "variable.c"
#include "input.c"
#include "jump.c"
#include "object.c"
#include "page.c"
#include "print.c"
#include "property.c"
#include "init.c"
#include "plus_opcodes.c"
#include "interp.c"

void _main () {
  ESI argptr;
  const char *jeu = nom_jeu;
  const char *sauvegarde = NULL;
  int largeur;
  int hauteur;
#ifdef INTERPNUM
  int interp_num;
#endif
  LCD_BUFFER buffer;

#ifdef ALPHALOCK
  unsigned char c;
  alphaLockOn (&c);
#endif
  
    /* Allez il faut rinitialiser les pointeurs globaux*/
  base_ptr = NULL;
  pg_table = NULL;
  text.buf = NULL;
  room.buf = NULL;
  prog_block_ptr = NULL;
  sauvegarde_ecran = NULL;
  stack_base = NULL;
#ifdef DEBUG
  tracing = FALSE;
#endif

  nom_jeu[7] = 0;

  InitArgPtr (argptr);
  if (GetArgType (argptr) == STR_TAG) jeu = GetStrnArg (argptr);
/*   if (GetArgType (argptr) == POSINT_TAG) largeur = GetIntArg (argptr); */
/*   else largeur = LCD_WIDTH / 4; */
/*   if (GetArgType (argptr) == POSINT_TAG) hauteur = GetIntArg (argptr); */
/*   else hauteur = LCD_HEIGHT / 6; */
#ifdef INTERPNUM
  if (GetArgType (argptr) == POSINT_TAG) interp_num = GetIntArg (argptr);
  else interp_num = 0;
#endif
/*  if (GetArgType (argptr) == POSINT_TAG) srand (GetIntArg (argptr)); /\* graine de chaos *\/
    else  */randomize();
  if (GetArgType (argptr) == STR_TAG) sauvegarde = GetStrnArg (argptr);


  /*
   * Open the game file, if possible...
   */
  
  switch (open_file (jeu)) {
    case 0 : quit();
    case 2 : sauvegarde = jeu;
  }
  
  if (init (LCD_WIDTH / 4, LCD_HEIGHT / 6)) {
#ifdef INTERPNUM
    data_head.interpreter_number = interp_num;
#endif
    sauvegarde_ecran = &buffer;
    LCD_save (sauvegarde_ecran);
    ClrScr();
    scr_setup();
#if 0
    /* Test */
    print_str ("Il tait une fois un petit chaperon rouge qui devait aller porter une galette et un petit pot de beurre  sa mre-grand ; pour cela il lui fallait traverser les bois dans lesquels rdait le grand mchant loup. Celui-ci la rencontra et lui demanda o elle se rendait. Je vais porter une galette et un petit pot de beurre  ma mre-grand, rpondit le chaperon. Ah ah, dit le loup, dans ce cas je connais un raccourci pour toi, et il lui indiqua un chemin qui tait en ralit bien plus long que le chemin habituel. Cela lui permit d'arriver avant elle chez la mre-grand. Toc toc toc, c'est le petit chaperon rouge. Tire la chevillette et la bobinette cherra, dit la mre-grand, ce qu'il fit.  peine entr, il se jeta sur elle et la dvora, puis il mit ses habits et se coucha dans le lit. Le petit chaperon rouge ne tarda pas  arriver. Toc toc toc, mre-grand, je vous apporte une galette et un petit pot de beurre de la part de maman. Tire la chevillette et la bobinette cherra, rpondit le loup. Le chaperon entra et s'approcha du lit. Mre-grand, dit-elle, comme vous avez de grandes oreilles ! C'est pour mieux t'couter, mon enfant, rpondit le loup. Mre-grand, reprit-elle, comme vous avez de grandes dents ! C'est pour mieux te dvorer, mon enfant, dit-il joignant le geste  la parole. Et je ne me souviens jamais de la fin.");
    new_line();
    ngetchx();
#endif
    if (sauvegarde) rextore (sauvegarde);
    else change_status();

    interp();
  }
  else
    ST_helpMsg (FRENCH ? "pas assez de mmoire" : "not enough memory");
  quit();
}
