
#include <stdlib.h>

#include "z_ucs_i.h"
#include "config.h"
#include "z_ucs.h"
#include "fizmo.h"
#include "i18n.h"
#include "splint.h"


char *z_ucs_to_system_charset(z_ucs *string)
{
  char *result;
  size_t bytes_required;
  z_ucs *ptr;
  char *dest;

  if (system_charset == SYSTEM_CHARSET_ASCII)
  {
    result = (char*)fizmo_malloc(z_ucs_len(string) + 1);

    dest = result;

    while (*string != 0)
    {
      if ((*string & 0xffffff80) != 0)
        *dest = '_';
      else
        *dest = (char)(*string & 0x7f);

      string++;
      dest++;
    }
    *dest = '\0';
    return result;
  }
  else if (system_charset == SYSTEM_CHARSET_ISO_8859_1)
  {
    result = (char*)fizmo_malloc(z_ucs_len(string) + 1);

    dest = result;

    while (*string != 0)
    {
      if ((*string & 0xffffff00) != 0)
        *dest = '_';
      else
        *dest = (char)(*string & 0xff);

      string++;
      dest++;
    }
    *dest = '\0';
    return result;
  }
  else if (system_charset == SYSTEM_CHARSET_UTF_8)
  {
    ptr = string;
    bytes_required = (size_t)z_ucs_to_utf_8(NULL, &ptr, 0);
    result = (char*)fizmo_malloc(bytes_required);

    ptr = string;
    (void)z_ucs_to_utf_8(result, &ptr, bytes_required);
    return result;
  }

  return NULL;
}

