
#ifndef tracelog_c_INCLUDED
#define tracelog_c_INCLUDED

#include <string.h>
#include <stdio.h>

#include "tracelog.h"
#include "config.h"
#include "i18n.h"
#include "types.h"
#include "z_ucs.h"
#include "splint.h"


/*@null@*/ FILE *stream_t = NULL;

#ifdef ENABLE_TRACING

void turn_on_trace(void)
{
  if (stream_t != NULL)
  {
    TRACE_LOG("Tracelog already active.\n");
    return;
  }

  stream_t = fopen(DEFAULT_TRACE_FILE_NAME, "w");

  if (stream_t == NULL)
    i18n_translate_and_exit(
        i18n_fizmo_COULD_NOT_OPEN_TRACE_FILE_P0S,
        -1,
        DEFAULT_TRACE_FILE_NAME);
}


void turn_off_trace(void)
{
  if (stream_t == NULL)
  {
    TRACE_LOG("Tracelog already deactivated.\n");
    return;
  }

  fflush(stream_t);
  fclose(stream_t);

  stream_t = NULL;
}


void _trace_log_z_ucs(z_ucs *output)
{
  char utf_8_output[80 * UTF_8_MB_LEN + 1];

  if (stream_t != NULL)
  {
    while (*output != 0)
    {
      z_ucs_to_utf_8(utf_8_output, &output, 80 * UTF_8_MB_LEN + 1);
      fputs(utf_8_output, stream_t);
      fflush(stream_t);
    }
  }
}

#endif /* ENABLE_TRACING */

#endif // tracelog_c_INCLUDED

