
#ifndef streams_h_INCLUDED
#define streams_h_INCLUDED

#include "types.h"

#define ASCII_TO_Z_UCS_BUFFER_SIZE 64

void init_streams();
void open_input_stream_1(void);
void close_input_stream_1(void);
int streams_z_ucs_output(z_ucs *z_ucs_output);
int streams_z_ucs_output_user_input(z_ucs *z_ucs_output);
int streams_latin1_output(char *latin1_output);
void opcode_output_stream(void);
void open_streams(void);
void close_streams(/*@null@*/ z_ucs *error_message);
void opcode_input_stream(void);
void ask_for_stream2_filename(void);
void ask_for_stream4_filename_if_required(bool dont_output_current_line);
void stream_4_latin1_output(char *latin1_output);
void stream_4_z_ucs_output(z_ucs *z_ucs_output);
void ask_for_input_stream_filename(void);

#ifndef streams_c_INCLUDED
extern bool stream_1_active;
extern bool stream_4_active;
extern bool input_stream_1_active;
extern bool input_stream_1_was_already_active;
extern FILE *input_stream_1;
extern size_t input_stream_1_filename_size;
extern char *input_stream_1_filename;
extern z_ucs last_script_filename[];
/*@-exportlocal@*/
extern bool stream_output_has_occured;
/*@+exportlocal@*/
// Since this flag is used by the screen interface, splint can not now about
// it.
#endif // streams_c_INCLUDED

#endif // streams_h_INCLUDED

