
#ifndef babel_h_INCLUDED
#define babel_h_INCLUDED

#ifndef DISABLE_LIBXML2
#include <libxml/tree.h>
#endif

#include "types.h"

struct babel_doc_entry
{
#ifndef DISABLE_LIBXML2
  xmlDocPtr babel_doc;
#else
  void *babel_doc;
#endif
  char *filename;
  long timestamp;
  bool uses_if_namespace;
};

struct babel_info
{
  struct babel_doc_entry **entries;
  int entries_allocated;
  int nof_entries;
};

struct babel_story_info
{
  uint16_t release_number;
  char *serial;
  int length;
  char *title;
  char *author;
  char *description;
};

void free_babel_info(struct babel_info *babel);
void free_babel_story_info(struct babel_story_info *b_info);
struct babel_info *load_babel_info_from_blorb(FILE *infile, int length,
    char *filename, struct stat *stat_buf);
struct babel_info *load_babel_info();
struct babel_story_info *get_babel_story_info(uint16_t release, char *serial,
    uint16_t checksum, struct babel_info *babel, bool babel_from_blorb);
void store_babel_info_timestamps(struct babel_info *babel);
bool babel_files_have_changed(struct babel_info *babel);

#endif /* babel_h_INCLUDED */

