//===========================================================================
// Copyright  1998 Thin Air Enterprises and Robert Dunn
//===========================================================================
//---------------------------------------------------------------------------
// class TIRichEditOle - adds basic OLE functionality to TRichEdit.
// Based on code found at http://www.dystopia.fi/~janij/techinfo/richedit.htm
// and presumably written by Jani Jrvinen.  Thanks, Jani.
//
// Additional code developed through examination of Borland's VCL library,
// Microsoft's MFC source code, and sample code available on Microsoft's
// developer web site.
//
// Note that this code is very experimental -- the author admits to only a
// vague familiarity with OLE and accepts no criticism of the code.  Many,
// if not most, of the interfaces return failure codes arbitrarily chosen by
// the author with no particular reason to think that the values are correct.
// In particular, no great effort has been expended looking for "memory
// leaks," and these are considered quite probable.  You have been warned.
//---------------------------------------------------------------------------
#ifndef RichEditOleCallbackH
#define RichEditOleCallbackH

#include <vcl\comctrls.hpp>
#include <vcl\comobj.hpp>
#include <vcl\ole2.hpp>
#include <vcl\oledlg.hpp>
#include <richole.h>

//#include <ole2.h>
//#include <richole.h>
//---------------------------------------------------------------------------
class TIRichEditOleCallback : public IRichEditOleCallback
{
protected:
	TRichEdit* FRichEdit;
	ULONG FRefCnt;
	bool FAcceptDrop;

public:
	// *** IUnknown methods ***
	STDMETHOD(QueryInterface) (THIS_ REFIID riid, LPVOID FAR * lplpObj);
	STDMETHOD_(ULONG, AddRef) (THIS);
	STDMETHOD_(ULONG, Release) (THIS);

	// *** IRichEditOleCallback methods ***
	STDMETHOD(GetNewStorage) (THIS_ LPSTORAGE FAR * lplpstg);
	STDMETHOD(GetInPlaceContext) (THIS_ LPOLEINPLACEFRAME FAR * lplpFrame,
		LPOLEINPLACEUIWINDOW FAR * lplpDoc, LPOLEINPLACEFRAMEINFO lpFrameInfo);
	STDMETHOD(ShowContainerUI) (THIS_ BOOL fShow);
	STDMETHOD(QueryInsertObject) (THIS_ LPCLSID lpclsid, LPSTORAGE lpstg,
		LONG cp);
	STDMETHOD(DeleteObject) (THIS_ LPOLEOBJECT lpoleobj);
	STDMETHOD(QueryAcceptData) (THIS_ LPDATAOBJECT lpdataobj,
		CLIPFORMAT FAR * lpcfFormat, DWORD reco, BOOL fReally, HGLOBAL hMetaPict);
	STDMETHOD(ContextSensitiveHelp) (THIS_ BOOL fEnterMode);
	STDMETHOD(GetClipboardData) (THIS_ CHARRANGE FAR * lpchrg, DWORD reco,
		LPDATAOBJECT FAR * lplpdataobj);
	STDMETHOD(GetDragDropEffect) (THIS_ BOOL fDrag, DWORD grfKeyState,
		LPDWORD pdwEffect);
	STDMETHOD(GetContextMenu) (THIS_ WORD seltype, LPOLEOBJECT lpoleobj,
		CHARRANGE FAR * lpchrg, HMENU FAR * lphmenu);

	TIRichEditOleCallback(TRichEdit* richedit);
	~TIRichEditOleCallback(void);

	__property bool AcceptDrop = { read = FAcceptDrop, write = FAcceptDrop };
};
//---------------------------------------------------------------------------
#endif
//===========================================================================
// Copyright  1998 Thin Air Enterprises and Robert Dunn
//===========================================================================

