//===========================================================================
// Copyright  1998 Thin Air Enterprises.  All rights reserved.
//===========================================================================
//---------------------------------------------------------------------------
// RichEdit20Format.h - header file for TRichEdit20 character and paragraph
// formatting classes.
//---------------------------------------------------------------------------
#ifndef RichEdit20FormatH
#define RichEdit20FormatH
//---------------------------------------------------------------------------
#include "richedit20format.h"
//---------------------------------------------------------------------------
// TTextAttributes2 class
//---------------------------------------------------------------------------
enum TFontStyle2 { fs2Bold, fs2Italic, fs2Underline, fs2StrikeOut,
	fs2SuperScript,	fs2SubScript
	};
typedef Set<TFontStyle2, fs2Bold, fs2SubScript> TFontStyles2;

enum TConsistentAttribute2 { ca2Bold, ca2Color, ca2Face, ca2Italic, ca2Size,
	ca2StrikeOut, ca2Underline, ca2Protected, ca2Link, ca2SuperScript,
	ca2SubScript
	};
typedef Set<TConsistentAttribute2, ca2Bold, ca2SubScript> TConsistentAttributes2;

// note: utDouble and utWord display as single solid underlines, i.e., appear
// the same as utUnderline.  only useful to create a document to be displayed
// in another, more complete editor, e.g., Word.  note that utDotted is
// implemented in RE 2.0 (at least in my Win98 version) in spite of MSDN
// doc and header file notes to the contrary.
enum TUnderlineType { utCF1Underline, utUnderline, utDotted, utDouble, utNone,
	utWord };

enum TThreeState { tsNo, tsYes, tsMaybe };

class TTextAttributes2 : public TTextAttributes
{
protected:
	TCustomRichEdit* FRichEdit2;// have to save our own copy - protected in base
	TAttributeType FType2;		// have to save our own copy - protected in base

	void __fastcall GetAttributes2(Richedit::TCharFormat2A &Format);
	Graphics::TColor __fastcall GetBackColor(void);
	TConsistentAttributes2 __fastcall GetConsistentAttributes2(void);
	TFontStyles2 __fastcall GetStyle2(void);
	void __fastcall SetAttributes2(Richedit::TCharFormat2A &Format);
	void __fastcall SetBackColor(Graphics::TColor Value);
	void __fastcall SetStyle2(TFontStyles2 Value);
	void __fastcall InitFormat2(Richedit::TCharFormat2A &Format);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);

	TUnderlineType __fastcall GetUnderlineType(void);
	void __fastcall SetUnderlineType(TUnderlineType ut);

	TThreeState __fastcall GetFontStyle(DWORD effect, DWORD mask);
	void __fastcall SetFontStyle(DWORD effect, DWORD mask, TThreeState state);
	TThreeState __fastcall GetBold(void);
	TThreeState __fastcall GetItalic(void);
	void __fastcall SetItalic(TThreeState state);
	void __fastcall SetBold(TThreeState state);
	TThreeState __fastcall GetUnderline(void);
	void __fastcall SetUnderline(TThreeState state);
	TThreeState __fastcall GetStrikeOut(void);
	void __fastcall SetStrikeOut(TThreeState state);
	TThreeState __fastcall GetSuperScript(void);
	void __fastcall SetSuperScript(TThreeState state);
	TThreeState __fastcall GetSubScript(void);
	void __fastcall SetSubScript(TThreeState state);
	TThreeState __fastcall GetLink(void);
	void __fastcall SetLink(TThreeState);
	TThreeState __fastcall GetProtected2(void);
	void __fastcall SetProtected2(TThreeState);

public:
	__fastcall TTextAttributes2(TCustomRichEdit* AOwner, TAttributeType AttributeType);
	__fastcall virtual ~TTextAttributes2(void) { };
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property Graphics::TColor BackColor = { read = GetBackColor, write = SetBackColor, nodefault};
	__property TConsistentAttributes2 ConsistentAttributes2 = { read = GetConsistentAttributes2, nodefault};
	__property TFontStyles2 Style2 = { read = GetStyle2, write = SetStyle2, nodefault};
	__property TUnderlineType UnderlineType = { read = GetUnderlineType, write = SetUnderlineType, nodefault };
	__property TThreeState Bold = { read = GetBold, write = SetBold, nodefault };
	__property TThreeState Italic = { read = GetItalic, write = SetItalic, nodefault };
	__property TThreeState Underline = { read = GetUnderline, write = SetUnderline, nodefault };
	__property TThreeState StrikeOut = { read = GetStrikeOut, write = SetStrikeOut, nodefault };
	__property TThreeState SuperScript = { read = GetSuperScript, write = SetSuperScript, nodefault };
	__property TThreeState SubScript = { read = GetSubScript, write = SetSubScript, nodefault };
	__property TThreeState Link = { read = GetLink, write = SetLink, nodefault};
	__property TThreeState Protected2 = { read = GetProtected2, write = SetProtected2, nodefault};
};
//---------------------------------------------------------------------------
// TParaAttributes2 class
//
// Note:  This class is not yet complete.  You may find code commented out,
// #if 0'd out of existance, etc.  You may also find code that simply does
// not function properly.  In particular, the NextTab() and PriorTab() code
// is barely tested and is probably full of bugs.
//
// I make no appologies for that.  I am making this available to you as
// quickly as I think that I have it solved in hopes that it saves you some
// time.  As with all other code on this site, if you find bugs, please save
// me -- and others that frequent this site -- some time by reporting the
// errors to me as soon as you uncover them.
//---------------------------------------------------------------------------
enum TParaConsistentAttribute {
	pcaAlignment, pcaLineSpacing, pcaNumbering, pcaOffset, pcaOffsetIndent,
	pcaRightIndent,	pcaSpaceBefore, pcaSpaceAfter, pcaStartIndent, pcaTabStops
	};

typedef Set<TParaConsistentAttribute, pcaAlignment, pcaTabStops>
	TParaConsistentAttributes;

enum TAlignment2 {
	ta2LeftJustify, ta2Center, ta2RightJustify, ta2Indeterminate
	};

enum TLineSpacing { lsSingle, lsOneAndOneHalf, lsDouble, lsIndeterminate };

enum TNumberingStyle2 { ns2None, ns2Bullet, ns2Indeterminate };

class TParaAttributes2 : public TParaAttributes
{
protected:
	TCustomRichEdit* FRichEdit2;
	TParaConsistentAttributes __fastcall GetConsistentAttributes(void);

	void InitFormat2(PARAFORMAT2& format);
	void GetFormat2(PARAFORMAT2& format);
	void SetFormat2(PARAFORMAT2& format);

	TAlignment2 __fastcall GetAlignment2(void);
	void __fastcall SetAlignment2(TAlignment2 alignment);
	TNumberingStyle2 __fastcall GetNumbering2(void);
	void __fastcall SetNumbering2(TNumberingStyle2 numberingStyle);
	int __fastcall GetSpaceBefore(void);
	void __fastcall SetSpaceBefore(int twips);
	int __fastcall GetSpaceAfter(void);
	void __fastcall SetSpaceAfter(int twips);
	TLineSpacing __fastcall GetLineSpacing(void);
	void __fastcall SetLineSpacing(TLineSpacing lineSpacing);
	int __fastcall GetFirstIndent2(void);
	void __fastcall SetFirstIndent2(int twips);
	int __fastcall GetLeftIndent2(void);
	void __fastcall SetLeftIndent2(int twips);
	int __fastcall GetRightIndent2(void);
	void __fastcall SetRightIndent2(int twips);

public:
	__fastcall TParaAttributes2(TCustomRichEdit* AOwner);
	__fastcall virtual ~TParaAttributes2(void) { };

	int __fastcall NextTab(int fromPos);
	int __fastcall PriorTab(int fromPos);

	__property TParaConsistentAttributes ConsistentAttributes =
		{ read = GetConsistentAttributes, nodefault };
	__property TAlignment2 Alignment2 = { read = GetAlignment2, write = SetAlignment2, nodefault };
	__property TNumberingStyle2 Numbering2 = { read = GetNumbering2, write = SetNumbering2, nodefault };
	__property int SpaceBefore = { read = GetSpaceBefore, write = SetSpaceBefore, nodefault };
	__property int SpaceAfter = { read = GetSpaceAfter, write = SetSpaceAfter, nodefault };
	__property TLineSpacing LineSpacing = { read = GetLineSpacing, write = SetLineSpacing, nodefault };
//	__property int LineSpacingTwips = { read = GetLineSpacingTwips, write = SetLineSpacingTwips, nodefault };
//	__property int LineSpacingTwipsExact = { read = GetLineSpacingTwipsExact, write = SetLineSpacingTwipsExact, nodefault };
//	__property int LineSpacingLine20ths = { read = GetLineSpacingLine20ths, write = SetLineSpacingLine20ths, nodefault };
	__property int FirstIndent2 = { read = GetFirstIndent2, write = SetFirstIndent2, nodefault };
	__property int LeftIndent2 = { read = GetLeftIndent2, write = SetLeftIndent2, nodefault };
	__property int RightIndent2 = { read = GetRightIndent2, write = SetRightIndent2, nodefault };
};
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------
// end RichEdit20Format.h
//---------------------------------------------------------------------------
//===========================================================================
// Copyright  1998 Thin Air Enterprises.  All rights reserved.
//===========================================================================
