//---------------------------------------------------------------------------

#ifndef MainH
#define MainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <clipbrd.hpp>
#include <registry.hpp>
#include <Menus.hpp>
#include <strutils.hpp>
#include <ComCtrls.hpp>
#include <Dialogs.hpp>
#include <XMLDoc.hpp>

#include "vmclass.h"
#include <ExtCtrls.hpp>

//---------------------------------------------------------------------------
class TMainForm : public TForm
{
__published:	// IDE-managed Components
  TMainMenu *MainMenu;
  TMenuItem *FileMenu;
  TMenuItem *RestartMenu;
  TMenuItem *OpenMenu;
  TMenuItem *N7;
  TMenuItem *OpenGameMenu;
  TMenuItem *SaveGameMenu;
  TMenuItem *N1;
  TMenuItem *TranscriptMenu;
  TMenuItem *N8;
  TMenuItem *PrevMenu1;
  TMenuItem *PrevMenu2;
  TMenuItem *PrevMenu3;
  TMenuItem *PrevMenu4;
  TMenuItem *N3;
  TMenuItem *ExitMenu;
  TMenuItem *EditMenu;
  TMenuItem *UndoMenu;
  TMenuItem *N5;
  TMenuItem *CopyMenu;
  TMenuItem *PasteMenu;
  TMenuItem *N10;
  TMenuItem *SelectMenu;
  TMenuItem *N6;
  TMenuItem *FindMenu;
  TMenuItem *OptionsMenu;
  TMenuItem *FontsMenu;
  TMenuItem *ColorsMenu;
  TMenuItem *MarginsMenu;
  TMenuItem *N4;
  TMenuItem *TimerMenu;
  TMenuItem *TimerShow;
  TMenuItem *TimerPause;
  TMenuItem *TimerReset;
  TMenuItem *WarningMenu;
  TMenuItem *CoverMenu;
  TMenuItem *Windows;
  TMenuItem *Verbs;
  TMenuItem *Prepositions;
  TMenuItem *Compass;
  TMenuItem *HelpMenu;
  TMenuItem *TopicsMenu;
  TMenuItem *N9;
  TMenuItem *StoryMenu;
  TMenuItem *AboutMenu;
  TStatusBar *StatusBar;
  TOpenDialog *StoryOpenDialog;
  TPopupMenu *PopupMenu;
  TMenuItem *PopupCopy;
  TMenuItem *PopupPaste;
  TSaveDialog *SaveGame;
  TOpenDialog *RestoreGame;
  TSaveDialog *ScriptDialog;
  TFindDialog *FindDialog;
  TTimer *ClockTimer;
  TSaveDialog *RecordDialog;
  TMenuItem *MoreMenu;
  TOpenDialog *PlayDialog;
  TOpenDialog *OpenData;
  TSaveDialog *SaveData;
  TTimer *WaitTimer;
  void __fastcall FormShow(TObject *Sender);
  void __fastcall FormResize(TObject *Sender);
  void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
  void __fastcall FontsMenuClick(TObject *Sender);
  void __fastcall ColorsMenuClick(TObject *Sender);
  void __fastcall MarginsMenuClick(TObject *Sender);
  void __fastcall WarningMenuClick(TObject *Sender);
  void __fastcall CoverMenuClick(TObject *Sender);
  void __fastcall TopicsMenuClick(TObject *Sender);
  void __fastcall AboutMenuClick(TObject *Sender);
  void __fastcall OpenMenuClick(TObject *Sender);
  void __fastcall PrevMenu1Click(TObject *Sender);
  void __fastcall PrevMenu2Click(TObject *Sender);
  void __fastcall PrevMenu3Click(TObject *Sender);
  void __fastcall PrevMenu4Click(TObject *Sender);
  void __fastcall ExitMenuClick(TObject *Sender);
  void __fastcall StoryMenuClick(TObject *Sender);
  void __fastcall RestartMenuClick(TObject *Sender);
  void __fastcall OpenGameMenuClick(TObject *Sender);
  void __fastcall SaveGameMenuClick(TObject *Sender);
  void __fastcall TranscriptMenuClick(TObject *Sender);
  void __fastcall CopyMenuClick(TObject *Sender);
  void __fastcall PasteMenuClick(TObject *Sender);
  void __fastcall SelectMenuClick(TObject *Sender);
  void __fastcall FindMenuClick(TObject *Sender);
  void __fastcall FindDialogClose(TObject *Sender);
  void __fastcall FindDialogShow(TObject *Sender);
  void __fastcall FindDialogFind(TObject *Sender);
  void __fastcall TimerShowClick(TObject *Sender);
  void __fastcall ClockTimerTimer(TObject *Sender);
  void __fastcall TimerResetClick(TObject *Sender);
  void __fastcall TimerPauseClick(TObject *Sender);
  void __fastcall VerbsClick(TObject *Sender);
  void __fastcall PrepositionsClick(TObject *Sender);
  void __fastcall CompassClick(TObject *Sender);
  void __fastcall MoreMenuClick(TObject *Sender);
  void __fastcall FormKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall UndoMenuClick(TObject *Sender);
  void __fastcall WaitTimerTimer(TObject *Sender);
  void __fastcall StatusBarMouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);

private:	// User declarations
  TClipboard *clipboard;
  TStringList *previous_stories;
  bool first_story;
  VM *vm;
  unsigned char version;
  TFileStream *story_file;
  int hours,minutes,seconds;

  void read_form_reg(String section,TForm *form,TRegIniFile *reg);
  void read_font_reg(String section,TFont *font,String def_font,int def_size,TRegIniFile *reg);
  void read_reg();
  void update_prev_menus();
  void update_prev_menu(TMenuItem *menu,String filename);
  void check_associations();
  void add_association(TRegIniFile *reg,String type);
  void write_reg();
  void write_form_reg(String section,TForm *form,TRegIniFile *reg);
  void write_font_reg(String section,TFont *font,TRegIniFile *reg);
  bool story_warning();
  void init_story(String filename);
  int read_blorb();
  void read_version();
  void cleanup_story();
  void toggle_clock();
  void reset_clock();
  void cancel_moring();


public:		// User declarations
  __fastcall TMainForm(TComponent* Owner);
  void toggle_menus(bool enable);
  void __fastcall toggle_waittimer();

  int client_width,client_height;
  bool dialogue_up;
  String home_dir;
  TFont *prop_font,*fixed_font;
  bool story_loaded;
};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
