! footnote.h
! Part of Platypus release 4
! Copyright 2001 Anson Turner.

Class Footnotes has proper, with number 0;

Gizmos FootnoteGizmo "(Footnote Gizmo)"
  with
    first_available 1,
    cog_class Footnotes;

        ! note (Footnotes object)
        ! Displays a footnote reference.

[ note nobj     fa x;

    if ((~~(nobj ofclass Footnotes)) || nobj notin FootnoteGizmo)
    {   print "[invalid footnote]"; rfalse; }
    if (nobj has light)
    {   if (FootnoteGizmo has concealed) rfalse;
        ActionMessage(##Footnote, 7, nobj.number);
        rtrue;
    }
    give FootnoteGizmo general;           ! has been referenced
    give nobj general;
    if (nobj.number == 0)
    {   fa = FootnoteGizmo.first_available;
        nobj.number = fa;
    .notelab1;
        fa++;
        objectloop(x in FootnoteGizmo)
            if (x.number == fa) jump notelab1;
        FootnoteGizmo.first_available = fa;
    }
    ActionMessage(##Footnote, 7, nobj.number);
];

[ FootnoteSub     x;

    if (FootnoteGizmo hasnt general)
        return ActionMessage(##Footnote, 9);
    objectloop(x in FootnoteGizmo)
        if (x has general && x.number == noun)
        {   ActionMessage(##Footnote, 8, noun);
            give x light;               ! has been viewed
            give FootnoteGizmo light;
            print (name) x; new_line;
            rtrue;
        }
     ActionMessage(##Footnote, 2, noun);
];

[ NotesSub     x y ln td;

    if (FootnoteGizmo hasnt light)
        return ActionMessage(##Footnote, 6);
    x = child(FootnoteGizmo);
    while (x)
    {   y = sibling(x);
        if (x has light) move x to blank;
        x = y;
    }
    while (child(blank))
    {   ln = 32767;
        objectloop(x in blank)
            if (x.number < ln) { ln = x.number; td = x; }
        ActionMessage(##Footnote, 8, ln);
        print (name) td; new_line;
        move td to FootnoteGizmo;
    }
];

MessageCogs "(Footnote Messages)"
  with
    messages [;
        Footnote: switch(lm_n) {
            2: "No footnote ",lm_o," has been given.";
            5: "Footnotes you have viewed:^";
            6: "You haven't looked at any footnotes.";
            7: print " [#b#", lm_o, "#r#]"; rtrue;
            8: print "[#b#", lm_o, "#r#]  "; rtrue;
            9: "No footnote references have been given.";
        }
    ];
