!------------------------------------------------------------------------------
!
!							N P C _ E N G I N E . h
!
!
!	Copyright (c) 1999, 2000 Volker Lanz.
!
!	serial 001217 - release 8
!
!
!	Overview of this file:
!	 (1) Setting up the stuff (constants, globals, arrays etc.)
!	 (2) Main NPC Engine object (controlling the NPC Engine)
!	 (3) NPC Engine class
!	 (4) Main routines (the ones that are likely to be used within a game)
!	 (5) NPC visibility and description routines
!	 (6) NPC following routines
!	 (7) Movement type dependant routines
!	 (8) Miscellaneous stuff
!	 (9) Initialisation routine
!	(10) Language dependant routines (NPC_Msg and NPC_Error plus a few
!	     little helpers)
!
!
!	WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!
!
!		The NPC_Msg routine has substantially changed with this release
!		of NPC_Engine. If you had this replaced in your game and intend
!		to use this new release, you'll have to modify your replaced
!		version of that routine to make the NPC Engine function properly!
!
!	WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!
!
!------------------------------------------------------------------------------


System_file;


!==============================================================================
!
!	1.  S E T T I N G   U P   S T U F F
!
!==============================================================================


!------------------------------------------------------------------------------
!
!	T Y P E   O F   M O V E M E N T
!
!	If neither PATH_MOVE_TYPE nor SUBWAY_MOVE_TYPE has been set by the
!	game author, we default to PATH_MOVE_TYPE.
!------------------------------------------------------------------------------

#ifndef PATH_MOVE_TYPE;	#ifndef SUBWAY_MOVE_TYPE;
	Constant PATH_MOVE_TYPE;
#endif; #endif;


!------------------------------------------------------------------------------
!	A T T R I B U T E S
!------------------------------------------------------------------------------

Attribute	npc_explored	alias worn;
Attribute	npc_hidden		alias clothing;
Attribute	npc_goto;


!------------------------------------------------------------------------------
!	F A K E   A C T I O N S
!------------------------------------------------------------------------------
fake_action	NPC_PrintVisible;


!------------------------------------------------------------------------------
!	P R O P E R T I E S
!------------------------------------------------------------------------------

Property	npc_open;
Property	looks_to;


!------------------------------------------------------------------------------
!	C O N S T A N T S
!------------------------------------------------------------------------------
Constant	NUMBER_OF_LINES		16;
Constant	MAX_INTERSECTIONS	14;

Constant	MULTIPLY			(MAX_INTERSECTIONS+1);

!------------------------------------------------------------------------------
!	G L O B A L S
!------------------------------------------------------------------------------
Global		npc_first_room;
Global		npc_first_npc;
Global		npc_found_line;


!------------------------------------------------------------------------------
!	A R R A Y S
!------------------------------------------------------------------------------
Array		adjacent_rooms-->2;

Array		intersection_list-->MAX_INTERSECTIONS;
Array		finished_lines-->NUMBER_OF_LINES;

Array		line_connections-->NUMBER_OF_LINES*MULTIPLY;
Array		number_of_connections-->NUMBER_OF_LINES;

Array		subway_names -->	"no line"
								"red line"
								"green line"
								"blue line"
                        		"brown line"
                        		"yellow line"
                        		"pink line"
                        		"orange line"
                        		"grey line"
                        		"beige line"
                        		"black line"
                        		"navy line"
								"lime line"
								"purple line"
								"khaki line"
								"white line";
						

!------------------------------------------------------------------------------
!
!	S U B W A Y   L I N E S
!
!	These are the subway lines the NPC Engine knows. Add as many as you like;
!	don't forget to increase NUMBER_OF_LINES and add the new names to the
!	subway_names array!
!------------------------------------------------------------------------------
Constant	no_line				0;
Constant	red_line			1;
Constant	green_line			2;
Constant	blue_line			3;
Constant	brown_line			4;
Constant	yellow_line			5;
Constant	pink_line			6;
Constant	orange_line			7;
Constant	grey_line			8;
Constant	beige_line			9;
Constant	black_line			10;
Constant	navy_line			11;
Constant	lime_line			12;
Constant	purple_line			13;
Constant	khaki_line			14;
Constant	white_line			15;


!------------------------------------------------------------------------------
!	N P C _ S C O P E
!------------------------------------------------------------------------------
[ NPC_Scope i;
	if (scope_stage == 1) 
		rfalse;
    
	if (scope_stage == 2)
	{
		i = npc_first_npc;
		while (i)
		{
			PlaceInScope(i);
			i = i.npc_next;
		}
		rtrue;
	}

	NPC_Msg(##Miscellany, 2);
];


!------------------------------------------------------------------------------
!	N P C _ G O T O _ S C O P E
!------------------------------------------------------------------------------
[ NPC_Goto_Scope i;
	if (scope_stage == 1) 
		rfalse;
    
	if (scope_stage == 2)
	{
		i = npc_first_room;

		while(i)
		{
			if (i has npc_goto)
				PlaceInScope(i);
				
			i = i.npc_number;
		}
		
		rtrue;
	}

	NPC_Msg(##NPC_Goto, 2);
];


!------------------------------------------------------------------------------
!	V E R B S
!------------------------------------------------------------------------------

Verb 'follow' 'chase' 'pursue' 'trail'
	* noun									-> Follow
    * scope = NPC_Scope						-> Follow;

Verb 'find' 'where' 'where^s'
	*										-> Find
	* scope = NPC_Scope						-> Find
	* noun									-> Find
	* 'is'/'are' scope = NPC_Scope			-> Find
	* 'is'/'are' noun						-> Find;


!------------------------------------------------------------------------------
!	N P C _ R O O M   C L A S S
!------------------------------------------------------------------------------
Class NPC_Room
	with
	npc_label,
	npc_prev_room,
	npc_prev_dir,
	npc_number,
	npc_subway			no_line;


!------------------------------------------------------------------------------	
!	N P C _ V I S I B L E   R O O M
!------------------------------------------------------------------------------
NPC_Room NPC_Visible_Room "(npc_visible_room)"
	with
	n_to 0, ne_to 0, e_to 0, se_to 0, s_to 0, sw_to 0, w_to 0, nw_to 0, u_to 0,
	d_to 0;


!------------------------------------------------------------------------------
!	T W _ W A I T I N G
!------------------------------------------------------------------------------

Object tw_waiting;


!------------------------------------------------------------------------------
!
!	I N F O R M   L I B R A R Y   E N T R Y   P O I N T S
!
!	If you need your own, copy the contents of these into the ones you have in
!	your game.	
!------------------------------------------------------------------------------

[ LookRoutine;
	NPC_LookRoutine();
];


!==============================================================================
!
!	2.  M A I N   N P C   E N G I N E   O B J E C T
!
!==============================================================================


Object NPC_Engine_Main "NPC Engine"
	with
	add_to_scope
		[o;
			! This puts all NPCs that are visible to the player in scope for
			! the Inform Library
			o = npc_first_npc;
			
			while (o)
			{
				if (o notin nothing && o hasnt npc_hidden && NPC_CheckVisible(ScopeCeiling(o)))
					PlaceInScope(o);
		
				o = o.npc_next;
			}
		],
	each_turn
		[o;
			! Core routine of the NPC Engine
			o = npc_first_npc;

			while (o)
			{
				if (ScopeCeiling(o) == location)
					o.npc_met = turns;
					
				if (o notin nothing && RunRoutines(o, npc_daemon))
					give tw_waiting on;
				
				if (o.npc_time_left > -1)
				{
					o.npc_time_left--;
					
					if (o.npc_time_left == 0)
					{
						if (RunRoutines(o, npc_time_out))
							give tw_waiting on;
							
						o.npc_time_left = -1;
					}
				}
								
				o = o.npc_next;
			}
		],
	found_in
		[;
			! This object is present everywhere to control the NPC Engine
			rtrue;
		],
	has				concealed proper;



!==============================================================================
!
!	3.  N P C _ E N G I N E   C L A S S
!
!==============================================================================


Class NPC_Engine
	with
	npc_next,				! used to cascade the npcs in a list
	npc_number,				! number of the npc in our list
	npc_meeting 			0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0,
	npc_time_left			-1,	
	npc_met,				! time the player met the npc
	npc_old_loc,			! previous location of npc
	npc_old_dir,			! previous dir the npc went in
	npc_source,				! room the npc comes from
	npc_target,				! The target destination
	npc_door_passed,		! door this npc has opened on its way (0 if none)
	npc_stopped,			! has this npc been stopped on its path by the player?
	npc_dest,				! The NPCs next destination when the timer times out
	npc_dirs				0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0,
	npc_stage,				! position along movement array
	npc_path_size,			! size of the path, calculated or predefined
	npc_move_type,			! 1 defined path, 2 stand still, 3 calculated path, 4 subway lines, 5 following player
	npc_current_line,		! The NPCs current line
	npc_next_line,			! The line the NPC is trying to get to right now
	npc_win,
	describe
		[;
			! The following avoids double descriptions (one by this describe() property,
			! one by the NPC Engine's NPC_PrintVisible)
			if (self.npc_move_type == 1 or 3 or 4 && self.npc_stopped == 0)
				rtrue;

			NPC_Msg(##Miscellany, 3, self);
			
			rtrue;
		],		
	npc_before_action
		[;
			rfalse;
		],
	npc_after_action
		[;
			rfalse;
		],
	npc_arrived
        [ room;
			room = room;
			rfalse;
		],
	npc_path_blocked
		[src dest blocking_door   dir;
			src = src;
			dest = dest;
			
			if (self in location)
			{
				NPC_Msg(##Miscellany, 6, self, blocking_door);
				rtrue;
			}
			
			dir = NPC_CheckVisible(ScopeCeiling(self));
			
			if (self hasnt npc_hidden && dir)
			{
				NPC_Msg(##Miscellany, 7, self, dir);
				rtrue;
			}

			rfalse;
		],
	npc_time_out
		[;
			NPC_Path(self, self.npc_dest, 2, 1);
			self.npc_dest = 0;
		],
	npc_meet
		[ npc;
			self.&npc_meeting-->(npc.npc_number) = turns;
			rtrue;
		],
	npc_last_saw
		[ npc;
			return (self.&npc_meeting-->(npc.npc_number));
		],
	npc_walkoff
		[i;
			NPC_Msg(##Miscellany, 4, self, i);
			rtrue;
		],
	npc_walkon
		[i;
			NPC_Msg(##Miscellany, 5, self, i);
			rtrue;
		],
	orders
		[;
			Find:
				<< FIND noun >>;
		],
	npc_daemon
		[ loc tmp new_dir new_loc tmp2 current_line next_line;
			switch(self.npc_move_type)
			{
				1, 3, 4:
					#ifdef NPC_DEBUG;
						if (parser_trace >= 3)
							print "^[npc_daemon of ", (name) self, " called with npc_move_type = ",
								self.npc_move_type, " (stage at ", self.npc_stage, ").]^";
					#endif;
					
					tmp = self.npc_before_action();
			
					if (tmp & 1)
						give tw_waiting on;
			
					if (tmp & 2)
					{
						#ifdef NPC_DEBUG;
							if (parser_trace >= 3)
								print "  [npc_before_action() for ", (name) self, " has returned ",
									tmp, ": stopping movement.]^";
						#ENDIF;

						NPC_TerminateMovement(self);
						rfalse;
					}

					if (self.npc_stopped && TestScope(self, player))
					{
						#ifdef NPC_DEBUG;
							if (parser_trace >= 3)
								print "[npc is waiting for player to let him leave.]^";
						#ENDIF;

						self.npc_old_loc = ScopeCeiling(self);
						
						self.npc_stopped--;
						
						if (self.npc_stopped == 0)
							return (NPC_Msg(##Miscellany, 1, self));
						
						rfalse;
					}
					
					self.npc_stopped = 0;

					loc = ScopeCeiling(self);

					! Is the movement type path or subway?
					if (self.npc_move_type == 1 or 3)
					{	! Pre-defined or calculated path
						
						current_line = next_line; ! use these to avoid compiler warnings
						
						new_dir = self.&npc_dirs->self.npc_stage;

						! Waiting for one turn
						if (new_dir == 0)
						{
							self.npc_stage--;
							if (self.npc_stage < 0)
							{
								self.npc_move_type = 2;
						
								if(self.npc_arrived(ScopeCeiling(self)))
									give tw_waiting on;
							}

							rfalse;
						}

						#ifdef NPC_DEBUG;
							if (parser_trace >= 3)
								print "  [getting new_loc from location ", (name) loc,
									" in dir ", (name) new_dir, ".]^";
						#ENDIF;

						new_loc = ObjectOrRun(loc, new_dir.door_dir);

						#ifdef NPC_DEBUG;
							if (parser_trace >= 3)
								print "  [new_loc = ", (name) new_loc, ".]^";
						#ENDIF;


						if (ZRegion(new_loc) ~= 1)
						{
							NPC_TerminateMovement(self);
							
							rfalse;
						}
					}
					#ifdef SUBWAY_MOVE_TYPE;
						if (self.npc_move_type == 4)
						{	! Subway
							new_loc = NPC_FindNextMove(self, loc, self.npc_target);

							if (ZRegion(new_loc) ~= 1)
							{
								NPC_TerminateMovement(self);
								rfalse;
							}

							new_dir = NPC_GetDirFor(loc, new_loc);

							! If there's a door in the direction we want to go, set
							! the new location to the door.						
							tmp = NPC_IsDoorInDir(loc, new_dir);
							if (tmp)
								new_loc = tmp;
						}
					#endif;
		

					! Try to open any doors that might be in the way
					if (new_loc has door)
					{
						if ((~~(new_loc provides npc_open)) 
								&& (new_loc hasnt open || new_loc has locked))
						{
							NPC_TerminateMovement(self);
							
							return(self.npc_path_blocked(self.npc_source, self.npc_target, new_loc));
						}

						tmp2 = NPC_GetOtherSide(loc, new_loc);
						
						if ((new_loc hasnt open) 
								&& (new_loc.npc_open(self) == false))
						{
							NPC_TerminateMovement(self);
							
							return(self.npc_path_blocked(self.npc_source, self.npc_target, new_loc));
						}
						
						new_loc = tmp2;
					}

					! Now move the NPC to its new location
					NPC_Move(self, new_loc, ##Go, new_dir);

					if (self.npc_move_type == 1 or 3)						
						self.npc_stage--;

					if (self.npc_after_action())
						give tw_waiting on;

					if (self.npc_move_type == 3)
					{
						if (self.npc_stage < 0)
						{
							NPC_TerminateMovement(self);

							if (self.npc_arrived(new_loc))
								give tw_waiting on;
						}
						
						rfalse;
					}

					if (ScopeCeiling(self) == self.npc_target)
					{
						NPC_TerminateMovement(self);

						if (self.npc_arrived(new_loc))
							give tw_waiting on;
					}
					
					rfalse;

				2:	! NPC is standing still
					self.npc_old_loc = ScopeCeiling(self);
					if (self.npc_win)
						NPC_PrintWindowVisible(self, self.npc_win, 1);

				5:	! NPC is following the player
					self.npc_old_loc = ScopeCeiling(self);
					self.npc_stopped = 0;
					
					if (ScopeCeiling(self) == location)
						rfalse;

					tmp = self.npc_before_action();
			
					if (tmp & 1)
						give tw_waiting on;
			
					if (tmp & 2)
					{
						#ifdef NPC_DEBUG;
							if (parser_trace >= 3)
								print "  [npc_before_action() for ", (name) self, " has returned ",
									tmp, ": stopping following.]^";
						#ENDIF;

						self.npc_move_type = 2;
						rfalse;
					}

					new_dir = NPC_GetDirFor(ScopeCeiling(self), location);
					
					if (~~ new_dir)
					{
						self.npc_move_type = 2;
						rfalse;
					}
					
					NPC_Move(self, location, ##Go, new_dir);

					if (self.npc_after_action())
						give tw_waiting on;
					
					rfalse;
					
				default:
					NPC_Error(13, self);
					rtrue;
			}
		],
	has					animate;



!==============================================================================
!
!	4.  M A I N   R O U T I N E S
!
!==============================================================================


!------------------------------------------------------------------------------
!
!	N P C _ F O L L O W P L A Y E R
!
!------------------------------------------------------------------------------
[ NPC_FollowPlayer npc;
	if (npc notin location)
	{
		NPC_Error(27, npc);
		rfalse;
	}
	
	npc.npc_move_type = 5;
	npc.npc_stopped = 0;
	
	rtrue;
];


!------------------------------------------------------------------------------
!
!	N P C _ S T O P F O L L O W P L A Y E R
!
!------------------------------------------------------------------------------
[ NPC_StopFollowPlayer npc;
	npc.npc_move_type = 2;
	rtrue;
];


!------------------------------------------------------------------------------
!
!	N P C _ S C H E D U L E
!
!	Used to schedule an npc movement to happen after a given delay.
!------------------------------------------------------------------------------
[ NPC_Schedule npc target delay;
	if (~~(npc ofclass NPC_Engine))
	{
		NPC_Error(15, npc);
		rfalse;
	}

	if (delay <= 0)
	{
		NPC_Error(9, npc, target);
		rfalse;
	}

	npc.npc_move_type = 2;
	npc.npc_stopped = 0;
	npc.npc_dest = target;

	npc.npc_time_left = delay;
	
	rtrue;
];


!------------------------------------------------------------------------------
!
!	N P C _ S T O P S C H E D U L E
!
!	Stops a set schedule for an NPC.
!------------------------------------------------------------------------------
[ NPC_StopSchedule npc;
	npc.npc_time_left = -1;
	rtrue;
];


!------------------------------------------------------------------------------
!
!	N P C _ M O V E
!
!	Moves an npc. Do not use "move npc to (whatever);" in your code if you
!	use the NPC_Engine. Use this routine instead.
!------------------------------------------------------------------------------
[ NPC_Move npc dest actn dir   visible_now visible_previous x;
	actn = actn;
	
	npc.npc_old_loc = ScopeCeiling(npc);
	npc.npc_old_dir = dir;

	objectloop (x in ScopeCeiling(npc))
		if (x ofclass NPC_Engine && x ~= npc)
		{
			npc.npc_meet(x);
			x.npc_meet(npc);
		}	
	
	if (dest == 0)
	{
		npc.npc_move_type = 2;
		npc.npc_old_loc = 0;
		npc.npc_time_left = -1;
		remove npc;
	}
	else
	{
		move npc to dest;
		
		if ((npc.npc_old_loc == 0) || (NPC_GetDirFor(npc.npc_old_loc, dest) == 0))
			npc.npc_old_loc = dest;
		
		if (npc.npc_win)
			NPC_PrintWindowVisible(npc, npc.npc_win, 1);
		else
		{
			visible_now = NPC_CheckVisible(dest);
			visible_previous = NPC_CheckVisible(npc.npc_old_loc);

			NPC_PrintVisible(location, npc, visible_now, visible_previous);
		}
	}
];


!------------------------------------------------------------------------------
!
!	N P C _ P A T H
!
!	This is just a stub which can be replaced within your story file.
!------------------------------------------------------------------------------
[ NPC_Path npc dest ifblocked use_best;
	NPC__Path(npc, dest, ifblocked, use_best);
];


!------------------------------------------------------------------------------
!	F I N D   S U B
!
!	Deals both with "where is npc?" and "npc, where is npc?" questions
!------------------------------------------------------------------------------
[ FindSub  m i;

	! No noun has been given.
	if (noun == 0)
	{
		NPC_Msg(##Find, 7);
		rtrue;
	}	

	! The given object is clearly visible to the actor (this one might cause trouble in certain
	! situations where something is visible to the actor who is being asked, but invisible to
	! the player)
	if (ScopeCeiling(noun) == ScopeCeiling(actor) && TestScope(noun, actor))
	{
		if (actor == player)
			NPC_Msg(##Find, 9, noun);
		else
			NPC_Msg(##Find, 8, noun);
		rtrue;
	}
	else if (noun ofclass NPC_Engine)
	{
		if (actor == player)
		{
			m = noun.npc_met;
			
			i = NPC_CheckVisible(ScopeCeiling(noun));
			
			if (i)
			{
				noun.npc_met = turns;
				NPC_Msg(##NPC_PrintVisible, 1, noun, i);
				rtrue;
			}
		}				
		else
			m = actor.npc_last_saw(noun);
		
		if (m == 0)
			NPC_Msg (##Find, 5, actor, noun);
		else
		{
			i = turns - m;	! That's the time that's passed since actor met noun

			#ifdef NPC_DEBUG;
				if (parser_trace >= 2)
					print "[time since last meeting: ", i, " minutes]^";
			#endif;

			NPC_Msg(##Find, 2, actor, noun);
				
			if (i > 120)		NPC_Msg(##Find, 1, 1);
			else if (i > 80)	NPC_Msg(##Find, 1, 2);
			else if (i > 45)	NPC_Msg(##Find, 1, 3);
			else if (i > 30)	NPC_Msg(##Find, 1, 4);
			else if (i > 10)	NPC_Msg(##Find, 1, 5);
			else if (i > 5)		NPC_Msg(##Find, 1, 6);
			else				NPC_Msg(##Find, 1, 7);
			
			if (actor ~= player)
				NPC_Msg(##Find, 3, actor, noun);

			new_line;
		}
	}		
	else
		NPC_Msg(##Find, 4, actor);
	
	rtrue;
];

	
!------------------------------------------------------------------------------
!
!	N P C _ P R E P A T H
!
!	Used like in moveclass.h.
!------------------------------------------------------------------------------
[ NPC_PrePath npc arname arentries   i;
	if (npc ofclass NPC_Engine)
	{
		npc.npc_stage = arentries - 1;
		npc.npc_move_type = 3;
		
		for (i = 0: i < arentries: i++)
			npc.&npc_dirs->i = arname->(arentries - i - 1);

		npc.npc_path_size = arentries;
	}
	else
	{
		NPC_Error(12, npc);
		rfalse;
	}
	
	rtrue;
];


!----------------------------------------------------------------------------	
!
!	N P C _ _ P A T H
!
!	Tries to find a path for the given npc from its current ScopeCeiling to
!	the destination given.
!----------------------------------------------------------------------------	
[ NPC__Path npc dest ifblocked use_best   i src rval;
	ifblocked = ifblocked;
	use_best = use_best;

	if (~~(npc ofclass NPC_Engine))
	{
		NPC_Error(15, npc);
		rfalse;
	}

	src = ScopeCeiling(npc);

	if (parent(npc) ~= src)
		move npc to src;

	if (src == dest)
	{
		#ifdef NPC_DEBUG;
			if (parser_trace >= 3)
				print "    [NPC__Path called for ", (name) npc, " with src
					and dest = ", (name) src, ".]^";
		#endif;

		if (npc.npc_arrived(dest))
			give tw_waiting on;
		
		rtrue;
	}
	
	npc.npc_target = dest;
	npc.npc_source = src;
	npc.npc_door_passed = 0;
	
	#ifdef PATH_MOVE_TYPE;
		for (i = 0: i < 32: i++)
			npc.&npc_dirs->i = 0;

		rval = NPC_FindPath(npc, dest);
		npc.npc_stage = npc.npc_path_size;
		npc.npc_move_type = 3;
	#endif;

	#ifdef SUBWAY_MOVE_TYPE;
		i = i;
		rval = 1;
		npc.npc_move_type = 4;
	#endif;
	
	if (~~rval)
	{
		npc.npc_move_type = 2;
		NPC_Error(4, npc, dest);
		rfalse;
	}

	rtrue;
];


!------------------------------------------------------------------------------
!
!	G O T O _ S U B
!
!------------------------------------------------------------------------------

[ NPC_GotoSub   i;
	if (ScopeCeiling(noun) == location)
	{
		NPC_Msg(##NPC_Goto, 1);
		rtrue;
	}

	move npc_temp_npc to location;

	npc_temp_npc.npc_target = ScopeCeiling(noun);
	npc_temp_npc.npc_source = location;
	npc_temp_npc.npc_door_passed = 0;
	
	for (i = 0: i < 32: i++)
		npc_temp_npc.&npc_dirs->i = 0;

	NPC_FindPath(npc_temp_npc, ScopeCeiling(noun));
	npc_temp_npc.npc_stage = npc_temp_npc.npc_path_size;

	if (npc_temp_npc.&npc_dirs->npc_temp_npc.npc_stage)
	{
		NPC_Msg(##NPC_Goto, 3, noun);
		< Go (npc_temp_npc.&npc_dirs->npc_temp_npc.npc_stage) >;
	}
	else
		NPC_Msg(##NPC_Goto, 2);

	remove npc_temp_npc;

	rtrue;
];


!------------------------------------------------------------------------------
!
!	N P C _ T E R M I N A T E   M O V E M E N T
!
!	Used to reset all movement variables for a given NPC, thus stopping his
!	movement.
!
!------------------------------------------------------------------------------
[ NPC_TerminateMovement npc;
	npc.npc_move_type = 2;
	npc.npc_current_line = 0;
	npc.npc_old_loc = parent(npc);
	npc.npc_next_line = 0;
	
	rtrue;
];


!==============================================================================
!
!	5.  N P C   V I S I B I L I T Y   A N D   D E S C R I P T I O N
!
!==============================================================================


!------------------------------------------------------------------------------
!
!	N P C _ P R I N T   V I S I B L E
!
! This routine does the actual printing of visible NPCs depending on the given 
! arguments:
!
! 	loc				location where we print this from
!	npc				npc
!	new_visible		direction npc is visible to; this value has most certainly
!					been calculated by NPC_CheckVisible()
!	old_visible		previous direction npc was visible to; this value has
!					as well most certainly been calculated by NPC_CheckVisible()
!	flag			1 means: include characters who aren't moving
!
! The routine returns true if it printed a message, otherwise false
!------------------------------------------------------------------------------

[ NPC_PrintVisible loc npc new_visible old_visible flag   rval;
	#ifdef NPC_DEBUG;
		if (parser_trace >= 2)
		{
			print "^[NPC_PrintVisible with ", (the) npc, " from ", (name) loc, " - 
				last dir of visibility: ", (name) old_visible, " - new dir: ",
				(name) new_visible, " - flag: ", flag, ".]^";
			print "    [npc is in: ", (name) ScopeCeiling(npc), " - previous
				location: ", (name) npc.npc_old_loc, " - previous_dir: ",
				(name) npc.npc_old_dir, ".]^";
		}
	#endif;
	
	! Take care of meeting between NPC and player
	if (new_visible || old_visible)
		npc.npc_met = turns;

	! We've got the following cases:
	! (A) The npc has the npc_hidden attribute set => no message is printed
	! (B) The npc just walked out of the room the player is in.
	! (C) The npc just walked into the room the player is in.
	! (D) The npc isn't moving, but flag is set to 1
	! (E) The npc is stopped at the moment.
	! (F) The npc wasn't visible the last move and comes into view
	! (G) The npc was visible the last move, is moving and still is visible
	! (H) The npc was visible the last move and disappears from sight

	! --- A ---
	! No description, because this NPC has the npc_hidden attribute set
	if (npc has npc_hidden)
	{
		#ifdef NPC_DEBUG;
			if (parser_trace >= 3)
				print "    [", (The) self, " has npc_hidden and will not be described.]^";
		#endif;
	}
	
	! --- B ---
	! The NPC just walked out of the room where we print this from

	else if (npc.npc_old_loc == loc && ScopeCeiling(npc) ~= loc && npc.npc_stopped == 0)
	{
		npc.npc_met = turns;
		
		if (ZRegion(npc.npc_walkoff) == 3)
		{
			print (The) npc, " ", (string) npc.npc_walkoff, " to ";
			LeaveToDir(npc.npc_old_dir);
			print ".^";
		}
		else
			npc.npc_walkoff(npc.npc_old_dir);
		
		rval = true;
	}
	
	! --- C ---
	! The NPC just walked into the room where the player is
		
	else if (ScopeCeiling(npc) == loc && npc.npc_old_loc ~= loc && npc.npc_stopped == 0)
	{
		npc.npc_met = turns;

		if (ZRegion(npc.npc_walkon) == 3)
			NPC_Msg(##NPC_PrintVisible, 8, npc);
		else
			npc.npc_walkon(npc.npc_old_dir);
			
		rval = true;
	}
	
	! --- D ---
	! The NPC isn't moving, but this routine was called with flag == 1 (what probably 
	! means that it was called because the player looked through a window).

	else if (ScopeCeiling(npc) == npc.npc_old_loc && new_visible ~= 0 && npc.npc_stopped == 0)
	{
		if (flag == 1)
		{
			#ifdef NPC_DEBUG;
				if (parser_trace >= 3)
					print "    [NPC isn't moving, but flag is 1.]^";
			#endif;

			NPC_Msg(##NPC_PrintVisible, 1, npc, new_visible);

			rval = true;
		}
	}
	
	! --- E ---
	! The NPC isn't moving because he is stopped at the moment.
	
	else if (npc.npc_stopped > 0 && new_visible ~= 0)
	{
		#ifdef NPC_DEBUG;
			if (parser_trace >= 3)
				print "    [NPC is stopped.]^";
		#endif;

		NPC_Msg(##NPC_PrintVisible, 1, npc, new_visible);
			
		rval = true;
	}
	else if (new_visible ~= 0)
	{
		! --- F ---
		! The NPC wasn't visible before, but now comes into sight
		
		if (old_visible == 0 && npc.npc_old_loc ~= loc)
		{
			#ifdef NPC_DEBUG;
				if (parser_trace >= 3)
					print "    [NPC was not visible before and now comes into view.]^";
			#endif;
			
			NPC_Msg(##NPC_PrintVisible, 2, npc, new_visible);

			if (npc.npc_door_passed)
				NPC_Msg(##NPC_PrintVisible, 3, npc);
				
			NPC_Msg(##NPC_PrintVisible, 4, npc, loc);
			
			rval = true;
		}
		
		! --- G ---
		! The NPC was visible the last move and still is
		
		else if (ScopeCeiling(npc) ~= npc.npc_old_loc)
		{
			#ifdef NPC_DEBUG;
				if (parser_trace >= 3)
					print "    [NPC was visible before and still is.]^";
			#endif;

			NPC_Msg(##NPC_PrintVisible, 5, npc, new_visible);

			rval = true;
		}
	}

	! --- H ---
	! The NPC was visible the last move and now disappears from sight
	
	else if (new_visible == 0 && old_visible && ScopeCeiling(npc) ~= npc.npc_old_loc)
	{
		#ifdef NPC_DEBUG;
			if (parser_trace >= 3)
				print "    [NPC was visible before and now disappears from sight.]^";
		#endif;

		NPC_Msg(##NPC_PrintVisible, 6, npc, old_visible);
		
		if(npc.npc_door_passed)
			NPC_Msg(##NPC_PrintVisible, 3, npc);

		NPC_Msg(##NPC_PrintVisible, 7, npc);

		rval = true;
	}
	! Here come the game-specific things...
	else if (NPC_AfterPrintVisible(npc, loc))
	{
		#ifdef NPC_DEBUG;
			if (parser_trace >= 3)
				print "    [NPC_AfterPrintVisible returned true.]^";
		#endif;

		rval = true;
	}
	
	! Nothing happens at all: NPC wasn't visible before and still isn't.
	else
	{
		#ifdef NPC_DEBUG;
			if (parser_trace >= 3)
				print "    [NPC was not visible before and still isn't.]^";
		#endif;
	}

	! If this was set, we informed the player about it and must clear it now
	npc.npc_door_passed = 0;
	
	! Now let's see if we printed anything at all. If so, we set tw_waiting to on and clear
	! the npc's window property
	if (rval)
	{
		npc.npc_win = 0;
		give tw_waiting on;
	}

	#ifdef NPC_DEBUG;
		if (parser_trace >= 2)
			print "[NPC_PrintVisible returns ", rval, ".]^";
	#endif;
	
	! And return true if we did print something, otherwise false
	return(rval);
];


!------------------------------------------------------------------------------
!
!	N P C _ A F T E R   P R I N T   V I S I B L E
!
!	This is a stub for an entry point. A story may replace this to check if
!	it wants to print a message of its own.
!------------------------------------------------------------------------------
[ NPC_AfterPrintVisible npc loc;
	npc = npc;
	loc = loc;
	rfalse;
];


!------------------------------------------------------------------------------
!
!	N P C _ C H E C K V I S I B L E
!
!	This routine checks if the location given ("loc") is visible from the 
!	location of the player (if one argument is given) or from the location
!	given (if two args are passed).
!------------------------------------------------------------------------------
[ NPC_CheckVisible test_loc current_room    current_compass check dir last_room tmp;

	! If no location was given as an argument, we take the player's current location
	if (~~current_room)
		current_room = location;

	tmp = current_room;

	#ifdef NPC_DEBUG;
		if (parser_trace >= 3)
			print "^[NPC_CheckVisible called for room '", (name) test_loc,
				"' from location '", (name) current_room, "'.]^";
	#endif;

	! If the rooms are the same or test_loc is nothing, return false
	if (test_loc == current_room || test_loc == nothing)
	{
		#ifdef NPC_DEBUG;
			if (parser_trace >= 3)
				print "[NPC_CheckVisible returns false: Rooms are the same or test_loc is nothing.]^";
		#endif;
		
		rfalse;
	}

	! Calling a story entry point to prevent certain rooms from being visible
	if (NPC_BeforeCheckVisible(current_room, test_loc))
	{

		#ifdef NPC_DEBUG;
			if (parser_trace >= 3)
				print "[NPC_CheckVisible returns false: NPC_BeforeCheckVisible returned true.]^";	
		#endif;

		rfalse;
	}

	! Now go through all the objects in the compass to check if we can see the test_loc in that 
	! direction
	objectloop (current_compass in Compass)
	{
		current_room = tmp;
		last_room = current_room;
		
		! Get the direction that compass objects points to
		dir = ObjectOrRun(current_compass, door_dir);

		#ifdef NPC_DEBUG;
			if (parser_trace >= 4)
				print "    [Looking to '", (name) current_compass,
					"' in room '", (name) current_room, "']^";
		#endif;

		! Now we go in the current compass direction until we can't any longer
		while (1)
		{
			if (ZRegion(current_room.dir) == 0 or 3)
			{
				#ifdef NPC_DEBUG;
					if (parser_trace >= 4)
						print "      [Nothing or string found -- finished with this direction.]^";
				#endif;
				
				jump NextCompass;
			}
				
			check = ObjectOrRun(current_room, dir);
			
			#ifdef NPC_DEBUG;
				if (parser_trace >= 4)
					print "      [Found: '", (name) check, "' with ZRegion ", ZRegion(check), "]^";
			#endif;

			! This is a door, but we can never see through doors, open or closed
			if (check has door)
				jump NextCompass;
					
			! We have found a compass direction in which the test_loc is
			! visible from the location of the player
			if (test_loc == check)
			{

				#ifdef NPC_DEBUG;
					if (parser_trace >= 3)
						print "[NPC_CheckVisible returns '", (name) current_compass, "'.]^";
				#endif;

				return(current_compass);
			}
			
			! If not, we go on in the direction
			last_room = current_room;
			current_room = check;
		}
		
		.NextCompass;
	}

	#ifdef NPC_DEBUG;
		if (parser_trace >= 3)
			print "[NPC_CheckVisible returns false.]^";	
	#endif;

	rfalse;
];


!------------------------------------------------------------------------------
!
!	N P C _ B E F O R E C H E C K V I S I B L E
!
!	A story entry point called before NPC_CheckVisible takes place. May be 
!	replaced by a story file to avoid going through NPC_CheckVisible by 
!	returning true.
!	Is passed current_room, where NPC_CheckVisible would start from, and
!	test_loc, the location the visibility of which is to be checked.
!------------------------------------------------------------------------------
[ NPC_BeforeCheckVisible current_room test_loc;
	current_room = current_room;
	test_loc = test_loc;
	rfalse;
];


!----------------------------------------------------------------------------	
!	N P C _ L O O K   T H R O U G H   W I N D O W
!----------------------------------------------------------------------------	
[ NPC_LookThroughWindow win   npc;
	npc = npc_first_npc;
	
	while (npc)
	{
		npc.npc_win = win;
		npc = npc.npc_next;
	}
];


!----------------------------------------------------------------------------	
!	N P C _ P R I N T  W I N D O W  V I S I B L E
!
!	This one prints npc's visible through the given window win.
!------------------------------------------------------------------------------
[ NPC_PrintWindowVisible npc win always    dto ddir new old msg_printed k l m address;
	#ifdef NPC_DEBUG;
		if (parser_trace >= 3)
			print "[NPC_PrintWindowVisible called for ", (name) win,
				" with always = ", always, ".]^";	
	#endif;

	if (win provides door_dir && win provides door_to && win provides looks_to)
	{
		dto = ObjectOrRun(win, door_to);
		ddir = ObjectOrRun(win, door_dir);
		
		NPC_Visible_Room.ddir = dto;
	
		#ifdef NPC_DEBUG;
			if (parser_trace >= 4)
				print "    [NPC_PrintWindowVisible: dto = ", (name) dto,
					" - dir = ", (name) ddir, ".]^";	
		#endif;

		address = win.&looks_to;
			
		if (address ~= 0)
		{
			if (ZRegion(address-->0) == 2)
			{
				NPC_Error(16, win);
				rfalse;
			}
			else
			{
				k=win.#looks_to;

				new = 0;
				old = 0;
				for (l=0: l < k/2: l++)
				{
					m = address-->l;
					if (ScopeCeiling(npc) == m)
						new = NPC_DirForTo(ddir);
					else if (npc.npc_old_loc == m)
						old = NPC_DirForTo(ddir);
				}
			}
				

			#ifdef NPC_DEBUG;
				if (parser_trace >= 3)
					print "    [Calling NPC_Print Visible with npc = ",
						(name) npc, " - new = ", (name) new, " - old = ",
						(name) old, "]^";
			#endif;

			if(NPC_PrintVisible (NPC_Visible_Room, npc, new, old, always))
				msg_printed = 1;
		}
			
		
		NPC_Visible_Room.ddir = 0;

		npc.npc_win = 0;

		if (msg_printed)
			rtrue;
	}

	rfalse;
];



!==============================================================================
!
!	6.  N P C   F O L L O W I N G
!
!==============================================================================


!------------------------------------------------------------------------------
!	A dummy npc object used to calculate a path for PATH_following
!------------------------------------------------------------------------------
Object npc_temp_npc
	class NPC_Engine
	has concealed;


!------------------------------------------------------------------------------
!	
!	F O L L O W S U B
!
!	Action routine for the follow verb.
!------------------------------------------------------------------------------
[ FollowSub    savenoun savepos succ i;
	if (NPC_BeforeFollowing(noun))
	{
		#ifdef NPC_DEBUG;
			if (parser_trace >= 2)
				print "[FollowSub: Can't follow ", (name) noun, ": NPC_BeforeFollowing
					returned true.]^";
		#endif;
		
		rfalse;
	}

	savenoun = noun;
	savepos = location;
	
	move npc_temp_npc to location;

	npc_temp_npc.npc_target = ScopeCeiling(noun);
	npc_temp_npc.npc_source = location;
	npc_temp_npc.npc_door_passed = 0;
	
	for (i = 0: i < 32: i++)
		npc_temp_npc.&npc_dirs->i = 0;

	NPC_FindPath(npc_temp_npc, ScopeCeiling(noun));
	npc_temp_npc.npc_stage = npc_temp_npc.npc_path_size;

	< Go (npc_temp_npc.&npc_dirs->npc_temp_npc.npc_stage) >;

	remove npc_temp_npc;	

	if (location ~= savepos)
		succ = 1;
	else
		succ = 0;

	NPC_AfterFollowing(savenoun, savepos, succ);
	
	rtrue;
];


!------------------------------------------------------------------------------
!
!	N P C _ B E F O R E F O L L O W I N G
!
!	Default for a story entry point called before a following action will take
!	place. May cancel the following action by returning true.
!------------------------------------------------------------------------------
[ NPC_BeforeFollowing item;
	if (item == player)
		return(NPC_Msg(##Follow, 2));

    if (~~(item ofclass NPC_Engine))
		return(NPC_Msg(##Follow, 3, item));

    if (ScopeCeiling(item) == location)
		return(NPC_Msg(##Follow, 4, item));

	if (item.npc_met == 0)
		return(NPC_Msg(##Follow, 5, item));

    if (turns - item.npc_met > 0)
		return(NPC_Msg(##Follow, 6, item));

	rfalse;
];


!------------------------------------------------------------------------------
!
!	N P C _ A F T E R F O L L O W I N G
!
!	Default for a story entry point called after a following action has taken 
!	place.
!------------------------------------------------------------------------------
[ NPC_AfterFollowing item oldpos succ;
	item = item;
	oldpos = oldpos;
	succ = succ;

	rfalse;
];



!==============================================================================
!
!	7.  M O V E M E N T   T Y P E   D E P E N D A N T   R O U T I N E S
!
!==============================================================================


!----------------------------------------------------------------------------	
!
!	N P C _ F I N D   P A T H
!
!	Finds the shortest path for the given npc from its current ScopeCeiling
!	to the destination given. Stores this path in the "npc_dirs" array of
!	the given npc in reverse order. Sets the npc.path_size to the size of
!	the array.
!
!	Will return false if no path was found. It will not print an error
!	message in this case.
!
!----------------------------------------------------------------------------	

[ NPC_FindPath npc dest   src i count the_room dir neighbour q;
	src = ScopeCeiling(npc);

	! If a destination was given that is not of the NPC_Room class, we'll try
	! to set the destination to the room that object is in.
	while ((~~(dest ofclass NPC_Room)) && (parent(dest) ~= nothing))
		dest = parent(dest);

	if (~~(src ofclass NPC_Room))
		rfalse;
	
	#ifdef NPC_DEBUG;
		if (parser_trace >= 3)
			print "  [NPC_FindPath called with npc = ", (name) npc, " in ", (name) src,
				" and dest = ", (name) dest, ".]^";
	#ENDIF;

	i = npc_first_room;
	
	! Cleaning up rooms
	while (i)
	{
		i.npc_label = 32767;
		i.npc_prev_dir = 0;
		give i ~npc_explored;

		i = i.npc_number;
	}
	
	! Set label of source room to 0, so the algorithm knows where to start
	src.npc_label = 0;

	! Main loop begins
	do
	{
		! Increase counter by one
		count++;
		
		#ifdef NPC_DEBUG;
			if (parser_trace >= 4)
				print "    [Iteration #", count, ".]^";		
		#endif;

		the_room = 0;
		q = 0;
		
		i = npc_first_room;
		
		! Select unexplored room with minimum label
		while (i)
		{
			if (i hasnt npc_explored)
			{
				q++;
			
				if (the_room == 0)
					the_room = i;	
				else if (i.npc_label <= the_room.npc_label)
					the_room = i;
			}

			i = i.npc_number;
		}

		! Couldn't find another room to explore - this must be the end
		if (q == 0)
			jump end_of_exploration;

		! The room we chose now gets the npc_explored attribute
		give the_room npc_explored;

		#ifdef NPC_DEBUG;
			if (parser_trace >= 4)
				print "      [Room chosen: ", (name) the_room, " -- giving it explored.]^";		
		#endif;

		! And we go through all compass directions in that room		
		objectloop (i in Compass)
		{
			dir = i.door_dir;

			if (ZRegion(the_room.dir) == 0 or 3)
				continue;

			neighbour = ObjectOrRun(the_room, dir);

			#ifdef NPC_DEBUG;
				if (parser_trace >= 4)
					print "        [Direction in room: ", (name) i, " -- ZRegion = ",
						ZRegion(neighbour), ".]^";		
			#endif;
			
			! There's a door in that direction! See if we can open it...
			if (neighbour && neighbour has door)
				neighbour = NPC_GetOtherSide(the_room, neighbour);

			! Okay, there is a room	and its label is less than that of the currently explored room
			if (neighbour && neighbour ofclass NPC_Room && neighbour.npc_label > the_room.npc_label)
			{
				#ifdef NPC_DEBUG;
					if (parser_trace >= 4)
						print "    [Direction ", (name) i, " in ", (name) the_room,
							" leads to ", (name) neighbour, ".]^";
				#endif;
				
				neighbour.npc_label = the_room.npc_label + 1;
				neighbour.npc_prev_room = the_room;
				neighbour.npc_prev_dir = i;
					
				#ifdef NPC_DEBUG;
					if (parser_trace >= 4)
						print "      [Setting label of ", (name) neighbour, " to ",
							neighbour.npc_label, ".]^";
				#endif;
			}
			
			if (neighbour == dest)
				jump end_of_exploration;
		}
		
	} until (0);

	.end_of_exploration;
	
	i = dest;
	q = 0;
	
	if (i.npc_prev_dir)
	{
		#ifdef NPC_DEBUG;
			if (parser_trace >= 3)
				print "    [Path found for ", (name) npc, " from ", (name) src, " to ", (name) dest, ":";	
		#endif;
		
		! Copy the path found into the npc_dirs array of the npc given
		while (i.npc_prev_dir)
		{
			#ifdef NPC_DEBUG;
				if (parser_trace >= 3)
					print " ", (name) i.npc_prev_dir, " (from ", (name) i, ") ";
			#endif;
			
			if (q > 31)
			{
				NPC_Error(17, npc, dest);
				rfalse;
			}
			
			npc.&npc_dirs->q = i.npc_prev_dir;
			q++;
			i = i.npc_prev_room;
		}
	}
	else
		rfalse;

	#ifdef NPC_DEBUG;
		if (parser_trace >= 3)
			print ".]^";
	#endif;
	
	! Set the correct path size for the npc
	npc.npc_path_size = q-1;

	#ifdef NPC_DEBUG;
		if (parser_trace >= 3)
			print "     [Setting path size to ", npc.npc_path_size, ".]^";
	#endif;
		
		
	rtrue;
];


!------------------------------------------------------------------------------
!
!	N P C _ S E T U P L I N E C O N N E C T I O N S
!
!	Initialises the pseudo-two-dimensional array that holds all the line
!	connections.
!------------------------------------------------------------------------------
[ NPC_SetupLineConnections   i j k m n room;
	for (i = 1: i < NUMBER_OF_LINES: i++)
	{
		k = 1;

		line_connections-->(i*MULTIPLY) = i;

		for (j = 0: j < MAX_INTERSECTIONS: j++)
		{
			room = intersection_list-->j;
	
			if (~~room)
				break;
		
			for (m = 0: m < NPC_LinesInRoom(room): m++)
				if (room.&npc_subway-->m == i)
				{
					for (n = 0: n < NPC_LinesInRoom(room): n++)
						if (room.&npc_subway-->n ~= i)
						{
							line_connections-->(i*MULTIPLY+k) = room.&npc_subway-->n;
							k++;
						}
					break;
				}
		}
		
		number_of_connections-->i = k;
	}
];

!------------------------------------------------------------------------------		
!
!	N P C _ L I N E S I N R O O M
!
!	Returns the number of subway lines running through a given room.
!------------------------------------------------------------------------------		
[ NPC_LinesInRoom room;
	if (room ofclass NPC_Room)
		return room.#npc_subway / 2;
	return (0);
];


!------------------------------------------------------------------------------		
!
!	N P C _ I S I N T E R S E C T I O N
!
!	Tests whether the given room is an intersection. returns
!	true if so, otherwise false.
!------------------------------------------------------------------------------		
[ NPC_IsIntersection room;
	if (room ofclass NPC_Room && room.#npc_subway > 2)
		rtrue;
	rfalse;
];


!------------------------------------------------------------------------------
!
!	N P C _ T E S T R O O M F O R L I N E
!
!	Checks whether the given line runs through the given room
!	or not. Returns true or false respectively.
!------------------------------------------------------------------------------
[ NPC_TestRoomForLine room line   i;
	for(i = 0: i < NPC_LinesInRoom(room): i++)
	{
		if (room.&npc_subway-->i == line)
			rtrue;
	}
	
	rfalse;
];


!------------------------------------------------------------------------------
!
!	N P C _ L I N E S M E E T
!
!	Tests if the given lines meet somewhere; returns the room if they do,
!	otherwise false
!------------------------------------------------------------------------------
[ NPC_LinesMeet line1 line2   i j k n r;
	for (i = 0: i < MAX_INTERSECTIONS: i++)
	{
		r = intersection_list-->i;
		
		if (~~r)
			continue;
		
		n = NPC_LinesInRoom(r);
		
		for (j = 0: j < n: j++)
			for (k = j+1: k < n: k++)
				if ((r.&npc_subway-->j == line1 && r.&npc_subway-->k == line2)
						 || (r.&npc_subway-->j == line2 && r.&npc_subway-->k == line1))
					return (r);
					
	}
	
	rfalse;
];


!------------------------------------------------------------------------------
!
!	N P C _ G E T N E I G H B O U R S
!
!	Sets the array adjacent_rooms-->0 and -->1 to the neighbours of the
!	given room on the given line.
!	Returns the number of neighbours found.
!
!------------------------------------------------------------------------------
[ NPC_GetNeighbours r line   room_in_dir i j dir;
	adjacent_rooms-->0 = 0;
	adjacent_rooms-->1 = 0;

	j = 0;

	objectloop (i in compass)
	{
		dir = i.door_dir;

		if (ZRegion(r.dir) == 0 or 3)
			continue;
		
		room_in_dir = ObjectOrRun(r, dir);

		room_in_dir = NPC_GetOtherSide(r, room_in_dir);

		if (~~ NPC_TestRoomForLine(room_in_dir, line))
			continue;
		
		if (room_in_dir == adjacent_rooms-->0 or adjacent_rooms-->1)
			continue;
		
		adjacent_rooms-->j = room_in_dir;

		if (++j == 3)
		{
			NPC_Error(19, r, line);
			rfalse;
		}
	}

	return(j);
];                                                                                                                                              


!------------------------------------------------------------------------------
!
!	N P C _ F I N D N E X T M O V E
!
!	Finds the next move of the given npc in source_room, trying to get to
!	target_room
!
!	Returns the room found, otherwise false.
!
!	If no room was found, this one will not print an error message.
!
!------------------------------------------------------------------------------
[ NPC_FindNextMove npc source_room target_room   i j k current_line target_line next_room source_line count tmp;
	! If a destination was given that is not of the NPC_Room class, we'll try
	! to set the destination to the room that object is in.
	while ((~~(target_room ofclass NPC_Room)) && (parent(target_room) ~= nothing))
		target_room = parent(target_room);

	if (~~(source_room ofclass NPC_Room))
		rfalse;
	
	#ifdef NPC_DEBUG;
		if (parser_trace >= 2)
			print "^[NPC_FindNextMove called for ", (name) npc, " in ",
				(name) source_room, " with target room ", (name) target_room, ", currently on ",
				(string) Subway_Names-->npc.npc_current_line, ", trying to get to ",
				(string) Subway_Names-->npc.npc_next_line, ".]^";
	#endif;

	! First of all, let's see if we can get on one direct line from the source to the target room
	for (i = 0: i < NPC_LinesInRoom(source_room): i++)
		for(j = 0: j < NPC_LinesInRoom(target_room): j++)
			if (source_room.&npc_subway-->i == target_room.&npc_subway-->j)
			{
				#ifdef NPC_DEBUG;
					if (parser_trace >= 2)
						print "[Found direct connection on line ", (string) Subway_Names-->(source_room.&npc_subway-->i), ".]^";
				#endif;
				
				return(NPC_WalkOnLine(npc, source_room.&npc_subway-->i, target_room));
			}

	if (~~ NPC_IsIntersection(source_room))
		current_line = source_room.npc_subway;
	else if (npc.npc_next_line && ~~ NPC_TestRoomForLine(source_room, npc.npc_next_line))
		current_line = npc.npc_current_line;
	else
		current_line = 0;
		
	! Next case: Either the current room isn't an intersection, so there's only one line, or
	! the next_line doesn't run through the room, so we don't have to bother with it.
	! We check whether it's a dead end or whether one of the adjacent rooms is the last room the
	! NPC was in, because these are special cases that don't require to search for
	! a line
	if (current_line)
	{
		#ifdef NPC_DEBUG;
			if (parser_trace >= 2)
				print "  [There's only one line in current room or the next line doesn't run through
					this room. Setting current line to: ", (string) subway_names-->current_line, ".]^";
		#endif;
		
		j = NPC_GetNeighbours (source_room, current_line);

		! First case: The current room is a dead end, so just walk in the other direction
		if (j == 1)
		{
			#ifdef NPC_DEBUG;
				if (parser_trace >= 2)
					print "[NPC is in a dead end. Returning ", (name) adjacent_rooms-->0, ".]^";
			#endif;
			return(adjacent_rooms-->0);
		}

		! Testing if one of the rooms is the room the npc was just in
		if (npc.npc_old_loc)
			for (i = 0: i < 2: i++)
				if (adjacent_rooms-->i == npc.npc_old_loc)
				{
					#ifdef NPC_DEBUG;
						if (parser_trace >= 2)
							print "[Adjacent room (", (name) adjacent_rooms-->i, ") ==
								npc.npc_old_loc. Returning  other adjacent (",
								(name) adjacent_rooms-->(1-i), ").]^";
					#endif;
					return (adjacent_rooms-->(1-i));
				}

		! So, there IS a current_line and a next_line, but we don't know where
		! the NPC came from (maybe he's been stopped by the player?).
		if (npc.npc_next_line)
		{		
			#ifdef NPC_DEBUG;
				if (parser_trace >= 3)
					print "  [NPC is on ", (string) Subway_Names-->current_line, " and
						tries to get to ", (string) Subway_Names-->npc.npc_next_line, ".]^";
			#endif;

			next_room = NPC_LinesMeet(current_line, npc.npc_next_line);
		
			tmp = NPC_WalkOnLine(npc, current_line, next_room);
		
			if (tmp)
			{
				#ifdef NPC_DEBUG;
					if (parser_trace >= 2)
						print "[NPC must go to ", (name) tmp, " to get to next
							intersection / target room ", (name) next_room, ".]^";
				#endif;

				return(tmp);
			}
		}
	}

	! Ok, it has to be the big search thing, then.
	
	! First we clear the finished_lines array, which will later be used to indicate
	! lines that have been recursed already.
	for (i = 0: i < NUMBER_OF_LINES: i++)
		finished_lines-->i = 0;

	! Set the current_line to finished; this avoids NPCs going round in circles
	finished_lines-->npc.npc_current_line = 1;
		
	! Set this global to zero to indicate that we haven't found a solution yet
	npc_found_line = 0;

	! We cycle through all the lines in the source room
	for (i = 0: i < NPC_LinesInRoom(source_room): i++)
	{
		source_line = source_room.&npc_subway-->i;

		! If this line has already been followed, skip it
		if (finished_lines-->source_line)
			continue;

		! Store this line as best bet for the NPCs current line
		npc.npc_current_line = source_line;

		finished_lines-->source_line = 1;
		
		count = number_of_connections-->source_line;
		
		#ifdef NPC_DEBUG;
			if (parser_trace >= 3)
				print "  [NPC_FindNextMove is looking at ", (string) Subway_Names-->source_line, ",
					which has ", count, " intersections.]^";
		#endif;

		! Now we go through all the connections this line has...
		for(k = 1: k < count: k++)
		{
			current_line = line_connections-->(source_line*MULTIPLY+k);

			#ifdef NPC_DEBUG;
				if (parser_trace >= 3)
					print "    [Setting current_line to ", (string) Subway_Names-->current_line, ".]^";
			#endif;

			! If this line has already been followed, skip it
			if (finished_lines-->current_line)
				continue;

			! Store this line as best bet for the NPCs next line
			npc.npc_next_line = current_line;
			
			! If we're on an intersection and the current_line goes through the
			! room, it'll be a source_line later, so we don't need to test it
			! here (in fact, if we do, we'll mess things up quite a bit)
			if (NPC_TestRoomForLine(source_room, current_line))
				continue;
			
			! Mark this line as followed
			finished_lines-->current_line = 1;
			
			! ... and cycle through all the lines in the target room
			for (j = 0: j < NPC_LinesInRoom(target_room): j++)
			{
				target_line = target_room.&npc_subway-->j;

				! Now call the recursive search function to see if we can
				! find matching lines here.
				if(NPC_RecurseLine(current_line, target_line))
				{
					next_room = NPC_LinesMeet(source_line, current_line);

					#ifdef NPC_DEBUG;
						if (parser_trace >= 3)
							print "  [Possible next target room '", (name) next_room, "' found via line ",
								(string) Subway_Names-->current_line, ".]^";
					#endif;

					! We have to make sure the new room isn't the one we're currently in
					! or the one the NPC just came from (shouldn't happen, just to be on the
					! safe side)
					if (next_room ~= source_room)
					{
						tmp = NPC_WalkOnLine(npc, source_line, next_room);
						
						if (tmp && tmp ~= npc.npc_old_loc)
						{
							#ifdef NPC_DEBUG;
								if (parser_trace >= 2)
									print "[Found next room '", (name) tmp, "'. NPC is on line ",
										(string) subway_names-->npc.npc_current_line, " and tries to get to ",
										(string) subway_names-->npc.npc_next_line, ".]^";
							#endif;
							return(tmp);
						}
					}
				}
			}
		}
	}
	
	npc.npc_current_line = 0;
	npc.npc_next_line = 0;
	
	rfalse;
];



!------------------------------------------------------------------------------
!
!	N P C _ R E C U R S E L I N E
!
!	Recursive routine that searches for a target_line along a given current_line
!
!------------------------------------------------------------------------------
[ NPC_RecurseLine current_line target_line   count i;
	count = number_of_connections-->current_line;

	#ifdef NPC_DEBUG;
		if (parser_trace >= 2)
			print "    [NPC_RecurseLine with current_line = ", (string) Subway_Names-->current_line, " and 
			target_line = ", (string) Subway_Names-->target_line, " found ", count, " intersections
			for current_line.]^";
	#endif;
	
	for (i = 0: i < count: i++)
	{
		if (line_connections-->(current_line*MULTIPLY+i) == target_line)
		{
			#ifdef NPC_DEBUG;
				if (parser_trace >= 2)
					print "    [NPC_RecurseLine -- line found: ", (string) Subway_Names-->target_line, ".]^";
			#endif;
			
			npc_found_line = 1;
		}
			
		if ((npc_found_line == 0) && (finished_lines-->(line_connections-->(current_line*MULTIPLY+i)) == 0))
		{
			#ifdef NPC_DEBUG;
				if (parser_trace >= 3)
					print "      [ Recursing NPC_RecurseLine with ", (string) Subway_Names-->(line_connections-->(current_line*MULTIPLY+i)), " and ",
						(string) Subway_Names-->target_line, ".]^";
			#endif;

			finished_lines-->(line_connections-->(current_line*MULTIPLY+i)) = 1;
				
			NPC_RecurseLine(line_connections-->(current_line*MULTIPLY+i), target_line);
		}
			
		if (npc_found_line)
			break;
	}
	
	
	return(npc_found_line);
];


!------------------------------------------------------------------------------
!
!	N P C _ W A L K O N L I N E
!
!	Moves the given npc along current_line towards target_room.
!
!------------------------------------------------------------------------------
[ NPC_WalkOnLine npc current_line target_room   j first_adjacent second_adjacent  ignore_room current_room;
	#ifdef NPC_DEBUG;
		if (parser_trace >= 2)
			print "    [NPC_WalkOnLine called for ", (name) npc, " with line = ", (string) Subway_Names-->current_line,
				" and target room ", (name) target_room, ".]^";
	#endif;
	
	j = NPC_GetNeighbours(ScopeCeiling(npc), current_line);

	if (j == 0)
		rfalse;

	if (j == 1)
	{
		#ifdef NPC_DEBUG;
			if (parser_trace >= 2)
				print "    [Only one adjacent room (", (name) adjacent_rooms-->0, ") -- returning it.]^";
		#endif;
		return (adjacent_rooms-->0);
	}

	first_adjacent = adjacent_rooms-->0;
	second_adjacent = adjacent_rooms-->1;
		
	ignore_room = ScopeCeiling(npc);
	current_room = first_adjacent;
		
	while (1)
	{
		#ifdef NPC_DEBUG;
			if (parser_trace >= 3)
				print "      [NPC_WalkOnLine is looking at room: ", (name) current_room, "]^";
		#endif;

		if (current_room == target_room)
		{
			#ifdef NPC_DEBUG;
				if (parser_trace >= 2)
					print "      [Target found. Returning ", (name) first_adjacent, "]^";
			#endif;
			return(first_adjacent);
		}
		
		j = NPC_GetNeighbours(current_room, current_line);

		! The direction we went in is the wrong one ==> the other one must be right and
		! is returned
		if (j == 1)
		{
			#ifdef NPC_DEBUG;
				if (parser_trace >= 2)
					print "      [Dead end -- first_adjacent is wrong, second_adjacent
						(", (name) second_adjacent, ") must be the right one.
						Returning it.]^";
			#endif;
			return (second_adjacent);
		}
		
		if (adjacent_rooms-->0 ~= ignore_room)
		{
			ignore_room = current_room;
			current_room = adjacent_rooms-->0;
		}
		else
		{
			ignore_room = current_room;
			current_room = adjacent_rooms-->1;
		}
	}
];


!==============================================================================
!
!	8.  M I S C   R O U T I N E S
!
!==============================================================================


!------------------------------------------------------------------------------
!
!	N P C _ L O O K R O U T I N E
!
!	Adds descriptions of non-moving or stopped NPCs to room descriptions
!------------------------------------------------------------------------------
[ NPC_LookRoutine o i;
	o = npc_first_npc;
	
	while (o)
	{
		if ((o.npc_move_type == 2 || o.npc_stopped > 0) && o hasnt concealed)
		{
			i = NPC_CheckVisible(ScopeCeiling(o));

			! Because the turns variable will be increased only after we
			! have done this, we increase it temporarily now...
			turns++;			
			NPC_PrintVisible(location, o, i, i, 1);
			
			! ... and decrease it again. Otherwise, following will mess up.
			turns--;
		}
		o = o.npc_next;
	}
];


!------------------------------------------------------------------------------
!
!	N P C _ G E T O T H E R S I D E
!
!	Returns the room a given direction in a given room leads to. Returns false
!	if a door in that direction cannot be opened by an NPC
!------------------------------------------------------------------------------
[ NPC_GetOtherSide room obj   save_parent save_loc rval;
	if (obj == 0)
		rfalse;

	if (obj hasnt door)
		return obj;
		
	save_parent = parent(obj);
	save_loc = location;
	
	move obj to room;
	location = room;
	rval = ObjectOrRun(obj, door_to);

	if (save_parent)
		move obj to save_parent;
	else
		remove obj;
		
	location = save_loc;
	
	return rval;
];


!------------------------------------------------------------------------------
!
!	N P C _ G E T D I R F O R
!
!	Returns the direction to get from source_room to dest_room, if
!	there's a direct connection between them. If not, it returns false;
!------------------------------------------------------------------------------
[ NPC_GetDirFor source_room dest_room   i j k;
	objectloop (i in Compass)
	{
		j = i.door_dir;

		if (ZRegion(source_room.j) == 0 or 3)
			continue;

		k = ObjectOrRun(source_room, j);
		
		if (k has door)	
			k = NPC_GetOtherSide(source_room, k);
		
		if (k == dest_room)
			return i;
	}
	
	rfalse;
];


!------------------------------------------------------------------------------		
!
!	N P C _ I S D O O R D I R
!
!	Returns the object no. of a door if there's a door in the given
!	dir from room r, otherwise false.
!------------------------------------------------------------------------------		
[ NPC_IsDoorInDir r dir   i k;
	i = dir.door_dir;

	if (ZRegion(r.i) == 0 or 3)
		rfalse;

	k = ObjectOrRun(r, i);

	if (k && k has door)
		return (k);

	rfalse;
];


!------------------------------------------------------------------------------
!
!	L E A V E   T O   D I R
!
!	Prints the corresponding direction for the given compass dir.
!------------------------------------------------------------------------------
[ LeaveToDir i;
	switch (i)
	{
		n_obj:		print "the north";
		s_obj:		print "the south";
		e_obj:		print "the east";
		w_obj:		print "the west";
		ne_obj:		print "the northeast";
		nw_obj:		print "the northwest";
		se_obj:		print "the southeast";
		sw_obj:		print "the southwest";
		u_obj:		print "upstairs";
		d_obj:		print "downstairs";
		in_obj:		print "inside";
		out_obj:	print "outside";
	}
];


!------------------------------------------------------------------------------
!
!	C O M E   F R O M   D I R
!
!	Prints inverted directions.
!------------------------------------------------------------------------------
[ ComeFromDir i;
	switch (i)
	{
		s_obj:		print "the north";
		n_obj:		print "the south";
		w_obj:		print "the east";
		e_obj:		print "the west";
		sw_obj:		print "the northeast";
		se_obj:		print "the northwest";
		nw_obj:		print "the southeast";
		ne_obj:		print "the southwest";
		d_obj:		print "upstairs";
		u_obj:		print "downstairs";
		out_obj:	print "inside";
		in_obj:		print "outside";
	}
];


!------------------------------------------------------------------------------
!
!	N P C _ D I R   F O R   T O
!
!	Returns a direction object for a given dir_to property (e.g. "n_obj" for
!	"n_to", "d_obj" for "d_to" and so on).
!------------------------------------------------------------------------------
[ NPC_DirForTo i   x;
	objectloop (x in Compass)
		if (x.door_dir == i)
			return (x);

	return (0);
];


!------------------------------------------------------------------------------
!
!	O B J E C T   O R   R U N
!
!	This replaces the Inform Library's ValueOrRun() function for the NPC Engine,
!	because ValueOrRun is reported to cause problems in larger games under
!	Library 6/10. Thanks to James Hayes for the bug report and solution.
!------------------------------------------------------------------------------
[ ObjectOrRun obj prop;
	switch (ZRegion(obj.prop))
	{
		0,3: rfalse;
		1: return obj.prop;
		2: return RunRoutines(obj, prop);
	}
];


!==============================================================================
!
!	9.  I N I T I A L I S A T I O N
!
!==============================================================================


!------------------------------------------------------------------------------
!
!	N P C _ I N I T I A L I S E
!
!	This is the initialisation function of the npc engine. Call this one in
!	your game's Initialise() function.
!------------------------------------------------------------------------------
[ NPC_Initialise   current prev c;
	current = 0;
	prev = 0;
	c = 0;
	
	objectloop (current ofclass NPC_Engine)
		if (current ~= npc_temp_npc)
		{
			current.npc_move_type = 2;
			current.npc_old_loc = ScopeCeiling(current);

			#ifndef NPC_MANUAL_NUMBERS;
				current.npc_number = c;

				if (prev)
					current.npc_next = prev;

				prev = current;
			#endif;
			
			if (++c > 31)
			{
				NPC_Error(6);
				@quit;
			}
		}

	#ifndef NPC_MANUAL_NUMBERS;
		npc_first_npc = prev;
	#endif;
	
	prev = 0;
	c = 0;
	
	objectloop (current ofclass NPC_Room)
	{
		#ifdef SUBWAY_MOVE_TYPE;
			if (NPC_IsIntersection(current))
			{
				intersection_list-->c++ = current;

				if (c == MAX_INTERSECTIONS)
				{
					NPC_Error(28);
					@quit;
				}
			}
		#endif;
			
		if (prev)
			current.npc_number = prev;
			
		prev = current;
	}
	
	#ifdef SUBWAY_MOVE_TYPE;
		NPC_SetupLineConnections();
	#endif;
	
	npc_first_room = prev;
];



!==============================================================================
!
!	10.  L A N G U A G E   D E P E N D A N T   R O U T I N E S
!
!==============================================================================


!------------------------------------------------------------------------------
[ HasOrHave x;
	if (x has pluralname) print "have";
	else print "has";
];

!------------------------------------------------------------------------------
[ DoesOrDo x;
	if (x has pluralname) print "do";
	else print "does";
];

!------------------------------------------------------------------------------
[ CIOrWe x;
	if (x has pluralname) print "We";
	else print "I";
];

!------------------------------------------------------------------------------
!
!	N P C _ M S G
!
!	All the messages the NPC Engine might print.
!------------------------------------------------------------------------------
[ NPC_Msg act n x1 x2;
	switch(act)
	{
		##NPC_Goto:
			switch(n)
			{
				1:
					"You're already there!";
					
				2:
					"You don't know how to get there right now.";
					
				3:
					"You're moving closer towards ", (the) x1, ".";
					
				default:
					NPC_Error(26, n);
					rtrue;
			}
			
		##Wait:
			switch(n)
			{
				1:	"That's too long to wait.";
				
				2:	"Time doesn't pass.";
				
				3:	"Time passes...";
				
				4:	print "Do you want to keep waiting? (Y/N) >";
					rtrue;
				
				5:	print "^It is now ";
				
				6:	".";
				
				7:	"(tomorrow)";
				
				8:	"Not a good idea. You might wait all day.";
				
				9:	print_ret (The) x1, " ", (isorare) x1, " already here!";
				
				10:	"^", (The) x1, ", for whom you are waiting, ", (hasorhave) x1, " arrived.";
				
				11:	print (The) x1, " still ", (hasorhave) x1, "n't arrived. ";
					rtrue;
					
				12:	"Ok.";
				
				default:
					NPC_Error (18, n);
					rtrue;
			}
				
				
		##Miscellany:
			switch(n)
			{
				1:	
					print (The) x1, " start";
					if (x1 hasnt pluralname) print "s";
					" to move about distractedly.";
				
				2:	
					L__M(##Miscellany, 30);
				
				3:	
					print_ret (The) x1, " ", (isorare) x1, " here.";
				
				4:
					print (The) x1, " ";

					if(x1.npc_door_passed)
					{
						print "open";
						if (x1 hasnt pluralname) print "s";
						print " ", (the) x1.npc_door_passed, " and ";
					}

					if (x2 == u_obj or d_obj)
						print (isorare) x1, " going";
					else
					{
						print "head";
						if (x1 hasnt pluralname) print "s";
						print " off to";
					}
		
					" ", (LeaveToDir) x2, ".";
					
				5:
					print (The) x1, " ";

					if(x1.npc_door_passed)
					{
						print "open";
						if (x1 hasnt pluralname) print "s";
						print " ", (the) x1.npc_door_passed, " and ";
					}

					if (ScopeCeiling(x1) == x1.npc_target)
					{
						print "step";
						if (x1 hasnt pluralname) print "s";
						print " into the room from ", (ComeFromDir) x2;
					}
					else if (x1.npc_move_type == 5)
						print (isorare) x1, " following you";
					else
						print (isorare) x1, " walking past you";

					".";

				6:
					print (The) x1, " ";
					if (x1 has pluralname)
						print "try";
					else
						print "tries";
					" to open ", (the) x2, ", but it seems to be locked.";
					
				7:
					"Off to ", (LeaveToDir) x2, ", you can see that ",
					(the) x1, " can't open a door.";
				
				default:
					NPC_Error(14, n);
					rtrue;

			}
		
		##NPC_PrintVisible:
			switch(n)
			{
				1:
					print (The) x1, " ", (isorare) x1, " off to";
	
					if (x2 == u_obj or d_obj)
						print "ward";

					" ", (LeaveToDir) x2, ".";
					
				2:
					print "To";
					if (x2 == u_obj or d_obj)
						print "ward";

					print " ", (LeaveToDir) x2, ", ", (the) x1, " ";
					rtrue;
					
				3:
					print "open";
					if (x1 hasnt pluralname) print "s";
					print " a door and ";
					rtrue;

				4:
					print "come";
					if (x1 hasnt pluralname) print "s";
					" into view from ", (ComeFromDir) x1.npc_old_dir, ".";

				5:
					print (The) x1, " ", (isorare) x1, " ";
					if (x1.npc_old_dir == d_obj)
						print "going downstairs";
					else if (x1.npc_old_dir == u_obj)
						print "going upstairs";
					else
					{
						print "to ", (LeaveToDir) x2, ", heading ";
						if ((x2 == n_obj && x1.npc_old_dir == s_obj) ||
								(x2 == ne_obj && x1.npc_old_dir == sw_obj) ||
								(x2 == e_obj && x1.npc_old_dir == w_obj) ||
								(x2 == se_obj && x1.npc_old_dir == nw_obj) ||
								(x2 == s_obj && x1.npc_old_dir == n_obj) ||
								(x2 == sw_obj && x1.npc_old_dir == ne_obj) ||
								(x2 == w_obj && x1.npc_old_dir == e_obj) ||
								(x2 == nw_obj && x1.npc_old_dir == se_obj) ||
								(x2 == u_obj && x1.npc_old_dir == d_obj) ||
								(x2 == d_obj && x1.npc_old_dir == u_obj))
							print "towards you";
						else
							print "toward ", (LeaveToDir) x1.npc_old_dir;
					}

					".";
					
				6:
					print (The) x1, ", off to ", (LeaveToDir) x2, ", ";
					rtrue;
					
				7:
					print "disappear";
					if (x1 hasnt pluralname) print "s";
					print " from sight ";

					if (x1.npc_old_dir == u_obj)
						print "up the stairs";
					else if(x1.npc_old_dir == d_obj)
						print "down the stairs";
					else
						print "to ", (LeaveToDir) x1.npc_old_dir;
					".";
					
				8:
					print_ret (The) x1, " ", (string) x1.npc_walkon, " from ",
						(ComeFromDir) x1.npc_old_dir, ".";
					
				default:
					NPC_Error(10, n);
					rtrue;
			}
	
		##Follow:
			switch(n)
			{
				2:	"You are always following yourself.";				

				3:	"You cannot follow ", (the) x1, ".";

				4:	"You are in the same place as ", (the) x1, "!";

				5:	"You haven't even seen ", (the) x1, " so far.";

				6:	"You seem to have lost track of ", (the) x1, ".";

				default:
					NPC_Error(11, n);
					rtrue;
			}
			
		##Find:
			switch(n)
			{
				1:
					switch(x1)
					{
						1:			print "a few hours";         
						2:			print "an hour or two";      
						3:			print "about an hour";       
						4:			print "about half an hour";  
						5:			print "about fifteen minutes";    
						6:			print "less than ten minutes";
						7:			print "just a minute";
						
						default:	NPC_Error(3);
									rtrue;
					}
				
					print " ago.";
					rtrue;
			
				2:
					if (x1 == player)
						print "You";
					else
						print "~", (CIOrWe) x1;
					print " last saw ", (itorthem) x2, " ";
					rtrue;
			
				3:
					print " ", (CIorWe) x1, " don't know where ";
					if (x2 has pluralname)
						print "they";
					else if (x2 has female)
						print "she";
					else
						print "he";
					print " went, though.~";
					rtrue;

				4:
					if (x1 == player)
						"You'll have to find out yourself.";
					else
						"~", (CIOrWe) x1, " don't know.~";

				5:
					if (x1 == player)
						print "You";
					else
						print "~", (CIOrWe) x1;
					print " haven't seen ", (itorthem) x2, " ";

					if (x1 == player)
						"yet.";

					"today.~";
				
				7:
					"That question cannot be answered.";
				
				8:
					"~Ahem...~";
				
				9:
					if (x1 has animate)
						"Are you blind?";
						
					if (x1 has pluralname)
						print "They're";
					else
						print "It's";
					" right here.";

				10:
					! Not used anymore
								
				default:
					NPC_Error(1, n);
					rtrue;
			}
		
		default:
			NPC_Error(2, action);
			rtrue;
	}
];


!------------------------------------------------------------------------------
!
!	N P C _ E R R O R
!
!	All the error messages the NPC Engine might print.
!------------------------------------------------------------------------------
[ NPC_Error n x1 x2;
	print "^^[ *** NPC Engine Runtime Error ", n, ": ";
	
	switch(n)
	{
		1:			print "NPC_Msg called with unknown value for FIND (", x1, ").";

		2:			print "NPC_Msg called with unknown action (", x1, ").";

		3:			print "NPC_Msg called for FIND, n = 1, unknown value for
						time passed since meeting.";

		4:			print "Couldn't find a path for ", (name) x1, " from ",
						(name) ScopeCeiling(x1), " to ", (name) x2, ".";

		6:			print "Number of NPCs in the story is higher than 32.";
		
		9:			print "NPC_Schedule for ", (name)  x1, " to ", (name) x2,
						" called with delay <= 0.";

		10:			print "NPC_Msg called with unknown value for
						NPC_PRINTVISIBLE (", x1, ").";

		11:			print "NPC_Msg called with unknown value for FOLLOW
						(", x1, ").";
		
		12:			print "NPC_PrePath called for non-NPC_Engine object
						'", (the) x1, "'.";
		
		13:			print "npc_move_type value for ", (the) x1, " is unknown.";
		
		14:			print "NPC_Msg called with unknown value for MISCELLANY
						(", x1, ").";
		
		15:			print "NPC__Path or NPC_Schedule called for non-NPC_Engine
						object '", (the) x1, "'.";
		
		16:			print "NPC_PrintWindowVisible: looks_to as routine not
						supported (window '", (name) x1, "').";
		
		17:			print "Path too long for ", (the) x1, " to ", (the) x2, ".";
		
		18:			print "NPC_Msg called with unknown value for WAIT
						(", x1, ").";
		
		19:			print "Too many exits on one line in room ", (name) x1,
						" -- line ", (string) subway_names-->x2, ".";
		
		23:			print "NPC '", (the) x1, "' is still on the playfield (in ",
						(name) x2, "), but its daemon isn't running.";

		24:			print "No adjacent rooms from room ", (name) x1, ".";
		
		26:			print "NPC_Msg called with unknown value for NPC_GOTO (", x1, ").";
		
		27:			print (The) x1, " can't follow the player since he isn't in the
						same location right now.";
		
		28:			print "Number of intersections in the story is too high; increase
						MAX_INTERSECTIONS (currently set to ", MAX_INTERSECTIONS, ").";
						
		default:	print "Unknown error.";
	}
	
	" *** ]^";
];


!------------------------------------------------------------------------------
!	E N D   O F   F I L E
!------------------------------------------------------------------------------